// Next available MSG number is    38 
// MODULE_ID DDATTDEF_DCL_
/* Next available MSG number is  38 */
//
//     ddattdef.dcl
//
//     Copyright (C) 1992, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//.
//------------------------------------------------------------------------
//  DESCRIPTION
//
//  This is the dialogue box definition file for the DDATTDEF command. This
//  is an enhancement to the ATTDEF command. It loads up a dialogue box
//  which presents to the user all the prompts and options that he/she
//  might encounter during the definition of one or several attributes.
//
//------------------------------------------------------------------------


//dcl_settings : default_dcl_settings { audit_level = 3; }


ddattdef : dialog {
    label = "Attribute Definition";
    : row {
        : boxed_column {
            label = "Mode";
            : toggle {
                label = "Invisible";
                mnemonic = "I";
                key = "invisible";
            }
            : toggle {
                label = "Constant";
                mnemonic = "C";
                key = "constant";
            }
            : toggle {
                label = "Verify";
                mnemonic = "V";
                key = "verify";
            }
            : toggle {
                label = "Preset";
                mnemonic = "P";
                key = "preset";
            }
        }
        : boxed_column {
            label = "Attribute";
            fixed_width = true;
            width = 40;

            : edit_box {
                label = "Tag:";
                mnemonic = "T";
                key = "att_tag";
                edit_width = 30;
                edit_limit = 256;
            }
            : edit_box {
                label = "Prompt:";
                mnemonic = "P";
                key = "att_prompt";
                edit_width = 30;
                edit_limit = 256;
            }
            : edit_box {
                label = "Value:";
                mnemonic = "V";
                key = "def_val";
                edit_width = 30;
                edit_limit = 256;
            }
        }
    }
    : row {
        : boxed_column { 
            label = "Insertion Point";
            : button {
                label = "Pick Point <";
                mnemonic = "k";
                key = "pick_pt";
            }
            : edit_box {
                label = "X:";
                mnemonic = "X";
                key = "x_pt";
                edit_width = 10;
            }
            : edit_box {
                label = "Y:";
                mnemonic = "Y";
                key = "y_pt";
                edit_width = 10;
            }
            : edit_box {
                label = "Z:";
                mnemonic = "Z";
                key = "z_pt";
                edit_width = 10;
            }
        }
        : boxed_column {
            label = "Text Options";
            fixed_width = true;
            width = 40;
            : column {
                : popup_list {
                    label = "Justification:";
                    key = "cjustif";
                    edit_width = 20;
                    mnemonic = "J";
                }
                : popup_list {
                    label = "Text Style:";
                    key = "tstyle";
                    edit_width = 20;
                    mnemonic = "T";
                }
            }
            : row {
                : button {
                    label = "Height <";
                    key = "bheight";
                    mnemonic = "e";
                    width = 15;
                    fixed_width = true;
                }
                : edit_box {
                    key = "height";
                    edit_width = 20;
                    value = "0.2000";
                    fixed_width = true;
                }
            }
            : row {
                : button {
                    label = "Rotation <";
                    key = "brot";
                    mnemonic = "R";
                    width = 15;
                    fixed_width = true;
                }
                : edit_box {
                    key = "rot";
                    edit_width = 20;
                    fixed_width = true;
                }
            }
        }
    }
    : toggle {
        label = "Align below previous attribute";
        key = "align_prev";
        fixed_width = true;
        mnemonic = "A";
    }
    ok_cancel_help_errtile;
}



