/*    

   TEMPLATE.C

   Copyright (C) 1990, 1991, 1992, 1993, 1994 by Autodesk, Inc.
 
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
 
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
 
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
    
   .

      DESCRIPTION:
  
      This is a template file to demonstrate the structure required by      
      an ADS application.
  
      Prototype for ADS application.
   
      by Amy Berger       
      April 16, 1990
  
      Updated July 30, 1990
  
*/


#include  <stdio.h>
#include  "adslib.h"

static int loadfuncs();
int adsfunc();


/* MAIN - the main routine */


void
main(argc, argv)
  int argc;
  char *argv[];
{
    int stat;
    short scode = RSRSLT;             /* This is the default result code */

    ads_init(argc, argv);             /* Initialize the interface */

    for ( ;; ) {                      /* Note loop conditions */

        if ((stat = ads_link(scode)) < 0) {

            printf("TEMPLATE: bad status from ads_link() = %d\n", stat);

            /* Can't use ads_printf to display 
               this message, because the link failed */
            fflush(stdout);
            exit(1);
        }

        scode = RSRSLT;               /* Default return value */

        /* Check for the following cases here */
        switch (stat) {

        case RQXLOAD:                 /* Register your ADS external functions.
                                         Register your function handlers if you
                                         want your ADS functions to be called
                                         transparent to this dispatch loop.
                                         Required for all applications.  */

            scode = loadfuncs() ? RSRSLT : RSERR;
            break;

        case RQSUBR:                  /* This case is normally expanded to 
                                         select one of the application's 
                                         external functions */
            break;

        case RQXUNLD:                 /* Do C program cleanup here.
                                         Not required unless you need to
                                         clean up your own allocated resources.

                                         Note: You don't have to undefine ADS
                                         functions.  LISP does it for you.  */
            break;

        case RQSAVE:                  /* AutoCAD SAVE command notification.
                                         You can use it for your own database
                                         synchronization.  Not required.  */
            break;

        case RQQUIT:                  /* AutoCAD QUIT command notification.
                                         Not required.  */
            break;

        case RQEND:                   /* AutoCAD END command notification.
                                         Not required.  */
            break;

        default:
            break;
        }
    }
}


/* LOADFUNCS  --  Define external functions with AutoLISP.

                  Normally expanded to call ads_defun() once for each
                  external function to be defined, assigning each one a
                  different ADS function code.  ads_regfunc() is then
                  called to specify the handler function for each ADS
                  function code.
*/
static int loadfuncs()
{
    if (ads_defun("ADSFUNC", 0) == RTNORM) {   /* Define function */
        ads_regfunc(adsfunc, 0);      /* Register handler */
        return 1;
    } else
        return 0;
}


/* ADSFUNC  --  Sample handler for ADS function code 0.

                This function will handle (ADSFUNC) calls.  You can have
                one handler for each external function, or use one handler
                for several functions.  ads_getfuncode() tells the handler
                which function (ADS function code) it's dealing with.

                If you choose to use the RQSUBR method, you should place
                this function call following the RQSUBR switch statement.
*/
int adsfunc()
{
    /* Do something. */

    return RSRSLT;                    /* Normal completion */
}
