/*****************************************************************************
      SAGET.H
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: Library of extended ads_getxxx() functions. These functions
               behave exactly the same as their original ADS counterparts
               but provide:

               - AutoLISP input redirection
               - supporting 'CAL (Geometry Calculator) command
               - options 'CP and Baseplane

               The library also contains some new functions for entering
               an axis and a plane etc.


*****************************************************************************/

#ifndef _SAGET_H
#define _SAGET_H


/****************************************************************************/
/*  EXPORTED VARIABLES                                                      */
/****************************************************************************/

extern int           lisp_input;  /* Input from the AutoLISP list of resbufs*/
extern int           lisp_error;  /* Error occured during AutoLISP input    */
extern struct resbuf *current_rb; /* Next rb to read from AutoLISP          */

extern ads_name      implied_selset;        /* The implied selset name   */
extern int           implied_selset_exists; /* The implied selset exists */

extern int           sa_get_returned_RTCAN; 

extern ads_name      ssget_ss[20];  
extern int           no_of_ssget_ss;


/****************************************************************************/
/*  EXPORTED FUNCTIONS                                                      */
/****************************************************************************/

/* Enhanced ads_xxxx() functions */

int sa_initget    _((int val, char *kwl));
int sa_getinput   _((char *str));
  
int sa_getpoint   _((ads_point pt, char *prompt,
                     ads_point result));
int sa_getcorner  _((ads_point pt, char *prompt,
                     ads_point result));
int sa_getangle   _((ads_point pt, char *prompt,
                     ads_real *result));
int sa_getdist    _((ads_point pt, char *prompt,
                     ads_real *result));
int sa_getorient  _((ads_point pt, char *prompt,
                     ads_real *result));
int sa_getreal    _((char *prompt, ads_real *result));
int sa_getint     _((char *prompt, int *result));

int sa_getstring  _((int cronly, char *prompt, char *result));
int sa_getkword   _((char *prompt, char *result));

int sa_entsel     _((char *str, ads_name entres, ads_point ptres));
int sa_ssget      _((char *str, 
                     void *pt1, ads_point pt2, 
                     struct resbuf *filter, ads_name ss));


/* Some more functions not available in ADS */

int sa_getaxis     _((char *prompt, ads_point p1, ads_point p2));
int sa_getplane    _((char *prompt, char *plane_option, 
                      ads_point p1, ads_point p2, ads_point p3));

int sa_init_input  _((int input_source));

int sa_init_cplast _((void));
int sa_set_cp      _((char *prompt));
int sa_return_cp   _((void));
int sa_cp2ucs      _((ads_point p));
void sa_reset_last_axis_and_plane _((void));


#endif /*_SAGET_H*/

