/* Next available MSG number is     3 */

/*****************************************************************************
      CALUSRF.C
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: The user-defined functions for the Geometry Calculator.

*****************************************************************************/


/****************************************************************************/
/*  INCLUDES                                                                */
/****************************************************************************/

#define MODULE_ID CALUSRF_C_

#include "cal.h"

#include "xmf.h"
#include "ads_ix.h"


/****************************************************************************/
/*.doc cal_MAX_func(internal)*/
/*+
  Calculator function which returns maximum from a given set of numbers.
-*/
/****************************************************************************/


static void
/*FCN*/cal_MAX_func()
{
    int        i;
    double     max;
    value_type type;

    if (no_of_params < 2) {
        error(0, XMSG("Function 'MAX' reguires at least two parameters", 1));
        return;
    }

    max  = -1e30;
    type = int_type;

    for (i=0; i<no_of_params; i++) {
        if (!IS_REAL(i)) {
            error(0, XMSG("Function 'MAX' requires only real or int parameters", 2));
            return;
        }
        if (params[i].type == real_type) {
            type = real_type;
        }
        if (params[i].r > max) {
            max = params[i].r;
        }
    } /*for*/

    result.type = type;
    result.r    = max;

} /*cal_MAX_func*/


/****************************************************************************/
/*.doc cal_register_user_functions(external)*/
/*+
  Insert the registration of all your calculator functions into the       
  following function. The example how to do is, we hope, selfexplanatory. 
-*/
/****************************************************************************/


void
/*FCN*/cal_register_user_functions()
{
    cal_register_function(/*MSG0*/"MAX", cal_MAX_func);

    /* Add registering your own functions here.... */

} /*cal_register_user_functions*/


