/*****************************************************************************
      CALMNGF.H
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: header file for calmngf.c.

*****************************************************************************/


/****************************************************************************/
/*  DEFINES                                                                 */
/****************************************************************************/

#define MAX_CAL_FUNC    200           /* Max number of calculator functions */
#define MAX_FUNC_PARAM   20           /* Max number of function parameters  */

/* Checking the type of input parameters to calculator functions */

#define IS_VECTOR(i) (params[i].type==vector_type)
#define IS_REAL(i)   ((params[i].type==real_type)||(params[i].type==int_type))
#define IS_INT(i)    (params[i].type==int_type)


/****************************************************************************/
/*  TYPEDEFS                                                                */
/****************************************************************************/


/* The table of calculator functions */

typedef struct
{
    char name[MAX_SYMBOL_LENGTH+1];
    void (*func)();
} cft[MAX_CAL_FUNC];


/****************************************************************************/
/*  EXPORTED VARIABLES AND FUNCTIONS                                        */
/****************************************************************************/

extern cft cal_funcs_table;           /* Table of calculator functions  */
extern int cal_funcs_number;          /* Number of calculator functions */

/* Variables for passing actual parameters to calculator functions 
   and returning the value from the function:

   Before a calculator function is called, its acutal parameters must 
   be stored in global array 'params[]' and the number of parameters in
   'no_of_params. The function returns its result in global variable 
   'result'.
*/

extern int             no_of_params;
extern vector_real_int params[MAX_FUNC_PARAM];
extern vector_real_int result;


/****************************************************************************/
/*.doc cal_register_function(external)*/
/*+
  Function registers new calculator function. 'func_name' is the
  name of the function which will be used to refer to this function
  in arithmetic expressions, 'func_ptr' is a pointer to the function 
  definition. If the function fails, it prints an error message
  and terminates the ADS application.
-*/
/****************************************************************************/

void cal_register_function _((char *func_name, void (*func_ptr)()));


/****************************************************************************/
/*.doc cal_invoke_function(external)*/
/*+
  Invoke calculator function whose name is 'func_name'. 

  Before a function is invoked, the function parameters must be stored in 
  array'params[]', the number of actual parameters in 'no_of_params'. The 
  invoked function returns its result in 'result'. 

  Function returns TRUE if function 'func_name' was successfully invoked
  and the invoked function succeeded, otherwise FALSE is returned. You can
  use 'cal_err' variable to check the reason why the invocation failed.
-*/
/****************************************************************************/

int cal_invoke_function _((char *func_name));




