/* Next available MSG number is    66 */

/*****************************************************************************
      CALERR.C
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: Error reporting function for the Geometry Calculator ADS
               application.

      CAUTION: the corresponding xmf file has been build manualy and
               the message numbers correspond to the positions of
	       the strings in the error_messages structure. So if
	       you add, remove or modify theses messages, please
	       update the xmf file.

*****************************************************************************/


/****************************************************************************/
/*  INCLUDES                                                                */
/****************************************************************************/

#define MODULE_ID CALERR_C_

#include "cal.h"

#include "xmf.h"
#include "ads_ix.h"


/****************************************************************************/
/*  EXPORTED VARIABLES                                                      */
/****************************************************************************/

int cal_err;                          /* Error number, 0 means O.K. */


/****************************************************************************/
/*  STATIC VARIABLES                                                        */
/****************************************************************************/

static char *error_messages[] =
{
   "%s",                                                            /* 0*/
   /*MSG0*/"Wrong real number '%s'",                                        /* 1*/
   /*MSG0*/"Illegal character '%s'",
   /*MSG0*/"Integer numbers must be between -32768 and 32767",
   /*MSG0*/"Function %s requires one argument",
   /*MSG0*/"Right parenthesis ')' missing",                                 /* 5*/
   /*MSG0*/"Vector components must be real numbers",
   /*MSG0*/"Wrong syntax of vector, maybe ',' missing",
   /*MSG0*/"Wrong syntax of vector, maybe ']' missing",
   /*MSG0*/"Unexpected end of expression",
   /*MSG0*/"Wrong syntax of expression",                                    /*10*/
   /*MSG0*/"Function %s requires vector argument",
   /*MSG0*/"Function %s requires real argument",
   /*MSG0*/"Argument to ASIN, ACOS must be between -1 and 1",
   /*MSG0*/"Argument to ROUND and TRUNC must be between -32768 and 32767",
   /*MSG0*/"Argument to SQRT cannot be negative",                           /*15*/
   /*MSG0*/"Power operator '^' requires real operands",
   /*MSG0*/"Negative numbers cannot be raised to real exponent",
   /*MSG0*/"Division by 0",
   /*MSG0*/"Operator '/' requires real-real or vector-real operands",
   /*MSG0*/"Operator '&' requires vector operands",                         /*20*/
   /*MSG0*/"Operators '+', '-' require operands of the same type",
   /*MSG0*/"Invalid feet'-inches\" format",
   /*MSG0*/"Numeric overflow",
   /*MSG0*/"Function TANG does not accept arguments 90+k*180 degrees",
   /*MSG0*/"Function %s takes no arguments",                                /*25*/
   /*MSG0*/"Use %s",
   /*MSG0*/"The calculator expression must be a string",
   /*MSG0*/"Assignment operator '=' used improperly",
   /*MSG0*/"Failed to assign the value of the expression to variable %s",
   /*MSG0*/"The 2D vector for NOR(v) function has zero length",             /*30*/
   /*MSG0*/"AutoLISP symbol '%s ...' is too long",
   /*MSG0*/"Unknown AutoCAD system variable %s",
   /*MSG0*/"Only real, integer or point AutoCAD system variables accepted",
   /*MSG0*/"Angles should be written in <deg>d<min>'<sec>\" format",
   /*MSG0*/"Wrong syntax of point (vector)",                                /*35*/
   /*MSG0*/"Point 'p' in ANG(apex,p1,p2,p) function lies on plane (apex,p1,p2)",
   /*MSG0*/"Points in ANG(apex,p1,p2,p) function coincide",
   /*MSG0*/"Function %s requires positive argument",
   /*MSG0*/"The 2D points in ANG(p1,p2) function coincide",
   /*MSG0*/"The two points defining line in function %s coincide",          /*40*/
   /*MSG0*/"Integer value of expression is not between -32768 and 32767",
   /*MSG0*/"The function name %s is not an identifier",
   /*MSG0*/"Value of AutoLISP variable %s must be a point, real or integer",
   /*MSG0*/"Too many calculator functions",
   /*MSG0*/"AutoLISP variable %s has no value",                             /*45*/
   /*MSG0*/"Null function name or function pointer to cal_register_function()",
   /*MSG0*/"Function name %s is too long",
   /*MSG0*/"The point to be rotated lies on the axis of rotation",
   /*MSG0*/"Comma expected in argument list of function %s",
   /*MSG0*/"Too many arguments to function %s",                             /*50*/
   /*MSG0*/"The points in NOR(p1,p2,p3) function coincide or are collinear",
   /*MSG0*/"Function %s doesn't exist",
   /*MSG0*/"The points 'p1ax' and 'p2ax' in ROT(p,p1ax,p2ax,angle) coincide",
   /*MSG0*/"The two lines in function %s do not intersect or are collinear",
   /*MSG0*/"The line is parallel to the plane",                             /*55*/
   /*MSG0*/"The 2D vector in ANG(v) function is zero length",
   /*MSG0*/"The 2D points in ANG(apex,p1,p2) function coincide",
   /*MSG0*/"The points 'p1' and 'p2' in function PLD(dist,p1,p2) coincide",
   /*MSG0*/"The three points defining the plane are coincident or collinear",
   /*MSG0*/"Function %s was already registered",                            /*60*/
   /*MSG0*/"The two 2D points defining line in %s function coincide",
   /*MSG0*/"The line lies on the plane",
   /*MSG0*/"Use CVUNIT(value,from_units,to_units)",
   /*MSG0*/"CVUNIT failed to convert units",
};


/****************************************************************************/
/*.doc error(external)*/
/*+
  Error reporting function. 'n' is the error number, 'str' is an additional 
  string argument which is printed only in some error messages. 

  If the error number 'n' is 0, then the string 'str' is printed 
  instead of a message from the 'error_messages' array.

  The function does nothing if 'cal_err' is already non-zero, avoiding 
  chained error messages.
-*/
/****************************************************************************/


void
/*FCN*/error(n, str)

  int  n;                             /* Error number                       */
  char *str;                          /* Additional string to print or NULL */
{
    cal_lex.sym = no_sym;

    if (cal_err != 0)
        return;

    if (n != 0) {
        cal_err = n;
    } else {
        cal_err = -999;
        if (str == NULL)
            return;                   /* Just assign cal_err = -999 */
    }
    
    if (str == NULL) 
        str = "";

    ads_printf(XMSG("\n>> Error: ", 65));
    if ((cal_err < 0) || (cal_err >= ELEMENTS(error_messages))) {
        ads_printf("%d\n\n", cal_err);
    } else {
        ads_printf(XMSG(error_messages[cal_err], cal_err), str);
        ads_printf(".\n\n");
    }
} /*error*/


