/*    

   ADSLIB.H

   Copyright (C) 1989, 1990, 1991, 1992, 1993, 1994 by Autodesk, Inc.
 
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
 
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
 
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
    
   .

   ADS definitions and system dependent controls.

   This also contains a substitute for stdlib.h on some systems.
   If we know the system has stdlib.h, just include it.

*/

#ifndef _adslib_h
#define _adslib_h 1

#ifdef _MAXSTRING
#undef    _MAXSTRING
#define   _MAXSTRING  (~0)
#endif

  
/* Note: As of this writing, Sun ANSI C defines __STDC__, but
   sets it to a non-numeric value.  This is contrary to the
   ANSI standard, but we'll live with it for now.  Hence the
   unusual handling of __STDC__. */

#ifdef __STDC__
#define STDC_DEFINED 1
#else
#define STDC_DEFINED 0
#endif

#ifdef _WINDOWS
#define WIN 1
#endif

#ifdef WINVER
#define WIN 1
#endif

#ifdef _MSC_VER
#define MICROSOFT 1
#endif

#ifdef __TURBOC__
#define TURBOC 1
#endif

#ifdef WIN
#define main(a,b) ads_main(a,b)
#define PROTOTYPES 1
#endif  /* WIN */

#ifndef PROTOTYPES
#if STDC_DEFINED || defined(__cplusplus)  /* "Standard C" or C++ */
#define PROTOTYPES 1
#endif  /* STDC_DEFINED || __cplusplus */
#endif  /* !PROTOTYPES */

/*  Tricky macro for declaration of function types with optional
    prototype (i.e., declaration of argument types).  The way the
    macro "_()" is defined, the following declaration:

       int fcn _((int i, char c));

    will expand into either

       int fcn (int i, char c);
       or
       int fcn ();

    depending on whether the symbol PROTOTYPES is defined.  Thanks to
    Bob Elman for this idea.  */

#ifdef PROTOTYPES
#define   _(x)  x
#else
#define   _(x)  ()
#endif /* PROTOTYPES */



/* Substitute for STDLIB.H on systems that do NOT have it.
   Also enable use of const in adsxxx.h declarations.  */

#ifndef ACRXAPP

#if       STDC_DEFINED || defined(__cplusplus) || WIN
#include  <stdlib.h>
#else

/* Declaration for ?alloc() was set to char * because that caused us fewer
   compiler warnings in some substandard systems.  Now we declare it as ANSI
   standard by default.  The Sparc compiler works fine with this, though the
   obsolete lint on Unix screams its ancient head off.  (Serious programmers
   use Gimpel's PC-Lint.)

   Any exceptions to the proper ANSI-style declaration must be explicitly
   machine by machine. 
   5/26/94
*/

void *malloc _((size_t size));
void *calloc _((unsigned int nelem, size_t elsize));
void free _((void *ptr));
void *realloc(void *, size_t);
#ifndef TURBOC
double atof _((char *nptr));
#endif
int atoi _((char *nptr));
void exit _((int status));
double fmod _((double x, double y));

/* Enable the use of const on machines that support it (by making it disappear
   on these non-standard machines). */
#ifndef const
#define const                         /* Make const invisible for adsxxx.h */
#define _adslib_h_const               /* Flag for later */
#endif  /* !const */
#endif  /*STDC_DEFINED || __cplusplus || WIN */

#endif  /* !ACRXAPP */

#include "ads.h"
#include "adscodes.h"

#if defined(ACRXAPP) && defined(solaris)
/*
            And except we will... For the Rx environment on
            Solaris , we will redefine malloc, realloc, free and calloc
            to be "ads_malloc()", "ads_realloc(), "ads_free()"
            and "ads_calloc()" to round this substitution out.
            The point is to have all Rx apps which must malloc
            objects to be fred by
            AutoCAD or another Rx app, or vice versa, to draw from the
            same memory management system, or else it doesn't work.

            An application is free to use its own memory management,
            or that of the system rumtime libraries, by #undef'ing
            these symbols, as long as such usage has balanced malloc
            and free() calls within the application.  Such an application
            can utlize both memory pools from a single module
            too.
*/

#ifdef malloc
#undef malloc
#endif

#ifdef calloc
#undef calloc
#endif

#ifdef free
#undef free
#endif 

#ifdef realloc
#undef realloc
#endif

/* 
   ads_malloc()/ads_free()/ads_msize()/ads_realloc()/ads_calloc() will
   be defined in ads.h  #if defined(ACRXAPP) && defined(solaris)
*/

#define malloc	ads_malloc
#define free	ads_free
#define realloc	ads_realloc
#define calloc	ads_calloc

#endif /* defined(ACRXAPP) && defined(Solaris) */

#ifdef _adslib_h_const                /* Clean up after yourself */
#undef const
#undef _adslib_h_const
#endif  /* !_adslib_h_const */


#endif  /* !_adslib_h */
