
/*
   TEMPLATE.CC

   Copyright (C) 1994 by Autodesk, Inc.
 
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
 
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
 
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
    
   .

      DESCRIPTION:
  
      This is a template file to demonstrate the structure required by      
      an Arx ADS application.
  
      Prototype for Arx ADS application.
   
      by Ed Becnel
      February 3, 1994
  
*/


#include <stdio.h>
#include "rxdefs.h"
#include "adslib.h"
#include "adesk.h"

static int loadfuncs();
int adsfunc();

extern "C" {
void initModule();
/****************************************************************************/
/*  LOCALLY DEFINED ENTRY POINT INVOKED BY Arx                              */
/****************************************************************************/
AcRx::AppRetCode acrxEntryPoint(AcRx::AppMsgCode msg, void* );

}                                                                 

// Initialization Function

void
/*FCN*/initModule()
{
}

/****************************************************************************/
/*  ENTRY POINT INVOKED BY Arx                                              */
/****************************************************************************/
AcRx::AppRetCode
/*FCN*/acrxEntryPoint(AcRx::AppMsgCode msg, void * )
{
    switch(msg) {
    case AcRx::kInitAppMsg: 	// Sent when Arx Application is loaded.
	initModule();		// - DO NOT USE ads library yet,
	break;			//   except for list of functions not
				//   related to drawing state or LISP.
				//   Detailed List of ADS functions
				//   valid at this point forthcoming.
    case AcRx::kLoadADSMsg: 	// Sent at same time
	loadfuncs();		// ADS Apps receive RQXLOAD code, i.e.
	break;			// once per drawing Open. At this time
				// you call:
				//
				// - All ADS Library functions are now
				//   valid including
				//   ads_defun(), ads_regfunc() , and
				//   drawing access functions are now
				//   operational.  Usage of them
				//   automatically registers an Rx
				//   application with the ADS 
				//   environment, so that LISP and
				//   ADS can dispatch their calls
				//   to this application.

    case AcRx::kUnloadADSMsg:
	break;			// Sent at same time when ADS Apps
				// receive RQXUNLD code.  App will
			 	// not be unloaded, but signals that
				// a drawing is being closed.
				// - Cleanup and release for all
				//   DWG and LISP related resources.
				// - Last time in drawing edit session
				//   that all ADS functions are valid.

    case AcRx::kInvkSubrMsg:
	break;			// Sent when RQSUBR is sent to ADS apps
				//
				// NOTE: Arx facilities and new Arx App 
				//       libraries all define direct 
				//       callback mechanisms.  This
				//       message code is strictly for
				//       ads_defun  compability.

    case AcRx::kSaveMsg: 	// Sent when RQSAVE is sent to ADS apps
	break;

    case AcRx::kEndMsg:  	// Sent when RQEND is sent to ADS apps
	break;

    case AcRx::kQuitMsg:	// Sent when RQQUIT is sen to ADS apps
	break;

    case AcRx::kCfgMsg:		// Sent when RQCFG is sent to ADS apps
	break;		  	// Not yet implemented.

    case AcRx::kUnloadAppMsg:
	break;			// The Arx Application is being unloaded.
				// Free remaining resources registered 
				// with Rx.
				//
				// At this point, LISP and the drawing
				// may or may not be long gone, and
				// related ADS functions will no
				// longer be valid.
				//
				// Perform all related cleanup in
				// kUnloadADSMsg case.
    default:
	break;
    }
    return AcRx::kRetOK;
}


/* LOADFUNCS  --  Define external functions with AutoLISP.

                  Normally expanded to call ads_defun() once for each
                  external function to be defined, assigning each one a
                  different ADS function code.  ads_regfunc() is then
                  called to specify the handler function for each ADS
                  function code.
*/
static int loadfuncs()
{
    if (ads_defun("C:ADSFUNC", 0) == RTNORM) {   /* Define function */
        ads_regfunc(adsfunc, 0);      /* Register handler */
        return 1;
    } else
        return 0;
}


/* ADSFUNC  --  Sample handler for ADS function code 0.

                This function will handle (ADSFUNC) calls.  You can have
                one handler for each external function, or use one handler
                for several functions.  ads_getfuncode() tells the handler
                which function (ADS function code) it's dealing with.

                If you choose to use the RQSUBR method, you should place
                this function call following the RQSUBR switch statement.
*/
int adsfunc()
{
    /* Do something. */
    ads_printf("\nHello World!\n");
    return AcRx::kRetOK;                    /* Normal completion */
}
