/* Next available MSG number is   1 */
/*
   Copyright (C) 1992, 1993, 1994 by Autodesk, Inc.
 
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
 
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
 
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
    
   .

*/

/* rxdefs.h -- General type definitions */

#ifndef _rxdefs_h_
#define _rxdefs_h_  1

#if defined(__cplusplus)
#ifndef AD_ADESK_H
#include "adesk.h"
#endif /* AD_ADESK_H */
#endif /* __cplusplus */

#ifndef NULLFCN
#define NULLFCN ((void (*)())0)
#endif

/* Adesk::UInt32 maximum value, stolen from <limits.h> */

#define ACRX_ULONG_MAX 0xFFFFFFFF

/* ASCII/Text constants

   Need to verify that Unicode supports this. */

#define ACRX_ASCII_MAX 255                 /* Same as UCHAR_MAX in <limits.h> */
#define ACRX_EOS 0                         /* End of String Indicator */

#if defined(__cplusplus)
/* AcRx:  typedef and enum namespace scoping struct. */

struct AcRx {

    typedef void (*FcnPtr) ();

    enum	 DictIterType { kDictSorted   = 0,
	                        kDictCollated = 1 };

    enum	 Ordering     { kLessThan     = -1,
				kEqual	      = 0,
				kGreaterThan  = 1,
				kNotOrderable = 2 };

    enum	 AppMsgCode   { kNullMsg	= 0,
				kInitAppMsg	= 1,
				kUnloadAppMsg	= 2,
				kLoadADSMsg	= 3,
				kUnloadADSMsg	= 4,
                                kInvkSubrMsg    = 5,
                                kCfgMsg         = 6,
                                kEndMsg         = 7,
                                kQuitMsg        = 8,
                                kSaveMsg        = 9
				/* TTE/BILL: Add
				   more codes here */ };

    enum	 AppRetCode   { kRetOK          = 0,
				kRetError	= 3
				/* TTE/BILL: Add
				   more codes here */  };
				
};
#endif  /* __cplusplus */

#endif /* _rxdefs_h */
