#ifndef AD_ADESK_H
#define AD_ADESK_H
//
//
/*
   Copyright (C) 1993, 1994 by Autodesk, Inc.
 
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
 
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
 
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
    
   .
*/
// CREATED BY: James Rowell, summer 1993 (R13)
//
// DESCRIPTION:
//
// This file contains the extension to the standard set of primitive-
// type names that should be shared by all Autodesk developers, both
// in-house and third-party.  All new code and modules written in C++
// should use these type names along with those supplied by C++ itself
// (for example, int, long, float, double, etc.)
//
// See adeskabb.h for abbreviations of the following names.

#include <limits.h>

struct Adesk
{
    // The types Int8, Int16 and Int32 will be conditionally compiled
    // to guarantee that each one represents an integer type of exactly
    // 8, 16 and 32 bits respectively.	These are to be used only when
    // the EXACT size of the integer is critical.
    //
    typedef char	   Int8;
    typedef short	   Int16;
    typedef long	   Int32;
    //
    // The unsigned versions of the above types.
    //
    typedef unsigned char  UInt8;
    typedef unsigned short UInt16;
    typedef unsigned long  UInt32;

    //	Size limits on above types, from limits.h.  The size limits
    //  on long types don't necessarily fit in an enum, so they are
    //  omitted.  Even kUInt16Max is suspect, but we'll wait until
    //	some compiler complains.
    //
    enum    {	kInt8Min    = CHAR_MIN,
		kInt8Max    = CHAR_MAX,
		kInt16Min   = SHRT_MIN,
		kInt16Max   = SHRT_MAX,
	    //	kInt32Min   = LONG_MIN,
	    //	kInt32Max   = LONG_MAX,

		kUInt8Max   = UCHAR_MAX,
		kUInt16Max  = USHRT_MAX
	    //	kUInt32Max  = ULONG_MAX
	    };

    // TEMPORARY.  DO NOT USE!  USE "double", this will disappear.
    //
    typedef double	   Real;

    // Convenient abbreviations (use optionally).
    //
    typedef unsigned char  uchar;
    typedef unsigned short ushort;
    typedef unsigned int   uint;
    typedef unsigned long  ulong;

    // Logical type (Note: never use int when Boolean is intended!)
    //
    typedef int 	   Boolean;
    enum		   { kFalse = 0, kTrue = 1 };

    // Error handling.
    //
    typedef int            ErrorCode;
    enum                   { eGood = 0, eBad, eInsufficientMemory,
			     eLast = eGood + 99 };
};

#ifndef NULL
#define NULL 0
#endif

// How to use ErrorCode.
//
// This is the basis for the default error handling mechanism.
// It is a simple enumeration which can be extended in any class
// without collision with this "global" list of error codes, or any
// list of error codes in one of its base classes.
//
// For example, a class has to define some new error codes:
//
// class Foo
// {
// public:
//     enum {
//	   eTooManyFoos = Adesk::eLast + 1,
//	   eFooBarfed,
//	   eCannotFooToday,
//	   eLast = eTooManyFoos + 99
//     };
// };
//
// Since Foo is a base class, then the first error in in its
// list must be one larger than the last element in the global
// list.  Up to 99 new items can actually be added to the 
// global list without causing the value of eFooError1 to change.
// Similarly new items can be added to the error codes in the Foo
// class without causing a "ripple effect" of changed values in any
// of its derived classes.
//
// In the way that Foo used Adesk::eLast to define its first value,
// any derived classes of Foo will do the same thing using the
// value Foo::eLast + 1.
//
// Autodesk software will write and read Adesk::ErrorCode as a
// short integer.

#endif
