/********************************************************************
 * fh3720.ctl - PC installer control file for Aldus FreeHand 3.1
 *
 * Copyright (C) 1990 Aldus Corporation.  All rights reserved.
 *
 * ABSTRACT:
 * All product-specific text goes in the .CTL file.  Nothing in the .RC
 * file should be product-specific.  Both the .CTL and the .RC files
 * must be localized.
 *
 * When localizing, only text in "double quotes" need be translated.
 * (Although, if the names of files on the distribution diskettes have
 * been changed, they'll have to be changed in this control file too.)
 *
 *******************************************************************/

/* The PRODUCT command is required.  
 */
PRODUCT "FreeHand 3.1"

VERSIONREQ "2.0"      /* minimum installer version required */


/* There is one DISK statement for each distribution disk.  It gives
 * the name by which the user will be asked for the disk, and a list
 * of the files on the disk.  In addition to the file names, the list
 * of files contains the sizes of the files (uncompressed, in bytes)
 * and the subdirectories in which the files can be found.  If the
 * file is in the root, the subdirectory can be left off.  The options
 * CHECKDATE or NOREPLACE can be specified after the subdirectory.  Lines
 * are separated by commas.
 *
 * This part of the control file will be created automatically by the
 * Disk Builder Utility.
 */



DISK "(FreeHand Disk 1  720K)"
   {
   (C)ALDUS.'92         62,
   ALDSETUP.EXE     189504  CHECKDATE,
   FH3720.CTL        35985,
   README.TXT        33525,
   REGCARD.FH~       35502,
   ALDVM.DL~         45378  "ALDUS"  CHECKDATE,
   ALDVMRES.RS~       5824  "ALDUS\USENGLSH"  CHECKDATE,
   A_PNT518.PD~       1820  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   A_PNT518.PP~      12115  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   AC500503.PD~       1386  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   AC500503.PP~      10502  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   ALJII523.PD~       1750  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   ALJII523.PP~      11629  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APLWIIF1.PD~       1800  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APLWIIF1.PP~      10533  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APLWIIG1.PD~       1976  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APLWIIG1.PP~      11390  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE230.PD~       1679  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE230.PP~       8802  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE380.PD~       1756  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE380.PP~      10334  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE422.PD~       1750  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APPLE422.PP~      10393  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS08522.PD~       3578  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS08522.PP~      11615  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS12522.PD~       1403  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS12522.PP~       9414  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS26522.PD~       1403  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS26522.PP~       9630  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS80522.PD~       3576  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   APS80522.PP~      11617  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   AST__470.PD~       1750  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   AST__470.PP~      11888  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG20_523.PD~       6656  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG20_523.PP~      18869  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG50_523.PD~       9076  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG50_523.PP~      25918  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG94_493.PD~       4914  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG94_493.PP~      14549  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG94_523.PD~       7268  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG94_523.PP~      20750  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG96_523.PD~       7272  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG96_523.PP~      20831  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG97_523.PD~       7990  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG97_523.PP~      21457  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG98_523.PD~       7267  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CG98_523.PP~      20758  "ALDUS\USENGLSH\PPDS1"  CHECKDATE,
   CL_500_1.PD~       2873  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CL_500_1.PP~      14141  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CN_500J1.PD~       2879  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CN_500J1.PP~      19530  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP4_1.PD~       1762  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP4_1.PP~      14805  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8_1.PD~       1750  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8_1.PP~      13329  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8R1.PD~       1752  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8R1.PP~      14098  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8T1.PD~       1752  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   CNLBP8T1.PP~      13507  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DATAP462.PD~       1822  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DATAP462.PP~      11605  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DP_US470.PD~       1704  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DP_US470.PP~      22685  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DPLZ9601.PD~       1699  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   DPLZ9601.PP~      13612  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL3KF21.PD~       1780  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL3KF21.PP~      12817  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL3KF51.PD~       1780  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL3KF51.PP~      12817  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL75523.PD~       1767  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   EPL75523.PP~      12314  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   F71RX503.PD~       1682  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   F71RX503.PP~      11986  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP3SI523.PD~       1778  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP3SI523.PP~      12923  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP_3D522.PD~       1757  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP_3D522.PP~      13238  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP_3P522.PD~       1757  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HP_3P522.PP~      12849  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIID522.PD~       1754  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIID522.PP~      13239  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIII522.PD~       1759  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIII522.PP~      13009  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIIP522.PD~       1754  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   HPIIP522.PP~      13019  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   IBM17523.PD~       1749  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   IBM17523.PP~      15744  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   IBM20470.PD~       1489  "ALDUS\USENGLSH\PPDS2"  CHECKDATE,
   IBM20470.PP~      17583  "ALDUS\USENGLSH\PPDS2"  CHECKDATE
   }


DISK "(FreeHand Disk 2  720K)"
   {
   (C)ALDUS.'92         62,
   IBM30505.PD~       1767  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   IBM30505.PP~      11670  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   IBM39523.PD~       1749  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   IBM39523.PP~      16832  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L100_425.PD~       4662  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L100_425.PP~      13692  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L200_471.PD~       5669  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L200_471.PP~      19049  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L200_493.PD~       5669  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L200_493.PP~      19124  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L300_471.PD~       6853  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L300_471.PP~      21363  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L300_493.PD~       6853  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L300_493.PP~      20781  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L330_523.PD~       6472  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L330_523.PP~      17040  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L3330523.PD~      12751  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L3330523.PP~      33595  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L500_493.PD~       6938  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L500_493.PP~      19068  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L530_523.PD~       6248  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L530_523.PP~      14549  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L5330523.PD~      11148  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   L5330523.PP~      27406  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNT_470.PD~       1797  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNT_470.PP~      10801  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNTX470.PD~       1794  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNTX470.PP~      10805  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNTX518.PD~       1795  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   LWNTX518.PP~      10775  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   MONO_522.PD~       9891  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   MONO_522.PP~      29304  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N2090522.PD~       1721  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N2090522.PP~      10227  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N2290520.PD~       1706  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N2290520.PP~      10049  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N890_470.PD~       1726  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N890_470.PP~      11367  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N890X505.PD~       1734  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   N890X505.PP~      11736  "ALDUS\USENGLSH\PPDS3"  CHECKDATE,
   NCOL_519.PD~       2798  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   NCOL_519.PP~      11921  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   O5241503.PD~       1727  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   O5241503.PP~      11135  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   O5242503.PD~       1732  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   O5242503.PP~      10962  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   OL830525.PD~       1736  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   OL830525.PP~      14151  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   OL840518.PD~       1729  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   OL840518.PP~      13914  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   P4455514.PD~       1721  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   P4455514.PP~      13452  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2200523.PD~       2898  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2200523.PP~      13701  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2210523.PD~       2898  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2210523.PP~      13830  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2220523.PD~       2898  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q2220523.PP~      13909  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q810T517.PD~       1735  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q810T517.PP~      11482  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q820_517.PD~       1713  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q820_517.PP~      11425  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q820T517.PD~       1726  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   Q820T517.PP~      11443  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS10503.PD~       2841  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS10503.PP~      10122  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS20503.PD~       2853  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS20503.PP~       9743  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS30503.PD~       2885  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QCS30503.PP~      10165  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS81470.PD~       1720  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS81470.PP~      10851  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS8_461.PD~       1726  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS8_461.PP~      10249  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS8P461.PD~       1733  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMS8P461.PP~      11331  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMSCS494.PD~       2878  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMSCS494.PP~      10702  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMSJ_461.PD~       1709  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMSJ_461.PP~       8996  "ALDUS\USENGLSH\PPDS4"  CHECKDATE,
   QMSJP461.PD~       1722  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   QMSJP461.PP~      10079  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   QUME_470.PD~       1687  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   QUME_470.PP~      10268  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   R6000505.PD~       1726  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   R6000505.PP~      12054  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   S5232503.PD~       1804  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   S5232503.PP~      10796  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   S746J522.PD~       1687  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   S746J522.PP~      10976  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   SCG20522.PD~       5457  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   SCG20522.PP~      33265  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   T1513470.PD~       1735  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   T1513470.PP~      11154  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   T1535470.PD~       1735  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   T1535470.PP~      12237  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TEKCP494.PD~       1693  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TEKCP494.PP~      10360  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TI08_450.PD~       1746  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TI08_450.PP~      10042  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIM17521.PD~       1736  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIM17521.PP~      14413  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIM35521.PD~       1732  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIM35521.PP~      15283  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIX17521.PD~       1755  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIX17521.PP~      14229  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIX35521.PD~       1751  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TIX35521.PP~      15095  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TKPHZR21.PD~       1734  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TKPHZR21.PP~      10893  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TKPHZR31.PD~       1721  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   TKPHZR31.PP~      16280  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   U9415470.PD~       1687  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   U9415470.PP~      12446  "ALDUS\USENGLSH\PPDS5"  CHECKDATE,
   UNI17521.PD~       1743  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   UNI17521.PP~      15727  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   UNI39521.PD~       1744  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   UNI39521.PP~      16787  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   V5334522.PD~       8949  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   V5334522.PP~      29814  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT42P522.PD~       4973  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT42P522.PP~      16858  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT43P522.PD~       5687  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT43P522.PP~      19333  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT530522.PD~       7847  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT530522.PP~      26257  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT550522.PD~       3787  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT550522.PP~      12762  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT60P480.PD~       1747  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT60P480.PP~       9430  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT60W480.PD~       1745  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   VT60W480.PP~       9694  "ALDUS\USENGLSH\PPDS6"  CHECKDATE,
   ADIIMP.FL~         3680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CGMIMP.FL~        54272  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CHARTIMP.FL~       8480  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   LOTUSIMP.FL~       7680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEKIMP.FL~         7160  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WMFIMP.FL~         3718  "ALDUS\USENGLSH\FILTERS"  CHECKDATE
   }


DISK "(FreeHand Disk 3  720K)"
   {
   (C)ALDUS.'92         62,
   FH3PART1.72~     2097728
   }


DISK "(FreeHand Disk 4  720K)"
   {
   (C)ALDUS.'92         62,
   CALIBRAT.FT~      39276,
   BLENDTBL.FT~     118746,
   FH3DEF.FT~         3569,
   FH3IMRES.RS~       4080,
   MEMORY.EX~         8191,
   HPGLIMP.FL~       39936  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CRAYONLB.CL~       3876  "FH3LIB",
   FH3.HL~          508135  "FH3LIB",
   FH3LANG.DL~      557568  "FH3LIB",
   PANTONE.LI~       38594  "FH3LIB",
   ICONFONT.FO~       9728  "FH3LIB",
   ARTYIDVR.FH~      37376  "FH3FILT",
   ILLODVR.FH~       76800  "FH3FILT",
   BRIGHT.FT~         3945  "TEMPLATE",
   CORP.FT~           3831  "TEMPLATE",
   EARTH.FT~          4095  "TEMPLATE",
   PASTEL.FT~         4107  "TEMPLATE"
   }


DISK "(FreeHand Disk 5  720K)"
   {
   (C)ALDUS.'92         62,
   FH3PART2.72~     825536,
   DRWIDVR.FH~      139946  "FH3FILT",
   MFIDVR.FH~        65536  "FH3FILT",
   TRUETYPE.FH~      44610  "FH3FILT",
   TYPE1C2P.FH~       8356  "FH3FILT",
   TYPE3C2P.FH~      38400  "FH3FILT"
   }


DISK "(FreeHand Disk 6  720K)"
   {
   (C)ALDUS.'92         62,
   FH3IM.DL~        165645,
   LTTRING.FH~        6998  "SAMPART",
   FABRIC.FH~        43965  "SAMPART",
   MAP.FH~           54721  "SAMPART",
   INFOART.FH~       26936  "SAMPART",
   SEEDS.FH~         28956  "SAMPART",
   CAR.FH~           99918  "SAMPART",
   MEDICAL.FH~       23714  "SAMPART",
   COMPLEX.FT~       12085  "SAMPART\TRACING",
   SIMPLE.FT~        12085  "SAMPART\TRACING",
   TBOOK.EX~        384320  "TUTORIAL"
   }


DISK "(FreeHand Disk 7  720K)"
   {
   (C)ALDUS.'92         62,
   TBKCOMP.DL~      105104  "TUTORIAL",
   TEXT1.FT~          4885  "TUTORIAL",
   TEXT2.FT~          4715  "TUTORIAL",
   FH3TUTIN.TB~     270830  "TUTORIAL",
   ACRDN.FT~         13135  "TUTORIAL",
   BUTTONS.FT~        6640  "TUTORIAL",
   DRUMS1.FT~         9698  "TUTORIAL",
   DRUMS2.FT~         9922  "TUTORIAL",
   FH3TUT.IC~         1846  "TUTORIAL",
   FH3TUT5.TB~      593675  "TUTORIAL",
   GUITAR1.FT~        5677  "TUTORIAL",
   GUITAR2.FT~        5642  "TUTORIAL",
   GUITAR3.FT~        5620  "TUTORIAL",
   GUITAR4.FT~        5522  "TUTORIAL"
   }


DISK "(FreeHand Disk 8  720K)"
   {
   (C)ALDUS.'92         62,
   FH3TUT4.TB~      320644  "TUTORIAL",
   TBKBASE.DL~      353936  "TUTORIAL",
   FH3TUT3.TB~      454336  "TUTORIAL"
   }


DISK "(FreeHand Disk 9  720K)"
   {
   (C)ALDUS.'92         62,
   FH3TUT1.TB~      645166  "TUTORIAL",
   FH3TUT2.TB~      344296  "TUTORIAL",
   TBKUTIL.DL~       59008  "TUTORIAL",
   ARROWS-2.FT~      10377  "CLIPART",
   BORDERS2.FT~     139357  "CLIPART"
   }


DISK "(FreeHand Disk 10  720K)"
   {
   (C)ALDUS.'92         62,
   ARROWS-1.FT~      21492  "CLIPART",
   ANIMALS.FT~       84637  "CLIPART",
   ARTS.FT~         208074  "CLIPART",
   BORDERS1.FT~     123878  "CLIPART",
   SHAPES.FT~        24915  "CLIPART",
   SPORTS-2.FT~      30554  "CLIPART",
   SCENES.FT~       239971  "CLIPART",
   SPORTS-1.FT~     159243  "CLIPART"
   }


DISK "(FreeHand Disk 11  720K)"
   {
   (C)ALDUS.'92         62,
   MEDIA.FT~        354771  "CLIPART",
   SYMBOLS1.FT~      46974  "CLIPART\SYMBOLS",
   SYMBOLS2.FT~      41227  "CLIPART\SYMBOLS",
   SYMBOLS3.FT~      51115  "CLIPART\SYMBOLS",
   SYMBOLS4.FT~      98109  "CLIPART\SYMBOLS",
   SYMBOLS5.FT~      63242  "CLIPART\SYMBOLS",
   EUROPE-2.FT~      39801  "CLIPART\FLAGS",
   AFRICA-1.FT~      38732  "CLIPART\FLAGS",
   AFRICA-2.FT~      38250  "CLIPART\FLAGS",
   AMERICAS.FT~      85253  "CLIPART\FLAGS",
   ASIA-1.FT~        79096  "CLIPART\FLAGS",
   ASIA-2.FT~        45420  "CLIPART\FLAGS",
   EUROPE-1.FT~      59748  "CLIPART\FLAGS",
   AFRICA.FT~        62255  "CLIPART\MAPS"
   }


DISK "(FreeHand Disk 12  720K)"
   {
   (C)ALDUS.'92         62,
   ASIA.FT~         121833  "CLIPART\MAPS",
   BRITAIN.FT~      128182  "CLIPART\MAPS",
   EASTEURO.FT~     250449  "CLIPART\MAPS",
   SCANDVIA.FT~     224852  "CLIPART\MAPS",
   N&C-AMER.FT~     122707  "CLIPART\MAPS"
   }


DISK "(FreeHand Disk 13  720K)"
   {
   (C)ALDUS.'92         62,
   AUSTRLIA.FT~      35605  "CLIPART\MAPS",
   CAMERICA.FT~     112442  "CLIPART\MAPS",
   CENTEURO.FT~     141636  "CLIPART\MAPS",
   MIDEAST.FT~      401322  "CLIPART\MAPS",
   FRANCE.FT~       131212  "CLIPART\MAPS",
   JAPAN.FT~        194936  "CLIPART\MAPS"
   }


DISK "(FreeHand Disk 14  720K)"
   {
   (C)ALDUS.'92         62,
   SAMERICA.FT~      39351  "CLIPART\MAPS",
   EUROPE.FT~       111167  "CLIPART\MAPS",
   SPAIN.FT~        115238  "CLIPART\MAPS",
   USA.FT~          124502  "CLIPART\MAPS",
   ITALY.FT~         96135  "CLIPART\MAPS",
   USSR.FT~         220985  "CLIPART\MAPS",
   WORLD.FT~        206572  "CLIPART\MAPS"
   }

INITIAL FHDir "C:\FH3US"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus FreeHand 3.1 files."
	" "
	"If this is the directory you want, click OK."
	}



DIALOG BadMove "&Setup" "&Manual"
  {
	CAPTION "Modify your system file?"
	TEXT
	{
	"The PATH statement in AUTOEXEC.BAT must include"
	"the Aldus FreeHand and Aldus directories in order for"
	"the program to run."
	" "
	"If you want to edit the PATH statement yourself later,"
	"click ""Manual.""  If you want Aldus Setup to modify"
	"the PATH statement, click ""Setup."""
        }
  }

DIALOG PPDWarning "&OK"
  {
	CAPTION "Printer support note"
	TEXT
	{
	"Aldus Setup allows you to choose printer support files (PPDs)"
	"by manufacturer. If you choose to install all of the PPDs, they"
	"will occupy 2MB of hard disk space and will extend the installation"
	"time."
	""
	"Please see the README.TXT file for a complete list of the PPDs"
	"and their printer equivalents."
	}
  }

DIALOG AldusGroup "&Continue"
  {
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus Setup program has created the Aldus"
	"group window."
	" "
	"Aldus Setup, Aldus FreeHand 3.1, and FH3 Tutorial"
	"(if installed) have been added to the Aldus Group."
	"Double-click a program icon to launch the program."
	}
  }

PACKAGE PROLOGUE "" SELECTED INVISIBLE
	{
	SET MustReboot "FALSE"
	SET Answer2 "&Manual"

	GETALDDIR AldDir
	}   /* end of Prologue */

PACKAGE First "" SELECTED INVISIBLE
  {
	SET ExeInstalled "FALSE"
  }

PACKAGE FreeHand "Aldus FreeHand 3.1  (5MB)" SELECTED
    {
    CONFIRMDIR FHDir

    GETPERSONAL                 /* ask user for personalization info */


    CONCAT AldDir "USENGLSH" EngDir
    CONCAT EngDir "SETUP" SetupDir
    CONCAT FHDir "FH3FILT" FHFiltDir
    CONCAT FHDir "FH3LIB" FHLibDir
    CONCAT FHDir "TEMPLATE" TemplateDir


    FILES AldDir
        {
    	ALDVM.DL~         
        }

    FILES EngDir
        {
	ALDVMRES.RS~
        }

    FILES SetupDir
        {
        ALDSETUP.EXE
	FH3720.CTL
        }

    FILES FHDir
        {
	(C)ALDUS.'92
        README.TXT
	REGCARD.FH~
	MEMORY.EX~
	FH3DEF.FT~
	FH3IM.DL~
	FH3IMRES.RS~
	BLENDTBL.FT~
	CALIBRAT.FT~
	FH3PART1.72~
	FH3PART2.72~
        }

    FILES FHFiltDir
        {
	ARTYIDVR.FH~
	DRWIDVR.FH~
	ILLODVR.FH~
	MFIDVR.FH~
	TRUETYPE.FH~
	TYPE1C2P.FH~
	TYPE3C2P.FH~
	}

    FILES TemplateDir
        {
	BRIGHT.FT~
	CORP.FT~
	EARTH.FT~
	PASTEL.FT~
	}
 
    FILES FHLibDir
	{
	CRAYONLB.CL~
	PANTONE.LI~
	FH3.HL~
	FH3LANG.DL~
	ICONFONT.FO~
	}

	
    ALDUSINI
	{
	"FreeHand3" "FreeHandFilters" FHFiltDir,
	"FreeHand3" "FreeHandLibrary" FHLibDir,
	"FreeHand3" "MAXIMIZE" "1"
	} 

    WININI
	{
	"Aldus" "NetAldusDirectory" "NONE",
	"Aldus"	"FH3LangDir" "USENGLSH",
	"Aldus"	"FreeHand3Directory" FHDir,
	"Extensions" "ft3" "fh3.exe ^.ft3",
	"Extensions" "fh3" "fh3.exe ^.fh3"
	}

    /* Ask the user if they want their system files checked and
     * updated if necessary.  Record their answer in the variable
     * Answer.
     */

    DISPLAY BadMove Answer2
    IF Answer2 EQS "&Setup"
        {
        SET MustReboot "TRUE"
        GETBOOTDRIVE BootDrive
        ONINSTALL
            {
            MODIFY "AUTOEXEC.BAT" BootDrive
                {
                PATH "path" FHDir
                PATH "path" AldDir
                }
            } /* end oninstall */
        }  /* end if */


     ONINSTALL
	{
	ASSEMBLE "FH3.EXE"
            {
            FH3PART1.72~
            FH3PART2.72~
            }		      
        } 
    CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
    CONCAT FHDir "FH3.EXE" FullFreeHandName
    ONINSTALL
        {
        ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
        ADDPROGRAMITEM "Aldus" FullFreeHandName "Aldus FreeHand 3.1" FullFreeHandName 0
	DISPLAY AldusGroup
        }

    ONINSTALL
	{
	PERSONALIZE FHLibDir "FH3LANG.DLL"     
        }



    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
        {
        WINDOWSMENU FHDir "README.TXT" "&README.TXT" 
        }
    SET ExeInstalled "TRUE"
    }   /* end FreeHand package */

PACKAGE Tutorial  "Interactive tutorial (3.6MB)"  SELECTED
    {
    CONFIRMDIR FHDir
    CONCAT FHDir "TUTORIAL" TutorialDir
    FILES TutorialDir
	{
	ACRDN.FT~
	BUTTONS.FT~
	DRUMS1.FT~
	DRUMS2.FT~
	FH3TUT.IC~
	FH3TUT1.TB~
	FH3TUT2.TB~
	FH3TUT3.TB~
	FH3TUT4.TB~
	FH3TUT5.TB~
	FH3TUTIN.TB~
	GUITAR1.FT~
	GUITAR2.FT~
	GUITAR3.FT~
	GUITAR4.FT~
	TBKBASE.DL~
	TBKCOMP.DL~
	TBKUTIL.DL~
	TBOOK.EX~
	TEXT1.FT~
	TEXT2.FT~
	}
    CONCAT TutorialDir "TBOOK.EXE FH3TUTIN.TBK" FullTutorialName
    CONCAT TutorialDir "FH3TUT.ICO" FullIconName
    ALDUSINI
	{
	"FreeHand3" "Tutorial" TutorialDir 
	}
    WININI
	{
	"Extensions" "tbk" "tbook.exe ^.tbk"
	}				    	
    ONINSTALL
        {
        ADDPROGRAMITEM "Aldus" FullTutorialName "FH3 Tutorial" FullIconName 0
        }
    }      /* end of Tutorial package */

PACKAGE Filters "Aldus product filters  (.1MB)" SELECTED
    {
	CONCAT AldDir "USENGLSH" EngDir
	CONCAT EngDir "FILTERS" FiltDir

	SELECT2 "Select filters" FiltDir
        {
        TEXT
            {
            "Select the Aldus product import filters you want"
            "to install or remove:"
            }
        ITEMS
	{
   ADIIMP.FL~ "ADI (.PLT) Import" "[AldusImports]" "ADI (.PLT) Import=ADIIMP.FLT,PLT",
   ADIIMP.FL~ "ADI (.ADI) Import" "[AldusImports]" "ADI (.ADI) Import=ADIIMP.FLT,ADI",
   CGMIMP.FL~ "CGM Graphics Import" "[AldusImports]" "CGM Graphics Import=CGMIMP.FLT,CGM",
   CHARTIMP.FL~ "Excel Chart Import" "[AldusImports]" "Excel Chart Import=CHARTIMP.FLT,XLC",
   HPGLIMP.FL~ "HPGL Import" "[AldusImports]" "HPGL Import=HPGLIMP.FLT,PLT",
   LOTUSIMP.FL~ "Lotus 1-2-3 (.PIC) Import" "[AldusImports]" "Lotus 1-2-3 (.PIC) Import=LOTUSIMP.FLT,PIC",
   TEKIMP.FL~ "Tektronix PLOT-10 Import" "[AldusImports]" "Tektronix PLOT-10 Import=TEKIMP.FLT,PLT",
   WMFIMP.FL~ "Windows Metafile Import" "[AldusImports]" "Windows Metafile Import=WMFIMP.FLT,WMF"
	}  /* end items */
        HELP
	{
	"Hold down Ctrl and click to select the import"
	"filters that you want to install from the "
	"""Available for installation"" list."
	" "
	"To remove a filter, select it from the ""Currently"
	"installed"" list.  Keep in mind that removing"
	"an Aldus product filter removes it for other"
	"Aldus programs you may have."
	}
    }  /* end select */

    ALDUSINI
	{
	"FreeHand3" "AldusFilters" FiltDir
	} 
 }   /* end of Filters pkg */



PACKAGE ClipArt "Clip art  (4.8MB) "  SELECTED
    {
    CONFIRMDIR FHDir
    CONCAT FHDir "CLIPART" ClipArtDir
    SELECT1 "Select clip art" ClipArtDir
        {
        TEXT
            {
	"Select the clip art files you want"
	"to install:"
            }
        ITEMS
		{
		ANIMALS.FT~ "ANIMALS",
		ARROWS-1.FT~+
		ARROWS-2.FT~ "ARROWS",
		ARTS.FT~ "ARTS",
		BORDERS1.FT~+
		BORDERS2.FT~ "BORDERS",
		AFRICA-1.FT~+
		AFRICA-2.FT~+
		AMERICAS.FT~+
		ASIA-1.FT~+
		ASIA-2.FT~+
		EUROPE-1.FT~+
		EUROPE-2.FT~ "FLAGS" "FLAGS",
		AFRICA.FT~+
		ASIA.FT~+
		AUSTRLIA.FT~+
		BRITAIN.FT~+
		CAMERICA.FT~+
		CENTEURO.FT~+
		EASTEURO.FT~+
		EUROPE.FT~+
		FRANCE.FT~+
		ITALY.FT~+
		JAPAN.FT~+
		MIDEAST.FT~+
		N&C-AMER.FT~+
		SAMERICA.FT~+
		SCANDVIA.FT~+
		SPAIN.FT~+
		USA.FT~+
		USSR.FT~+
		WORLD.FT~ "MAPS" "MAPS",
		MEDIA.FT~ "MEDIA",
		SCENES.FT~ "SCENES",
		SHAPES.FT~ "SHAPES",
		SPORTS-1.FT~+
		SPORTS-2.FT~ "SPORTS",
		SYMBOLS1.FT~+
		SYMBOLS2.FT~+
		SYMBOLS3.FT~+
		SYMBOLS4.FT~+
		SYMBOLS5.FT~ "SYMBOLS" "SYMBOLS"
		}
        HELP
        {
	"Hold down Ctrl and click to select the clip art"
	"files that you want to install. Refer to the"
	"""Aldus FreeHand Getting Started"" manual for"
	"more information about the clip art."
        }
      }   
    }   /*  end of ClipArt package */


PACKAGE SampArt "Sample art  (.3MB)" SELECTED
    {
	CONFIRMDIR FHDir
	CONCAT FHDir "SAMPART" SampDir
	SELECT1 "Select sample art" SampDir
	{
	TEXT
		{
		"Select the sample art files you"
		"want to install:"
		}
	ITEMS
		{
		CAR.FH~ "Car",
		MAP.FH~ "Color Map",
		FABRIC.FH~ "Fabric Design",
		INFOART.FH~ "Information Art",
		MEDICAL.FH~ "Medical",
		LTTRING.FH~ "Sample Lettering",
		SEEDS.FH~ "Seed Packaging",
		COMPLEX.FT~+
       		SIMPLE.FT~ "Tracing" "TRACING"
		}
	        HELP
		{
		"Hold down Ctrl and click to select the sample"
		"art files you want to install."
		}
     	}   /* end select1 */

    }   /* end of SampArt package */

PACKAGE PPDs "Printer support files  (2.2MB)" SELECTED
	{
	CONCAT AldDir "USENGLSH" EngDir
	CONCAT EngDir "PPDS" PPDDir
	DISPLAY PPDWarning
	WININI
		{
		"Aldus" "PPDDir" PPDDir
		}
	SELECT1 "Select printer files by manufacturer" PPDDir
	{
	TEXT
		{
		"To conserve disk space, select only"
		"the printers you want to use."
		}
	ITEMS
		{
		AC500503.PD~+
		AC500503.PP~+
		CG20_523.PD~+
		CG20_523.PP~+
		CG50_523.PD~+
		CG50_523.PP~+
		CG94_493.PD~+
		CG94_493.PP~+
		CG94_523.PD~+
		CG94_523.PP~+
		CG96_523.PD~+
		CG96_523.PP~+
		CG97_523.PD~+
		CG97_523.PP~+
		CG98_523.PD~+
		CG98_523.PP~ "Agfa Printers",
		APLWIIF1.PD~+
		APLWIIF1.PP~+
		APLWIIG1.PD~+
		APLWIIG1.PP~+
		APPLE230.PD~+
		APPLE230.PP~+
		APPLE380.PD~+
		APPLE380.PP~+
		APPLE422.PD~+
		APPLE422.PP~+
		A_PNT518.PD~+
		A_PNT518.PP~+
		LWNT_470.PD~+
		LWNT_470.PP~+
		LWNTX470.PD~+
		LWNTX470.PP~+
		LWNTX518.PD~+
		LWNTX518.PP~ "Apple Printers",
		APS08522.PD~+
		APS08522.PP~+
		APS12522.PD~+
		APS12522.PP~+
		APS26522.PD~+
		APS26522.PP~+
		APS80522.PD~+
		APS80522.PP~ "APS Printers",
		AST__470.PD~+
		AST__470.PP~ "AST Printers",
		CL_500_1.PD~+
		CL_500_1.PP~+
		CN_500J1.PD~+
		CN_500J1.PP~+
		CNLBP4_1.PD~+
		CNLBP4_1.PP~+
		CNLBP8_1.PD~+
		CNLBP8_1.PP~+
		CNLBP8R1.PD~+
		CNLBP8R1.PP~+
		CNLBP8T1.PD~+
		CNLBP8T1.PP~ "Canon Printers",
		DATAP462.PD~+
		DATAP462.PP~+
		DP_US470.PD~+
		DP_US470.PP~+
		DPLZ9601.PD~+
		DPLZ9601.PP~ "Dataproducts Printers",
		EPL3KF21.PD~+
		EPL3KF21.PP~+
		EPL3KF51.PD~+
		EPL3KF51.PP~+
		EPL75523.PD~+
		EPL75523.PP~ "Epson Printers",
		F71RX503.PD~+
		F71RX503.PP~ "Fujitsu Printers",
		ALJII523.PD~+		    
		ALJII523.PP~ "HP LaserJet II (Adobe PS cartridge)", 
		QMSJP461.PD~+
		QMSJP461.PP~+
		QMSJ_461.PP~+
		QMSJ_461.PD~ "HP LaserJet (QMS PS or PS+)",
		HPIID522.PD~+
		HPIID522.PP~+
		HPIII522.PD~+
		HPIII522.PP~+
		HPIIP522.PD~+
		HPIIP522.PP~ "HP LaserJet II Printers",
		HP3SI523.PD~+
		HP3SI523.PP~+
		HP_3D522.PD~+
		HP_3D522.PP~+
		HP_3P522.PD~+
		HP_3P522.PP~ "HP LaserJet III Printers",
		IBM17523.PD~+
		IBM17523.PP~+
		IBM20470.PD~+
		IBM20470.PP~+
		IBM30505.PD~+
		IBM30505.PP~+
		IBM39523.PD~+
		IBM39523.PP~ "IBM Printers",
		L100_425.PD~+
		L100_425.PP~+
		L200_471.PD~+
		L200_471.PP~+
		L200_493.PD~+
		L200_493.PP~+
		L300_471.PD~+
		L300_471.PP~+
		L300_493.PD~+
		L300_493.PP~+
		L330_523.PD~+
		L330_523.PP~+
		L3330523.PD~+
		L3330523.PP~+
		L500_493.PD~+
		L500_493.PP~+
		L530_523.PD~+
		L530_523.PP~+
		L5330523.PD~+
		L5330523.PP~ "Linotype Printers",
		MONO_522.PD~+
		MONO_522.PP~ "Monotype Printers",
		N2090522.PD~+
		N2090522.PP~+
		N2290520.PD~+
		N2290520.PP~+
		N890_470.PD~+
		N890_470.PP~+
		N890X505.PD~+
		N890X505.PP~+
		NCOL_519.PD~+
		NCOL_519.PP~ "NEC Printers",
		O5241503.PD~+
		O5241503.PP~+
		O5242503.PD~+
		O5242503.PP~ "Oc Printers",
		OL830525.PD~+
		OL830525.PP~+
		OL840518.PD~+
		OL840518.PP~ "Okidata Printers",
		P4455514.PD~+
		P4455514.PP~ "Panasonic Printers",
		Q2200523.PD~+
		Q2200523.PP~+
		Q2210523.PD~+
		Q2210523.PP~+
		Q2220523.PD~+
		Q2220523.PP~+
		Q810T517.PD~+
		Q810T517.PP~+
		Q820_517.PD~+
		Q820_517.PP~+
		Q820T517.PD~+
		Q820T517.PP~+
		QCS10503.PD~+
		QCS10503.PP~+
		QCS20503.PD~+
		QCS20503.PP~+
		QCS30503.PD~+
		QCS30503.PP~+
		QMS81470.PD~+
		QMS81470.PP~+
		QMS8_461.PD~+
		QMS8_461.PP~+
		QMS8P461.PD~+
		QMS8P461.PP~+
		QMSCS494.PD~+
		QMSCS494.PP~ "QMS Printers",
		QUME_470.PD~+
		QUME_470.PP~ "Qume Printers",
		R6000505.PD~+
		R6000505.PP~ "Ricoh Printers",
		S5232503.PD~+
		S5232503.PP~ "Schlumberger Printers",
		S746J522.PD~+
		S746J522.PP~ "Shinko Printers",
		SCG20522.PD~+
		SCG20522.PP~ "Scantext Printers",
		TKPHZR21.PD~+
		TKPHZR21.PP~+
		TKPHZR31.PD~+
		TKPHZR31.PP~+
		TEKCP494.PD~+
		TEKCP494.PP~ "Tektronix Printers",
		T1513470.PD~+
		T1513470.PP~+
		T1535470.PD~+
		T1535470.PP~+
		TI08_450.PD~+
		TI08_450.PP~+
		TIM17521.PD~+
		TIM17521.PP~+
		TIM35521.PD~+
		TIM35521.PP~+
		TIX17521.PD~+
		TIX17521.PP~+
		TIX35521.PD~+
		TIX35521.PP~ "Texas Instruments Printers",
		U9415470.PD~+
		U9415470.PP~+
		UNI17521.PD~+
		UNI17521.PP~+
		UNI39521.PD~+
		UNI39521.PP~ "Unisys Printers",
		V5334522.PD~+
		V5334522.PP~+
		VT42P522.PD~+
		VT42P522.PP~+
		VT43P522.PD~+
		VT43P522.PP~+
		VT530522.PD~+
		VT530522.PP~+
		VT550522.PD~+
		VT550522.PP~+
		VT60P480.PD~+
		VT60P480.PP~+
		VT60W480.PD~+
		VT60W480.PP~ "Varityper Printers"
		}
	HELP
		{
		"Hold down Ctrl and click to select printer"
		"support files for the manufacturers of the"
		"printers you have installed."
		""
		"Printer support files contain information "
		"that helps Aldus FreeHand produce the best"
		"printed results possible for each kind of"
		"PostScript printer."
		}
	}  /* end Select */


    }  /* End of PPD package */

	


DIALOG SucRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to read the Aldus"
	"FreeHand 3.1 README.TXT file, which has been added to the" 
	"View menu.  You may also choose to examine other information"
	"provided from the Diagnostics or View menus in Aldus Setup."
    }
}

DIALOG SucNoRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
    }
}

DIALOG RebootReminder "&OK"
{
    TEXT
	{
	"Your AUTOEXEC.BAT file has been changed."
	"You must restart your machine before running"
	"Aldus FreeHand 3.1."
	}
}

PACKAGE Last "" SELECTED INVISIBLE
 {
    IF ExeInstalled EQS "TRUE"
	{  
	ONINSTALL
		{
		DISPLAY SucRead
		}
	}
    IF ExeInstalled EQS "FALSE"
        {
        ONINSTALL
		{
        	DISPLAY SucNoRead
		}
	}
    IF MustReboot EQS "TRUE"
        {
        ONINSTALL
		{
	        DISPLAY RebootReminder
		}
        }
 }

/*
PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
    IF MustReboot EQS "TRUE"
        {
        DISPLAY RebootReminder
        }
    }
*/
