{{$DEFINE DEBUG}
{Shortens each minute from 60 seconds to 5 seconds for debugging purposes;
undefine or comment out for normal operation.}

(* global variables and structs *)

unit tt_vars;

interface

{untyped constants (fixed values)}
const
  maxtasks=32;
  ScreenWidth=40;
  TaskNameLength=ScreenWidth-2;
  TaskCommentLength=(ScreenWidth*5)-1;
  bSunday   = 1;
  bMonday   = 2;
  bTuesday  = 4;
  bWednesday= 8;
  bThursday =16;
  bFriday   =32;
  bSaturday =64;
  bReserved=128;

{type definitions}
type
  bDays=byte;
  Second=byte;
  Minute=word;
  TaskNum=byte;
  useractions=(
    none,
    pausetask,
    skiptask,
    defertask,
    extendtask,
    acknowledge,
    quit
  );
  task=record
    TaskName:string[TaskNameLength];
    Days:bDays;
    MinMinutes,MaxMinutes,ExtendedMinutes:Minute;
    Pausable,Skippable,Deferrable,Extendable,
    Completed,Paused:boolean;
    SecondsRemaining,SecondsSpent:longint;
    TaskComment:string[TaskCommentLength];
  end;
  taskarray=array [0..maxtasks-1] of task;

{typed constants (initialized variables}
const
  daysofweek:array[0..6] of byte=(
    bSunday,bMonday,bTuesday,bWednesday,bThursday,bFriday,bSaturday
  );
  TotalSeconds:longint=0;
  LastKnownSecond:byte=255;
  curtask:tasknum=0;
  numtasks:tasknum=0;
  TaskFileName:string='tasks.ini';
  Delimiter:char='|';
  UserExit:boolean=false;
  {$IFDEF DEBUG}
  NumSecondsInAMinute=5;
  {$ELSE}
  NumSecondsInAMinute=60;
  {$ENDIF}
  NumSecondsInAnHour=NumSecondsInAMinute*60;
  ExtendStep=1;
  Verbose:boolean=false;
  WeekString:string[7]='SMTWTFS';
  CheckOnly:boolean=false;

var
  Tasks:taskarray;

implementation

(* nothin' here but us chickens... *)

end.
