{$S-,R-,V-,I-,B-,F+,O+,A-}

{$I OPDEFINE.INC}

{*********************************************************}
{*                    OPDOS.PAS 1.10                     *}
{*     Copyright (c) TurboPower Software 1987, 1989.     *}
{* Portions copyright (c) Sunny Hill Software 1985, 1986 *}
{*     and used under license to TurboPower Software     *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit OpDos;
  {-Miscellaneous DOS/BIOS call routines}

interface

uses
  Dos, OpString;

const
  ExecSaveScreen    = 0;
  ExecShowMemory    = 1;
  ExecPauseAfterRun = 2;
  ExecRestoreScreen = 3;
type
  ActionCodeType = ExecSaveScreen..ExecRestoreScreen;
  DiskClass = (
    Floppy360, Floppy720, Floppy12, Floppy144, OtherFloppy, Bernoulli,
    HardDisk, RamDisk, SubstDrive, UnknownDisk, InvalidDrive);

  EnvRec =
    record
      EnvSeg : Word;              {Segment of the environment}
      EnvLen : Word;              {Usable length of the environment}
      EnvPtr : Pointer;           {Nil except when allocated on heap}
    end;

  ExecDosProc = procedure(ActionCode : ActionCodeType; Param : Word);

const
  StackSafetyMargin : Word = 1000;
  MinSpaceForDos : Word = 20000; {Minimum bytes for DOS shell to run}

  StdInHandle = 0;           {handle numbers for OpenStdDev}
  StdOutHandle = 1;
  StdErrHandle = 2;
  StdPrnHandle = 4;

function DosVersion : Word;
  {-Returns the DOS version number. High byte has major version number,
    low byte has minor version number. Eg., DOS 3.1 => $0301.}
  inline(
    $B4/$30/                 {mov ah,$30}
    $CD/$21/                 {int $21}
    $86/$C4);                {xchg ah,al}

function NumberOfDrives : Byte;
  {-Returns the number of logical drives}

procedure SelectDrive(Drive : Char);
  {-Selects the specified drive as default if possible}

function DefaultDrive : Char;
  {-Returns the default drive as an uppercase letter}

function ValidDrive(Drive : Char) : Boolean;
  {-Return True if the specified drive is valid}

function GetDiskInfo(Drive : Byte; var ClustersAvailable, TotalClusters,
                     BytesPerSector, SectorsPerCluster : Word) : Boolean;
  {-Return technical info about the specified drive}

function GetDiskClass(Drive : Char; var SubstDriveChar : Char) : DiskClass;
  {-Return the disk class for the drive with the specified letter}

function ReadDiskSectors(Drive : Word; FirstSect : Longint;
                         NumSects : Word; var Buf) : Boolean;
  {-Read absolute disk sectors.}

function WriteDiskSectors(Drive : Word; FirstSect : Longint;
                          NumSects : Word; var Buf) : Boolean;
  {-Write absolute disk sectors.}

function GetFileMode(FName : string; var Attr : Word) : Byte;
  {-Returns a file's attribute in Attr and the DOS error code as the function
    result.}

function FlushDosBuffers(var F) : Boolean;
  {-Flush DOS's buffers for the specified file}

function FileHandlesLeft : Byte;
  {-Return the number of available file handles}

function FileHandlesOpen(CountDevices : Boolean) : Byte;
  {-Return the number of open files owned by a program}

procedure SetDta(DTAptr : Pointer);
  {-Set the DOS DTA to point to DTAptr}

procedure GetDta(var DTAptr : Pointer);
  {-Return the DOS DTA pointer}

function ParsePath(var InputPath, SearchPath, LeadInPath : string) : Boolean;
  {-Takes a user entered path, trims blanks, and returns a valid global
    search path and a valid lead-in path.}

function PrintInstalled : Boolean;
  {-Returns True if PRINT.COM is installed}

function SubmitPrintFile(FileName : string) : Byte;
  {-This procedure submits a file to the PC DOS 3.0 or greater concurrent
   print utility.}

procedure CancelPrintFile(FileMask : string);
  {-Cancels the files matched by the file mask passed in FileMask.}

procedure CancelAllPrintFiles;
  {-Cancels all files in the print queue}

function GetPrintStatus(var QPtr : Pointer) : Byte;
 {-Halts printing, returns current error status, puts pointer to the filename
   queue in the QPtr variable. Filenames in the queue are 64-byte ASCIIZ
   strings. The end of the queue is marked by a name starting with a null.}

procedure EndPrintStatus;
  {-Releases the spooler from the GetPrintStatus procedure.}

function GetEnvironmentString(SearchString : string) : string;
  {-Return a string from the environment}

function SetBlock(var Paragraphs : Word) : Boolean;
  {-Change size of DOS memory block allocated to this program}

procedure NoExecDosProc(ActionCode : ActionCodeType; Param : Word);
  {-Do-nothing ExecDosProc}

function ExecDos(Command : string; UseSecond : Boolean; EDP : ExecDosProc) : Integer;
 {-Execute any DOS command. Call with Command = '' for a new shell.
   If UseSecond is false, Command must be the full pathname of a program to be
   executed. EDP is a procedure to display status, save/restore the screen,
   etc. ExecDos return codes are as follows:
         0 : Success
        -1 : Insufficient memory to store free list
        -2 : DOS setblock error before EXEC call
        -3 : DOS setblock error after EXEC call  -- critical error!
        -4 : Insufficient memory to run DOS command
      else   a DOS error code
  }

function TextSeek(var F : Text; Target : LongInt) : Boolean;
 {-Do a Seek for a text file opened for input. Returns False in case of I/O
   error.}

function TextFileSize(var F : Text) : LongInt;
  {-Return the size of text file F. Returns -1 in case of I/O error.}

function TextPos(var F : Text) : LongInt;
 {-Return the current position of the logical file pointer (that is,
   the position of the physical file pointer, adjusted to account for
   buffering). Returns -1 in case of I/O error.}

function TextFlush(var F : Text) : Boolean;
  {-Flush the buffer(s) for a text file. Returns False in case of I/O error.}

function OpenStdDev(var F : Text; StdHandle : Word) : Boolean;
  {-Assign the text file to a standard DOS device: 0, 1, 2, or 4}

function HandleIsConsole(Handle : Word) : Boolean;
  {-Return true if handle is the console device}

procedure SetRawMode(var F : Text; On : Boolean);
  {-Set "raw" mode on or off for the specified text file (must be a device)}

function ExistFile(FName : string) : Boolean;
  {-Return true if file is found}

function ExistOnPath(FName : string; var FullName : string) : Boolean;
 {-Return true if fname is found in
   a) current directory
   b) program's directory (DOS 3.X only)
   c) any DOS path directory
  and return full path name to file}

function IsDirectory(FName : String) : Boolean;
  {-Return true if FName is a directory}

function SameFile(FilePath1,FilePath2 : String;
                  var ErrorCode : Word) : Boolean;
  {-Return true if FilePath1 and FilePath2 refer to the same physical file.
    Error codes:
      0 - Success (no error)
      1 - Invalid FilePath
  }

function CopyFile(SrcPath, DestPath : String;
                  Buffer : Pointer;
                  BufferSize : Word) : Word;
  {-Copy the file specified by SrcPath into DestPath. DestPath must specify
    a complete filename, it may not be the name of a directory without the
    file portion.  This a low level routine, and the input pathnames are not
    checked for validity. Buffer must already be allocated, and must be no
    less than BufferSize.}

function TimeMs : LongInt;
  {-Return time of day in milliseconds since midnight}

{-------- routines from TPENV --------}

procedure MasterEnv(var Env : EnvRec);
  {-Return master environment record}

procedure CurrentEnv(var Env : EnvRec);
  {-Return current environment record}

procedure ParentEnv(var Env : EnvRec);
  {-Return environment record of program's parent}

procedure NewEnv(var Env : EnvRec; Size : Word);
  {-Allocate a new environment on the heap}

procedure DisposeEnv(var Env : EnvRec);
  {-Deallocate an environment previously allocated on heap}

procedure SetCurrentEnv(Env : EnvRec);
  {-Specify a different environment for the current program}

procedure CopyEnv(Src, Dest : EnvRec);
  {-Copy contents of Src environment to Dest environment}

function EnvFree(Env : EnvRec) : Word;
  {-Return bytes free in environment}

function GetEnvStr(Env : EnvRec; Search : string) : string;
  {-Return a string from the environment}

function SetEnvStr(Env : EnvRec; Search, Value : string) : Boolean;
  {-Set environment string, returning true if successful}

procedure DumpEnv(Env : EnvRec);
  {-Dump the environment to the screen}

function GetProgramStr(Env : EnvRec) : string;
  {-Return the name of the program that owns Env, '' if DOS < 3.0 or unknown}

function SetProgramStr(Env : EnvRec; Path : string) : Boolean;
  {-Add a program name to the end of an environment if sufficient space}

function ShellWithPrompt(Prompt : string; EDP : ExecDosProc) : Integer;
  {-Shell to DOS with a new prompt}

  {============================================================================}

implementation

type
  SegOfs = record
             O, S : Word;
           end;
  LongRec = record
              LowWord, HighWord : Word; {structure of a LongInt}
            end;

  EnvArray = array[0..32767] of Char;
  EnvArrayPtr = ^EnvArray;

  {text buffer}
  TextBuffer = array[0..65520] of Byte;
var
  Regs : Registers;
const                         {!!.02}
  DSReadDrive  : Byte = $FF;  {!!.02}
  DSWriteDrive : Byte = $FF;  {!!.02}
  DSReadBig    : Byte = $00;  {!!.02}
  DSWriteBig   : Byte = $00;  {!!.02}

  {$L OPDISK.OBJ}

  function NumberOfDrives : Byte; external;
  procedure SelectDrive(Drive : Char); external;
  function DefaultDrive : Char; external;
  function GetDiskInfo(Drive : Byte; var ClustersAvailable, TotalClusters,
                       BytesPerSector, SectorsPerCluster : Word) : Boolean;
    external;
  function ReadDiskSectors(Drive : Word; FirstSect : Longint;
                           NumSects : Word; var Buf) : Boolean;
    external;
  function WriteDiskSectors(Drive : Word; FirstSect : Longint;
                            NumSects : Word; var Buf) : Boolean;
    external;

  function ValidDrive(Drive : Char) : Boolean;
    {-Return True if the specified drive is valid}
  var
    CurDrive : Char;
  begin
    CurDrive := DefaultDrive;
    SelectDrive(Drive);
    ValidDrive := (DefaultDrive = Drive);
    SelectDrive(CurDrive);
  end;

  function GetDiskClass(Drive : Char; var SubstDriveChar : Char) : DiskClass;
    {-Return the disk class for the drive with the specified letter}
    {-This routine uses an undocumented DOS function ($32). Information about
      this function was obtained from Terry Dettmann's DOS Programmer's
      Reference (Que, 1988).}
  type
    ParamBlock =
      record
        DriveNumber, DeviceDriverUnit : Byte;
        BytesPerSector : Word;
        SectorsPerCluster, ShiftFactor : Byte;
        ReservedBootSectors : Word;
        FatCopies : Byte;
        RootDirEntries, FirstDataSector, HighestCluster : Word;
        SectorsPerFat : Byte;
        RootDirStartingSector : Word;
        DeviceDriverAddress : Pointer;
        Media2and3 : Byte; {media descriptor here in DOS 2.x and 3.x}
        Media4 : Byte;     {media descriptor here in DOS 4.x}
        NextDeviceParamBlock : Pointer;
      end;
    ParamBlockPtr = ^ParamBlock;
  var
    DriveNum : Byte;
    MediaDescriptor : Byte;
  begin
    {assume failure}
    GetDiskClass := InvalidDrive;

    {assume that this is not a SUBSTituted drive}
    SubstDriveChar := Drive;

    {convert drive letter to drive number}
    Drive := Upcase(Drive);
    case Drive of
      'A'..'Z' : DriveNum := Ord(Drive)-$40;
      else Exit;
    end;

    with Regs do begin
      {get pointer to media descriptor byte}
      AH := $1C;
      DL := DriveNum;
      MsDos(Regs);
      MediaDescriptor := Mem[DS:BX];

      {get pointer to drive parameter block}
      AH := $32;
      DL := DriveNum;
      MsDos(Regs);

      {drive invalid if AL = $FF}
      if (AL = $FF) then
        Exit;

      with ParamBlockPtr(Ptr(DS,BX))^ do begin
        {DOS 4.x has bug in $1C function}                        {!!.02}
        if (Hi(DosVersion) = 4) and (MediaDescriptor = $FF) then {!!.02}
          MediaDescriptor := Media4;                             {!!.02}

        {check for SUBSTituted drive}
        if (DriveNumber <> Pred(DriveNum)) then begin
          GetDiskClass := SubstDrive;
          SubstDriveChar := Char(Ord('A')+DriveNumber);
        end
        else if (FatCopies = 1) then
          {RAM disks have one copy of File Allocation Table}
          GetDiskClass := RamDisk
        else if (MediaDescriptor = $F8) then
          {MediaDescriptor of $F8 indicates hard disk}
          GetDiskClass := HardDisk
        else if (MediaDescriptor = $FD) and (SectorsPerFat <> 2) then
          {Bernoulli drives have more than 2 sectors per FAT}
          GetDiskClass := Bernoulli
        else if (MediaDescriptor >= $F9) then
          {media descriptors >= $F9 are for floppy disks}
          case HighestCluster of
             355 : GetDiskClass := Floppy360;
             714,
            1423 : GetDiskClass := Floppy720;
            2372 : GetDiskClass := Floppy12;
            else   GetDiskClass := OtherFloppy;
          end
        else if (MediaDescriptor = $F0) and (HighestCluster = 2848) then
          {it's a 1.44 meg floppy}
          GetDiskClass := Floppy144
        else
          {unable to classify disk/drive}
          GetDiskClass := UnknownDisk;
      end;
    end;
  end;

  function GetFileMode(FName : string; var Attr : Word) : Byte;
    {-Returns a file's attribute in Attr and the DOS error code as the function
      result.}
  var
    F : file;
  begin
    Assign(F, FName);
    {call routine in Turbo's DOS unit to get the attribute}
    GetFAttr(F, Attr);
    GetFileMode := DosError;
  end;

  function FlushDosBuffers(var F) : Boolean;
    {-Flush DOS's buffers for the specified file}
  var
    Handle : Word absolute F;
  begin
    FlushDosBuffers := False;
    with Regs do begin
      {dupe the file handle}
      AH := $45;
      BX := Handle;
      MsDos(Regs);
      if Odd(Flags) then
        Exit;

      {close the duped file}
      BX := AX;
      AH := $3E;
      MsDos(Regs);
      if Odd(Flags) then
        Exit;
    end;
    FlushDosBuffers := True;
  end;

  procedure SetDta(DTAptr : Pointer);
    {-Set the DOS DTA to point to DTA}
  begin
    with Regs do begin
      AH := $1A;
      DS := Seg(DTAptr^);
      DX := Ofs(DTAptr^);
      MsDos(Regs);
    end;
  end;

  procedure GetDta(var DTAptr : Pointer);
    {-Return the DOS DTA pointer}
  begin
    with Regs do begin
      AH := $2F;
      MsDos(Regs);
      DTAptr := Ptr(ES, BX);
    end;
  end;

  function ParsePath(var InputPath, SearchPath, LeadInPath : string) : Boolean;
    {-Takes a user entered path, trims blanks, and returns a valid global
      search path and a valid lead-in path.}
  var
    S : string;
    SLen : Byte absolute S;
    Attr : Word;

    function IsPath(S : string) : Boolean;
      {-Return True if S is empty or ends with ':' or '\'}
    var
      SLen : Byte absolute S;
    begin
      {check last character in S}
      case S[SLen] of
        ':' : IsPath := (SLen = 2);
        '\' : IsPath := True;
        '.' : IsPath := (SLen = 1) or (S = '..') or
                        ((SLen > 2) and                      {!!.03}
                         ((Pos('\..', S) = (SLen - 2)) or    {!!.03}
                          (Pos(':.', S)  = (SLen - 1)) or    {!!.10}
                          (Pos(':..', S) = (SLen - 2)) )     {!!.03}
                        );                                   {!!.03}
        else IsPath := (SLen = 0); {True if string is empty}
      end;
    end;

    function NameIsValid(S : string) : Boolean; {!!.10}
    var
      I : Word;
    begin
      NameIsValid := False;
      for I := 1 to Length(S) do
        if S[I] in [#0..#31, '"', '[', ']', '|', ';'..'>', '+', ','] then
          Exit;
      NameIsValid := True;
    end;

  begin
    {Assume success}
    ParsePath := True;

    {Get working copy of InputPath; convert to uppercase and trim blanks}
    S := StUpCase(Trim(InputPath));

    if (Pos(':', S) > 2) or (Pos('/', S) <> 0) or
       (Pos('::', S) <> 0) or (Pos('\\', S) <> 0) then
      ParsePath := False
    {if S is just a path name, add "*.*" to search path}
    else if IsPath(S) then begin
      if S[SLen] = '.' then
        S := S+'\';
      LeadInPath := S;
      SearchPath := S+'*.*';
    end
    else
      if SLen >= 77 then
        ParsePath := False
      else
        {test validity of pathname by calling routine to get file attribute}
        case GetFileMode(S, Attr) of

          0 : if (Attr and Directory {= $10} ) <> 0 then begin
                {Input path is valid directory name}
                SearchPath := S+'\*.*';
                LeadInPath := S+'\';
              end
              else begin
                {Input path is the name of a file}
                SearchPath := S;

                {trim end of string until only a path is left}
                while not IsPath(S) do
                  Dec(SLen);
                LeadInPath := S
              end;

          3 : begin
                {path not found}

                {reject clearly invalid names}
                ParsePath := NameIsValid(S);

                SearchPath := S;

                {trim end of string until only a path is left}
                while not IsPath(S) do
                  Dec(SLen);

                if (S[SLen] <> ':') or (SLen = 2) then
                  LeadInPath := S
                else
                  ParsePath := False;
              end;
        else
          ParsePath := False;
        end;
  end;

  function PrintInstalled : Boolean;
    {-Returns True if PRINT.COM is installed}
  begin
    {INT $2F functions available only in DOS 3}
    if DosVersion >= $300 then
      with Regs do begin
        AX := $0100;         {get PRINT installed status}
        Intr($2F, Regs);     {print spool control interrupt}
        PrintInstalled := (AL = $FF); {DOS returns $FF in AL if PRINT installed}
      end
    else
      PrintInstalled := False;
  end;

  function SubmitPrintFile(FileName : string) : Byte;
    {-This procedure submits a file to the PC DOS 3.0 or greater concurrent
      print utility.}
  type
    AsciiZ = array[1..65] of Char;
    SubmitPacket = record
                     Level : Byte;
                     FilenamePtr : ^AsciiZ;
                   end;
  var
    SubPack : SubmitPacket;
    S : string;
    SLen : Byte absolute S;
  begin
    S := Trim(FileName);
    if SLen <> 0 then
      with SubPack, Regs do begin
        Level := 0;          {set level code}
        if SLen > 64 then
          SLen := 64;        {truncate filenames longer than 64 characters}
        S[Succ(SLen)] := #0; {add null to end of string}
        FilenamePtr := @S[1]; {point to first character in S}
        DS := Seg(SubPack);  {DS:DX points to the packet}
        DX := Ofs(SubPack);
        AX := $0101;         {submit file to be printed}
        Intr($2F, Regs);     {print spool control interrupt}
        if Odd(Flags) then   {check carry flag}
          SubmitPrintFile := AL {carry set, return code in AL}
        else
          SubmitPrintFile := 0;
      end
    else
      SubmitPrintFile := 2;  {return the code for a file not found error}
  end;

  procedure CancelPrintFile(FileMask : string);
    {-Cancels the files matched by the file mask passed in FileMask.}
  var
    Len : Byte absolute FileMask;
  begin
    if Len > 64 then
      Len := 64;             {truncate filenames longer than 64 characters}
    with Regs do begin
      FileMask[Succ(Len)] := #0; {make FileMask an ASCIIZ string}
      DS := Seg(FileMask);   {DS:DX points to the ASCIIZ string}
      DX := Ofs(FileMask[1]);
      AX := $0102;           {cancel print file}
      Intr($2F, Regs);       {print spool control interrupt}
    end;
  end;

  procedure CancelAllPrintFiles;
    {-Cancels all files in the print queue}
  begin
    Regs.AX := $0103;        {cancel all files function}
    Intr($2F, Regs);         {print spool control interrupt}
  end;

  function GetPrintStatus(var QPtr : Pointer) : Byte;
    {-Halts printing, returns current error status, puts pointer to the filename
      queue in the QPtr variable. Filenames in the queue are 64-byte ASCIIZ
      strings. The end of the queue is marked by a name starting with a null.}
  begin
    with Regs do begin
      AX := $0104;           {access print queue function}
      Intr($2F, Regs);       {print spool control interrupt}
      {check carry flag}
      if Odd(Flags) then begin
        {carry set, return code in AL}
        QPtr := nil;
        GetPrintStatus := AL;
      end
      else begin
        {DS:SI points to the queue}
        QPtr := Ptr(DS, SI);
        GetPrintStatus := 0;
      end;
    end;
  end;

  procedure EndPrintStatus;
    {-Releases the spooler from the GetPrintStatus procedure.}
  begin
    Regs.AX := $0105;        {unfreeze queue function}
    Intr($2F, Regs);         {print spool control interrupt}
  end;

  function GetEnvironmentString(SearchString : string) : string;
    {-Return a string from the environment}
  begin
    while SearchString[Length(SearchString)] = '=' do
      Dec(SearchString[0]);
    GetEnvironmentString := Dos.GetEnv(SearchString);
  end;

  function PtrDiff(H, L : Pointer) : LongInt;
    {-Return the number of bytes between H^ and L^. H is the higher address}
  var
    High : SegOfs absolute H;
    Low : SegOfs absolute L;
  begin
    PtrDiff := (LongInt(High.S) shl 4+High.O)-(LongInt(Low.S) shl 4+Low.O);
  end;

  function SetBlock(var Paragraphs : Word) : Boolean;
    {-Change size of DOS memory block allocated to this program}
  begin
    with Regs do begin
      AH := $4A;
      ES := PrefixSeg;
      BX := Paragraphs;
      MsDos(Regs);
      Paragraphs := BX;
      SetBlock := not Odd(Flags);
    end;
  end;

  function UsingEmulator : Boolean;
    {-Return True if floating point emulator in use}
  type
    Array3 = array[1..3] of Char;
  const
    EmuSignature : Array3 = 'emu';
  var
    A3P : ^Array3;
  begin
    A3P := Ptr(SSeg, $E0);
    {using emulator if Test8087 is 0 and emulator's signature is found in SS}
    UsingEmulator := (Test8087 = 0) and (A3P^ = EmuSignature);
  end;

{$IFDEF Heap6} {!!.10} {New version of ExecDos follows}

  function ExecDos(Command : string; UseSecond : Boolean; EDP : ExecDosProc) : Integer;
    {-Execute any DOS command. Call with Command = '' for a new shell. If
      UseSecond is false, Command must be the full pathname of a program to be
      executed}
  var
    {Variables for saving and restoring state of system}
    OurInt23 : Pointer;
    OurInt24 : Pointer;
    SaveDta : Pointer;  {!!.01}

    {Variables for managing the heap compression}
    ParasWeHave : Word;
    ParasForDos : Word;
    ParasToKeep : Word;
    OldHeapEnd : Pointer;

    {Variables for parsing the command line}
    BlankPos : Word;
    PathName : string[127];
    CommandTail : string[127];
  begin
    {Current DOS memory allocation read from memory control block}
    ParasWeHave := MemW[Pred(PrefixSeg):3];

    {Calculate amount of memory to give up}
    ParasForDos := Pred(PtrDiff(HeapEnd, HeapPtr) shr 4);

    {Calculate amount of memory to keep while in shell}
    ParasToKeep := ParasWeHave-ParasForDos;

    {See if enough memory to run DOS}
    if (ParasForDos > 0) and (ParasForDos < (MinSpaceForDos shr 4)) then begin
      ExecDos := -4;
      Exit;
    end;

    {Deallocate memory for DOS}
    if not SetBlock(ParasToKeep) then begin
      ExecDos := -2;
      Exit;
    end;

    {Save old end of heap and set new one}
    OldHeapEnd := HeapEnd;
    HeapEnd := HeapPtr;

    {get parameters for Execute}
    if Command = '' then
      UseSecond := True;
    CommandTail := '';
    if not UseSecond {command processor} then begin
      {Command is assumed to be a full pathname for a program}
      BlankPos := Pos(' ', Command);
      if BlankPos = 0 then
        PathName := Command
      else begin
        CommandTail := Copy(Command, BlankPos, Length(Command));
        PathName := Copy(Command, 1, Pred(BlankPos));
      end;
    end
    else begin
      {Pathname is the full pathname for COMMAND.COM}
      PathName := GetEnvironmentString('COMSPEC');

      {if Command is empty, we're doing a shell}
      if Command <> '' then
        {we're asking COMMAND.COM to execute the command}
        CommandTail := '/C '+Command;
    end;

    {Let user routine store and clear the physical screen}
    EDP(ExecSaveScreen, 0);

    {let user routine show status info if entering DOS shell}
    if (Command = '') then
      {Pass user routine the approximate memory available in KB}
      EDP(ExecShowMemory, (ParasForDos-240) shr 6);

    {get current DTA}    {!!.01}
    GetDta(SaveDta);     {!!.01}

    {switch vectors}
    SwapVectors;

    {Call Turbo's EXEC function}
    Exec(PathName, CommandTail);

    {restore vectors}
    SwapVectors;

    {restore DTA}        {!!.01}
    SetDta(SaveDta);     {!!.01}

    {Reallocate memory from DOS}
    if not SetBlock(ParasWeHave) then begin
      ExecDos := -3;
      Exit;
    end;

    {Put heap end back where it was}
    HeapEnd := OldHeapEnd;

    {if not in shell, let user routine allow time to see result}
    if (Command <> '') or (DosError <> 0) then
      EDP(ExecPauseAfterRun, 0);

    {give user routine a chance to restore the screen}
    EDP(ExecRestoreScreen, 0);

    {If we get to here, our function result is in DosError}
    ExecDos := DosError;
  end;

{$ELSE}

  function EndOfHeap : Pointer;
    {-Returns a pointer to the end of the free list}
  var
    FreeSegOfs : SegOfs absolute FreePtr;
  begin
    if FreeSegOfs.O = 0 then
      {the free list is empty, add $1000 to the segment}
      EndOfHeap := Ptr(FreeSegOfs.S+$1000, 0)
    else
      EndOfHeap := Ptr(FreeSegOfs.S+(FreeSegOfs.O shr 4), 0);
  end;

  function ExecDos(Command : string; UseSecond : Boolean; EDP : ExecDosProc) : Integer;
    {-Execute any DOS command. Call with Command = '' for a new shell. If
      UseSecond is false, Command must be the full pathname of a program to be
      executed}
  label
    ExitPoint;
  var
    PathName,
    CommandTail : string[127];
    OurInt23,
    OurInt24,
    OldEndOfHeap,
    NewEndOfHeap,
    TopOfHeap : Pointer;
    BlankPos,
    Allocated,
    SizeOfFreeList,
    ParasToKeep,
    ParasWeHave,
    ParasForDos : Word;
    SaveDta : Pointer;  {!!.01}
  begin
    {Calculate number of bytes to save}
    TopOfHeap := Ptr(SegOfs(FreePtr).S+$1000, 0);
    SizeOfFreeList := PtrDiff(TopOfHeap, EndOfHeap);

    {get current DTA}    {!!.01}
    GetDta(SaveDta);     {!!.01}

    {If enough space available, use stack to store the free list}
    if (not UsingEmulator) and
       (LongInt(SizeOfFreeList)+StackSafetyMargin < LongInt(SPtr)) then begin
      NewEndOfHeap := Ptr(SSeg, 0);
      Allocated := 0;
    end
    else begin
      {Check for sufficient memory}
      if MaxAvail < LongInt(SizeOfFreeList) then begin
        {Insufficient memory to store free list}
        ExecDos := -1;
        Exit;
      end;

      {Allocate memory for a copy of free list}
      Allocated := SizeOfFreeList;
      if Allocated > 0 then
        GetMem(NewEndOfHeap, Allocated);

      {Recalculate the size of the free list}
      SizeOfFreeList := Word(PtrDiff(TopOfHeap, EndOfHeap));
    end;

    {Save the current pointer to the end of the free list}
    OldEndOfHeap := EndOfHeap;

    {Current DOS memory allocation read from memory control block}
    ParasWeHave := MemW[Pred(PrefixSeg):3];

    {Calculate amount of memory to give up}
    ParasForDos := Pred(PtrDiff(TopOfHeap, HeapPtr) shr 4);

    {Calculate amount of memory to keep while in shell}
    ParasToKeep := ParasWeHave-ParasForDos;

    {See if enough memory to run DOS}
    if (ParasForDos > 0) and (ParasForDos < (MinSpaceForDos shr 4)) then begin
      ExecDos := -4;
      goto ExitPoint;
    end;

    {Deallocate memory for DOS}
    if not SetBlock(ParasToKeep) then begin
      ExecDos := -2;
      goto ExitPoint;
    end;

    {get parameters for Execute}
    if Command = '' then
      UseSecond := True;
     CommandTail := '';
    if not UseSecond {command processor} then begin
      {Command is assumed to be a full pathname for a program}
      BlankPos := Pos(' ', Command);
      if BlankPos = 0 then
        PathName := Command
      else begin
        CommandTail := Copy(Command, BlankPos, Length(Command));
        PathName := Copy(Command, 1, Pred(BlankPos));
      end;
    end
    else begin
      {Pathname is the full pathname for COMMAND.COM}
      PathName := GetEnvironmentString('COMSPEC');

      {if Command is empty, we're doing a shell}
      if Command <> '' then
        {we're asking COMMAND.COM to execute the command}
        CommandTail := '/C '+Command;
    end;

    {Let user routine store and clear the physical screen}
    EDP(ExecSaveScreen, 0);

    {let user routine show status info if entering DOS shell}
    if (Command = '') then
      {Pass user routine the approximate memory available in KB}
      EDP(ExecShowMemory, (ParasForDos-240) shr 6);

    {Copy the free list to a safe location}
    Move(OldEndOfHeap^, NewEndOfHeap^, SizeOfFreeList);

    {switch vectors}
    SwapVectors;

    {Call Turbo's EXEC function}
    Exec(PathName, CommandTail);

    {restore vectors}
    SwapVectors;

    {restore DTA}        {!!.01}
    SetDta(SaveDta);     {!!.01}

    {Reallocate memory from DOS}
    if not SetBlock(ParasWeHave) then begin
      ExecDos := -3;
      goto ExitPoint;
    end;

    {Put free list back where it was}
    Move(NewEndOfHeap^, OldEndOfHeap^, SizeOfFreeList);

    {if not in shell, let user routine allow time to see result}
    if (Command <> '') or (DosError <> 0) then
      EDP(ExecPauseAfterRun, 0);

    {give user routine a chance to restore the screen}
    EDP(ExecRestoreScreen, 0);

    {If we get to here, our function result is in DosError}
    ExecDos := DosError;

ExitPoint:
    {Deallocate any dynamic memory used}
    if Allocated <> 0 then
      FreeMem(NewEndOfHeap, Allocated);
  end;

{$ENDIF}

  function DosBlockWrite(H : Word; var Src; N : Word) : Word;
    {-Calls DOS's BlockWrite routine. Returns 0 if successful, else the DOS
      error code.}
  begin
    with Regs do begin
      AH := $40;             {write to file}
      BX := H;               {file handle}
      CX := N;               {Number of bytes to write}
      DS := Seg(Src);        {DS:DX points to buffer}
      DX := Ofs(Src);
      MsDos(Regs);           {returns bytes written in AX}

      {check carry flag, also the number of bytes written}
      if Odd(Flags) or (AX <> N) then
        DosBlockWrite := AX
      else
        DosBlockWrite := 0;
    end;
  end;

  function TextSeek(var F : Text; Target : LongInt) : Boolean;
    {-Do a Seek for a text file opened for input. Returns False in case of I/O
      error.}
  var
    T : LongRec absolute Target;
    Pos : LongInt;
  begin
    with Regs, TextRec(F) do begin
      {assume failure}
      TextSeek := False;

      {check for file opened for input}
      if Mode <> fmInput then
        Exit;

      {get current position of the file pointer}
      AX := $4201;           {move file pointer function}
      BX := Handle;          {file handle}
      CX := 0;               {if CX and DX are both 0, call returns the..}
      DX := 0;               {current file pointer in DX:AX}
      MsDos(Regs);

      {check for I/O error}
      if Odd(Flags) then
        Exit;

      {calculate current position for the start of the buffer}
      LongRec(Pos).HighWord := DX;
      LongRec(Pos).LowWord := AX;
      Dec(Pos, BufEnd);

      {see if the Target is within the buffer}
      Pos := Target-Pos;
      if (Pos >= 0) and (Pos < BufEnd) then
        {it is--just move the buffer pointer}
        BufPos := Pos
      else begin
        {have DOS seek to the Target-ed offset}
        AX := $4200;         {move file pointer function}
        BX := Handle;        {file handle}
        CX := T.HighWord;    {CX has high word of Target offset}
        DX := T.LowWord;     {DX has low word}
        MsDos(Regs);

        {check for I/O error}
        if Odd(Flags) then
          Exit;

        {tell Turbo its buffer is empty}
        BufEnd := 0;
        BufPos := 0;
      end;
    end;

    {if we get to here we succeeded}
    TextSeek := True;
  end;

  function TextFileSize(var F : Text) : LongInt;
    {-Return the size of text file F. Returns -1 in case of I/O error.}
  var
    OldHi, OldLow : Integer;
  begin
    with Regs, TextRec(F) do begin
      {check for open file}
      if Mode = fmClosed then begin
        TextFileSize := -1;
        Exit;
      end;

      {get current position of the file pointer}
      AX := $4201;           {move file pointer function}
      BX := Handle;          {file handle}
      CX := 0;               {if CX and DX are both 0, call returns the..}
      DX := 0;               {current file pointer in DX:AX}
      MsDos(Regs);

      {check for I/O error}
      if Odd(Flags) then begin
        TextFileSize := -1;
        Exit;
      end;

      {save current position of the file pointer}
      OldHi := DX;
      OldLow := AX;

      {have DOS move to end-of-file}
      AX := $4202;           {move file pointer function}
      BX := Handle;          {file handle}
      CX := 0;               {if CX and DX are both 0, call returns the...}
      DX := 0;               {current file pointer in DX:AX}
      MsDos(Regs);           {call DOS}

      {check for I/O error}
      if Odd(Flags) then begin
        TextFileSize := -1;
        Exit;
      end;

      {calculate the size}
      TextFileSize := LongInt(DX) shl 16+AX;

      {reset the old position of the file pointer}
      AX := $4200;           {move file pointer function}
      BX := Handle;          {file handle}
      CX := OldHi;           {high word of old position}
      DX := OldLow;          {low word of old position}
      MsDos(Regs);           {call DOS}

      {check for I/O error}
      if Odd(Flags) then
        TextFileSize := -1;
    end;
  end;

  function TextPos(var F : Text) : LongInt;
    {-Return the current position of the logical file pointer (that is,
      the position of the physical file pointer, adjusted to account for
      buffering). Returns -1 in case of I/O error.}
  var
    Position : LongInt;
  begin
    with Regs, TextRec(F) do begin
      {check for open file}
      if Mode = fmClosed then begin
        TextPos := -1;
        Exit;
      end;

      {get current position of the physical file pointer}
      AX := $4201;           {move file pointer function}
      BX := Handle;          {file handle}
      CX := 0;               {if CX and DX are both 0, call returns the...}
      DX := 0;               {current file pointer in DX:AX}
      MsDos(Regs);           {call DOS}

      {check for I/O error}
      if Odd(Flags) then begin
        TextPos := -1;
        Exit;
      end;

      {calculate the position of the logical file pointer}
      LongRec(Position).HighWord := DX;
      LongRec(Position).LowWord := AX;
      if Mode = fmOutput then
        {writing}
        Inc(Position, BufPos)
      else
        {reading}
        if BufEnd <> 0 then
          Dec(Position, BufEnd-BufPos);

      {return the calculated position}
      TextPos := Position;
    end;
  end;

  function TextFlush(var F : Text) : Boolean;
    {-Flush the buffer(s) for a text file. Returns False in case of I/O error.}
  var
    Position : LongInt;
    P : LongRec absolute Position;
    Code : Word;
  begin
    with Regs, TextRec(F) do begin
      {assume failure}
      TextFlush := False;

      {check for open file}
      if Mode = fmClosed then
        Exit;

      {see if file is opened for reading or writing}
      if Mode = fmInput then begin
        {get current position of the logical file pointer}
        Position := TextPos(F);

        {exit in case of I/O error}
        if Position = -1 then
          Exit;

        {set the new position of the physical file pointer}
        AX := $4200;         {move file pointer function}
        BX := Handle;        {file handle}
        CX := P.HighWord;    {CX has high word of offset}
        DX := P.LowWord;     {DX has low word}
        MsDos(Regs);         {call DOS}

        {check for I/O error}
        if Odd(Flags) then
          Exit;
      end
      else begin
        {write the current contents of the buffer, if any}
        if BufPos <> 0 then begin
          Code := DosBlockWrite(Handle, BufPtr^, BufPos);
          if Code <> 0 then
            Exit;
        end;

        {flush DOS's buffers}
        if not FlushDosBuffers(F) then
          Exit;
      end;

      {tell Turbo its buffer is empty}
      BufEnd := 0;
      BufPos := 0;
    end;

    {if we get to here we succeeded}
    TextFlush := True;
  end;

  function OpenStdDev(var F : Text; StdHandle : Word) : Boolean;
    {-Assign the text file to the specified standard DOS device}
  begin
    OpenStdDev := False;
    case StdHandle of
      StdInHandle,
      StdOutHandle,
      StdErrHandle,
      StdPrnHandle :
        begin
          {Initialize the file variable}
          Assign(F, '');
          Rewrite(F);
          if IoResult = 0 then begin
            TextRec(F).Handle := StdHandle;
            if StdHandle = StdErrHandle then
              TextRec(F).BufSize := 1;
            OpenStdDev := True;
          end;
        end;
    end;
  end;

  function HandleIsConsole(Handle : Word) : Boolean;
    {-Return true if handle is the console device (input or output)}
  begin
    with Regs do begin
      AX := $4400;
      BX := Handle;
      MsDos(Regs);
      if (DX and $80) = 0 then
        HandleIsConsole := False
      else
        HandleIsConsole := (DX and $02 <> 0) or (DX and $01 <> 0);
    end;
  end;

  procedure SetRawMode(var F : Text; On : Boolean);
    {-Set "raw" mode on or off for the specified text file (must be a device)}
  begin
    with TextRec(F), Regs do begin
      {check for open file}
      if (Mode < fmInput) or (Mode > fmInOut) then begin
        {Turbo's file not found error code}
        DosError := 103;
        Exit;
      end;

      DosError := 0;

      AX := $4400;           {Get device information}
      BX := Handle;
      MsDos(Regs);           {returns device info in DX}

      if not Odd(Flags) then begin
        {check bit 7 for device flag}
        if DL and $80 = 0 then
          Exit;

        {clear unwanted bits}
        DX := DX and $00AF;

        {select raw/cooked mode}
        if On then
          {set bit 5 of DX}
          DL := DL or $20
        else
          {clear bit 5 of DX}
          DL := DL and $DF;

        AX := $4401;           {Set device information}
        BX := Handle;          {BX has file handle}
        MsDos(Regs);
      end;

      if Odd(Flags) then
        DosError := AX
      else
        DosError := 0;
    end;
  end;

  function FileHandlesOpen(CountDevices : Boolean) : Byte; {!!.01}
    {-Return the number of open files owned by a program}
  type
    HandleTable = array[0..254] of Byte;
  var
    HandlesPtr : ^HandleTable;
    I, N, Max : Byte;
  begin
    {pointer to file handles table at PrefixSeg:$34}
    HandlesPtr := Pointer(MemL[PrefixSeg:$34]);

    {size of file handles table at PrefixSeg:$32}
    Max := Mem[PrefixSeg:$0032]-1;

    N := 0;
    for I := 0 to Max do
      if HandlesPtr^[I] <> $FF then
        case I of
          0..4 : Inc(N, Ord(CountDevices));
          else   Inc(N);
        end;

    FileHandlesOpen := N;
  end;

  function FileHandlesLeft : Byte;    {!!.01}
    {-Return the number of available file handles}
  const
    NullName : array[1..4] of Char = 'NUL'#0;
    MaxHandles = 255;
  var
    Handles : array[1..MaxHandles] of Word;
    N : Byte;
  begin
    inline(
      $30/$ED/                    {xor ch,ch            ;CX = MaxHandles}
      $B1/<MaxHandles/            {mov cl,<MaxHandles}
      $BA/>NullName/              {mov dx,>NullName     ;DS:DX => NullName}
      $BF/>InOutRes/              {mov di,>InOutRes     ;DS:DI => InOutRes}
      $8D/$B6/>Handles/           {lea si,[bp+>Handles] ;SI has offset for Handles[1]}
                                  {Next:}
      $B8/$02/$3D/                {mov ax,$3D02         ;DOS open file function}
      $CD/$21/                    {int $21              ;call DOS}
      $72/$0B/                    {jc Close             ;start closing if CF set}
      $38/$2D/                    {cmp [di],ch          ;IoResult = 0?}
      $75/$07/                    {jne Close            ;if not, start closing}
      $36/                        {ss:}
      $89/$04/                    {mov [si],ax          ;save the Handle}
      $46/                        {inc si               ;inc pointer into Handles}
      $46/                        {inc si}
      $E2/$EE/                    {loop Next            ;repeat if CX > 0}
                                  {Close:}
      $F6/$D1/                    {not cl               ;flip bits in cl}
      $88/$8E/>N/                 {mov [bp+>N],cl       ;save handle count in N}
      $E3/$0C/                    {jcxz Done            ;done if count is 0}
                                  {CloseOne:}
      $4E/                        {dec si               ;dec pointer into Handles}
      $4E/                        {dec si}
      $36/                        {ss:}
      $8B/$1C/                    {mov bx,[si]          ;get the handle into BX}
      $B8/$00/$3E/                {mov ax,$3E00         ;DOS close file function}
      $CD/$21/                    {int $21              ;call DOS, ignore error}
      $E2/$F4/                    {loop CloseOne        ;do it again}
                                  {Done:}
      $89/$0D);                   {mov [di],cx          ;clear IoResult (CX = 0)}

    FileHandlesLeft := N;
  end;

  function ExistFile(FName : string) : Boolean;
    {-Return true if file is found}
  var
    FLen : Byte absolute FName;
  begin
    {check for empty string}
    if Length(FName) = 0 then
      ExistFile := False
    else with Regs do begin
      Inc(FLen);
      FName[FLen] := #0;
      AX := $4300;           {get file attribute}
      DS := Seg(FName);
      DX := Ofs(FName[1]);
      MsDos(Regs);
      ExistFile := (not Odd(Flags)) {and (IoResult = 0)} and {!!.10}
                   (CX and (VolumeID+Directory) = 0);
    end;
  end;

  function ExistOnPath(FName : string; var FullName : string) : Boolean;
   {-Return true if FName is found in
      a) current directory
      b) program's directory (DOS 3.X only)
      c) any DOS path directory
    and return path name to file}
  var
    Ppos, Fpos : Word;
    DosPath : string;
  begin
    {string empty?}
    if Length(FName) = 0 then begin
      ExistOnPath := False;
      Exit;
    end;

    {Assume success}
    ExistOnPath := True;

    {Check current directory}
    if ExistFile(FName) then begin
      FullName := FName;
      Exit;
    end;

    {If DOS 3 or higher, check the directory where the program was found}
    if DosVersion >= $300 then begin
      FullName := JustPathname(ParamStr(0));
      FullName := AddBackSlash(FullName)+FName;
      if ExistFile(FullName) then
        Exit;
    end;

    {Check the path}
    DosPath := Dos.GetEnv('PATH');
    Ppos := 1;
    while Ppos < Length(DosPath) do begin

      {Find the termination of the current path entry}
      Fpos := Ppos;
      while (Fpos <= Length(DosPath)) and (DosPath[Fpos] <> ';') do
        Inc(Fpos);

      if Fpos > Ppos then begin
        {A path entry found}
        FullName[0] := Char(Fpos-Ppos);
        Move(DosPath[Ppos], FullName[1], Fpos-Ppos);
        FullName := AddBackSlash(FullName)+FName;
        if ExistFile(FullName) then
          Exit;
      end;

      {Prepare to look at next item}
      Ppos := Succ(Fpos);
    end;

    {Not found, even on the path}
    ExistOnPath := False;
    FullName := FName;
  end;

  function TimeMs : LongInt;
    {-Return time of day in milliseconds since midnight}
  begin
    with Regs do begin
      AH := $2C;
      MsDos(Regs);
      TimeMs := 1000*(LongInt(DH)+60*(LongInt(CL)+60*LongInt(CH)))+10*LongInt(DL);
    end;
  end;

  procedure ClearEnvRec(var Env : EnvRec);
    {-Initialize an environment record}
  begin
    FillChar(Env, SizeOf(Env), 0);
  end;

  procedure MasterEnv(var Env : EnvRec);
    {-Return master environment record}
  var
    Owner : Word;
    Mcb : Word;
    Eseg : Word;
    Done : Boolean;
  begin
    with Env do begin
      ClearEnvRec(Env);

      {Interrupt $2E points into COMMAND.COM}
      Owner := MemW[0:(2+4*$2E)];

      {Mcb points to memory control block for COMMAND}
      Mcb := Owner-1;
      if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> Owner) then
        Exit;

      {Read segment of environment from PSP of COMMAND}
      Eseg := MemW[Owner:$2C];

      {Earlier versions of DOS don't store environment segment there}
      if Eseg = 0 then begin
        {Master environment is next block past COMMAND}
        Mcb := Owner+MemW[Mcb:3];
        if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> Owner) then
          {Not the right memory control block}
          Exit;
        Eseg := Mcb+1;
      end else
        Mcb := Eseg-1;

      {Return segment and length of environment}
      EnvSeg := Eseg;
      EnvLen := MemW[Mcb:3] shl 4;
    end;
  end;

  procedure CurrentEnv(var Env : EnvRec);
    {-Return current environment record}
  var
    ESeg : Word;
    Mcb : Word;
  begin
    with Env do begin
      ClearEnvRec(Env);
      ESeg := MemW[PrefixSeg:$2C];
      Mcb := ESeg-1;
      if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> PrefixSeg) then
        Exit;
      EnvSeg := ESeg;
      EnvLen := MemW[Mcb:3] shl 4;
    end;
  end;

  procedure ParentEnv(var Env : EnvRec);
    {-Return environment record of program's parent}
  var
    PSeg : Word;
    ESeg : Word;
    Mcb : Word;
  begin
    with Env do begin
      ClearEnvRec(Env);
      {Get segment of parent}
      PSeg := MemW[PrefixSeg:$16];
      ESeg := MemW[PSeg:$2C];
      Mcb := ESeg-1;
      if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> PSeg) then
        Exit;
      if ESeg = 0 then
        MasterEnv(Env)
      else begin
        EnvSeg := ESeg;
        EnvLen := MemW[Mcb:3] shl 4;
      end;
    end;
  end;

  procedure NewEnv(var Env : EnvRec; Size : Word);
    {-Allocate a new environment (on the heap)}
  var
    Mcb : Word;
  begin
    with Env do
      if MaxAvail < Size+31 then
        {Insufficient space}
        ClearEnvRec(Env)
      else begin
        {31 extra bytes for paragraph alignment, fake MCB}
        GetMem(EnvPtr, Size+31);
        EnvSeg := SegOfs(EnvPtr).S+1;
        if SegOfs(EnvPtr).O <> 0 then
          Inc(EnvSeg);
        EnvLen := Size;
        {Fill it with nulls}
        FillChar(EnvPtr^, Size+31, 0);
        {Make a fake MCB below it}
        Mcb := EnvSeg-1;
        Mem[Mcb:0] := Byte('M');
        MemW[Mcb:1] := PrefixSeg;
        MemW[Mcb:3] := (Size+15) shr 4;
      end;
  end;

  procedure DisposeEnv(var Env : EnvRec);
    {-Deallocate an environment previously allocated on heap}
  begin
    with Env do
      if EnvPtr <> nil then begin
        FreeMem(EnvPtr, EnvLen+31);
        ClearEnvRec(Env);
      end;
  end;

  procedure SetCurrentEnv(Env : EnvRec);
    {-Specify a different environment for the current program}
  begin
    with Env do
      if EnvSeg <> 0 then
        MemW[PrefixSeg:$2C] := EnvSeg;
  end;

  procedure CopyEnv(Src, Dest : EnvRec);
    {-Copy contents of Src environment to Dest environment}
  var
    Size : Word;
    SPtr : EnvArrayPtr;
    DPtr : EnvArrayPtr;
  begin
    if (Src.EnvSeg = 0) or (Dest.EnvSeg = 0) then
      Exit;

    if Src.EnvLen <= Dest.EnvLen then
      {Space for the whole thing}
      Size := Src.EnvLen
    else
      {Take what fits}
      Size := Dest.EnvLen-2;

    SPtr := Ptr(Src.EnvSeg, 0);
    DPtr := Ptr(Dest.EnvSeg, 0);
    Move(SPtr^, DPtr^, Size);
    FillChar(DPtr^[Size], Dest.EnvLen-Size, 0);
  end;

  procedure SkipAsciiZ(EPtr : EnvArrayPtr; var EOfs : Word);
    {-Skip to end of current AsciiZ string}
  begin
    while EPtr^[EOfs] <> #0 do
      Inc(EOfs);
  end;

  function EnvNext(EPtr : EnvArrayPtr) : Word;
    {-Return the next available location in environment at EPtr^}
  var
    EOfs : Word;
  begin
    EOfs := 0;
    if EPtr <> nil then begin
      while EPtr^[EOfs] <> #0 do begin
        SkipAsciiZ(EPtr, EOfs);
        Inc(EOfs);
      end;
    end;
    EnvNext := EOfs;
  end;

  function EnvFree(Env : EnvRec) : Word;
    {-Return bytes free in environment}
  begin
    with Env do
      if EnvSeg <> 0 then
        EnvFree := EnvLen-EnvNext(Ptr(EnvSeg, 0))-1
      else
        EnvFree := 0;
  end;

  function SearchEnv(EPtr : EnvArrayPtr; var Search : string) : Word;
    {-Return the position of Search in environment, or $FFFF if not found.
      Prior to calling SearchEnv, assure that
        EPtr is not nil,
        Search is not empty
    }
  var
    SLen : Byte absolute Search;
    EOfs : Word;
    MOfs : Word;
    SOfs : Word;
    Match : Boolean;
  begin
    {Force upper case search}
    Search := StUpcase(Search);

    {Assure search string ends in =}
    if Search[SLen] <> '=' then begin
      Inc(SLen);
      Search[SLen] := '=';
    end;

    EOfs := 0;
    while EPtr^[EOfs] <> #0 do begin
      {At the start of a new environment element}
      SOfs := 1;
      MOfs := EOfs;
      repeat
        Match := (EPtr^[EOfs] = Search[SOfs]);
        if Match then begin
          Inc(EOfs);
          Inc(SOfs);
        end;
      until not Match or (SOfs > SLen);

      if Match then begin
        {Found a match, return index of start of match}
        SearchEnv := MOfs;
        Exit;
      end;

      {Skip to end of this environment string}
      SkipAsciiZ(EPtr, EOfs);

      {Skip to start of next environment string}
      Inc(EOfs);
    end;

    {No match}
    SearchEnv := $FFFF;
  end;

  procedure GetAsciiZ(EPtr : EnvArrayPtr; var EOfs : Word; var EStr : string);
    {-Collect AsciiZ string starting at EPtr^[EOfs]}
  var
    ELen : Byte absolute EStr;
  begin
    ELen := 0;
    while (EPtr^[EOfs] <> #0) and (ELen < 255) do begin
      Inc(ELen);
      EStr[ELen] := EPtr^[EOfs];
      Inc(EOfs);
    end;
  end;

  function GetEnvStr(Env : EnvRec; Search : string) : string;
    {-Return a string from the environment}
  var
    SLen : Byte absolute Search;
    EPtr : EnvArrayPtr;
    EOfs : Word;
    EStr : string;
    ELen : Byte absolute EStr;
  begin
    with Env do begin
      ELen := 0;
      if (EnvSeg <> 0) and (SLen <> 0) then begin
        {Find the search string}
        EPtr := Ptr(EnvSeg, 0);
        EOfs := SearchEnv(EPtr, Search);
        if EOfs <> $FFFF then begin
          {Skip over the search string}
          Inc(EOfs, SLen);
          {Build the result string}
          GetAsciiZ(EPtr, EOfs, EStr);
        end;
      end;
      GetEnvStr := EStr;
    end;
  end;

  function SetEnvStr(Env : EnvRec; Search, Value : string) : Boolean;
    {-Set environment string, returning true if successful}
  var
    SLen : Byte absolute Search;
    VLen : Byte absolute Value;
    EPtr : EnvArrayPtr;
    ENext : Word;
    EOfs : Word;
    MOfs : Word;
    OldLen : Word;
    NewLen : Word;
    NulLen : Word;
  begin
    with Env do begin
      SetEnvStr := False;
      if (EnvSeg = 0) or (SLen = 0) then
        Exit;
      EPtr := Ptr(EnvSeg, 0);

      {Find the search string}
      EOfs := SearchEnv(EPtr, Search);

      {Get the index of the next available environment location}
      ENext := EnvNext(EPtr);

      {Get total length of new environment string}
      NewLen := SLen+VLen;

      if EOfs <> $FFFF then begin
        {Search string exists}
        MOfs := EOfs+SLen;
        {Scan to end of string}
        SkipAsciiZ(EPtr, MOfs);
        OldLen := MOfs-EOfs;
        {No extra nulls to add}
        NulLen := 0;
      end else begin
        OldLen := 0;
        {One extra null to add}
        NulLen := 1;
      end;

      if VLen <> 0 then
        {Not a pure deletion}
        if ENext+NewLen+NulLen >= EnvLen+OldLen then
          {New string won't fit}
          Exit;

      if OldLen <> 0 then begin
        {Overwrite previous environment string}
        Move(EPtr^[MOfs+1], EPtr^[EOfs], ENext-MOfs-1);
        {More space free now}
        Dec(ENext, OldLen+1);
      end;

      {Append new string}
      if VLen <> 0 then begin
        Move(Search[1], EPtr^[ENext], SLen);
        Inc(ENext, SLen);
        Move(Value[1], EPtr^[ENext], VLen);
        Inc(ENext, VLen);
      end;

      {Clear out the rest of the environment}
      FillChar(EPtr^[ENext], EnvLen-ENext, 0);

      SetEnvStr := True;
    end;
  end;

  procedure DumpEnv(Env : EnvRec);
    {-Dump the environment to the screen}
  var
    EOfs : Word;
    EPtr : EnvArrayPtr;
  begin
    with Env do begin
      if EnvSeg = 0 then
        Exit;
      EPtr := Ptr(EnvSeg, 0);
      EOfs := 0;
      WriteLn;
      while EPtr^[EOfs] <> #0 do begin
        while EPtr^[EOfs] <> #0 do begin
          Write(EPtr^[EOfs]);
          Inc(EOfs);
        end;
        WriteLn;
        Inc(EOfs);
      end;
      WriteLn('Bytes free: ', EnvFree(Env));
    end;
  end;

  function GetProgramStr(Env : EnvRec) : string;
    {-Return the name of the program that owns Env, '' if DOS < 3.0 or unknown}
  var
    EOfs : Word;
    EPtr : EnvArrayPtr;
    PStr : string;
  begin
    GetProgramStr := '';
    if DosVersion < $0300 then
      Exit;
    if Env.EnvSeg = 0 then
      Exit;
    {Find the end of the current environment}
    EPtr := Ptr(Env.EnvSeg, 0);
    EOfs := EnvNext(EPtr);
    if Mem[Env.EnvSeg:EOfs+1] = 1 then begin {!!.02}
      {Skip to start of path name}
      Inc(EOfs, 3);
      {Collect the path name}
      GetAsciiZ(EPtr, EOfs, PStr);
      GetProgramStr := PStr;
    end;                                      {!!.02}
  end;

  function SetProgramStr(Env : EnvRec; Path : string) : Boolean;
    {-Add a program name to the end of an environment if sufficient space}
  var
    PLen : Byte absolute Path;
    EOfs : Word;
    Numb : Word;
    EPtr : EnvArrayPtr;
  begin
    SetProgramStr := False;
    with Env do begin
      if EnvSeg = 0 then
        Exit;
      {Find the end of the current environment}
      EPtr := Ptr(EnvSeg, 0);
      EOfs := EnvNext(EPtr);
      {Assure space for path}
      if EnvLen < PLen+EOfs+4 then
        Exit;
      {Put in the count field}
      Inc(EOfs);
      Numb := 1;
      Move(Numb, EPtr^[EOfs], 2);
      {Skip to start of path name}
      Inc(EOfs, 2);
      {Move the path into place}
      Path := StUpcase(Path);
      Move(Path[1], EPtr^[EOfs], PLen);
      {Null terminate}
      Inc(EOfs, PLen);
      EPtr^[EOfs] := #0;
      SetProgramStr := True;
    end;
  end;

  function ShellWithPrompt(Prompt : string; EDP : ExecDosProc) : Integer;
    {-Shell to DOS with a new prompt}
  const
    PromptStr : string[6] = 'PROMPT';
  var
    PLen : Byte absolute Prompt;
    NSize : Word;
    Status : Integer;
    CE : EnvRec;
    NE : EnvRec;
    OldP : string;
    OldPLen : Byte absolute OldP;
  begin
    {Point to current environment}
    CurrentEnv(CE);
    if CE.EnvSeg = 0 then begin
      {Error getting environment}
      ShellWithPrompt := -5;
      Exit;
    end;

    {Compute size of new environment}
    OldP := Dos.GetEnv(PromptStr);
    NSize := CE.EnvLen;
    if OldPLen < PLen then
      Inc(NSize, PLen-OldPLen);

    {Allocate and initialize a new environment}
    NewEnv(NE, NSize);
    if NE.EnvSeg = 0 then begin
      {Insufficient memory for new environment}
      ShellWithPrompt := -6;
      Exit;
    end;
    CopyEnv(CE, NE);

    {Get the program name from the current environment}
    OldP := ParamStr(0);

    {Set the new prompt string}
    if not SetEnvStr(NE, PromptStr, Prompt) then begin
      {Program error, should have enough space}
      ShellWithPrompt := -7;
      Exit;
    end;

    {Transfer program name to new environment if possible}
    if not SetProgramStr(NE, OldP) then
      ;

    {Point to new environment}
    SetCurrentEnv(NE);

    {Shell to DOS with new prompt in place}
    Status := ExecDos('', True, EDP);

    {Restore previous environment}
    SetCurrentEnv(CE);

    {Release the heap space}
    if Status >= 0 then
      DisposeEnv(NE);

    {Return exec status}
    ShellWithPrompt := Status;
  end;

  {!!.10} {Rewritten}
  function IsDirectory(FName : String) : Boolean;
    {-Return true if FName is a directory}
  var
    IO : Word;
    CurDir : PathStr;
    CurDestDir : PathStr;
    DiffDrive : Boolean;
  begin
    GetDir(0, CurDir);

    if (Length(FName) >= 2) and (FName[2] = ':') and (FName[1] <> CurDir[1])
    then begin
      {Checking on a different drive}
      DiffDrive := True;
      ChDir(FName[1]+':');
      if IoResult <> 0 then begin
        IsDirectory := False;
        Exit;
      end;
      GetDir(0, CurDestDir);
    end else
      DiffDrive := False;

    ChDir(FName);
    IsDirectory := (IoResult = 0);

    if DiffDrive then begin
      ChDir(CurDestDir);
      IO := IoResult;
    end;

    ChDir(CurDir);
    IO := IoResult;
  end;

  function SameFile(FilePath1, FilePath2 : String;
                    var ErrorCode : Word) : Boolean;
    {-Return true if FilePath1 and FilePath2 refer to the same physical file.
      Error codes:
        0 - Success (no error)
        1 - Invalid FilePath1
        2 - Invalid FilePath2
        3 - Error on Dos Set/GetFAttr
    }
  var
    F1, F2 : File;
    Attr1, Attr2, NewAttr : Word;
  begin
    SameFile := False;
    ErrorCode := 0;
    Assign(F1,FilePath1);
    Assign(F2,FilePath2);
    GetFAttr(F1,Attr1);
    if DosError <> 0 then begin
      ErrorCode := 1;
      Exit;
    end;
    GetFAttr(F2,Attr2);
    if DosError <> 0 then begin
      {leave ErrorCode at 0 if file not found but path is valid}
      if DosError <> 2 then
        ErrorCode := 2;
      Exit;
    end;
    if Attr1 <> Attr2 then
      Exit;
    if ((Attr1 and Archive) = 0) then
      NewAttr := Attr1 or Archive
    else
      NewAttr := Attr1 and (not Archive);
    SetFAttr(F1,NewAttr);
    if DosError <> 0 then begin
      ErrorCode := 3;
      Exit;
    end;
    GetFAttr(F2,Attr2);
    if DosError <> 0 then
      ErrorCode := 3;

    SameFile := Attr2 = NewAttr;

    SetFAttr(F1,Attr1);
    if DosError <> 0 then
      ErrorCode := 3;
  end;

  function CopyFile(SrcPath, DestPath : String;
                    Buffer : Pointer;
                    BufferSize : Word) : Word;
    {-Copy the file specified by SrcPath into DestPath. DestPath must specify
      a complete filename, it may not be the name of a directory without the
      file portion.  This a low level routine, and the input pathnames are not
      checked for validity. Buffer must already be allocated, and must be no
      less than BufferSize.}
  var
    ErrorCode,BytesRead,BytesWritten : Word;
    Time : LongInt;
    Src,Dest : File;
    SaveFileMode : Word;                                 {!!.03}

    procedure UnDo(CloseAndDeleteDest : Boolean);
    begin
      Close(Src);
      if IoResult <> 0 then ;
      if CloseAndDeleteDest then begin
        Close(Dest);
        if IoResult <> 0 then ;
        Erase(Dest);
        if IoResult <> 0 then ;
      end;
    end;

  begin
    SaveFileMode := FileMode;                            {!!.03}
    FileMode := FileMode and $F0;                        {!!.03}
    Assign(Src,SrcPath);
    Reset(Src,1);
    FileMode := SaveFileMode;                            {!!.03}
    if IoResult <> 0 then begin
      CopyFile := 1;                   {unable to open SrcPath}
      Exit;
    end;
    Assign(Dest,DestPath);
    Rewrite(Dest,1);
    if IoResult <> 0 then begin
      CopyFile := 2;                   {unable to open DestPath}
      Undo(False);
    end;
    while not EOF(Src) do begin
      BlockRead(Src,Buffer^,BufferSize,BytesRead);
      if IoResult <> 0 then begin
        CopyFile := 3;                 {error reading SrcPath}
        UnDo(True);
        Exit;
      end;
      BlockWrite(Dest,Buffer^,BytesRead,BytesWritten);
      if (IoResult <> 0) or (BytesWritten <> BytesRead) then begin
        CopyFile := 4;                 {error reading SrcPath}
        UnDo(True);                        {error writing DestPath}
        Exit;
      end;
    end;
    GetFTime(Src,Time);
    if DosError <> 0 then begin
      CopyFile := 5;                   {error getting SrcPath's Date/Time}
      UnDo(True);
      Exit;
    end;
    SetFTime(Dest,Time);
    if DosError <> 0 then begin
      CopyFile := 6;                   {error getting DestPath's Date/Time}
      UnDo(True);
      Exit;
    end;
    Close(Dest);
    if IoResult <> 0 then begin        {!!.02}
      CopyFile := 7;
      Close(Src);                      {!!.02}
      if IoResult <> 0 then ;          {!!.02}
    end                                {!!.02}
    else begin                         {!!.02}
      Close(Src);                      {!!.02}
      if IoResult <> 0 then ;          {!!.02}
      CopyFile := 0;                   {!!.02}
    end;                               {!!.02}
  end;

  procedure NoExecDosProc(ActionCode : ActionCodeType; Param : Word);
    {-Do-nothing ExecDosProc}
  begin
  end;

{$IFDEF InitAllUnits}
begin
{$ENDIF}
end.
