;******************************************************
;                  OPCASE.ASM 1.10
;              String handling routines
;     Copyright (c) TurboPower Software 1987, 1989.
;                All rights reserved.
;******************************************************

        INCLUDE OPCOMMON.ASM

;****************************************************** Code

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE

        PUBLIC  Upcase, Locase
        PUBLIC  StUpcase, StLocase
        PUBLIC  SetInternationalUpcase, SetDefaultUpcase  ;!!.02
        PUBLIC  UpCasePrim, LoCasePrim
        PUBLIC  MoveFast

UpcaseFunc Pointer <>                   ;Address of upcase function  !!.02

;****************************************************** DefaultUpcase
;!!.02 new routine
;Works with Code Page 437, the standard U.S. character set
;Entry : character to upcase in AL, assumed >=#128
;Exit  : uppercase in AL
;        BX wiped out

UpCaseMap LABEL BYTE                    ;Maps international characters
                                        ;#128..#165
        DB      '', '', 'E', 'A', '', 'A', '', '', 'E', 'E'
        DB      'E', 'I', 'I', 'I', '', '', '', '', '', 'O'
        DB      '', 'O', 'U', 'U', 'Y', '', '', '', '', ''
        DB      '', '', 'A', 'I', 'O', 'U', '', ''

DefaultUpcase PROC FAR
        CMP     AL,165
        JA      DefaultDone             ;Done if AL > #167
        SUB     AL,128                  ;Reduce to range of map table
        MOV     BX,OFFSET UpCaseMap
        XLAT    CS:[BX]                 ;Use map table
DefaultDone:
        RET
DefaultUpcase ENDP

;****************************************************** SetInternationalUpcase
;!!.02 new routine
;procedure SetInternationalUpcase;
;Activate DOS international uppercase function for current code page

SetInternationalUpcase PROC    FAR
        StackFrameBP
        SUB     SP,34                   ;Space for CountryInfo
        SetPtrByOfst UpcaseFunc, CS, DefaultUpcase ;Assume default upcase
        MOV     AH,30h                  ;Get DOS version
        INT     21h
        CMP     AL,2
        JBE     SetDone                 ;Get out for DOS 2.x or earlier
        MOV     AX,3800h                ;Get DOS country info
        MOV     DX,SP                   ;DX offset of CountryInfo space
        PUSH    DS
        PUSH    SS
        POP     DS                      ;DS=SS
        INT     21h
        POP     DS
        JC      SetDone                 ;Done if function failed
        MOV     AX,[BP-14]
        MOV     UpcaseFunc.Segm,AX      ;Save DOS function address
        MOV     AX,[BP-16]
        MOV     UpcaseFunc.Ofst,AX
SetDone:
        ExitCode 0
SetInternationalUpcase ENDP

;****************************************************** SetDefaultUpcase
;!!.02 new routine
;procedure SetDefaultUpcase;
;Activate default uppercase function

SetDefaultUpcase PROC    FAR
        SetPtrByOfst UpcaseFunc, CS, DefaultUpcase
        RET
SetDefaultUpcase ENDP

;****************************************************** UpcasePrim
;!!.02 modified for generalized international uppercasing function
;Entry : character to upcase in AL
;Exit  : uppercase in AL

UpcasePrim PROC FAR
UpcasePrimNear:                         ;!!.02
        CMP     AL,128
        JAE     ExtUpcase               ;Jump if extended uppercase
        CMP     AL,'a'
        JB      UpCaseDone              ;Done if AL < 'a'
        CMP     AL,'z'
        JA      UpCaseDone              ;Done if AL > 'z'
        SUB     AL,32                   ;Convert to uppercase
UpCaseDone:
        RET
ExtUpCase:                              ;International uppercase
        PUSH    BX                      ;Save registers DOS might wipe out
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSH    DI
        CALL    UpcaseFunc              ;Call international upcase function
        POP     DI
        POP     SI
        POP     DX
        POP     CX
        POP     BX
        RET
UpcasePrim ENDP

;****************************************************** Upcase

;function UpCase(Ch : Char) : Char;
;Return uppercase of char, with international character support

UpCase  PROC    FAR
        MOV     BX,SP
        MOV     AL,SS:[BX+4]            ;AL = input character
        PUSH    CS                      ;!!.02
        CALL    UpcasePrimNear          ;!!.02
        RET     2
UpCase  ENDP

;****************************************************** LocasePrim

;Entry : character to locase in AL
;Exit  : lowercase in AL
;        BX wiped out

LoCaseMap LABEL BYTE                    ;Maps international characters
                                        ;#128..#165
        DB      '', '', '', '', '', '', '', '', '', ''
        DB      '', '', '', '', '', '', '', '', '', ''
        DB      '', '', '', '', '', '', '', '', '', ''
        DB      '', '', '', '', '', '', '', ''

LoCasePrim PROC FAR
LoCasePrimNear:                         ;!!.02
        CMP     AL,'A'
        JB      LoCaseDone              ;Done if AL < 'a'
        CMP     AL,165
        JA      LoCaseDone              ;Done if AL > #165
        CMP     AL,'Z'
        JA      ExtLoCase               ;Jump if extended lowercase
        ADD     AL,32                   ;Convert to lowercase
LoCaseDone:
        RET
ExtLoCase:                              ;International lowercase
        CMP     AL,128
        JB      LoCaseDone              ;Done if AL < #128
        SUB     AL,128                  ;Reduce to range of map table
        MOV     BX,OFFSET LoCaseMap
        XLAT    CS:[BX]                 ;Use map table
        RET
LoCasePrim ENDP

;****************************************************** Locase

;function Locase(Ch : Char) : Char;
;Return lowercase of char, with international character support

LoCase  PROC    FAR
        MOV     BX,SP
        MOV     AL,SS:[BX+4]            ;AL = input character
        PUSH    CS                      ;!!.02
        CALL    LoCasePrimNear          ;!!.02
        RET     2
LoCase  ENDP

;****************************************************** StLocase

;function StLocase(S : string) : string;
;Convert upper case letters in string to lower case

StLocase PROC FAR
         MOV     DX,OFFSET LocasePrim
         JMP     SHORT StCaseNear
StLocase ENDP

;****************************************************** StUpcase

;function StUpcase(S : string) : string;
;Convert lower case letters in string to upper case

StUpcase PROC FAR
         MOV     DX,OFFSET UpcasePrim
         ; falls through into StCase
StUpcase ENDP

;****************************************************** StCase
;Convert string to one case or another, depending on DX
StCase  PROC    FAR
StCaseNear:
        StackFrame
        PUSH    DS
        CLD                             ;go forward
        LDS     SI,SS:[BX+4]            ;DS:SI => S
        LES     DI,SS:[BX+8]            ;ES:DI => function result
        LODSB                           ;AL = Length(S)
        STOSB                           ;Set length of result
        SetZero CH                      ;CH = 0
        MOV     CL,AL                   ;CX = Length(S)
        JCXZ    SUDone                  ;Done if CX is 0
SUNext:
        LODSB                           ;Next char into AL
        PUSH    CS                      ;Fake a FAR CALL
        CALL    DX                      ;Uppercase it
        STOSB                           ;Store char in result
        LOOP    SUNext                  ;repeat
SUDone:
        POP     DS
        RET     4
StCase  ENDP

;****************************************************** MoveFast

; procedure MoveFast(var Src, Dest; Count : Word);
; Move Count bytes from Src to Dest

; Thanks to Pat Ritchey for portions of this routine

mfSrc   EQU     DWORD PTR [BP+12]
mfDest  EQU     DWORD PTR [BP+8]
mfCount EQU     WORD PTR [BP+6]

MoveFast        PROC FAR

        PUSH    BP                      ;set up stack frame
        MOV     BP,SP
        PUSH    DS                      ;save DS
        LDS     SI,mfSrc                ;DS:SI => Src
        LES     DI,mfDest               ;ES:DI => Dest
        MOV     CX,mfCount              ;CX    =  Count
        JCXZ    mfDone                  ;Do nothing if CX = 0
        MOV     BX,DS                   ;Isolate high nibble of the 20-bit
        MOV     DX,ES                   ;addresses in ES:DI and DS:SI
        MOV     AH,BH                   ;into AH and AL -- this compares the
        MOV     AL,DH                   ;top 4 bits of the 20-bit address
        AND     AX,0F0F0h
        CMP     AH,AL                   ;Compare high nibbles
        JA      mfForward               ;Go forward if source is higher
        JB      mfReverse               ;Go backward if source is below dest
        PUSH    CX                      ;High nibbles of segments are equal--
        MOV     CX,4                    ;merge SI and DI with the remaining
        SHL     BX,CL                   ;12 bits of ES and DI so we can
        SHL     DX,CL                   ;compare the last 16 bits of the
        POP     CX                      ;20-bit addresses
        ADD     BX,SI
        ADD     DX,DI
        CMP     BX,DX                   ;Is source above dest?
        JA      mfForward               ;If so, go forward
mfReverse:
        STD                             ;go backward
        ADD     SI,CX                   ;point just beyond the ends
        ADD     DI,CX
        DEC     SI                      ;point to the actual ends
        DEC     DI
        TEST    DI,1                    ;is destination offset odd?
        JNZ     mfRevWord
        MOVSB                           ;move the odd byte
        DEC     CX                      ;decrement loop count
mfRevWord:
        DEC     SI                      ;point to the beginning of the word
        DEC     DI
        SHR     CX,1                    ;CX = words to move
        REP     MOVSW
        JNC     mfDone                  ;is there an odd byte to move?
        INC     SI                      ;point to the next byte
        INC     DI
        JMP     SHORT mfOddByte
mfForward:
        CLD                             ;go forward
        TEST    DI,1                    ;is destination offset odd?
        JZ      mfForWord
        MOVSB                           ;move the odd byte
        DEC     CX                      ;decrement loop count
mfForWord:
        SHR     CX,1                    ;CX = words to move
        REP     MOVSW
        JNC     mfDone                  ;is there an odd byte to move?
mfOddByte:
        MOVSB                           ;move the odd byte
mfDone:
        POP     DS                      ;restore DS
        POP     BP                      ;restore BP
        RET     10

MoveFast        ENDP

CODE    ENDS

        END
