UNIT XMS;


(******************************************************************

 Use XMS (Extended) and UMB (Upper) Memory in Borland Pascal.
 Allocate memory and move data between XMS and conventional memory.
 Does not support the Upper memory blocks of DOS 5 and above.

 (c) Copyright 1996 by Klaus Hartnegg,
     www.klaus-hartnegg.de

 Free for non-commercial use but please
 send me a mail or postcard if you use this.

 Usage:
 - automatic initialization of the unit sets the variable IsInstalled.
   You absolutely MUST check this and don't call any of the
   procedures herein if this variable is false!
 - errors are returned in the global variable XmsError.
   The value 0 means that everything is OK.
   It's unlikely that this is ever nonzero as long as
   you don't allocate more memory than is availalble
   and are careful to use always the correct handle.
   But to be sure, please check this. Caution: will be reset
   by each call, so check every time!
 - use GetHandle to allocate XMS memory. This will return a nuber.
   Store this number, you need it to access and release the memory.
 - MoveEmb can copy data from conventional to XMS memory and back.
   Use 0 as handle number to specify conventional memory or a
   handle number returned from GetHandle to specify XMS memory.
   SrcOffset is a pointer to the conventional memory.
   DstOffset is an offset within the XMS memory block
   (or NIL to use if from the start of the block).
   BlockLength is the amount of data to copy (in bytes).
   LIMITATION: BlockLength must be an even number!!

 Attention: the Borland Pascal IDE uses all XMS for itself.
 To stop it from doing so, you must do
    SET DPMIMEM=MAXMEM 2048

Values for XMS error code:
 00h	successful
 80h	function not implemented
 81h	Vdisk was detected
 82h	an A20 error occurred
 8Eh	a general driver error
 8Fh	unrecoverable driver error
 90h	HMA does not exist or is not managed by XMS provider
 91h	HMA is already in use
 92h	DX is less than the /HMAMIN= parameter
 93h	HMA is not allocated
 94h	A20 line still enabled
 A0h	all extended memory is allocated
 A1h	all available extended memory handles are allocated
 A2h	invalid handle
 A3h	source handle is invalid
 A4h	source offset is invalid
 A5h	destination handle is invalid
 A6h	destination offset is invalid
 A7h	length is invalid
 A8h	move has an invalid overlap
 A9h	parity error occurred
 AAh	block is not locked
 ABh	block is locked
 ACh	block lock count overflowed
 ADh	lock failed
 B0h	only a smaller UMB is available
 B1h	no UMB's are available
 B2h	UMB segment number is invalid

******************************************************************)


{$IFDEF DPMI}  { can not be used in procted mode }
'CAN NOT BE USED IN PROTECTED MODE !!'
{$ENDIF}

{ DEFINE CLEANUP}


INTERFACE

{$IFDEF CLEANUP}
Procedure InitCleanup;
Procedure Cleanup;
{$ENDIF}


Function IsInstalled : boolean;
Function XmsError    : byte;

Function XmsMemAvail : word;  { total memory in kB }
Function XmsMaxAvail : word;  { size of largest contiguous block in kB }

Function  GetHandle (Size : word) : word;  { allocate memory, size in kB }
Procedure FreeHandle (Handle : word);      { release memory }

{ copy data from conventional to xms or back }
Procedure MoveEmb (SrcHandle:word; SrcOffset:Pointer;
                   DstHandle:word; DstOffset:Pointer;
                   Blocklength : word);
{ copy from or to xms memory, use handle=0 for main memory }
{ Blocklength is measured in bytes and it must be an even number }


{ Upper Memory Blocks, not in DOS 5 with DOS=UMB in config.sys ! }
Function  GetUMB (var Size : word) : word;   { size in paragraphs }
Procedure ReleaseUMB (Segment : word);
Procedure ResizeUMB  (Segment, newSize : word);

function  MaxUmbAvailable : word; { returns size in paragraphs }
procedure GetUmbBestFit (size : word; var segment : word; var ok:boolean);
{ allocates the block that is just big enough }



type
  XmsHandleTable = record
     signature : byte;
     size      : byte;
     num       : word;
     ptr       : pointer;
  end;

  XmsHandlePtr = ^XmsHandleTable;

  dword = record
     Low  : word;
     High : word;
  end;

  XmsHandleDescriptor = record
     flag : byte;
     lock : byte;   { lock count, 0 = unlocked }
     adr  : dword;  { in kB, shift left by 10 for abs. address }
     size : dword;  { in kB }
  end;

  XmsHandleDescrArr = array [1..100] of XmsHandleDescriptor;

Function GetXmsHandleTable : XmsHandlePtr;




IMPLEMENTATION

uses
  {$IFDEF CLEANUP} LinkdLst, {$ENDIF}
  dos;


var
  _IsInstalled : boolean;
  _XmsError    : byte;
  XmsAddress   : pointer;
  EmmStrucSeg  : word;
  EmmStrucOfs  : word;

  EmmStruc     : record
                    Blocklength : pointer;
                    SrcHandle   : word;
                    SrcOffset   : pointer;
                    DstHandle   : word;
                    DstOffset   : pointer;
                 end;

{$IFDEF CLEANUP}
var
  CleanupActive  : boolean;
  CleanupHandles : LinkedList;
{$ENDIF}


Function IsInstalled : boolean;
begin
  IsInstalled := _IsInstalled;
end;


Function XmsError : byte;
begin
  XmsError := _XmsError;
  _XmsError := 0;
end;


function TestInstalled : boolean; assembler;
asm
   mov ax,$4300
   int $2F
   cmp al, $80
   je  @1
   mov al,0
   jmp @9
@1:mov al,1
@9:
end;


function GetDriverAddress : pointer; assembler;
asm
  mov ax,$4310
  int $2F
  mov DX,ES
  mov AX,BX
end;


function XmsMemAvail : word; assembler;
asm
  mov  al,0
  mov  [_XmsError], al
  mov  ah,8
  mov  bl,0
  call [XmsAddress]
  mov  ax,dx
  mov  [_XmsError], bl
end;


function XmsMaxAvail : word; assembler;
asm
  mov  al,0
  mov  [_XmsError], al
  mov  ah,8
  mov  bl,0
  call [XmsAddress]
  mov  [_XmsError], bl
end;


function GetHandle (Size : word) : word;
var
  Handle : word;
begin
   asm
   mov  al,0
   mov  [_XmsError], al
   mov  ah,9
   mov  dx,[size]
   call [XmsAddress]
   or   ax,ax
   jne  @1
   mov  [_XmsError], bl
   jmp  @9
@1:mov  word ptr Handle,dx
@9:
   end;
   {$IFDEF CLEANUP}
   if (_XmsError = 0) and CleanupActive then
      CleanupHandles.add (Handle);
   {$ENDIF}
   GetHandle := Handle;
end;


Procedure FreeHandle (Handle : word);
begin
   asm
   mov  al,0
   mov  [_XmsError], al
   mov  ah,$A
   mov  dx,[handle]
   call [XmsAddress]
   or   ax,ax
   jne  @1
   mov  [_XmsError], bl
@1:
   end;
   {$IFDEF CLEANUP}
   if (_XmsError = 0) and CleanupActive then
      if CleanupHandles.Find (Handle) then begin
         CleanupHandles.Step;
         CleanupHandles.Del;
      end;
   {$ENDIF}
end;


Procedure MoveEmb (SrcHandle:word; SrcOffset:Pointer;
                   DstHandle:word; DstOffset:Pointer;
                   Blocklength : word);
begin
  EmmStruc.SrcHandle   := SrcHandle;
  EmmStruc.SrcOffset   := SrcOffset;
  EmmStruc.DstHandle   := DstHandle;
  EmmStruc.DstOffset   := DstOffset;
  EmmStruc.BlockLength := ptr(0,BlockLength);
  asm
    mov  al,0
    mov  [_XmsError], al
    mov  ah,$B
    push ds
    pop  es
    mov  ds,EmmStrucSeg
    mov  si,EmmStrucOfs
    call [es:XmsAddress]
    push es
    pop  ds
    or   ax,ax
    jne  @1
    mov  [_XmsError], bl
@1:
  end;
end;



function GetUMB (var Size : word) : word; assembler;
asm
   mov  al,0
   mov  [_XmsError], al

   mov  ah,$10
   les  di, [size]
   mov  dx, es:[di]
   call [XmsAddress]

{ ax = 1: ok     bx=segment, dx=real block size }
{ ax = 0: error  bl=err-code dx=largest block size }

   or   ax,ax
   jne  @1
   mov  [_XmsError], bl
@1:
   les  di, [size]
   mov  es:[di], dx   { dx = real size }

   mov  ax,bx         { bx = segment }
end;



Procedure ReleaseUMB (Segment : word); assembler;
asm
   mov  al,0
   mov  [_XmsError], al
   mov  ah,$11
   mov  dx,[Segment]
   call [XmsAddress]
   or   ax,ax
   jne  @1
   mov  [_XmsError], bl
   jmp  @9
@1:
@9:
end;


Procedure ResizeUMB (Segment, NewSize : word); assembler;
asm
   mov  al,0
   mov  [_XmsError], al
   mov  ah,$12
   mov  dx,[Segment]
   mov  bx,[NewSize]
   call [XmsAddress]
   or   ax,ax
   jne  @1
   mov  [_XmsError], bl
   jmp  @9
@1:
@9:
end;



function MaxUmbAvailable : word; { size in paragraphs }
var
  size, segment : word;
begin
  MaxUmbAvailable := 0;
  if not Xms.IsInstalled then exit;

  size := 65535;
  segment := GetUmb (size);

  if XmsError = 0 then begin
     { impossible, can never happen }
     ReleaseUmb (Segment);
     MaxUmbAvailable := size;
     exit;
  end;

  if XmsError <> $B0 {only smaller umb available} then exit;

  MaxUmbAvailable := size;
end;


procedure GetUmbBestFit (size : word; var segment : word; var ok:boolean);
const
  maxnumblocks = 20;
var
  blocknum : array [1..maxnumblocks] of word;
  numblocks : byte;

  procedure release_all;
  var i : byte;
  begin
     for i := 1 to numblocks do
        ReleaseUmb (blocknum[i]);
  end;

var
  bestblock : byte;
  bestsize  : word;
  size2 : word;
  i : byte;
begin
  ok := false;
  if not Xms.IsInstalled then exit;
  if MaxUmbAvailable < size then exit;

  { allocate all UMB memory that is available }
  numblocks := 0;
  bestblock := 0;
  repeat
     size2 := MaxUmbAvailable;
     ok := (size2 > 0);
     if ok then begin
        inc (numblocks);
        blocknum[numblocks] := GetUmb (size2);
        if XmsError <> 0 then begin { should never ever happen }
           dec (numblocks);
           release_all;
           exit;
        end;
        { remember number of smallest fitting block }
        if (size2 >= size) then begin
           if (bestblock = 0) or (size2 < bestsize) then begin
              bestblock := numblocks;
              bestsize  := size2;
           end;
        end;
     end;
  until not ok or (numblocks = maxnumblocks);

  { release everything }
  release_all;

  if numblocks = maxnumblocks then exit;
  if bestblock = 0 then exit;

  { allocate all larger blocks }
  numblocks := 0;
  for i := 1 to bestblock - 1 do begin
     inc (numblocks);
     size2 := MaxUmbAvailable;
     blocknum[numblocks] := GetUmb (size2);
     if XmsError <> 0 then begin { should never ever happen }
        dec (numblocks);
        release_all;
        exit;
     end;
  end;

  { allocate optimal fitting block }
  size2 := size;
  segment := GetUmb (size2);
  ok := (XmsError = 0) and (size = size2);

  { release all others }
  release_all;
end;



Function GetXmsHandleTable : XmsHandlePtr;
{ returns NIL if function not supported }
var
  reg : registers;
begin
  GetXmsHandleTable := NIL;

  if not xms.IsInstalled then exit;

  reg.ax := $4309;
  intr ($2F, reg);
  if reg.al <> $43 then exit;

  GetXmsHandleTable := ptr (reg.es, reg.bx);
end;




{$IFDEF CLEANUP}

var
  OldExit : pointer;


{$F+} Procedure Cleanup; {$F-}
var
  Handle : word;
begin
  ExitProc := OldExit;
  CleanupActive := false; { wichtig, sonst pfuscht FreeHandle in CleanupHandles rein }

  CleanupHandles.Reset;
  while not CleanupHandles.Eol do begin
     CleanupHandles.Get (Handle);
     writeln ('releasing xms handle ',handle);
     FreeHandle (Handle);
  end;
  CleanupHandles.Done;
end;


Procedure InitCleanup;
var
  Handle : word;
begin
  if CleanupActive then exit;
  CleanupActive := true;
  CleanupHandles.Init (sizeof(Handle));
  OldExit := ExitProc;
  ExitProc := @Cleanup;
end;

{$ENDIF}


BEGIN  { Initialization }
  _XmsError := 0;
  _IsInstalled := TestInstalled;
  if _IsInstalled then begin
     EmmStrucSeg := seg(EmmStruc);
     EmmStrucOfs := ofs(EmmStruc);
     XmsAddress := GetDriverAddress;
  end;

  {$IFDEF CLEANUP}
  CleanupActive := false;
  {$ENDIF}
END.

