Unit SB16math;


INTERFACE

type
  string4 = string[4];

Function  GetBit  (d:word; bit:byte): boolean;
Procedure ClrBitb (var d:byte; bit:byte);
Procedure SetBitb (var d:byte; bit:byte);

Function  WordVal (c:string; var ok:boolean) : word;
Function  WordStr (a:word) : string;

Function  HexVal1 (key:char; var ok:boolean) : byte;
Function  HexVal  (c:string; var ok:boolean) : longint;
Function  Hex4 (d:word):string4;

var
  BiosTimeCounter  : longint absolute $0040:$006C; { # int $1C, Dos Clock  }

Function GetBiosTimeCounter : longint;


IMPLEMENTATION

const
  BitVal : array [0..15] of word
         = ($0001,$0002,$0004,$0008,$0010,$0020,$0040,$0080,
            $0100,$0200,$0400,$0800,$1000,$2000,$4000,$8000);

Function  GetBit (d:word; bit:byte): boolean;
begin
  GetBit := (d and BitVal[bit]) <> 0;
end;

Procedure ClrBitb (var d:byte; bit:byte);
begin
  d := d and not BitVal[bit];
end;

Procedure SetBitb (var d:byte; bit:byte);
begin
  d := d or BitVal[bit];
end;


Function WordVal (c:string; var ok:boolean) : word;
var
  i : integer;
  a : real;
begin
  WordVal := 0;   { sonst abbruch wenn ergebnis zufllig > 65535 und bei aufruf einer word-variablen zugewiesen wird }
  val (c,a,i);
  ok := (i=0) and (pos('.',c)=0); if not ok then exit;
  ok := (a >= 0) and (a <= 65535); if not ok then exit;
  WordVal := round(a);
end;


Function WordStr (a:word) : string;
var
  c : string[10];
begin
  str (a,c);
  WordStr := c;
end;


const
  hexChars: array [0..$F] of Char = '0123456789ABCDEF';


Function HexVal1 (key:char; var ok:boolean) : byte;
begin
  ok := true;
  key := upcase(key);
  if key < '0' then ok := false
  else if key <= '9' then HexVal1 := ord(key) - ord('0')
  else if key <  'A' then ok := false
  else if key <= 'F' then HexVal1 := ord(key) - ord('A') + 10
  else ok := false;
end;


Function HexVal (c:string; var ok:boolean) : longint;
var
  i,j : byte;
  l : longint;
begin
  if (c <> '') and (c[1] = '$') then delete (c,1,1);
  l := 0;
  for i := 1 to length(c) do begin
     j := HexVal1 (c[i],ok);
     if not ok then exit;
     l := l shl 4 + j;
  end;
  HexVal := l;
end;


Function Hex4 (d:word):string4;
var
  c : string4;
  i : byte;
begin
  c[0] := #4;
  for i := 4 downto 1 do begin
     c[i] := HexChars[d and $F];
     d := d shr 4;
  end;
  Hex4 := c;
end;


Function GetBiosTimeCounter : longint;
begin
  asm
  pushf;
  cli;
  end;
  GetBiosTimeCounter := BiosTimeCounter;
  asm
  popf;
  end;
end;



END.

