(**********************************************************************

 Demo for Unit SB16WAV: record sound to WAV file on Sound Blaster 16

**********************************************************************)


{ Ton-Aufzeichnung mit Sound Blaster 16 in WAV-Datei }


uses
  crt,
  sb16, sbmix, sb16wav,
 { divers, defines,} sb16math;

const
  SamplingRate= 44100;
  sixteenbit  = true;
  stereo      = true;

const
  fn = 'test.wav';

const
  maxticks = 6*60*18;  { maximale Aufnahme-Dauer in BiosTimeTicks (1/18 sek) }


var
  n   : word;
  t,t0: longint;
  p   : pointer;
  adr1: longint;
  adr2: longint;
  err : byte;
  mem : longint;

begin
  mem := memavail;

  if not sb16.ResetDSP then begin
     writeln ('error: no sound blaster found!');
     halt (1);
  end;

  sbmix.SetDefaultVolume;
  sbmix.InputLineOnly;
  SetMixReg ('vll',31);
  SetMixReg ('vlr',31);
  SetMixReg ('igl', 3);  { Input Gain Left  }
  SetMixReg ('igr', 3);  { Input Gain Right }
  SetMixReg ('oll', 1);
  SetMixReg ('olr', 1);
  SetMixReg ('acg', 1);  { auto gain control abschalten }

  sb16wav.init;

  sb16wav.InitRecording (fn, samplingrate, sixteenbit, stereo, true, err);
  if err <> 0 then begin
    case err of
    1 : writeln ('error: can not write output file');
    2 : writeln ('error: no sound blaster found!');
    3 : writeln ('error: sound card not compatible with sound blaster 16');
    4 : writeln ('error: can not determine sound card parameters');
    5 : writeln ('error: not enough memory available');
    6 : writeln ('error: no XMS memory available');
    7 : writeln ('error: not enough XMS memory available');
    else writeln ('unknown error');
    end; {case}
    halt (1);
  end;

  sb16wav.StartRecording;

  n := 0;
  t0 := GetBiosTimeCounter;
  repeat
    sb16wav.flush_buffers;

    t := GetBiosTimeCounter;
    if t <> t0 then begin
       inc (n);
       t0 := t;
       write ('.');
    end;
  until (n = maxticks) or keypressed;
  while keypressed do readkey;
  writeln;

  sb16wav.StopRecording;
  sbmix.MixerReset;
  sb16wav.done;


  if mem <> memavail then
     writeln ('memory leak!');
end.
