(**********************************************************************

 Demo for Unit SB16WAV: play a WAV file on Sound Blaster 16

**********************************************************************)

uses
  dos, crt,
  sb16, sb16wav, sbmix;


Procedure Abort (reason:string);
begin
  writeln (reason);
  halt (1);
end;


var
  fn  : pathstr;
  err : byte;
  mem : longint;

BEGIN
  mem := memavail;

  fn := paramstr(1);
  if fn = '' then begin
     writeln ('WavPlay (c) 2001 by Klaus Hartnegg, hartnegg@gmx.de');
     writeln ('Syntax : wavplay <filename>');
     writeln ('Example: wavplay hello.wav');
     halt (1);
  end;

  sb16wav.init;

  sb16wav.InitPlayback (fn, 0, true, err);
  if err <> 0 then case err of
    1 : abort ('error: can not read file '+fn);
    2 : abort ('error: no sound blaster found!');
    3 : abort ('error: sound card not compatible with sound blaster 16');
    4 : abort ('error: can not determine sound card parameters');
    5 : abort ('error: not enough memory available');
    6 : abort ('error: no XMS memory available');
    7 : abort ('error: not enough XMS memory available');
    else abort ('unknown error');
  end;

  sbmix.SetDefaultVolume;
  if paramstr(2) = 'maxvol' then begin
     sbmix.SetMixReg ('vml',31);
     sbmix.SetMixReg ('vmr',31);
     sbmix.SetMixReg ('vvl',31);
     sbmix.SetMixReg ('vvr',31);
     sbmix.SetMixReg ('ogl',3);
     sbmix.SetMixReg ('ogr',3);
  end;

  sb16wav.StartPlayback;
  repeat
     sb16wav.fill_buffers;
     { here your program can do other things }
  until keypressed or sb16wav.PlaybackReady;
  while keypressed do readkey;
  sb16wav.StopPlayback;

  sb16wav.done;

  writeln;
  writeln;
  if BufUnderflow <> 0 then
     writeln (BufUnderflow,' Buffer Underflows');

  if mem <> memavail then
     writeln ('warning: this program has a memory leak!');
END.
