Unit DmaBuf;

(*********************************************************************

allocate a buffer that does not cross a 64 kilobyte boundary

required for data transfer that uses DMA

using such a buffer speeds up BIOS-functions that
read sectors from floppy disk

13.09.2004 fix sometimes buffer did pass 64 kB limit
               rewrote calculation to use address instead of segment

**********************************************************************)


{$DEFINE DEBUG}


INTERFACE

type
  DmaBufferObj = Object
                {--------------------------}
                BuffPtr : Pointer;
                BufSize : longint;
                {--------------------------}
                Procedure Init (size:longint);
                Function  BufPtr : Pointer;
                Procedure Done;
                {--------------------------}
              end;


IMPLEMENTATION



Procedure DmaBufferObj.Init (size:longint);
var
  adr1, adr2 : longint;
  FillPtr    : pointer;
  FillSize   : word;
begin
  if BuffPtr <> NIL then Done;  { release previous buffer }

  BufSize := Size;

  FillSize := 0;
  GetMem (BuffPtr, 1);
  adr1 := longint(seg(BuffPtr^))*16;
  adr2 := adr1 + Size;
  FreeMem (BuffPtr, 1);

  { make sure the buffer does not pass a 64k boundary }
  if adr1 div $10000 <> adr2 div $10000 then begin
     adr2 := $10000 * (adr1 div $10000 + 1);
     FillSize := (adr2 - adr1);
  end;
  if FillSize < 16 then FillSize := 16;

  GetMem (FillPtr, FillSize);
  GetMem (BuffPtr, 1);
  while ofs(BuffPtr^) <> 0 do begin
     FreeMem (BuffPtr,1);
     FreeMem (FillPtr, FillSize);
     dec (FillSize);
     GetMem (FillPtr, FillSize);
     GetMem (BuffPtr, 1);
  end;
  FreeMem (BuffPtr, 1);
  GetMem  (BuffPtr, Size);
  FreeMem (FillPtr, FillSize);

  { Prfen ob DMA-Buffer wirklich keine 64k-Grenze enthlt }
  {$IFDEF DEBUG}
  adr1 := longint(seg(BuffPtr^)) * 16 + ofs(BuffPtr^);
  adr2 := adr1 + Size;
  if adr1 div 65536 <> adr2 div 65536 then runerror (255);
  {$ENDIF}
end;


Function  DmaBufferObj.BufPtr : Pointer;
begin
  BufPtr := BuffPtr;
end;


Procedure DmaBufferObj.Done;
begin
  if BuffPtr <> NIL then FreeMem (BuffPtr, BufSize);
  BuffPtr := NIL;
end;


END.
