
// ---------------------------------------------------------------------
//
// WinPlay1.c - Sample QuickTime for Windows Application
//
//              (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <qtw.h>

long FAR PASCAL __export WndProc (HWND, UINT, WPARAM, LPARAM);

MovieFile mfMovie;
RECT rcMovie;
Movie mMovie;
MovieController mcController;


int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdParam, int nCmdShow)
   {
   static char szAppName[] = "WinPlay1";
   HWND        hWnd;
   MSG         msg;
   WNDCLASS    wndclass;

// Establish links to QuickTime for Windows

   if (QTInitialize (NULL))
      {
      MessageBox (NULL, "QTInitialize failure", szAppName, MB_OK);
      return 0;
      }

// Allocate memory required for playing movies

   if (EnterMovies ())
      {
      MessageBox (NULL, "EnterMovies failure", szAppName, MB_OK);
      return 0;
      }

// Register and create main window

   if (!hPrevInstance)
      {
      wndclass.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WndProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon (NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;

      if (!RegisterClass (&wndclass))
         {
         MessageBox (NULL, "RegisterClass failure", szAppName, MB_OK);
         return 0;
         }
      }

   hWnd = CreateWindow(szAppName, szAppName, WS_CAPTION | WS_SYSMENU |
      WS_CLIPCHILDREN | WS_OVERLAPPED, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

   if (hWnd == NULL)
      {
      MessageBox (NULL, "CreateWindow failure", szAppName, MB_OK);
      return 0;
      }

// Instantiate the movie

   if (OpenMovieFile ("SAMPLE.MOV", &mfMovie, OF_READ) != noErr)
      {
      MessageBox (NULL, "OpenMovieFile failure", szAppName, MB_OK);
      return 0;
      }

   NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
   CloseMovieFile (mfMovie);

// Instantiate the movie controller

   GetMovieBox (mMovie, &rcMovie);
   OffsetRect(&rcMovie, -rcMovie.left, -rcMovie.top);
   mcController = NewMovieController (mMovie, &rcMovie,
      mcTopLeftMovie + mcScaleMovieToFit, hWnd);

// Make the movie paused initially

   MCDoAction (mcController, mcActionPlay, 0);

// Eliminate the grow box

   SetRectEmpty (&rcMovie);
   MCDoAction (mcController, mcActionSetGrowBoxBounds, &rcMovie);

// Make the frame just big enough for the movie

   MCGetControllerBoundsRect (mcController, &rcMovie);
   AdjustWindowRect (&rcMovie, WS_CAPTION | WS_OVERLAPPED, FALSE);
   OffsetRect(&rcMovie, -rcMovie.left, -rcMovie.top);
   SetWindowPos (hWnd, 0, 0, 0,
      rcMovie.right, rcMovie.bottom, SWP_NOMOVE | SWP_NOZORDER);

// Make the movie active

   SetMovieActive (mMovie, TRUE);

// Make the main window visible

   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

// Play the movie

   while (GetMessage (&msg, NULL, 0, 0))
      {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
      }

// Destroy the movie controller

   DisposeMovieController (mcController);

// Destroy the movie

   DisposeMovie (mMovie);

// Cut the connections to QuickTime for Windows

   ExitMovies ();
   QTTerminate ();

// Return to Windows

   return msg.wParam;
   }


long FAR PASCAL __export WndProc (HWND hWnd, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
   PAINTSTRUCT ps;

// Drive the movie controller

   if (MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam))
      return 0;

// Process the windows message

   switch (message)
      {
      case WM_PAINT:

         if (!BeginPaint (hWnd, &ps))
            return 0;
         EndPaint (hWnd, &ps);
         return 0;

      case WM_DESTROY:

         PostQuitMessage (0);
         return 0;
      }

// Return to Windows

   return DefWindowProc (hWnd, message, wParam, lParam);
   }

