
// ---------------------------------------------------------------------
//
// Viewer.h  - Picture Viewer - QuickTime for Windows
//
//             Version 1.0
//
//             (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Prevent multiple inclusion
// --------------------------
   #ifndef VIEWER_H
      #define VIEWER_H

   #define VIEWER_ROOT_NAME     "VIEW"
   #define MAX_PATH_LEN           256
   #define MAX_NAME_LEN            20
   #define FILE_EXT_LEN             5


// Functions
// -----------------------------------------------------------------------
// ViewerFrameWndProc is the frame window proc:
//
//
   LONG __export CALLBACK ViewerFrameWndProc   (HWND, UINT, WPARAM, LPARAM);
// -----------------------------------------------------------------------

// ViewerPictWndProc is the picture window proc:
//
//
   LONG __export CALLBACK ViewerPictureWndProc (HWND, UINT, WPARAM, LPARAM);
// -----------------------------------------------------------------------


// ViewerSetActiveModeless - Set handle of active modeless dlg used in
//                           main message loop
//
//
   VOID FAR ViewerSetActiveModeless( WPARAM, HWND );
// -----------------------------------------------------------------------


// Query function prototypes
// -----------------------------------------------------------------------
// ViewerQueryInstance returns the instance handle:
//
//   HINSTANCE hInstance;    Returned instance handle
//
     HINSTANCE FAR ViewerQueryInstance (VOID);
// -----------------------------------------------------------------------

// ViewerQueryResources returns the resource-only DLL handle:
//
//   HINSTANCE hResources;   Returned instance handle
//
     HINSTANCE FAR ViewerQueryResources (VOID);
// -----------------------------------------------------------------------

// ViewerQueryFrameWindow returns the frame window handle:
//
//   HWND hwndFrame;         Returned Frame window handle
//
     HWND FAR ViewerQueryFrameWindow (VOID);
// -----------------------------------------------------------------------

// ViewerQueryClientWindow returns the MDI client window handle:
//
//   HWND hwndClient;        Returned MDI client window handle
//
     HWND FAR ViewerQueryClientWindow( VOID );
// --------------------------------------------------------------------

// ViewerQueryActivePictureName returns the name of the active picture:
//
//   LSSTR;                  Returned -> name of active picture
//
     LPSTR FAR ViewerQueryActivePictureName( LPSTR );
// --------------------------------------------------------------------

// ViewerQueryNumPictures returns the number of pictures:
//
//   LSCSTR;                 Returned the number of pictures
//
   WORD FAR ViewerQueryNumPictures( VOID );
// --------------------------------------------------------------------

// ViewerNoMoreWindow sets global handles to NULL. Called during
//                    frame window WM_DESTROY message processing:
//
//
   VOID FAR ViewerNoMoreWindow( VOID );
// --------------------------------------------------------------------

// ViewerIsPalettized asks if we are running on a palettized device
//
//
   BOOL FAR ViewerIsPalettized( VOID );
// --------------------------------------------------------------------

// StoreCurrentSystemPalette stores a copy of the current system palette
//
//
   VOID FAR StoreCurrentSystemPalette( HPALETTE );
// --------------------------------------------------------------------


// ViewerQueryOleData returns -> to ole data struct
//
   LPQTOLE_OLEDATA FAR ViewerQueryOleData( VOID );
// --------------------------------------------------------------------


// End of Viewer.H
// -------------
   #endif
