
; ---------------------------------------------------------------------
;
; RAW16.ASM    - QuickTime for Windows Sample Decompressor
;
;                Version 1.1
;
;                (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------


INCLUDE  QTMACROS.INC

CODESEG  SEGMENT PARA USE16 PUBLIC 'CODE'
         OPTION  LANGUAGE:PASCAL
        .386

OnePixel MACRO   source:REQ, target:REQ
         MOV     AX, [ESI+source]      ;; Get a word
         ROL     AX, 8                 ;; Flip the bytes
         MOV     ES:[EDI+target], AX   ;; Store the word
         ENDM

OnePixelInPlace MACRO   offst:REQ
         ROL     WORD PTR [ESI+offst], 8  ;; Flip the bytes
         ENDM

DecompressRaw16 PROC USES SI DI DS ES, Inbuf:FAR PTR, Outbuf:FAR PTR,
                 BCOUNT:DWORD

         XOR     ESI, ESI         ; Zero out high order word
         XOR     ESI, ESI         ; Initialize high order word
         LDS     SI, Inbuf        ; DS:ESI = compressed buffer
         XOR     EDI, EDI         ; Initialize high order word
         LES     DI, Outbuf       ; ES:EDI = uncompressed buffer
         MOV     ECX, BCOUNT      ; Get buffer size in bytes
         SHR     ECX, 1           ; Convert to size in words, drop odd byte
         MOV     DX, CX           ; Isolate remainder mod 8
         AND     DX, 7            ;
         SHR     ECX, 3           ; Compute number of 8-pixel groups
         MOV     EAX, Inbuf       ; Are source and target buffers identical?
         CMP     EAX, Outbuf      ;
         JE      FlipInPlace      ; Skip if identical
         ALIGN   16
Loop8A:
i        =       0
         REPEAT  8
         OnePixel  i,  i
i        =       i + 2
         ENDM
         ADD     ESI, i           ; Advance source pointer
         ADD     EDI, i           ; Advance target pointer
         DEC     ECX              ; One fewer group to process
         JG      Loop8A           ; Loop once for each group of 8 pixels
         TEST    DX, DX           ; Any pixels remaining?
         JE      Done             ; Skip if none remaining
Loop1A:
         OnePixel 0, 0            ; Process one pixel
         ADD      ESI, 2          ; Advance source pointer
         ADD      EDI, 2          ; Advance target pointer
         DEC      DX              ; One fewer pixel to process
         JG       Loop1A          ; Loop once for each pixel
Done:
         RET                      ; Return to caller

         ALIGN   16
FlipInPlace:
Loop8B:
i        =       0
         REPEAT  8
         OnePixelInPlace  i
i        =       i + 2
         ENDM
         ADD     ESI, i           ; Advance source pointer
         DEC     ECX              ; One fewer group to process
         JG      Loop8B           ; Loop once for each group of 8 pixels
         TEST    DX, DX           ; Any pixels remaining?
         JE      Done             ; Skip if none remaining
Loop1B:
         OnePixelInPlace 0        ; Process one pixel
         ADD      ESI, 2          ; Advance source pointer
         DEC      DX              ; One fewer pixel to process
         JG       Loop1B          ; Loop once for each pixel
         JMP      Done            ; Go to common exit

DecompressRaw16 ENDP

CODESEG  ENDS
         END
