
// ---------------------------------------------------------------------
//
// QTWSAVER.C   - QuickTime for Windows
//
//                Version 1.0
//
//                (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


#include <windows.h>
#include <commdlg.h>
#include <scrnsave.h>
#include <qtw.h>
#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
#include "fileexts.rh"

static MovieFile mfMovie;
static Movie mMovie;
static MovieController mcController;

char szAppName[40];
HINSTANCE _cdecl hMainInstance;
HWND _cdecl hMainWindow;
char _cdecl szName[TITLEBARNAMELEN];
char _cdecl szIsPassword[22];
char _cdecl szIniFile[MAXFILELEN];
char _cdecl szScreenSaver[22];
char _cdecl szPassword[16];
char _cdecl szDifferentPW[BUFFLEN];
char _cdecl szChangePW[30];
char _cdecl szBadOldPW[BUFFLEN];
char _cdecl szHelpFile[MAXFILELEN];
char _cdecl szNoHelpMemory[BUFFLEN];
UINT _cdecl MyHelpMessage;
HOOKPROC _cdecl fpMessageFilter;

VOID NEAR MySelectAMovie (VOID);


// RegisterDialogClasses
// ---------------------------------------------------------------------
BOOL RegisterDialogClasses (HINSTANCE hInst)
{
    return TRUE;
}


// ScreenSaverProc
// ---------------------------------------------------------------------
LRESULT WINAPI ScreenSaverProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    RECT rcMovie, rcClient;
    char szSection[_MAX_PATH];
    char szProfile[_MAX_PATH];
    char szMovie[_MAX_PATH];

    // Drive the movie controller

    MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam);

    // Act on message from Windows

    switch (message)

    {
        // Creating screen saver

        case WM_CREATE:

            // Initialize QTW

            if ((QTInitialize (NULL) != QTI_OK) || (EnterMovies () != noErr)) {
                DestroyWindow (hWnd);
                return 0;
            }

            // Get movie name

            for (;;) {
                LoadString (hMainInstance, idsAppName, szSection, sizeof (szSection));
                LoadString (hMainInstance, idsIniFile, szProfile, sizeof (szProfile));
                GetPrivateProfileString (szSection, "Movie", "", szMovie, sizeof (szMovie), szProfile);
                if (szMovie[0] != 0) break;
                MySelectAMovie ();
            }

            // Open the movie

            if (OpenMovieFile (szMovie, &mfMovie, OF_READ) != noErr) {
                DestroyWindow (hWnd);
                return 0;
            }
            NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
            CloseMovieFile (mfMovie);

            // Instantiate the controller

            GetMovieBox (mMovie, &rcMovie);
            GetClientRect (GetDesktopWindow (), &rcClient);
            OffsetRect(&rcMovie, -rcMovie.left, -rcMovie.top);
            rcMovie.right *= 2, rcMovie.bottom *= 2;
            OffsetRect(&rcMovie, (rcClient.right - rcMovie.right) / 2,
                (rcClient.bottom - rcMovie.bottom) / 2);
            mcController = NewMovieController (mMovie, &rcMovie,
                mcTopLeftMovie + mcScaleMovieToFit + mcNotVisible, hWnd);

            // Action!

            SetMovieActive (mMovie, TRUE);
            InvalidateRect (hWnd, &rcMovie, FALSE);
            MCDoAction (mcController, mcActionSetVolume, (LPVOID) MAKESFIXED (0, 64));
            MCDoAction (mcController, mcActionSetFlags, (LPVOID) mcFlagsUseWindowPalette);
            MCDoAction (mcController, mcActionSetLooping, (LPVOID) TRUE);
            PrerollMovie (mMovie, 0, MAKELFIXED (1, 0));
            MCDoAction (mcController, mcActionPlay, (LPVOID) MAKELFIXED (1, 0));
            break;

        // Destroying the screen saver

        case WM_DESTROY:
            DisposeMovieController (mcController);
            DisposeMovie (mMovie);
            ExitMovies ();
            QTTerminate ();
            break;

        // Paint It Black

        case WM_ERASEBKGND:
            GetClientRect (hWnd, &rcMovie);
            FillRect ((HDC) wParam, &rcMovie, (HBRUSH) GetStockObject (BLACK_BRUSH));
            return 0;

    }

    // Return to Windows

    return DefScreenSaverProc (hWnd, message, wParam, lParam);
}


// ScreenSaverConfigureDialog
// ---------------------------------------------------------------------
BOOL WINAPI ScreenSaverConfigureDialog (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        case WM_INITDIALOG:
            MySelectAMovie ();
            EndDialog (hDlg, TRUE);
            return TRUE;
    }
    return FALSE;
}


// MySelectAMovie
// ---------------------------------------------------------------------
VOID NEAR MySelectAMovie (VOID)
{
    char szDir[_MAX_DIR];
    char szFileTitle[_MAX_PATH];
    char szMovie[_MAX_PATH];
    char szSection[_MAX_PATH];
    char szFilter[_MAX_PATH];
    char szProfile[_MAX_PATH];
    char* p;
    OPENFILENAME ofn;

    // Where was the old movie?

    LoadString (hMainInstance, idsAppName, szSection, sizeof (szSection));
    LoadString (hMainInstance, idsIniFile, szProfile, sizeof (szProfile));
    GetPrivateProfileString (szSection, "Movie", "", szDir, sizeof (szMovie), szProfile);
    if (strlen (szDir) > 0) {
        p = strrchr (szDir, '\\');
        *p = 0;
    }
    else _getcwd (szDir, sizeof (szDir));

    // Select a movie

    szMovie[0] = '\0';
    memset (&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = 0;
    ofn.lpstrFilter = CommonGetFileFilter (hMainInstance, (WORD) COMMON_MOVIES_FILEEXT, szFilter, sizeof szFilter);
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = szMovie;
    ofn.nMaxFile = sizeof(szMovie);
    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = sizeof(szFileTitle);
    ofn.lpstrInitialDir = szDir;
    ofn.lpstrTitle = "Select a Movie";
    ofn.Flags = OFN_HIDEREADONLY;
    if (GetOpenFileName (&ofn) != 0) {
        WritePrivateProfileString (szSection, "Movie", szMovie, szProfile);
    }

    // Return to caller

    return;

}
