
// ---------------------------------------------------------------------
//
// QTRAW.CPP    - QuickTime for Windows Sample Decompressor
//
//                Version 1.1
//
//                (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Windows header files
#include <windows.h>
#include <windowsx.h>

// Compiler header files
#include <string.h>

// Application header files
#include "prototyp.hp"

// Global data
ComponentDescription cdTable[] = // one component in this DLL
  { ostypeDCMP                     // ostypeComponentType
  , ostypeRAW                      // ostypeComponentSubType
  , ostypeAPPL                     // ostypeComponentManufacturer
  , 0                              // dwComponentFlags
  , 0                              // dwComponentFlagsMask
  , ( ComponentRoutine) CodecEntry // crEntryPoint
  , 0                              // hrsrcName
  , 0                              // hrsrcInfo
  , 0                              // hrsrcIcon
  } ;

/* function cfBandDecompress:
   Decompress one frame of the movie
*/
ComponentResult QTAPI cfBandDecompress( STKOFF_CMP so
    , LPVOID lpvStorage
    , LPCODECDECOMPRESSPARAMS lpdecomp
    )
{
    ImageDescription FAR * lpIm = lpdecomp->lpim ;
    LPVOID lpCompressed = lpdecomp->lpCompressed
        , lpUncompressed = lpdecomp->lpUncompressed
        ;
    // compute maximum size of uncompressed buffer
    DWORD dwMaxSize = GetSelectorLimit( SELECTOROF( lpUncompressed))
        - OFFSETOF( lpUncompressed)
        ;
    LONG lSafeSize = min( lpdecomp->lCompressedSize, ( LONG) dwMaxSize) ;

    // act based on sample depth
    if ( lpIm->depth == 16)
        DecompressRaw16( lpCompressed, lpUncompressed, lSafeSize) ;
    else if ( lpCompressed == lpUncompressed) // if source and target agree
        return noErr ;
    else
        CopyMemory( lpUncompressed, lpCompressed, lSafeSize) ;

    // successful return
    return noErr ;
} // cfBandDecompress

/* function cfCloseSelect:
   Close an open component instance
*/
ComponentResult QTAPI cfCloseSelect( STKOFF_CMP so, ComponentInstance ci)
{
    // free any allocated storage
    LPVOID lpvPrivate = GetComponentInstanceStorage( ci) ;
    FreeMemory( lpvPrivate) ;

    // successful return
    return noErr ;
} // cfCloseSelect

/* function cfGetCodecInfo:
   Fill out the codec information block
*/
ComponentResult QTAPI cfGetCodecInfo( STKOFF_CMP so
    , LPVOID lpvStorage
    , LPCODECINFO lpinfo
    )
{
    // initialize fields to 0
    _fmemset( lpinfo, 0, sizeof( CODECINFO)) ;

    // fill out nonzero fields
    lpinfo->dwDecompressFlags = cdTable[ 0].dwComponentFlags & 0xffffffL ;
    lpinfo->dwFormatFlags = codecInfoDepth1
        | codecInfoDepth2
        | codecInfoDepth4
        | codecInfoDepth8
        | codecInfoDepth16
        | codecInfoDepth24
        | codecInfoDepth32
        | codecInfoDepth34
        | codecInfoDepth36
        | codecInfoDepth40
        | codecInfoDoesLossless
        ;
    lpinfo->wDecompressionSpeed = 392 ;

    // return to caller
    return noErr ;
} // cfGetCodecInfo

/* function cfOpenSelect:
   Open a codec component instance
*/
ComponentResult QTAPI cfOpenSelect( STKOFF_CMP so, ComponentInstance ci)
{
    // allocate and register private storage
    #if 0 // no private storage for RAW
    LPVOID lpvPrivate = GetMemory( sizeof( RAW)) ;
    if ( lpvPrivate == 0)
        return insufficientMemory ;
    SetComponentInstanceStorage( ci, lpvPrivate) ;
    #endif

    // successful return
    return noErr ;
} // cfOpenSelect

/* function cfPreDecompress:
   Evaluate the image compression manager's proposed terms
*/
ComponentResult QTAPI cfPreDecompress( STKOFF_CMP so
    , LPVOID lpvStorage
    , LPCODECDECOMPRESSPARAMS lpdecomp
    )
{
    // set capabilities
    ImageDescription FAR * lpIm = lpdecomp->lpim ;
    LPCODECCAPABILITIES lpcapab = lpdecomp->lpCapabilities ;
    lpcapab->lFlags = 0 ;              // cannot do anything
    lpcapab->wBandMin = lpIm->height ; // no banding
    lpcapab->wBandInc = lpIm->height ; // no banding
    lpcapab->wExtendHeight = 1 ;       // 1 row per compression unit
    lpcapab->wExtendWidth  = 3 ;       // allow 3 bytes for DWORD access
    lpcapab->wWantedPixelSize = lpIm->depth > 32
        ? lpIm->depth - 32
        : lpIm->depth
        ;
    lpcapab->optt = OPT_RAW ;          // must decompress to raw
    return lpcapab->optt == lpdecomp->optt ? noErr : codecConditionErr ;
} // cfPreDecompress

/* function cfSequenceBusy:
   Report if an asynchronous operation is active
*/
ComponentResult QTAPI cfSequenceBusy( STKOFF_CMP so
    , LPVOID lpvStorage
    , ImageSequence seq
    )
{
    return FALSE ; // no asynchronous operations
} // cfSequenceBusy
