
// ---------------------------------------------------------------------
//
// QTOle.h - OLE Server - QuickTime for Windows
//
//           Version 1.0
//
//           (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Prevent multiple inclusion
// --------------------------
   #ifndef QTOLE_H
      #define QTOLE_H

   #include <qtw.h>

// defines
// -------
   #ifndef MAX_PATH_LEN
   #define MAX_PATH_LEN      256
   #endif

   #ifndef MAX_TEXT_LEN
   #define MAX_TEXT_LEN       64
   #endif

     // Object type ids. Application can support one or the other
   #define MOVIE_OBJECT     0x0001
   #define PICTURE_OBJECT   0x0002

   #define VERSION_1             1
   #define DEFAULT_RATE       MAKELFIXED( 1, 0 )

   #define QTOLE_API     CALLBACK __loadds


// typedefs
// ----------
   typedef LONG    QTOLE_ERR;
   typedef struct  _tagQTOLE_OPTIONS    FAR *LPQTOLE_OPTIONS;

   typedef QTOLE_ERR (CALLBACK *QTOLEPROC) (UINT, WPARAM, LPARAM, LPQTOLE_OPTIONS);

   typedef struct _tagQTOLE_INIT
      {DWORD              lStructSize;
       LONG               lVersion;
       HINSTANCE          hInstance;
       HINSTANCE          hResources;
       LPSTR              lpCmdLine;
       LPCSTR             lpClassName;
       LPCSTR             lpServerCaption;
       LPINT              lpnCmdShow;
       WORD               wIDFirstString;
       WORD               wIDFirstDlg;
       BOOL               bMultipleObjectServer;
       QTOLEPROC          fpServerCallBack;

      } QTOLE_INIT;
   typedef QTOLE_INIT FAR *LPQTOLE_INIT;


   typedef struct _tagQTOLE_OLEDATA
      {DWORD              lStructSize;
       LONG               lVersion;
       WORD               wObjectType;
       LPVOID             lpqtoleServer;

      } QTOLE_OLEDATA;
   typedef QTOLE_OLEDATA FAR *LPQTOLE_OLEDATA;


   typedef struct _tagQTOLE_OPENWND
      {DWORD              lStructSize;
       LONG               lVersion;
       WORD               wObjectType;
       HWND               hwndObject;
       LPCSTR             lpObjectPath;
       LPCSTR             lpObjectName;
      } QTOLE_OPENWND;
   typedef QTOLE_OPENWND FAR *LPQTOLE_OPENWND;


   typedef struct _tagQTOLE_OPTIONS
      {DWORD              lStructSize;
       LONG               lVersion;
       WORD               wObjectType;
       HWND               hwndObject;
      } QTOLE_OPTIONS;

   typedef struct _tagQTOLE_OPTIONSMOVIE
      {DWORD              lStructSize;
       LONG               lVersion;
       WORD               wObjectType;
       HWND               hwndObject;
            // movie handle
       Movie              mMovie;
       LFIXED             lfxRate;
       BOOL               bSoundOnlyMovie;
            // movie copy options
       BOOL               bCopyCurrentFrame;
       BOOL               bCopyIcon;
       BOOL               bShowTitleBar;
       TimeValue          tvDisplayFrame;
            // looping options
       BOOL               bLoop;
       BOOL               bLoopPalindrome;
            // play selection option
       BOOL               bPlaySelectionOnly;
            // size data
       SIZE               sizeNormal;
       SIZE               sizeCurrent;
            // size options
       BOOL               bSizeHalf;
       BOOL               bSizeNormal;
       BOOL               bSizeDouble;
            // miscellaneous options
       BOOL               bShowMovieController;
       BOOL               bUseMoviePalette;
       BOOL               bDrawWindowFrame;
            // caption data
       char               szCaption[MAX_TEXT_LEN];
            // selection and duration data
       TimeRecord         trSelStart;
       TimeRecord         trSelDuration;
       TimeValue          tvMovieDuration;

      } QTOLE_OPTIONSMOVIE;
   typedef QTOLE_OPTIONSMOVIE FAR *LPQTOLE_OPTIONSMOVIE;


   typedef struct _tagQTOLE_OPTIONSPICTURE
      {DWORD              lStructSize;
       LONG               lVersion;
       WORD               wObjectType;
       HWND               hwndObject;
            // Picture handle
       PicHandle          phPicture;
            // Picture copy options
       BOOL               bCopyIcon;
       BOOL               bShowTitleBar;
       RECT               rcSelection;
            // size data
       WORD               wZoomCurrent;    // 100 is 1 x 1, 200 is 2 x expansion, etc
            // size options
       BOOL               bZoomHalf;
       BOOL               bZoomNormal;
       BOOL               bZoomDouble;
            // miscellaneous options
       BOOL               bShowPictureControls;
       BOOL               bUsePicturePalette;
       BOOL               bDrawWindowFrame;
            // caption data
       char               szCaption[MAX_TEXT_LEN];

      } QTOLE_OPTIONSPICTURE;
   typedef QTOLE_OPTIONSPICTURE FAR *LPQTOLE_OPTIONSPICTURE;


// Callback function message IDS
// -----------------------------
   #define QTOLE_MSG_OPENOBJECT        0x0100
   #define QTOLE_MSG_SHOWOBJECT        0x0101
   #define QTOLE_MSG_OPENOPTIONSDLG    0x0102
   #define QTOLE_MSG_PLAYOBJECT        0x0103
   #define QTOLE_MSG_FILEOPEN          0x0104

// Localized string id offsets
// ---------------------------
   #define QTOLE_STR_OFFSET_READABLENAME       0
   #define QTOLE_STR_OFFSET_PLAY               1
   #define QTOLE_STR_OFFSET_EDIT               2
   #define QTOLE_STR_OFFSET_OPTIONS            3
   #define QTOLE_STR_OFFSET_UPDATA             4
   #define QTOLE_STR_OFFSET_ALREADYINSERTING   5
   #define QTOLE_STR_OFFSET_WHEREFILE          6
   #define QTOLE_STR_OFFSET_UPDATEPATH         7
   #define QTOLE_STR_OFFSET_NOTFILESIZE        8
   #define QTOLE_STR_OFFSET_NOTFILENAME        9
   #define QTOLE_STR_OFFSET_SEARCHDIRS        10
   #define QTOLE_STR_OFFSET_FILENOTFOUND      11

// Localized dialog template id offsets
// ---------------------------
   #define QTOLE_DLG_OFFSET_SEARCHDLG       0


// Error Codes
// -----------
   enum
      {QTOLE_OK                  =   0L,
       QTOLE_GEN_ERROR           =   1L,
       QTOLE_INSTALL_ONLY        =   2L,
       QTOLE_CMDLINE_SYNTAX      =   3L,
       QTOLE_SERVERWRONGVERSION  =   4L,
       QTOLE_NATIVEWRONGVERSION  =   5L,
       QTOLE_NOMEMORY            =   6L,
       QTOLE_OLEINITFAILURE      =   7L,
       QTOLE_BAD_INPUT_FOR_REG   =   8L,
       QTOLE_REGFAILED           =   9L,
       QTOLE_NOSERVERDATA        =  10L,
       QTOLE_COPYFAILED          =  11L,
       QTOLE_INVALIDDATAREF      =  12L,
       QTOLE_NEWMOVIEERR         =  13L,
       QTOLE_NOVIDEOINFO         =  14L,
       QTOLE_NOCONTROLLER        =  15L

      };

// Interface Prototypes
// --------------------
       // Call before application CreateWindow in startup code
   QTOLE_ERR  QTOLE_API QTOLE_Initialize          (LPQTOLE_OLEDATA, LPQTOLE_INIT);

       // Call after application CreateWindow returns an hwnd
   VOID       QTOLE_API QTOLE_SetApplicationHwnd  (LPQTOLE_OLEDATA, HWND);

       // Call during creation of object window. This may or may not be the main app
       // window
   QTOLE_ERR  QTOLE_API QTOLE_OpeningNewObjectWnd (LPQTOLE_OLEDATA, LPQTOLE_OPENWND);

       // Call during Edit-Copy processing
   QTOLE_ERR  QTOLE_API QTOLE_Copy                (LPQTOLE_OLEDATA, LPQTOLE_OPTIONS);

       // Used to open an object wnd in response to the QTOLE_MSG_PLAYOBJECT
       // call in the server callback function.  The server must post a message
       // to itself to call this function.
   QTOLE_ERR  QTOLE_API QTOLE_PlayObject          ( LPQTOLE_OLEDATA, LPARAM );

       // Called after closing Options dlg when it is opened as a result of
       // QTOle.dll sending message
   VOID       QTOLE_API QTOLE_ClosedOptionsDlg    (LPQTOLE_OLEDATA,
                                                              LPQTOLE_OPTIONS, BOOL);

       // Call during document WM_CLOSE or WM_DESTROY processing
   BOOL       QTOLE_API QTOLE_ClosingDocWnd       (LPQTOLE_OLEDATA, LPQTOLE_OPTIONS);

       // Called during File menu popup initialization
   BOOL       QTOLE_API QTOLE_IsActiveObjectWnd   (LPQTOLE_OLEDATA, HWND, LPSTR);


       // Call during server WM_CLOSE or WM_DESTROY processing
   BOOL       QTOLE_API QTOLE_ClosingServerWnd    (LPQTOLE_OLEDATA, UINT);

       // Call after exiting message loop
   QTOLE_ERR  QTOLE_API QTOLE_OLECleanUp          (LPQTOLE_OLEDATA);

   #endif
