
// ---------------------------------------------------------------------
//
// Player.h - Movie Player - QuickTime for Windows
//
//            Version 1.0
//
//            (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Prevent multiple inclusion
// --------------------------
   #ifndef PLAYER_H
      #define PLAYER_H

   #include <commdlg.h>

   #define PLAYER_ROOT_NAME     "PLAY"
   #define MAX_PATH_LEN           256
   #define MAX_NAME_LEN            20
   #define FILE_EXT_LEN             5


// Handles
// -------
   DECLARE_HANDLE(HMOVIEDATA);

// typedefs
// ---------
   typedef struct
     {char              szMoviePath[MAX_PATH_LEN];  // Path of movie file
      char              szMovieName[MAX_NAME_LEN];  // File name of movie
      char              szMovieExt[FILE_EXT_LEN];   // File extension
      WORD              wDuplicationIndex;     // Duplication index
                                               // e.g. 1 if first, 2 if 2nd
      char              szFileSize[18];        // "xxxK bytes"
      Movie             mMovie;                // Handle of the movie
      MovieController   mcMovieController;     // Handle of movie controller
      ImageDescription  idMovieInfo;           // Video info struct
      SoundDescription  sdSoundInfo;           // Sound info struct
      BOOL              bSoundOnly;            // Sound only movie flag
      OSErr             oserrVideoInfo;        // Return from GetVideoInfo
      OSErr             oserrSoundInfo;        // Return from GetSoundInfo
      BOOL              bDisableSizeMsgProcessing;  // Flag used in WM_SIZE message processing
      BOOL              bDisableMoveMsgProcessing;  // Flag used in WM_MOVE message processing
      BOOL              wMinMaxEtc;            // Saved value used in WM_SIZE
                                               // Message processing
      LFIXED            lfxSavePlayRate;       // Saved play rate
      HWND              hwndGetInfo;           // HWND of info dialog box
      HWND              hwndSearch;            // HWND of search dialog box
      HFONT             hfInfo;                // Font of info dialog box
      TimeRecord        trSelectionStart;      // Selection start or -1 if no selection
      TimeRecord        trSelectionDuration;   // Selection duration
      MCActionFilter    lpFilterProc;          // -> DoAction filter proc
      BOOL              bSettingControllerSize;   // DoAction filter blocking flag
      RECT              rcGrowBox;             // Grow box bounds rect
      BOOL              bGrowBoxSubclassed;    // TRUE if grow box is successfully
                                               // subclassed
      QTOLE_OPTIONSMOVIE qtoleOptions;         // Ole movie options struct
      WORD              cx, cy;                // Normal width, height
      UINT              uiFindMessage;         // Find replace message
      FINDREPLACE       fr;                    // Supports search
      char              szSearch[128];         // Actual search text
      TimeValue         tvSearch;              // Movie time of found data
      LONG              lOffset;               // Offset in sample of found data

     } MOVIEDATASTRUCT, * NPMOVIEDATA;


// Functions
// -----------------------------------------------------------------------
// PlayerFrameWndProc is the frame window proc:
//
//
   LONG __export CALLBACK PlayerFrameWndProc (HWND, UINT, WPARAM, LPARAM);
// -----------------------------------------------------------------------

// PlayerMovieWndProc is the movie window proc:
//
//
   LONG __export CALLBACK PlayerMovieWndProc (HWND, UINT, WPARAM, LPARAM);
// -----------------------------------------------------------------------


// PlayerSetActiveModeless - Set handle of active modeless dlg used in
//                           main message loop
//
//
   VOID FAR PlayerSetActiveModeless (WPARAM, HWND);
// -----------------------------------------------------------------------


// PlayerGetOptions - Opens the options dialog
//
   BOOL FAR PlayerGetOptions        (HWND, LPQTOLE_OPTIONSMOVIE);
// --------------------------------------------------------------------


// Function: PlayerGetDefaultOptions - Gets the default options
//
   VOID FAR PlayerGetDefaultOptions( LPQTOLE_OPTIONSMOVIE lpOptions );
// --------------------------------------------------------------------


// QTOLEServerCallBack - Server callback used by qtole.dll to
//                       send commands to the server
   QTOLE_ERR __export CALLBACK QTOLEServerCallBack
                                   (UINT, WPARAM, LPARAM, LPQTOLE_OPTIONSMOVIE);
// --------------------------------------------------------------------


// Query function prototypes
// -----------------------------------------------------------------------
// PlayerQueryInstance returns the instance handle:
//
// HINSTANCE hInstance;    Returned instance handle
//
   HINSTANCE FAR PlayerQueryInstance (VOID);
// -----------------------------------------------------------------------


// PlayerQueryResources returns the resource-only DLL handle:
//
// HINSTANCE hResources;   Returned instance handle
//
   HINSTANCE FAR PlayerQueryResources (VOID);
// -----------------------------------------------------------------------


// PlayerQueryFrameWindow returns the frame window handle:
//
// HWND hwndFrame;         Returned Frame window handle
//
   HWND FAR PlayerQueryFrameWindow (VOID);
// -----------------------------------------------------------------------


// PlayerQueryClientWindow returns the MDI client window handle:
//
// HWND hwndClient;        Returned MDI client window handle
//
   HWND FAR PlayerQueryClientWindow( VOID );
// --------------------------------------------------------------------


// PlayerQueryActiveMovieName returns the name of the active movie:
//
// LSCSTR;                 Returned -> name of active movie
//
   LPSTR FAR PlayerQueryActiveMovieName( LPSTR );
// --------------------------------------------------------------------


// PlayerQueryNumMovies returns the number of movie windows:
//
// WORD;                   Returned number of movies
//
   WORD FAR PlayerQueryNumMovies( VOID );
// --------------------------------------------------------------------


// PlayerQueryMDIAction returns the menu id if tiling, cascading
//                      or arranging icons:
//
// WORD;                   Returned menu id, else 0
//
   WORD FAR PlayerQueryMDIAction( VOID );
// --------------------------------------------------------------------


// PlayerNoMoreWindow sets some global handles to NULL. Called during
//                    frame window WM_DESTROY message processing:
//
   VOID FAR PlayerNoMoreWindow( VOID );
// --------------------------------------------------------------------


// PlayerQueryOleData return -> to ole data struct
//
   LPQTOLE_OLEDATA FAR PlayerQueryOleData( VOID );
// --------------------------------------------------------------------


// UpdateMovieForOptions - Sets movie to reflect current options
//
   VOID FAR UpdateMovieForOptions (HWND, NPMOVIEDATA, BOOL);
// --------------------------------------------------------------------


// End of player.H
// -------------
   #endif
