
// ---------------------------------------------------------------------
//
// Picture.h  - Picture Viewer - QuickTime for Windows
//
//              Version 1.0
//
//              (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Prevent multiple inclusion
// --------------------------
   #ifndef PICTURE_H
      #define PICTURE_H

// Background brush
// --------------------------
   #define PICBACKGRNDBRUSH    GetStockObject( LTGRAY_BRUSH )


// Typedef of structure used to store picture instance data
// ----------------------------------------------------------------------

typedef struct {                            // Hungarian: spms
      HWND              hwnd;               // Handle of control
      WORD              wCurMax;            // Current maximum value
      WORD              wCurPos;            // Current position
      WORD              wCurLine;           // Current line size
      WORD              wCurPage;           // Current page size
      } SCROLLPARMS, * NPSCROLLPARMS;

typedef struct {                          // Hungarian: zs
      HWND              hwnd;             // Handle of control
      WORD              wCurZoomIndex;    // Current zoom
      POINT             ptBucklePos;      // Saved buckle position
      HBITMAP           hbmpNotBuckle;    // Handle to no buckle bitmap
      } ZOOMSCROLL, * NPZOOMSCROLL;


DECLARE_HANDLE(HPICTUREDATA);

typedef struct {                            // Hungarian: pd
      char              szPicturePath[MAX_PATH_LEN];   // Path of picture
      char              szPictureName[MAX_NAME_LEN];   // Name of picture
      char              szPictureExt[FILE_EXT_LEN];    // File extension
      WORD              wDuplicationIndex;  // Duplication index
                                            // e.g. 1 if first, 2 if second
      char              szPictType[30];     // Type of picture
      char              szFileSize[18];     // "xxxK"
      char              szFileSizeOnDisk[18];  // "xxxK on disk"
      PicHandle         phPicture;          // Picture handle
      HBITMAP           hbitmapIcon;        // Icon memory bitmap
      LPBITMAPINFO      lpDIBIconMem;       // -> DIB icon bitmap info struct
                                            // This is used only if monitor is
                                            // palettized
      HPALETTE          hpalPicture;        // Picture palette (or NULL if none)
      ImageDescription  idImageInfo;        // Image info
      BOOL              bDisableSizeMsgProcessing;  // Flag used in WM_SIZE
                                            // message processing
      BOOL              wMinMaxEtc;         // Saved value used in WM_SIZE
                                            // Message processing
      SCROLLPARMS       spmsHScroll;        // Horz scroll parms
      SCROLLPARMS       spmsVScroll;        // Horz scroll parms
      ZOOMSCROLL        zsZoomScroll;       // Zoom scroll parms
      RECT              rcCurPictureRect;   // Current picture rect.
                                            // This rect includes scrolling
      BOOL              bScrollWaitForPaint;// Disables scroll processing
                                            // until after first paint occurs
                                            // during activation processing.
      HWND              hwndBanner;         // HWND of banner window
      HWND              hwndGetInfo;        // HWND of info dialog box
      HFONT             hfInfo;             // Font of info dialog box
      RECT              rcGrowBox;          // RECT of grow box
      BOOL              bGrowBoxSubclassed; // TRUE if grow box is successfully
                                            // subclassed
      QTOLE_OPTIONSPICTURE qtoleOptions;    // Ole picture options struct

     } PICTUREDATASTRUCT, * NPPICTUREDATA;

// Control ids
   #define PICTURE_ZOOM_SCROLL         10  // child control id
   #define PICTURE_HORZ_SCROLL         11  // child control id
   #define PICTURE_VERT_SCROLL         12  // child control id
   #define PICTURE_BANNER              13  // child control id

// Window classes for controls
// ---------
   #define PICTURE_ZOOM_CLASS        "PictureZoomScrollClass"
   #define PICTURE_BANNER_CLASS      "PictureBannerClass"


// Functions
// -----------------------------------------------------------------------

// PictureZoomWndProc is the callback function for the zoom control
//
   LONG __export CALLBACK PictureZoomWndProc (HWND, UINT, WPARAM, LPARAM);
// -----------------------------------------------------------------------

//  ProcessHorzScroll processes the horizontal scroll messages:
//
//
   LONG FAR  ProcessHorzScroll   (HWND, WORD, int);
// -----------------------------------------------------------------------

//  ProcessVertScroll processes the vertical scroll messages:
//
//
   LONG FAR  ProcessVertScroll   (HWND, WORD, int);
// -----------------------------------------------------------------------

//  ScrollToCorner scrolls the picture to upper-left and lower-right corners:
//
//
   LONG FAR  ScrollToCorner      (HWND, WORD);
// -----------------------------------------------------------------------

//  Resizes the child windows when the picture window is resized:
//
//
   VOID FAR  ResizeKids          (HWND, WORD, WORD);

// -----------------------------------------------------------------------


//  Creates the child windows for the picture window:
//
//
   LONG FAR CreateViewerKids     (HWND, NPPICTUREDATA);
// -----------------------------------------------------------------------


//  Registers the picture resize scrollbar window:
//
//
   BOOL FAR RegisterChildControls (HINSTANCE);
// -----------------------------------------------------------------------


//  Returns the client rect that corresponds to the given picture rect:
//
//
   VOID FAR ClientRectFromPicture  (LPRECT);
// -----------------------------------------------------------------------

//  Returns the max picture rect that corresponds to the given client rect:
//
//
   VOID FAR PictureRectFromClient  (LPRECT);
// -----------------------------------------------------------------------

//  Converts from client coordinates to picture coordinates:
//
//
   VOID FAR ClientToPicture  (LPPOINT, WORD);
// -----------------------------------------------------------------------

//  Converts from picture coordinates to client coordinates:
//
//
   VOID FAR PictureToClient  (LPPOINT, WORD);
// -----------------------------------------------------------------------


//  Determines if the cursor is in the grow box corner
//
//
   BOOL FAR IsInGrowBox         (HWND, POINT);
// -----------------------------------------------------------------------


//  Destroy the grow box bitmap
//
//
   VOID FAR DestroyGrowBoxBitmap (VOID);
// -----------------------------------------------------------------------


//  Paint the grow box bitmap
//
//
   VOID FAR PaintTheGrowBox     (HWND, HDC, NPPICTUREDATA);
// -----------------------------------------------------------------------


//  Limit the resizing to keep the windows inside the MDI rect when
//  using the grow box
//
//
   VOID FAR LimitTheDragSize    (HWND, BOOL);
// -----------------------------------------------------------------------


//  Initialize the maximized window grow box resizing:
//
//
   BOOL FAR  InitMaxWndGrowBoxResize  (HWND, POINT);
// -----------------------------------------------------------------------

//  Move the resize rect during maximized window grow box resizing:
//
//
   VOID FAR  MoveTheFrameRect         (HWND, POINT);
// -----------------------------------------------------------------------

//  Terminate the maximized window grow box resizing:
//
//
   VOID FAR  EndMaxWndGrowBoxResize   (HWND);
// -----------------------------------------------------------------------


//  Resizes the picture to the size indicated by the input size index:
//
//
   LONG FAR ZoomPicture         (HWND, WORD);
// -----------------------------------------------------------------------


//  Process the WM_GETMINMAXINFO message:
//
//
   LONG FAR SetMinMaxInfo       (MINMAXINFO FAR*);
// -----------------------------------------------------------------------

// Creates the font used in the zoom control and banner bar:
//
//
   HFONT FAR MakeAnArialFont    (HDC, int);
// -----------------------------------------------------------------------


// ViewerGetOptions - Opens the options dialog
//
   BOOL FAR ViewerGetOptions       (HWND, LPQTOLE_OPTIONSPICTURE);
// --------------------------------------------------------------------

// UpdatePictForOptions - Sets picture to reflect current options
//
   VOID FAR UpdatePictForOptions   (HWND, NPPICTUREDATA, BOOL);
// -----------------------------------------------------------------------

// ViewerGetDefaultOptions - Gets the default options
//
   VOID FAR ViewerGetDefaultOptions( LPQTOLE_OPTIONSPICTURE lpOptions );
// --------------------------------------------------------------------


// QTOLEServerCallBack - Server callback used by qtole.dll to send commands
//                       to the server
//
   QTOLE_ERR __export CALLBACK QTOLEServerCallBack
                                (UINT, WPARAM, LPARAM, LPQTOLE_OPTIONSPICTURE);
// --------------------------------------------------------------------


// Query function prototypes
// --------------------------------------------------------------------

// Get the zoom multiplier for the current zoom index
//
//
   WORD FAR ViewerQueryZoomMultiplier   (WORD);
// --------------------------------------------------------------------


// Get the zoom index for the given zoom multiplier
//
//
   WORD FAR ViewerQueryZoomIndex   (WORD);
// --------------------------------------------------------------------


// Get the adjusted width of the zoom window
//
//
   WORD FAR ViewerQueryZoomWndWidth( VOID );
// --------------------------------------------------------------------


// ViewerGetOptionsStruct Sets playere to reflect current options
//
   VOID FAR ViewerGetOptionsStruct (NPPICTUREDATA, HWND);
// --------------------------------------------------------------------


// End of Picture.H
// -------------
   #endif
