// ---------------------------------------------------------------------
//
// P9000V.CPP    Sample VHDW Component for P9000 chips
//
//               Version 1.0
//
//               (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Windows header files
// --------------------
#include <windows.h>
#include <windowsx.h>


// Compiler header files
// ---------------------
#include <stdlib.h>
#include <string.h>


// QuickTime header files
// ----------------------
#include <qtcodec.h>
#include <qtvhdw.h>


// Project header files
// --------------------
#include "p9000.h"


// Assembler functions
// -------------------
extern "C" {
    DWORD QTAPI VHDWEntry (VOID);
    WORD FAR CDECL DispatchP9000 ();
}


// Local functions
// ---------------
static VOID FAR PASCAL FixupCM (ENTRYFUNC lpfnCM);
static VOID FAR PASCAL FixupTB (ENTRYFUNC lpfnTB);
static HINSTANCE GetInstOfThisMod ();


// Global data
// -----------
extern "C" ENTRYFUNC lpfnQTComponentManager ;
extern "C" ENTRYFUNC lpfnQTToolbox ;


// Local data
// ----------
static HINSTANCE hInstThisMod;
static HDWDISP CheckHardware;


// Local macros
// ------------
#define CURR_VERSION 1


// Component description
// ---------------------
ComponentDescription cdTable[] =
  { QTFOURCC ('v','h','d','w')
  , QTFOURCC ('s','0','0','2')
  , QTFOURCC ('a','p','p','l')
  , 0
  , 0
  , (ComponentRoutine) VHDWEntry
  , 0
  , 0
  , 0
  };


// Function cfCanDoSelect: Report if a function is implemented
// -----------------------------------------------------------
extern "C" ComponentResult QTAPI cfCanDoSelect (STKOFF_CMP so, LONG lFunctionSelector) {

    // Switch on function selector
    switch (lFunctionSelector) {
        case kComponentOpenSelect:
        case kComponentCloseSelect:
        case kComponentCanDoSelect:
        case kComponentVersionSelect:
        case kComponentRegisterSelect:
        case kComponentTargetSelect:
        case kSniffVideoHardware:
            return TRUE;
        default:
            return FALSE;
    }
}


// Function cfCloseSelect: Close an open component instance
// --------------------------------------------------------
extern "C" ComponentResult QTAPI cfCloseSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Close component free any allocated storage

    // Successful return
    return noErr;
}


// Function cfOpenSelect: Open a component instance
// ------------------------------------------------
extern "C" ComponentResult QTAPI cfOpenSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Allocate and register private storage

    // Successful return
    return noErr;
}


// Function RegisterSelect: Return 0 as there is nothing to check before registering
// ---------------------------------------------------------------------------------
extern "C" ComponentResult QTAPI cfRegisterSelect (STKOFF_CMP so, ComponentInstance ci) {

    return 0;
}


// Function SniffVideoHardware
// ---------------------------
extern "C" HDWDISP QTAPI cfSniffVideoHardware (STKOFF_CMP so, ComponentInstance ci,
                                                BMP_TYPE bmpt, LPSTR lpszCompID, LPSTR lpszHdwID) {

    LPSTR lpszPixels;

    // Identify component
    lstrcpy (lpszCompID, "Sample P9000 VHDW Component");

    // Filter out BMP types not supported by our custom routines
    switch (bmpt)  {
        case BMP_INDEX_8  : lpszPixels = "8-bit palettized"   ; break;
        case BMP_5_5_5    : lpszPixels = "16-bit 555"         ; break;
        case BMP_5_6_5    : lpszPixels = "16-bit 565"         ; break;
        case BMP_5_6_5_M  : lpszPixels = "16-bit 565 Motorola"; break;
        case BMP_8_8_8_RGB: lpszPixels = "24-bit RGB"         ; break;
        case BMP_8_8_8_BGR: lpszPixels = "24-bit BGR"         ; break;
            break;
    default :
        return 0;
    }

    // Weitek P9000
    // Typical cards:  Diamond Viper
    CheckHardware = (HDWDISP) DispatchP9000;
    if (CheckHardware (VDSP_IDENTIFY) != 0 && CheckHardware (VDSP_VERSION) == CURR_VERSION) {
        wsprintf (lpszHdwID, "%s pixels; P9000 internal hardware support", lpszPixels);
        return CheckHardware;
    }

    // The adapter hardware is not supported
    CheckHardware = 0;
    return 0;
}


/// Function TargetSelect: Not implemented
// ---------------------------------------
extern "C" ComponentResult QTAPI cfTargetSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Successful return
    return noErr;
}


// Function cfVersionSelect: Return the version of this component
// ----------------------------------------------------------------
extern "C" ComponentResult QTAPI cfVersionSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Return an arbitrary non-zero version to the user
    return CheckHardware != NULL? CheckHardware (VDSP_VERSION) : CURR_VERSION;
}


// Function FixupCM: Establish direct linkage to Component Manager
// ---------------------------------------------------------------
static VOID FAR PASCAL FixupCM (ENTRYFUNC lpfnCM) {

    lpfnQTComponentManager = lpfnCM;
}


// Function FixupTB: Establish direct linkage to Movie Toolbox
// -----------------------------------------------------------
static VOID FAR PASCAL FixupTB (ENTRYFUNC lpfnTB) {

    lpfnQTToolbox = lpfnTB;
}


// Function GetInstOfThisMod: Get the instance handle of this module
// -----------------------------------------------------------------
static HINSTANCE GetInstOfThisMod () {

    return hInstThisMod;
}


// Function IdentifyP9000: Identify P9000
// --------------------------------------
extern "C" BOOL FAR PASCAL IdentifyP9000 (PP9000 pp9) {

    // Determine name of P9000 INI file
    static char szINI[256], szTemp[256], FAR *p;
    p = GetDOSEnvironment();
    while (*p != 0) {
        lstrcpy (szTemp, p);
        AnsiUpper (szTemp);
        if (_fmemcmp (szTemp, "VIPERPATH=", 10) == 0) {
            lstrcpy (szINI, szTemp + 10);
            if (szINI[lstrlen (szINI) - 1] == ';')
                szINI[lstrlen (szINI) - 1] = 0;
            if (szINI[lstrlen (szINI) - 1] != '\\')
                lstrcat (szINI, "\\");
            break;
        }
        else p += lstrlen (p) + 1;
    }
    if (*p == 0)
        lstrcpy (szINI, "c:\\viper\\");
    lstrcat (szINI, "viper.ini");

    // Determine base physical address
    static char szBuffer[8], *q;
    GetPrivateProfileString ("hardware", "memaddr", "0", szBuffer, sizeof szBuffer, szINI);
    static DWORD dwMem = strtoul (szBuffer, &q, 16);
    if (dwMem == 0)
        return FALSE;
    else pp9->dwPhysical = (dwMem << 16) + 0x200000L;

    // Determine memory size
    static WORD wSize = GetPrivateProfileInt ("hardware", "memsize", 0, szINI);
    if (wSize == 0)
        return FALSE;
    else pp9->dwMemory = (DWORD) wSize * 0x100000L;

    // Determine scan line width
    static HDC hDC = GetDC (NULL);
    static int iDepth = GetDeviceCaps (hDC, BITSPIXEL) * GetDeviceCaps (hDC, PLANES);
    static int iWidth = GetDeviceCaps (hDC, HORZRES);
    ReleaseDC (NULL, hDC);
    pp9->wScanLineWidth = (iDepth * iWidth) >> 3;

    // Return OK
    return TRUE;

}


// Function LibMain: DLL Initialization
// ------------------------------------
int FAR PASCAL LibMain (HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine) {

    // Perform common initialization
    if (wHeapSize > 0)
        UnlockData(0);
    hInstThisMod = hInstance;

    // Successful return
    return 1;
}


// Function THNGIDENTIFY: Entry point called by Component Manager; the function fills the Component ID structure
// -------------------------------------------------------------------------------------------------------------
extern "C" OSType FAR PASCAL THNGIDENTIFY (LPCID FAR *lplpcid) {

    // Allocate memory for CID information; the memory will be freed by the Component Manager
    LPCID lpcid =  (LPCID) GlobalAllocPtr (GHND, sizeof CID);
    if (lpcid == 0)
        return 0;

    // Fill the structure
    lpcid->lVersion = CID_VERSION;
    lpcid->sComponentCount = 1;
    lpcid->lpcdTable =  (LPCD) &cdTable;
    lpcid->lpfnTBFixup = FixupTB;
    lpcid->lpfnCMFixup = FixupCM;
    *lplpcid = lpcid;

    // Return to caller
    return THING;
}


// Function WEP: Windows DLL exit procedure
// ----------------------------------------
#pragma check_stack( off)
extern "C" BOOL FAR PASCAL WEP (int nExitType) {

    // Clean up as requried by the adapter
    if (CheckHardware != 0)
        CheckHardware (VDSP_TERMINATE) ;

    // successful return
    return TRUE ;
}
#pragma check_stack()
