; ---------------------------------------------------------------------
;
; P9000.ASM     Sample VHDW Component for P9000 chips
;
;               Version 1.0
;
;               (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------

        INCLUDE QTMACROS.INC
        INCLUDE P9000.INC


; Data Segment
; ------------
DGROUP  GROUP   _DATA
_DATA   SEGMENT PARA PUBLIC 'DATA'
LinBase LABEL   DWORD            ; Linear address...
LinLow  WORD    ?                ; ...low
LinHigh WORD    ?                ; ...high
SelBase DWORD   0                ; Current selector base
Selector WORD   0                ; Selector for linear addressing
p9      P9000   {0,0}            ; P9000 Interface
_DATA   ENDS


; Code Segment
; ------------
CODESEG SEGMENT PARA USE16 PUBLIC 'CODE'
        OPTION  LANGUAGE:C
        .386
        ASSUME  DS:DGROUP
        EXTERN  PASCAL ALLOCSELECTOR:FAR
        EXTERN  PASCAL FREESELECTOR:FAR
        EXTERN  PASCAL SETSELECTORBASE:FAR
        EXTERN  PASCAL SETSELECTORLIMIT:FAR
        EXTERN  PASCAL IdentifyP9000:FAR


; --------------------------------------------------------
; Function PhysToLin: Convert a physical address to a linear address
;
; The physical address must be above 1 MB.  To use the linear
; address, the caller must assign it to a selector.
; --------------------------------------------------------
        ALIGN   16
PhysToLin PROC  USES ESI EDI, Physical:DWORD, ByteSize:DWORD

; Get the physical address in BX:CX and the size in SI:DI
        MOV     ECX, Physical
        SHLD    EBX, ECX, 16
        MOV     EDI, ByteSize
        SHLD    ESI, EDI, 16

; Call DPMI
        MOV     AX, 0800H
        INT     31H
        JC      Error
        MOV     DX, BX
        MOV     AX, CX
Exit:   RET

; Handle DPMI error
Error:  XOR     DX, DX
        XOR     AX, AX
        JMP     Exit

; All done!
PhysToLin ENDP


; --------------------------------------------------------
; Function FreeLinear: Free a linear address allocated
; by PhysToLin
; --------------------------------------------------------
        ALIGN   16
FreeLinear PROC  Linear:DWORD
        MOV     ECX, Linear
        SHLD    EBX, ECX, 16
        MOV     AX, 0801H
        INT     31H
        RET
FreeLinear ENDP


; --------------------------------------------------------
; Function DispatchP9000: Dispatch the hardware functions
; --------------------------------------------------------
DispatchP9000 PROC FAR

; Establish stack addressability; get dispatch code
        PUSH    BP
        MOV     BP, SP
        XCHG    [BP+6], AX
        POP     BP

; Jump on disptach code
        CMP     AX, VDSP_SETBANK
        JE      SetBank
        CMP     AX, VDSP_SLIDEWINDOW
        JE      SlideWind
        CMP     AX, VDSP_SAVECONTEXT
        JE      SaveBank
        CMP     AX, VDSP_RESTCONTEXT
        JE      RestBank
        CMP     AX, VDSP_SETTARGET
        JE      SetTarget
        CMP     AX, VDSP_READWRITE
        JE      ReadWrite
        CMP     AX, VDSP_IDENTIFY
        JE      Identify
        CMP     AX, VDSP_VERSION
        JE      GetVersion
        CMP     AX, VDSP_BANKTABLE
        JE      BankTable
        CMP     AX, VDSP_BITBLTTYPE
        JE      BitBltType
        CMP     AX, VDSP_SCANWIDTH
        JE      ScanWidth
        CMP     AX, VDSP_TERMINATE
        JE      Terminate

; All done!
        MOV     AX, [BP+6]
        RET
DispatchP9000 ENDP



        OPTION  PROC:PRIVATE ; Functions below are local
; --------------------------------------------------------
; Function BankTable: Decide if we need to use a bank split table
;
; Typically, adapters that use non-overlapped banks require a split table.
; Adapters that use either linear addressing or sliding banks do not use a
; split table, as the SplitWindow function ensures no scan lines are
; written across a bank boundary.
;
; Returns:  AX = TRUE or FALSE
; --------------------------------------------------------
        ALIGN   16
BankTable PROC  FAR SaveAX:WORD
        XOR     AX, AX
        RET
BankTable ENDP


; --------------------------------------------------------
; Function BitBltType: Decide whose BitBlt to use
;
; Returns:  AX = the type
; --------------------------------------------------------
        ALIGN   16
BitBltType PROC FAR SaveAX:WORD
        MOV     AX, BBL_DRVR
        RET
BitBltType ENDP


; --------------------------------------------------------
; Function GetVersion: return the version of our code
;
; Returns:  AX = the version
; --------------------------------------------------------
        ALIGN   16
GetVersion PROC FAR SaveAX:WORD
        MOV     AX, 1
        RET
GetVersion ENDP


; --------------------------------------------------------
; Function Identify: Determine if this hardware routine
; matches the current adapter and driver
;
; Returns:  AX = TRUE   hardware matches
;                FALSE  hardware does not match
; --------------------------------------------------------
Identify PROC   FAR USES ES SI DI

; Call our C routine to identify the P9000. We've coded it in C
; (see P9000V.CPP) because it would be a major pain to code
; in assembler.
        PUSH    DS
        PUSH    OFFSET p9
        CALL    IdentifyP9000
        TEST    AX, AX
        JZ      NoMatch

; Convert the physical address to a linear address
        PUSH    p9.dwMemory
        PUSH    p9.dwPhysical
        CALL    PhysToLin
        ADD     SP, 8
        MOV     LinLow, AX
        MOV     LinHigh, DX
        CMP     LinBase, 0
        JE      NoMatch

; Allocate a selector
        PUSH    DS
        CALL    ALLOCSELECTOR
        TEST    AX, AX
        JZ      NoMatch
        MOV     Selector, AX
        PUSH    Selector
        PUSH    LinBase
        CALL    SETSELECTORBASE
        PUSH    Selector
        PUSH    0
        PUSH    -1
        CALL    SETSELECTORLIMIT

; Found it!
Exit:   MOV     AX, 1
        RET

; Ooops! wrong chip...
NoMatch:MOV     AX, 0
        RET

; All done!
Identify ENDP


; --------------------------------------------------------
; Function RestBank: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
RestBank PROC   FAR USES DS, SaveAX:WORD, ShowCursor:WORD
        PUSH    DGROUP
        POP     DS
        RET
RestBank ENDP


; --------------------------------------------------------
; Function ReadWrite: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
ReadWrite PROC  FAR SaveAX:WORD
        MOV     AX, SaveAX
        RET
ReadWrite ENDP


; --------------------------------------------------------
; Function SaveBank: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
SaveBank PROC   FAR USES DS, SaveAX:WORD, HideCursor:WORD
        PUSH    DGROUP
        POP     DS
        RET
SaveBank ENDP


; --------------------------------------------------------
; Function ScanWidth: Get the scan width, also known as
; the pixel pitch
;
; Returns:  AX = Scan width
; --------------------------------------------------------
        ALIGN   16
ScanWidth PROC  FAR USES DS, SaveAX:WORD
        PUSH    DGROUP
        POP     DS
        MOV     AX, p9.wScanLineWidth
        RET
ScanWidth ENDP


; --------------------------------------------------------
; Function SetBank: Set the ET4000 bank register
; --------------------------------------------------------
        ALIGN   16
SetBank PROC    FAR USES DX, SaveAX:WORD, BankID:WORD
        PUSH    DGROUP
        POP     DS
        RET
SetBank ENDP


; --------------------------------------------------------
; Function SetTarget:
; Initialize the bank and ES:DI from an offset in
; the frame buffer
;
; Returns:  AX     = 0
;           ES:DI  = 16:16 pointer in frame buffer
; --------------------------------------------------------
        ALIGN   16
SetTarget PROC  FAR USES DS, SaveAX:WORD, Offst:DWORD

; Establish data area addressability
        PUSH    DGROUP
        POP     DS

; Add offset to selector base and allocate a new selector
        MOV     EAX, Offst
        ADD     EAX, LinBase
        MOV     SelBase, EAX
        PUSH    Selector
        PUSH    eax
        CALL    SETSELECTORBASE

; Return ES:DI to the caller
        MOV     ES, Selector
        XOR     DI, DI
        RET
SetTarget ENDP

; --------------------------------------------------------
; Function SlideWind:
; Adjust the selector base to keep the offset under 64 KB
;
; Entry:  ES:DI = current target pointer
;
; Returns:  DI may be updated
;           ES may have a new selector base
; --------------------------------------------------------
        ALIGN   16
SlideWind PROC  FAR SaveAX:WORD, BankID:WORD

; Only process if offset >= 48kb
        CMP     DI, 0C000H
        JB      NoChg

; Establish data area addressability
        PUSH    DS
        PUSH    EDI
        PUSH    DGROUP
        POP     DS

; Compute new base address and allocate a new selector
        MOVZX   EDI, DI
        ADD     EDI, SelBase
        MOV     SelBase, EDI
        PUSH    ES
        PUSH    EDI
        CALL    SETSELECTORBASE

; Return ES:DI to the caller
        MOV     ES, Selector
        POP     EDI
        XOR     DI, DI
        POP     DS

; All done!
NoChg:  RET
SlideWind ENDP


; --------------------------------------------------------
; Function Terminate: Deallocate the linear address selector
; --------------------------------------------------------
        ALIGN   16
Terminate PROC  FAR SaveAX:WORD
        MOV     AX, Selector
        TEST    AX, AX
        JZ      Done
        PUSH    ax
        CALL    FREESELECTOR
        PUSH    LinBase
        CALL    FreeLinear
        ADD     SP, 4
Done:   RET
Terminate ENDP



CODESEG ENDS
         END

