
// ---------------------------------------------------------------------
//
// FRONTROW.C   - QuickTime for Windows
//
//                Version 1.0
//
//                (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <commdlg.h>
#include <qtw.h>
#include <dos.h>
#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h> 
#include "fileexts.rh"

long FAR PASCAL __export WndProc (HWND, UINT, WPARAM, LPARAM);

static MovieFile mfMovie;
static Movie mMovie;
static MovieController mcController;
static HWND hWnd;
static char szAppName[] = "FRONTROW";


// WinMain
// ---------------------------------------------------------------------
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdParam, int nCmdShow)
{
    MSG msg;
    WNDCLASS wndclass;
    char szDir[_MAX_DIR];
    char szMovieTitle[_MAX_PATH];
    char szMovie[_MAX_PATH];
    char szFilter[_MAX_PATH];
    OPENFILENAME ofn;
    RECT rcClient, rcMovie;
    LONG lStyle;
    struct _stat st;
    char* p;

    // If parameter is missing, look for a movie with the same name
    // as the executable. If this isn't found, use the standard
    // open dialog to get a movie name

    if (lstrlen (lpszCmdParam) == 0) {
        GetModuleFileName (hInstance, szMovie, sizeof (szMovie));
        p = strrchr (szMovie, '.');
        strcpy (p, ".MOV");
        if (_stat (szMovie, &st)) {
            _getcwd (szDir, sizeof (szDir));
            szMovie[0] = '\0';
            memset (&ofn, 0, sizeof(OPENFILENAME));
            ofn.lStructSize = sizeof(OPENFILENAME);
            ofn.hwndOwner = 0;
            ofn.lpstrFilter = CommonGetFileFilter (hInstance, (WORD) COMMON_MOVIES_FILEEXT, szFilter, sizeof szFilter);
            ofn.nFilterIndex = 1;
            ofn.lpstrFile = szMovie;
            ofn.nMaxFile = sizeof(szMovie);
            ofn.lpstrFileTitle = szMovieTitle;
            ofn.nMaxFileTitle = sizeof(szMovieTitle);
            ofn.lpstrInitialDir = szDir;
            ofn.lpstrTitle = "Select a Movie to Watch";
            ofn.Flags = OFN_HIDEREADONLY;
            if (GetOpenFileName (&ofn) == 0)
                return 0;
        }
        _strupr (szMovie);
    }

    // Otherwise, treat the command line parameter as the
    // root directory.

    else {
        lstrcpy (szMovie, lpszCmdParam);
        _strupr (szMovie);
    }

    // Establish links to QuickTime for Windows

    if (QTInitialize (NULL)) {
        MessageBox (NULL, "QTInitialize failure", szAppName, MB_OK);
        return 0;
    }

    // Allocate memory required for playing movies

    if (EnterMovies ()) {
        MessageBox (NULL, "EnterMovies failure", szAppName, MB_OK);
        return 0;
    }

    // Instantiate movie

    if (OpenMovieFile (szMovie, &mfMovie, OF_READ) != noErr) {
        MessageBox (NULL, "OpenMovieFile failure", szAppName, MB_OK);
        PostQuitMessage (0);
        return 0;
    }

    NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
    CloseMovieFile (mfMovie);

    // Register and create main window

    if (!hPrevInstance) {
        wndclass.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon (NULL,IDI_APPLICATION);
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground = (HBRUSH) GetStockObject (BLACK_BRUSH);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;
        if (!RegisterClass (&wndclass)) {
            MessageBox (NULL, "RegisterClass failure", szAppName, MB_OK);
            return 0;
        }
    }

    hWnd = CreateWindow(szAppName, szAppName,
        WS_POPUP, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

    if (hWnd == NULL) {
        MessageBox (NULL, "CreateWindow failure", szAppName, MB_OK);
        return 0;
    }

    // Instantiate the movie controller

    GetMovieBox (mMovie, &rcMovie);
    GetClientRect (GetDesktopWindow (), &rcClient);
    OffsetRect (&rcMovie, -rcMovie.left, -rcMovie.top);
    rcMovie.right *= 2, rcMovie.bottom *= 2;
    OffsetRect (&rcMovie, (rcClient.right - rcMovie.right) / 2,
      (rcClient.bottom - rcMovie.bottom) / 2);
    mcController = NewMovieController (mMovie, &rcMovie,
        mcTopLeftMovie + mcScaleMovieToFit + mcNotVisible, hWnd);

    // Make the main window visible

    lStyle = GetWindowLong (hWnd, GWL_STYLE);
    lStyle &= ~(WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_BORDER | WS_THICKFRAME | WS_DLGFRAME);
    SetWindowLong (hWnd, GWL_STYLE, lStyle);
    ShowWindow (hWnd, SW_SHOWMAXIMIZED);
    UpdateWindow (hWnd);
    SetMovieActive (mMovie, TRUE);
    InvalidateRect (hWnd, &rcMovie, FALSE);
    MCDoAction (mcController, mcActionSetFlags, (LPVOID) mcFlagsUseWindowPalette);
    MCDoAction (mcController, mcActionSetKeysEnabled, (LPVOID) TRUE);

    // Play the movie

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    // Destroy movie controller

    DisposeMovieController (mcController);

    // Destroy movie

    DisposeMovie (mMovie);

    // Cut the connections to QuickTime for Windows

    ExitMovies ();
    QTTerminate ();

    // Return to Windows

    return msg.wParam;
}


// WndProc
// ---------------------------------------------------------------------
long FAR PASCAL __export WndProc (HWND hWnd, UINT message, WPARAM wParam,
   LPARAM lParam)
{
    PAINTSTRUCT ps;

    // Drive the movie controller

    MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam);

    // Process the windows message

    switch (message) {

        // In case we have to paint this movie

        case WM_PAINT:
            if (!BeginPaint (hWnd, &ps))
                return 0;
            EndPaint (hWnd, &ps);
            return 0;

        // All done!

        case WM_DESTROY:
            PostQuitMessage (0);
            return 0;

    }

    // Return to Windows

    return DefWindowProc (hWnd, message, wParam, lParam);
}
