
// ---------------------------------------------------------------------
//
// Filters.c - Sample QuickTime for Windows Application
//
//             (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <qtw.h>

long FAR PASCAL __export WndProc  (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK __export TestFilter (MovieController, UINT,
   LPVOID, LONG);

MovieController mcController;
RECT rcNorm;
short sMCHeight;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdParam, int nCmdShow)
   {
   static char szAppName[] = "Filters";
   HWND        hWnd;
   MSG         msg;
   WNDCLASS    wndclass;
   MovieFile   mfMovie;
   RECT        rcMovie;
   Movie       mMovie;

// Establish links to QuickTime for Windows

   if (QTInitialize (NULL))
      {
      MessageBox (NULL, "QTInitialize failure", szAppName, MB_OK);
      return 0;
      }

// Allocate memory required for playing movies

   if (EnterMovies ())
      {
      MessageBox (NULL, "EnterMovies failure", szAppName, MB_OK);
      return 0;
      }

// Register and create main window

   if (!hPrevInstance)
      {
      wndclass.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WndProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon (NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;

      if (!RegisterClass (&wndclass))
         {
         MessageBox (NULL, "RegisterClass failure", szAppName, MB_OK);
         return 0;
         }
      }

   hWnd = CreateWindow(szAppName, szAppName, WS_OVERLAPPEDWINDOW |
      WS_CLIPCHILDREN, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

   if (hWnd == NULL)
      {
      MessageBox (NULL, "CreateWindow failure", szAppName, MB_OK);
      return 0;
      }

// Instantiate the movie

   if (OpenMovieFile ("SAMPLE.MOV", &mfMovie, OF_READ) != noErr)
      {
      MessageBox (NULL, "OpenMovieFile failure", szAppName, MB_OK);
      return 0;
      }

   NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
   CloseMovieFile (mfMovie);

// Get the normal movie dimensions. We'll use these as the
// movie aspect ratio in the filter

   GetMovieBox (mMovie, &rcNorm);
   OffsetRect (&rcNorm, -rcNorm.left, -rcNorm.top);

// Build the movie rectangle

   GetClientRect (hWnd, &rcMovie);
   rcMovie.top = (rcMovie.bottom / 3) - (rcNorm.bottom / 2);
   rcMovie.bottom = rcMovie.top + rcNorm.bottom;
   rcMovie.left = (rcMovie.right / 3) - (rcNorm.right / 2);
   rcMovie.right = rcMovie.left + rcNorm.right;

// Instantiate the movie controller

   mcController = NewMovieController (mMovie, &rcMovie,
      mcTopLeftMovie + mcScaleMovieToFit + mcWithBadge, hWnd);

// Make the movie paused initially

   MCDoAction (mcController, mcActionPlay, 0);

// Calculate the controller height for use in filter

   MCGetControllerBoundsRect (mcController, &rcMovie);
   OffsetRect (&rcMovie, -rcMovie.left, -rcMovie.top);
   sMCHeight = rcMovie.bottom - rcNorm.bottom;

// Set an action filter, passing in the parent window handle

   MCSetActionFilter (mcController, TestFilter, (LONG) ((LPVOID) hWnd));

// Enable the keyboard interface

   MCDoAction (mcController, mcActionSetKeysEnabled, (LPVOID) TRUE);

// Make the movie active

   SetMovieActive (mMovie, TRUE);

// Make the movie visible

   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

// Play the movie

   while (GetMessage (&msg, NULL, 0, 0))
      {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
      }

// Destroy the movie controller

   DisposeMovieController (mcController);

// Destroy the movie

   DisposeMovie (mMovie);

// Cut the connections to QuickTime for Windows

   ExitMovies ();
   QTTerminate ();

// Return to Windows

   return msg.wParam;
   }


long FAR PASCAL WndProc (HWND hWnd, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
   PAINTSTRUCT ps;

// Drive the movie controller

   if (MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam))
      return 0;

// Process the windows message

   switch (message)
      {
      case WM_PAINT:

         if (!BeginPaint (hWnd, &ps))
            return 0;
         EndPaint (hWnd, &ps);
         return 0;

      case WM_DESTROY:

         PostQuitMessage (0);
         return 0;
      }

// Return to Windows

   return DefWindowProc (hWnd, message, wParam, lParam);
   }


BOOL CALLBACK __export TestFilter (MovieController mcCaller,
   UINT uAction, LPVOID lpParam, LONG refcon)
   {
   RECT rcBounds;
   static BOOL bBlock;

// Don't want to recursively call ourselves

   if (bBlock)
      return FALSE;

// Respond to mcAction

   switch (uAction)
      {
      case mcActionControllerSizeChanged:

      // Force a paint of the old client rectangle

         InvalidateRect ((HWND) refcon, NULL, TRUE);

         MCGetControllerBoundsRect (mcCaller, &rcBounds);

      // Calculate new bounds rect bottom

         rcBounds.bottom =
            rcBounds.top + MulDiv (rcBounds.right - rcBounds.left,
               rcNorm.bottom, rcNorm.right);

      // Add the controller height back in

         rcBounds.bottom += sMCHeight;

         bBlock = TRUE;
         MCSetControllerBoundsRect (mcCaller, &rcBounds);
         bBlock = FALSE;

         return TRUE;

      default:

         return FALSE;
      }
   }

