// ---------------------------------------------------------------------
//
// ET4000V.CPP   Sample VHDW Component for ET4000 chips
//
//               Version 1.0
//
//               (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Windows header files
// --------------------
#include <windows.h>
#include <windowsx.h>


// Compiler header files
// ---------------------
#include <stdlib.h>


// QuickTime header files
// ----------------------
#include <qtcodec.h>
#include <qtvhdw.h>


// Assembler functions
// -------------------
extern "C" {
    DWORD QTAPI VHDWEntry (VOID);
    WORD FAR CDECL DispatchET4000 ();
}


// Local functions
// ---------------
static VOID FAR PASCAL FixupCM (ENTRYFUNC lpfnCM);
static VOID FAR PASCAL FixupTB (ENTRYFUNC lpfnTB);
static HINSTANCE GetInstOfThisMod ();


// Global data
// -----------
extern "C" ENTRYFUNC lpfnQTComponentManager ;
extern "C" ENTRYFUNC lpfnQTToolbox ;


// Local data
// ----------
static HINSTANCE hInstThisMod;
static HDWDISP CheckHardware;


// Local macros
// ------------
#define CURR_VERSION 1


// Component description
// ---------------------
ComponentDescription cdTable[] =
  { QTFOURCC ('v','h','d','w')
  , QTFOURCC ('s','0','0','1')
  , QTFOURCC ('a','p','p','l')
  , 0
  , 0
  , (ComponentRoutine) VHDWEntry
  , 0
  , 0
  , 0
  };


// Function cfCanDoSelect: Report if a function is implemented
// -----------------------------------------------------------
extern "C" ComponentResult QTAPI cfCanDoSelect (STKOFF_CMP so, LONG lFunctionSelector) {

    // Switch on function selector
    switch (lFunctionSelector) {
        case kComponentOpenSelect:
        case kComponentCloseSelect:
        case kComponentCanDoSelect:
        case kComponentVersionSelect:
        case kComponentRegisterSelect:
        case kComponentTargetSelect:
        case kSniffVideoHardware:
            return TRUE;
        default:
            return FALSE;
    }
}


// Function cfCloseSelect: Close an open component instance
// --------------------------------------------------------
extern "C" ComponentResult QTAPI cfCloseSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Close component free any allocated storage

    // Successful return
    return noErr;
}


// Function cfOpenSelect: Open a component instance
// ------------------------------------------------
extern "C" ComponentResult QTAPI cfOpenSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Allocate and register private storage

    // Successful return
    return noErr;
}


// Function RegisterSelect: Return 0 as there is nothing to check before registering
// ---------------------------------------------------------------------------------
extern "C" ComponentResult QTAPI cfRegisterSelect (STKOFF_CMP so, ComponentInstance ci) {

    return 0;
}


// Function SniffVideoHardware
// ---------------------------
extern "C" HDWDISP QTAPI cfSniffVideoHardware (STKOFF_CMP so, ComponentInstance ci,
                                                BMP_TYPE bmpt, LPSTR lpszCompID, LPSTR lpszHdwID) {

    LPSTR lpszPixels;

    // Identify component
    lstrcpy (lpszCompID, "Sample ET4000 VHDW Component");

    // Filter out BMP types not supported by our custom routines
    switch (bmpt)  {
        case BMP_INDEX_8  : lpszPixels = "8-bit palettized"   ; break;
        case BMP_5_5_5    : lpszPixels = "16-bit 555"         ; break;
        case BMP_5_6_5    : lpszPixels = "16-bit 565"         ; break;
        case BMP_5_6_5_M  : lpszPixels = "16-bit 565 Motorola"; break;
        case BMP_8_8_8_RGB: lpszPixels = "24-bit RGB"         ; break;
        case BMP_8_8_8_BGR: lpszPixels = "24-bit BGR"         ; break;
            break;
    default :
        return 0;
    }

    // Tseng ET4000
    // Typical cards:  Orchid ProDesigner IIs, Diamond SpeedStar 24
    CheckHardware = (HDWDISP) DispatchET4000;
    if (CheckHardware (VDSP_IDENTIFY) != 0 && CheckHardware (VDSP_VERSION) == CURR_VERSION) {
        wsprintf (lpszHdwID, "%s pixels; ET4000 internal hardware support", lpszPixels);
        return CheckHardware;
    }

    // The adapter hardware is not supported
    CheckHardware = 0;
    return 0;
}


/// Function TargetSelect: Not implemented
// ---------------------------------------
extern "C" ComponentResult QTAPI cfTargetSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Successful return
    return noErr;
}


// Function cfVersionSelect: Return the version of this component
// ----------------------------------------------------------------
extern "C" ComponentResult QTAPI cfVersionSelect (STKOFF_CMP so, ComponentInstance ci) {

    // Return an arbitrary non-zero version to the user
    return CheckHardware != NULL? CheckHardware (VDSP_VERSION) : CURR_VERSION;
}


// Function FixupCM: Establish direct linkage to Component Manager
// ---------------------------------------------------------------
static VOID FAR PASCAL FixupCM (ENTRYFUNC lpfnCM) {

    lpfnQTComponentManager = lpfnCM;
}


// Function FixupTB: Establish direct linkage to Movie Toolbox
// -----------------------------------------------------------
static VOID FAR PASCAL FixupTB (ENTRYFUNC lpfnTB) {

    lpfnQTToolbox = lpfnTB;
}


// Function GetInstOfThisMod: Get the instance handle of this module
// -----------------------------------------------------------------
static HINSTANCE GetInstOfThisMod () {

    return hInstThisMod;
}


// Function LibMain: DLL Initialization
// ------------------------------------
int FAR PASCAL LibMain (HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine) {

    // Perform common initialization
    if (wHeapSize > 0)
        UnlockData(0);
    hInstThisMod = hInstance;

    // Successful return
    return 1;
}


// Function THNGIDENTIFY: Entry point called by Component Manager; the function fills the Component ID structure
// -------------------------------------------------------------------------------------------------------------
extern "C" OSType FAR PASCAL THNGIDENTIFY (LPCID FAR *lplpcid) {

    // Allocate memory for CID information; the memory will be freed by the Component Manager
    LPCID lpcid =  (LPCID) GlobalAllocPtr (GHND, sizeof CID);
    if (lpcid == 0)
        return 0;

    // Fill the structure
    lpcid->lVersion = CID_VERSION;
    lpcid->sComponentCount = 1;
    lpcid->lpcdTable =  (LPCD) &cdTable;
    lpcid->lpfnTBFixup = FixupTB;
    lpcid->lpfnCMFixup = FixupCM;
    *lplpcid = lpcid;

    // Return to caller
    return THING;
}


// Function WEP: Windows DLL exit procedure
// ----------------------------------------
#pragma check_stack( off)
extern "C" BOOL FAR PASCAL WEP (int nExitType) {

    // Clean up as requried by the adapter
    if (CheckHardware != 0)
        CheckHardware (VDSP_TERMINATE) ;

    // successful return
    return TRUE ;
}
#pragma check_stack()
