; ---------------------------------------------------------------------
;
; ET4000.ASM    Sample VHDW Component for ET4000 chips
;
;               Version 1.0
;
;               (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------

        INCLUDE QTMACROS.INC


; Data Segment. We'll use A000h (defined by Windows) to access the frame
; buffer and C000h (also defined by Windows) to access the BIOS.
; ----------------------------------------------------------------------
DGROUP  GROUP   _DATA
_DATA   SEGMENT WORD PUBLIC 'DATA'
        EXTERN  C _A000h:WORD
        EXTERN  C _C000h:WORD
BankSav BYTE    ?
EyeCtch BYTE    "Tseng", 0
_DATA   ENDS


; Text Segment. We'll use the C fstrstr function; to code in assembler
; would be a major pain and the performance hit is negligible.
; --------------------------------------------------------------------
_TEXT   SEGMENT WORD USE16 PUBLIC 'CODE'
        EXTERN  C _fstrstr:FAR
_TEXT   ENDS


; Code Segment
; ------------
CODESEG SEGMENT PARA USE16 PUBLIC 'CODE'
        OPTION  LANGUAGE:C
        .386
        ASSUME  DS:DGROUP
        EXTERN  PASCAL SHOWCURSOR:FAR


; --------------------------------------------------------
; Function ReadIndex: Read an indexed register
;
; Entry:  AL = Index
;         DX = Base address
; Exit:   Success  AH = value CY = 0
;         Failure  AH = 0     CY = 1
;         All other registers, including AL, are preserved
; --------------------------------------------------------
ReadIndex PROC  USES BX CX

; We'll retry an arbitrary number of times
        MOV     CX, 100
        MOV     AH, AL

; Read the indexed value into BL
Again:  MOV     AL, AH
        OUT     DX, AL
        INC     DX
        IN      AL, DX
        MOV     BL, AL

; Read the current index; did we read the right index?
        DEC     DX
        IN      AL, DX
        CMP     AL, AH
        JE      Success

; If not, retry; if retry count exhausted, return an error
        DEC     CX
        JG      Again
        MOV     AH, 0
        STC
        JMP     Exit

; We read the right index, so return success
Success:MOV     AH, BL
        CLC
Exit:   RET

; All done!
ReadIndex ENDP


; --------------------------------------------------------
; Function DispatchET4000: Dispatch the hardware functions
; --------------------------------------------------------
DispatchET4000 PROC FAR

; Establish stack addressability; get dispatch code
        PUSH    BP
        MOV     BP, SP
        XCHG    [BP+6], AX
        POP     BP

; Jump on disptach code
        CMP     AX, VDSP_SETBANK
        JE      SetBank
        CMP     AX, VDSP_SLIDEWINDOW
        JE      SlideWind
        CMP     AX, VDSP_SAVECONTEXT
        JE      SaveBank
        CMP     AX, VDSP_RESTCONTEXT
        JE      RestBank
        CMP     AX, VDSP_SETTARGET
        JE      SetTarget
        CMP     AX, VDSP_READWRITE
        JE      ReadWrite
        CMP     AX, VDSP_IDENTIFY
        JE      Identify
        CMP     AX, VDSP_VERSION
        JE      GetVersion
        CMP     AX, VDSP_BANKTABLE
        JE      BankTable
        CMP     AX, VDSP_BITBLTTYPE
        JE      BitBltType
        CMP     AX, VDSP_SCANWIDTH
        JE      ScanWidth
        CMP     AX, VDSP_TERMINATE
        JE      Terminate

; All done!
        MOV     AX, [BP+6]
        RET
DispatchET4000 ENDP



        OPTION  PROC:PRIVATE ; Functions below are local
; --------------------------------------------------------
; Function BankTable: Decide if we need to use a bank split table
;
; Typically, adapters that use non-overlapped banks require a split table.
; Adapters that use either linear addressing or sliding banks do not use a
; split table, as the SplitWindow function ensures no scan lines are
; written across a bank boundary.
;
; Returns:  AX = TRUE or FALSE
; --------------------------------------------------------
        ALIGN   16
BankTable PROC  FAR SaveAX:WORD
        MOV     AL, 1
        RET
BankTable ENDP


; --------------------------------------------------------
; Function BitBltType: Decide whose BitBlt to use
;
; Returns:  AX = the type
; --------------------------------------------------------
        ALIGN   16
BitBltType PROC FAR SaveAX:WORD
        MOV     AX, BBL_MOVSD
        RET
BitBltType ENDP


; --------------------------------------------------------
; Function GetVersion: return the version of our code
;
; Returns:  AX = the version
; --------------------------------------------------------
        ALIGN   16
GetVersion PROC FAR SaveAX:WORD
        MOV     AX, 1
        RET
GetVersion ENDP


; --------------------------------------------------------
; Function Identify: Determine if this hardware routine
; matches the current adapter and driver
;
; Returns:  AX = TRUE   hardware matches
;                FALSE  hardware does not match
; --------------------------------------------------------
        ALIGN   16
Identify PROC    FAR

; Search BIOS for Tseng identifier in the BIOS
        PUSH    DS
        PUSH    OFFSET EyeCtch
        LEA     AX, _C000h
        PUSH    AX
        PUSH    0
        CALL    _fstrstr
        ADD     SP, 8
        OR      AX, DX
        JE      NoMatch

; If it's some kind of Tseng, see if it's an ET400. See the ET4000
; reference manual for details on this code.
        MOV     DX, 3D4H
        MOV     AL, 33H
        CALL    ReadIndex
        JC      NoMatch
        MOV     BL, AH
        XOR     AH, 0FH
        OUT     DX, AX
        CALL    ReadIndex
        JC      NoMatch
        XOR     AH, 0FH
        MOV     BH, AH
        MOV     AH, BL
        OUT     DX, AX
        CMP     BL, BH
        JNE     NoMatch
        MOV     AL, 1

; Successful return
Exit:   RET

; Failure
NoMatch:XOR     AX, AX
        JMP     Exit
Identify ENDP


; --------------------------------------------------------
; Function RestBank: Restore the bank IDs
; --------------------------------------------------------
        ALIGN   16
RestBank PROC   FAR USES AX DX DS, SaveAX:WORD, ShowCursor:WORD

; Establish data area addressability
        PUSH    DGROUP
        POP     DS

; Should we show the cursor (which we hid in SaveBank)?
        CMP     ShowCursor, 0
        JE      NoShow
        PUSH    1
        CALL    SHOWCURSOR

; Restore the ET400 bank address register
NoShow: MOV     AL, BankSav
        MOV     DX, 3CDH
        OUT     DX, AL

; All done!
        RET
RestBank ENDP


; --------------------------------------------------------
; Function ReadWrite: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
ReadWrite PROC  FAR SaveAX:WORD
        MOV     AX, SaveAX
        RET
ReadWrite ENDP


; --------------------------------------------------------
; Function SaveBank: Get the bank IDs
;
; Returns:  AL = Combined IDs
; --------------------------------------------------------
        ALIGN   16
SaveBank PROC   FAR USES DX DS, SaveAX:WORD, HideCursor:WORD

; Establish data area addressability
        PUSH    DGROUP
        POP     DS

; Should we hide the cursor? We iterate until the cursor is really hidden
        CMP     HideCursor, 0
        JE      NoHide
LoopHideCursor:
        PUSH    0
        CALL    SHOWCURSOR
        INC     AX
        JG      LoopHideCursor

; Get the ET4000 bank register
NoHide: MOV     DX, 3CDH
        IN      AL, DX
        MOV     BankSav, AL

; All done!
        RET
SaveBank ENDP


; --------------------------------------------------------
; Function ScanWidth: Get the scan width, also known as
; the pixel pitch
;
; Returns:  AX = Scan width
; --------------------------------------------------------
        ALIGN   16
ScanWidth PROC  FAR SaveAX:WORD
        MOV     DX, 3D4H
        MOV     AL, 13H
        CALL    ReadIndex
        MOV     AL, 0
        SHR     AX, 5
        RET
ScanWidth ENDP


; --------------------------------------------------------
; Function SetBank: Set the ET4000 bank register
; --------------------------------------------------------
        ALIGN   16
SetBank PROC    FAR USES DX, SaveAX:WORD, BankID:WORD
        MOV     AX, BankID
        AND     AL, 0FH
        MOV     AH, AL
        SHL     AH, 4
        OR      AL, AH
        MOV     DX, 3CDH
        OUT     DX, AL
        MOV     AX, SaveAX
        RET
SetBank ENDP


; --------------------------------------------------------
; Function SetTarget: Initialize the bank and ES:DI from
; an offset in the frame buffer
;
; Returns:  AX    = Current bank ID (from SetBank)
;           ES:DI = 16:16 pointer in frame buffer
; --------------------------------------------------------
        ALIGN   16
SetTarget PROC  FAR SaveAX:WORD, OffsetLo:WORD, OffsetHi:WORD
        LEA     AX, _A000h
        MOV     ES, AX
        MOV     DI, OffsetLo
        MOV     AX, OffsetHi
        PUSH    AX
        PUSH    AX
        CALL    SetBank
        ADD     SP, 4
        RET
SetTarget ENDP


; --------------------------------------------------------
; Function SlideWind: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
SlideWind PROC   FAR SaveAX:WORD, BankID:WORD
        MOV     AX, BankID
        RET
SlideWind ENDP


; --------------------------------------------------------
; Function Terminate: dummy in this implementation
; --------------------------------------------------------
        ALIGN   16
Terminate PROC   FAR SaveAX:WORD
        MOV     AX, SaveAX
        RET
Terminate ENDP



CODESEG ENDS
        END
