; ---------------------------------------------------------------------
;
; DISPATCH.ASM  Sample VHDW Component dispatch
;
;               Version 1.0
;
;               (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------

        INCLUDE QTMACROS.INC

DGROUP  GROUP   _DATA
_DATA   SEGMENT PARA PUBLIC 'DATA'
_DATA   ENDS

CODESEG SEGMENT PARA USE16 PUBLIC 'CODE'
        OPTION  LANGUAGE:C
        .386
        ASSUME  DS:DGROUP


; Forward References
; ------------------
        EXTERN  C cfOpenSelect:NEAR
        EXTERN  C cfCloseSelect:NEAR
        EXTERN  C cfCanDoSelect:NEAR
        EXTERN  C cfVersionSelect:NEAR
        EXTERN  C cfRegisterSelect:NEAR
        EXTERN  C cfTargetSelect:NEAR
        EXTERN  C cfSniffVideoHardware:NEAR


; Vector Table for Required Selectors
; -----------------------------------
SelTab:
        DW      cfOpenSelect
        DW      cfCloseSelect
        DW      cfCanDoSelect
        DW      cfVersionSelect
        DW      cfRegisterSelect
        DW      cfTargetSelect


; ---------------------------------------------------------------------
; VHDW Component Entry Point
; ---------------------------------------------------------------------
VHDWEntry PROC  FAR

; Negative selectors represent entry points required by the component manager
; Other selectors are unique to this component
        TEST    BX, BX
        JL      ReqSel

; The only selector this component handles is kSniffVideoHardware
        MOV     AX, DGROUP
        MOV     DS, AX
        CMP     BX, kSniffVideoHardware
        JE      cfSniffVideoHardware

; 0x80008002 is the magic return code for a bad selector
        MOV     DX, 8000h
        MOV     AX, 8002h
        RET

; Handle the required negative selectors
ReqSel: NEG     BX
        DEC     BX
        ADD     BX, BX
        MOV     AX, DGROUP
        MOV     DS, AX
        JMP     WORD PTR cs:SelTab [BX]

; All done!
VHDWEntry ENDP
CODESEG ENDS
        END
