/*
********************************************************************************
**
** File: datahp.h
**
** Description:
**
**  Private header file for use with Quicktime Data Handler.
**
********************************************************************************
*/
#ifndef DATAHP_H
#define DATAHP_H

#include <mmsystem.h>

#include <qtw.h>
#include <compmgr.h>

#define INTERNAL_DHLR
#include "datah.h"

// Data types
typedef short * PSHORT ;
typedef short FAR * LPSHORT ;
typedef BOOL * PBOOL ;
typedef BOOL FAR * LPBOOL ;
#define HUGE _huge
typedef char HUGE * HPSTR ;
typedef unsigned char HUGE * HPBYTE ;
typedef void HUGE * HPVOID ;
typedef LONG HUGE * HPLONG ;
#define GlobalDeref(a) GlobalLock(a)

typedef struct _tagDataHInstanceStorage {
    ComponentInstance ci;
    HGLOBAL fileName;           // required for mmioOpen
    HMMIO mmioH;                // mmio handle to open file
    LONG lFlags;
    DWORD minFileOffset;
    DWORD maxFileOffset;
    LONG bytesPerSecond;
} DataHInstanceStorage, FAR *DataHInstanceStoragePtr;
    
typedef struct _tagDataHGlobalStorage {
    BOOL mmioInitialized;
} DataHGlobalStorage, FAR *DataHGlobalStoragePtr;


/* data handler version 1.0 */
#define kDataHVersion   0x00010000
#define mmioINVALID ((HMMIO)-1)
#define hfileINVALID ((HFILE)-1)

/* internal data handler function prototypes */
#ifdef __cplusplus
extern "C" {
#endif

ComponentResult QTAPI DataHCanDo( STKOFF_CMP so, LONG lFunctionSelector) ;
ComponentResult QTAPI DataHClose( STKOFF_CMP so, ComponentInstance ci) ;
ComponentResult QTAPI DataHOpen( STKOFF_CMP so, ComponentInstance ci) ;
ComponentResult QTAPI DataHVersion( STKOFF_CMP so, ComponentInstance ci) ;
DWORD QTAPI DataHEntry(VOID);
LPVOID QTAPI GetMemory( LONG lSize) ;
OSType FAR PASCAL THNGIDENTIFY( LPCID FAR *lplpcid) ;

#ifdef __cplusplus
}                                           // defined __cplusplus
#endif

#endif /* DATAHP_H */
