/*
********************************************************************************
**
** File: datah.h
**
** Description:
**
**  Public header file for use with the Apple Data Handler.
**
********************************************************************************
*/
#ifndef DATAH_H
#define DATAH_H

#include <qtw.h>
#include <compmgr.h>

/* 4-byte types */
#define ostypeDHLR QTFOURCC('d','h','l','r')
#define ostypeALIS QTFOURCC('a','l','i','s')
#define ostypeHNDL QTFOURCC('h','n','d','l')
#define kDataHExtendedSchedule QTFOURCC('x','t','n','d')

/* data types */
typedef long Fixed;
typedef BOOL Boolean;
typedef unsigned char Byte;
typedef Byte __far *Ptr;

/* error codes */
#define dataReadErr             -1
#define dataReadError           -1

typedef enum DataHUseFlagsRecord {
    kDataHCanRead               = 1L<<0,
    kDataHSpecialRead           = 1L<<1,
    kDataHSpecialReadFile       = 1L<<2,
    kDataHCanWrite              = 1L<<3,
    kDataHSpecialWrite          = 1L<<4,
    kDataHSpecialWriteFile      = 1L<<5,
    kDataHCanStreamingWrite     = 1L<<6,
    kDataHMustCheckDataRef      = 1L<<7
    } DataHUseFlags;

typedef struct DataHVolumeListRecord {
    short   vRefNum;
    long    flags;
    } DataHVolumeListRecord, far *DataHVolumeListPtr, far * far *DataHVolumeList;

typedef struct DataHScheduleRecord {
    TimeRecord  timeNeededBy;
    long        extendedID;
    long        extendedVers;
    Fixed       priority;
    } DataHScheduleRecord, far *DataHSchedulePtr;

typedef void (far *DHCompleteProc)(Ptr request, long refcon, OSErr err);
        
/* the selector ids for the data handler functions */
enum {

    /* these functions are common to all components */
    kDataUnregisterSelector             = -7,
    kDataTargetSelector                 = -6,
    kDataRegisterSelector               = -5,
    kDataVersionSelector                = -4,
    kDataCanDoSelector                  = -3,
    kDataCloseSelector                  = -2,
    kDataOpenSelector                   = -1,

    /* these functions are common to all DataHandler components */
    kDataGetDataSelector                = 2,
    kDataPutDataSelector                = 3,
    kDataFlushDataSelector              = 4,
    kDataOpenForWriteSelector           = 5,
    kDataCloseForWriteSelector          = 6,
    kDataOpenForReadSelector            = 8,
    kDataCloseForReadSelector           = 9,
    kDataSetDatRefSelector              = 10,
    kDataGetDataRefSelector             = 11,
    kDataCompareDataRefSelector         = 12,
    kDataTaskSelector                   = 13,
    kDataScheduleDataSelector           = 14,
    kDataFinishDataSelector             = 15,
    kDataFlushCacheSelector             = 16,
    kDataResolveDataRefSelector         = 17,
    kDataGetFileSizeSelector            = 18,
    kDataCanUseDataRefSelector          = 19,
    kDataGetVolumeListSelector          = 20,
    kDataWriteSelector                  = 21,
    kDataPreextendSelector              = 22,
    kDataSetFileSizeSelector            = 23,
    kDataGetFreeSpaceSelector           = 24,
    kDataCreateFileSelector             = 25,
    kDataGetPreferredBlockSizeSelector  = 26,
    kDataGetDeviceIndexSelector         = 27,
    /* 28 and 29 unused */
    kDataGetScheduleAheadTimeSelector   = 30,
        
    /* these functions are specific to the Apple Data Handler component */
    kDataPlaybackHintsSelector          = 0x100+3,
    
    kDataSetOSFileReferenceSelector     = 0x200+4,
    kDataGetOSFileReferenceSelector     = 0x200+5
    
};

/*
** this allows the same header file to be used for the dhlr and
** it's clients
*/
#ifdef INTERNAL_DHLR
  #define DHLR_FPARM1 STKOFF_CMP so, LPVOID instanceStorage,
  #define DHLR_FPARM2 STKOFF_CMP so, LPVOID instanceStorage
#else
  #define DHLR_FPARM1 ComponentInstance ci,
  #define DHLR_FPARM2 ComponentInstance ci
#endif

/* the data handler function prototypes */
#ifdef __cplusplus
extern "C" {
#endif

ComponentResult QTAPI DataHCanUseDataRef (DHLR_FPARM1
    Handle dataRef,
    DataHUseFlags far *useFlags);
ComponentResult QTAPI DataHGetVolumeList (DHLR_FPARM1
    DataHVolumeList far *volumeList);
ComponentResult QTAPI DataHGetDeviceIndex (DHLR_FPARM1
    long far *deviceIndex);
ComponentResult QTAPI DataHSetDataRef (DHLR_FPARM1
    Handle dataRef);
ComponentResult QTAPI DataHGetDataRef (DHLR_FPARM1
    Handle far *dataRef);
ComponentResult QTAPI DataHCompareDataRef (DHLR_FPARM1
    Handle dataRef,
    Boolean far *equal);
ComponentResult QTAPI DataHResolveDataRef (DHLR_FPARM1
    Handle theDataRef,
    Boolean far *wasChanged,
    Boolean userInterfaceAllowed);
ComponentResult QTAPI DataHOpenForRead (DHLR_FPARM2);
ComponentResult QTAPI DataHCloseForRead (DHLR_FPARM2);
ComponentResult QTAPI DataHOpenForWrite (DHLR_FPARM2);
ComponentResult QTAPI DataHCloseForWrite (DHLR_FPARM2);
ComponentResult QTAPI DataHGetData (DHLR_FPARM1
    Handle h,
    long hOffset,
    long offset,
    long size);
ComponentResult QTAPI DataHPutData (DHLR_FPARM1
    Handle h,
    long hOffset,
    long far *offset,
    long size);
ComponentResult QTAPI DataHScheduleData (DHLR_FPARM1
    Ptr placeToPutDataPtr,
    long fileOffset,
    long dataSize,
    long refCon,
    DataHSchedulePtr scheduleRec,
    DHCompleteProc completionRtn);
ComponentResult QTAPI DataHFinishData (DHLR_FPARM1
    Ptr placeToPutDataPtr,
    Boolean cancel );
ComponentResult QTAPI DataHTask (DHLR_FPARM2);
ComponentResult QTAPI DataHFlushCache (DHLR_FPARM2);
ComponentResult QTAPI DataHFlushData (DHLR_FPARM2);
ComponentResult QTAPI DataHGetFileSize (DHLR_FPARM1
    long far *fileSize);
ComponentResult QTAPI DataHSetFileSize (DHLR_FPARM1
    long fileSize);
ComponentResult QTAPI DataHCreateFile (DHLR_FPARM1
    OSType creator,
    Boolean deleteExisting);
ComponentResult QTAPI DataHGetPreferredBlockSize (DHLR_FPARM1
    long far *blockSize);
ComponentResult QTAPI DataHGetFreeSpace (DHLR_FPARM1
    unsigned long far *freeSize);
ComponentResult QTAPI DataHPreextend (DHLR_FPARM1
    long maxToAdd,
    long far *spaceAdded);
ComponentResult QTAPI DataHWrite (DHLR_FPARM1
    Ptr data,
    long offset,
    long size,
    DHCompleteProc completion,
    long refcon);
ComponentResult QTAPI DataHGetScheduleAheadTime (DHLR_FPARM1
    long far *millisecs);
ComponentResult QTAPI DataHPlaybackHints (DHLR_FPARM1
    long flags,
    unsigned long minFileOffset,
    unsigned long maxFileOffset,
    long bytesPerSecond);
ComponentResult QTAPI DataHSetOSFileReference (DHLR_FPARM1
    long fileRef,
    long openFlags);
ComponentResult QTAPI DataHGetOSFileReference (DHLR_FPARM1
    long far *fileRef,
    long far *openFlags);

#ifdef __cplusplus
}
#endif

#endif /* DATAH_H */
