
// ---------------------------------------------------------------------
//
// Common.h - Common Routines - QuickTime for Windows
//
//            Version 1.0
//
//            (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------



// Prevent multiple inclusion
// --------------------------
   #ifndef COMMON_H
      #define COMMON_H


// Constants
// ---------
   #define CCHMAXPATH 264
   #define COMMON_STRING_MAX 256


// Module Names & Entrypoints
// --------------------------
   #define QTPREFIX "QT"

   #define QTW_PROFILE "QTW.INI"



// Functions
// -----------------------------------------------------------------------
   #ifdef __cplusplus
      extern "C" {
   #endif

// -----------------------------------------------------------------------
// CommonAlloc allocates some memory from the heap. It returns a far
// pointer to that memory, or NULL if an error occurred.
//
//   LONG lBytes;            /* Size of memory to allocate */
//
     VOID FAR * FAR CommonAlloc (LONG lBytes);

// -----------------------------------------------------------------------
// CommonFormatMessage formats a message in memory from a string in a
// resource-only DLL.
//
//   HINSTANCE hResources;   /* Handle to resource-only DLL */
//   WORD idMsg;             /* ID of message string in DLL */
//   LPSTR lpszMsg;          /* Area in which to build message */
//   ...                     /* Substitution symbols (like vsprintf) */
//
     LPSTR FAR CommonFormatMessage (HINSTANCE hResources, WORD idMsg, LPSTR lpszMsg, ...);

// -----------------------------------------------------------------------
// CommonFree frees memory allocated by CommonAlloc.
//
//   VOID FAR *pvMemory;     /* -->Memory allocated by CommonAlloc */
//
     VOID FAR CommonFree (VOID FAR *pvMemory);

// --------------------------------------------------------------------
// CommonGetDirectoryOfModule returns the directory path of the calling routine.
// The returned path DOES NOT contain a final '\'
//
//   HINSTANCE hInstance;      /* Application's instance handle */
//   LPSTR lpPath;             /* pointer to path buffer */
//
     LPSTR FAR CommonGetDirectoryOfModule (HINSTANCE hInstance, LPSTR lpPath );

// -----------------------------------------------------------------------
// CommonGetLocalizedHelpFile returns the name of the application's
// localized Help File.
//
//   LPSTR lpszAppl;          /* Application's root name, eg: INST */
//   LPSTR lpszName;          /* Area in which to build help file name */
//   HINSTANCE hInstance;     /* Application's instance handle */
//
     LPSTR FAR CommonGetLocalizedHelpFile (LPSTR lpszAppl, LPSTR lpszName, HINSTANCE hInstance);

// -----------------------------------------------------------------------
// CommonGetLocalizedResources returns the handle of the application's
// localized resource-only DLL.
//
//   LPSTR lpszAppl;         /* Application's root name, eg: INST */
//   HINSTANCE hInstance;    /* Application's instance handle */
//   WORD idNoMemMsg;        /* Application's no-memory message */
//
     HINSTANCE FAR CommonGetLocalizedResources (LPSTR lpszAppl, HINSTANCE hInstance, WORD idNoMemMsg);

// -----------------------------------------------------------------------
// CommonGetCurrentRegion returns the Mac region code corresponding
// to the current Windows language code.
//
//
     UINT FAR CommonGetCurrentRegion (VOID);

// -----------------------------------------------------------------------
// CommonTellUser displays a message to the user from a string in a
// resource-only DLL. CommonTellUser returns the user reply directly
// from the Windows MessageBox function.
//
//   HINSTANCE hResources;   /* Handle to resource-only DLL */
//   WORD idMsg;             /* ID of message string in DLL */
//   WORD idCaption;         /* ID of caption string in DLL */
//   WORD idStyle;           /* Message box styles */
//   ...                     /* Substitution symbols (like sprintf) */
//
     int FAR CommonTellUser (HINSTANCE hResources, WORD idMsg, WORD idCaption, WORD idStyle, ...);

// -----------------------------------------------------------------------
// CommonSpeed returns an approximation of the speed of the processor.
//
     DWORD FAR CommonSpeed (VOID);

// -----------------------------------------------------------------------
   #ifdef __cplusplus
      }
   #endif
// -----------------------------------------------------------------------


// End of Common.H
// ---------------
   #endif
