//
// Project:      QuickTime for Windows
//
// Component:    Data Handler
//
// Description:  Code common to all data handlers
//
// ---------------------------------------------------------------------
// Windows header files
#include <windows.h>
#include <windowsx.h>

// Application header files
#include "datahp.h"

// Local functions
static VOID FAR PASCAL FixupCM( ENTRYFUNC lpfnCM) ;
static VOID FAR PASCAL FixupTB( ENTRYFUNC lpfnTB) ;

// Global data
extern "C" ENTRYFUNC lpfnQTComponentManager ;
extern "C" ENTRYFUNC lpfnQTToolbox ;
extern ComponentDescription cdTable;     // components in this DLL

// EJECT PAGE 
/*
********************************************************************************
**
** Name: FixupCM()
**
** Description:
**
**  Establish direct linkage to Component Manager.
**
********************************************************************************
*/
static VOID FAR PASCAL FixupCM( ENTRYFUNC lpfnCM)
{
    lpfnQTComponentManager = lpfnCM;
}

// EJECT PAGE 
/*
********************************************************************************
**
** Name: FixupTB()
**
** Description:
**
**  Establish direct linkage to Movie Toolbox.
**
********************************************************************************
*/
static VOID FAR PASCAL FixupTB( ENTRYFUNC lpfnTB)
{
    lpfnQTToolbox = lpfnTB;
}

// EJECT PAGE 
/*
********************************************************************************
**
** Name: THINGIDENTIFY()
**
** Description:
**
**  Entry point called by Component Manager  This function fills the Component
**  ID structure.
**  
********************************************************************************
*/
OSType FAR PASCAL THNGIDENTIFY( LPCID FAR *lplpcid)
{
    // allocate memory for CID information
    // The memory will be freed by the Component Manager.
    LPCID lpcid = ( LPCID) GetMemory( sizeof CID) ;
    if ( lpcid == 0)                          // if allocation failed
        return 0 ;                              // take error return

    // fill the structure
    lpcid->lVersion = CID_VERSION ;
    lpcid->sComponentCount = 1 ;
    lpcid->lpcdTable = ( LPCD) &cdTable ;
    lpcid->lpfnTBFixup = FixupTB ;
    lpcid->lpfnCMFixup = FixupCM ;
    *lplpcid = lpcid ;

    // return to caller
    return THING ;
}
