Macro_file SEARCH;
// $Header: /MEWIN/SRC/SEARCH.S 56    2/01/95 1:22p Manny $
// $ModTime: $

#include metools.sh
#include winsmall.sh
#include mew_dlgs.sh
#include mew_btn.sh
#include mewlist2.sh
#include dialog.sh
#include mewhelp.sh
#include mew.sh

#define SP_HELPLINK         ""
#define SEARCH_HELPLINK     "SEARCH"
#define SRCHREP_HELPLINK    "SEARCH AND REPLACE"
#define MFSRCH_HELPLINK     "MULTI-FILE SEARCH"
#define MFSRCHREP_HELPLINK  "MULTI-FILE SEARCH AND REPLACE"


Global
{
	int reg_exp_style;    // TRUE = Unix style expressions
	int MovedSRPosX;
	int MovedSRPosY;
}

Prototype Search
{
  int Create_SR_Dialog (int Search_Mode, int MultiFile, int prompted, int search_all_windows);
  int SR_Dialog_Loop   (int Dlg);
}

/*******************************************************************************
														MULTI-EDIT MACRO FILE

Name: SEARCH

S_AND_R						- The general purpose search and search/replace macro.
SEARCH_LIST TRANS	- Brings up the list of occurrences created by search.
SRCH_ACROSS_LINE	- Performs Word/Phrase search
REPL_ACROSS_LINE	- Performs Word/Phrase replace
SRCHINTR					- Generates a dialog box for S_AND_R.
SEARCH						- This is the user interface for a SEARCH.
S_REPL						- This is the user interface for a SEARCH AND REPLACE.
REPSRCH						- This repeats the last search or search/replace.
FS								- The interface to multi-file search
FILESRCH					- Performs the actual multi-file search

                Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/
// Function to tell if List all is available
int ListAllAvailable ()
{
  return (Global_Str("!SR_LST_WN") == "");
}


int Create_SR_Dialog (int Search_Mode, int MultiFile, int prompted, int search_all_windows)
{
    int x;
    int ctrl, fctrl;
		int line_height = 0, font_height = 0, font_width = 0, dfont = 0;
    struct tRect rect;

    int dlg = Create_MEW_Dlg( "Search Options", SP_HELPLINK, frame_handle, DLG_NOCENTER | DLG_NOSIZE);
    Get_MEW_Dlg_Metrics( dlg, line_height, font_height, font_width, dfont );

  if ( Search_Mode )
  {
    x = 10;
    fctrl = Create_MEW_Ctrl( "BUTTON", "&Replace",
                WS_CHILD | BS_DEFPUSHBUTTON  | WS_VISIBLE | WS_TABSTOP,
                x,
                line_height,
                font_width  * 10,
								line_height + 2,
                dlg, 1001, app_handle, 0);
    x += font_width * 14;

    if ( prompted )
    {
      ctrl = Create_MEW_Ctrl( "BUTTON", "&Skip",
                  WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                  x,
                  line_height,
                  font_width  * 10,
                  line_height + 2,
                  dlg, 1003, app_handle, 0);
      x += font_width * 11;
    }

    ctrl = Create_MEW_Ctrl( "BUTTON", "&Cancel",
                WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                x,
                line_height,
                font_width  * 10,
								line_height + 2,
                dlg, 1002, app_handle, 0);
    x += font_width * 11;

    if ( prompted )
    {
      ctrl = Create_MEW_Ctrl( "BUTTON", "&Non Stop",
                  WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                  x,
                  line_height,
                  font_width  * 10,
                  line_height + 2,
                  dlg, 1004, app_handle, 0);
      x += font_width * 11;
    }

    if ( MultiFile )
    {
      ctrl = Create_MEW_Ctrl( "BUTTON", "Skip &File",
                  WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                  x,
                  line_height,
                  font_width  * 10,
                  line_height + 2,
                  dlg, 1006, app_handle, 0);
      x += font_width * 11;

      ctrl = Create_MEW_Ctrl( "BUTTON", "A&llFiles",
                  WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                  x,
                  line_height,
                  font_width  * 10,
                  line_height + 2,
                  dlg, 1005, app_handle, 0);
      x += font_width * 11;
    }
  }
  else
  {
    x = 10;
    fctrl = Create_MEW_Ctrl( "BUTTON", "&Search Again",
                WS_CHILD | BS_DEFPUSHBUTTON  | WS_VISIBLE | WS_TABSTOP,
                x,
                line_height,
                font_width  * 20,
								line_height + 2,
                dlg, 1001, app_handle, 0);
    x += font_width * 24;

    if ( search_all_windows )
    {
      ctrl = Create_MEW_Ctrl( "BUTTON", "Skip &Window",
                  WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                  x,
                  line_height,
                  font_width  * 20,
                  line_height + 2,
                  dlg, 1003, app_handle, 0);
      x += font_width * 24;
    }
    ctrl = Create_MEW_Ctrl( "BUTTON", "&Cancel",
                WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                x,
                line_height,
                font_width  * 10,
								line_height + 2,
                dlg, 1002, app_handle, 0);
  }
  Auto_Size_Mew_Dlg (dlg, 100, 100);

  GetWindowRect (dlg, &rect);
  int wd = rect.right - rect.left;
  int hd = rect.bottom - rect.top;

  int x, y, tempwidth;
  GetWindowRect (window_handle, &rect);
	if ( MovedSRPosX || MovedSRPosY )
	{
		x = MovedSRPosX;
		y = MovedSRPosY;
		tempwidth = GetSystemMetrics(SM_CXSCREEN);
		while ( (x + wd) > tempwidth ) {
			x = x-1;
		}
	}
  else if ( c_row < 5)
  {
    y = rect.bottom - hd;
    x = rect.right  - wd;
  }
  else
  {
    y = rect.top;
    x = rect.right - wd;
  }

  SetWindowPos ( dlg, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
  ShowWindow (dlg, SW_SHOW);
  SetFocus (fctrl);
  return (dlg);
}

int SR_Dialog_Loop (int dlg)
{
  int return_value;
  struct TMsg msg;
	struct tRect rect;

  while ( GetMessage (&msg, 0, 0, 0) )
  {
		if ( (msg.wParam == 3001) || (msg.wParam == 3002) )  // band-aid to fix display problem
		{                                                    // with updating when doing S&R
			PeekMessage( &msg, dlg, 0, 0, PM_REMOVE);
			msg.wParam = 1;
		}
    if ( msg.message == WM_USER)
    {
      if ( msg.wParam > 1000 )
      {
        return_value = msg.wparam - 1000;
        break;
      }
      else if ( msg.wparam == 2 )
      {
        return_value = 2;
        break;
      }
    }
    if( !IsDialogMessage( dlg, &msg) )
    {
        TranslateMessage( &msg );
        DispatchMessage ( &msg );
    }
  }
	GetWindowRect(dlg, &rect);
	MovedSRPosX = rect.left;
	MovedSRPosY = rect.top;
  return (return_value);
}

void SR_Dialog_End ()
{
  struct tMsg msg;

  while ( PeekMessage (&msg, 0, 0, 0, 0) )
  {
    TranslateMessage( &msg );
    DispatchMessage ( &msg );
  }

}

macro s_and_r No_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: S_AND_R

Description:  Search and search/replace interface.

Parameters:
							/BC=  Number of boxes to kill after exiting

Returns:      Return_Int = 0 if <ESC> was pressed at the prompts.
							Return_Int = 1 if search was carried through.
							Global_Int('FOUND_COUNT') = # of occurrences found.

Globals used:

							Global_Str('Switches')  	The search switches:
																				I - Ignore case
																				G - Global, search entire file
																				N - No prompts, search and replace
																						unconditionally
																				P - Prompt for repeated searches/replaces
																				B - Search backwards
																				X - Regular expressions off.  Faster if
																						regs not needed.
																				R - Restrict search to marked block
																				C - Don't move cursor to the right after
																						a replace has occurred between
																						multiple searches and replaces.
																						Applies only to search and replace.
																				W - Word/Phrase search
																				L - List all occurrences
																				A - search all windows
							Global_Str('Repl_Switches') Replace switches - See above.
							GLOBAL_STR('SEARCH_STR')	String to search for.
							GLOBAL_STR('REPLACE_STR')	String to replace with.
							GLOBAL_INT('SEARCH_MODE')	Mode 0=search 1=seach and replace
							GLOBAL_INT('REPSEARCH')		Simply repeat search or search/replace
																				according to previous search.  No box
																				with prompts.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int FoundNum, count, jm, jz, JX, Start_Row, Box_Ofs,t_col, kill_count, tp,
			hl,Back_Search, Search_Mode, Restrict, Restrict_Count, orig_line,
			Active_Window = Window_Id,
			first_window = window_id,
			List_Window_Num = 0,
			tpb = persistent_blocks,
			Making_List = false,
      file_replace = (parse_int("/FR=", mparm_str) > 0),
			all_files = 0,
      ev_count = 0,
			t_status_row = status_row,
			search_all_windows = 0,
			all_windows_count = 0,
			all_windows_foundnum = 0,
			all_windows_global = 0,
      skip_all = 0,
			t_tab_expand = tab_expand,
      s_flags = 0;  // TMJ - 06-15-93 12:58pm - For Unix style expressions

	int  GLOBALSEARCH, noprompt, S_Prompt,Searching,temp_ins, S_RES ,
					No_Cursor_Movement,New_Line_Num, Across_Lines,
					at_top = 0;
	str  Search_Str,Replace_Str,SpareString[200], Switches_Str[20], help_str[20],
					Interface_Mac ,
					list_File_Name[128];

	persistent_blocks = TRUE;
  kill_count  = parse_int('/BC=', mparm_str );
  start_row   = parse_int('/Y=', mparm_str);
	Box_Ofs = 0;

	Push_Undo;
	help_str = SEARCH_HELPLINK;
  Search_Str  = GLOBAL_STR('SEARCH_STR');
	Replace_Str = GLOBAL_STR('REPLACE_STR');
	Search_Mode = GLOBAL_INT('SEARCH_MODE');

	if (file_replace) {
		if(search_mode) {
			sparestring = 'FRSWITCHES';
		} else {
			sparestring = 'FSWITCHES';
		}
	} else {
		if(  search_mode  ) {
			sparestring = 'REPL_SWITCHES';
		} else {
			sparestring = 'SWITCHES';
		}
	}
	Switches_Str = caps(Global_Str(sparestring));

	FoundNum = 0;
	count = 0;

	if(  GLOBAL_INT('REPSEARCH') == 0  ) {
		jx = xpos( 'R', switches_str, 1 );
		if( !tpb && block_stat && !jx) {
			switches_str += 'R';
		}
		else if( !tpb && !block_stat && jx ) {
			switches_str = str_del( switches_str, jx, 1 );
		}
		set_global_str( sparestring, switches_str );
		if(  Search_Mode  ) {
			Box_Ofs = 1;
		}
		if(  search_mode  ) {
			help_str = SRCHREP_HELPLINK;
		}
		Set_Global_Int('MENU_RESULT',FALSE);

/* This allows the user to call an alternate search interface */
		Interface_Mac = Global_Str('@SRCH_INTR_MACRO');
		if(  (Interface_Mac == '')  ) {
			Interface_Mac = 'SRCHINTR ';
		}
		if(  (XPOS(' ',Interface_Mac,1) == 0)  ) {
			Interface_Mac = Interface_Mac + ' ';
		}
		refresh = false;
		mark_pos;
		if(  (c_line == block_line1) &
				(block_stat > 0) & (block_line1 == block_line2)  ) {
			if(  (block_stat == 1)  ) {
				first_word;
				set_global_str('SEARCH_HISTORY0', get_word('') );
			} else {
				set_global_str('SEARCH_HISTORY0', copy(get_line,block_col1, (block_col2 - block_col1) + 1));
			}
/*
			} else if(  (block_stat == 2)  ) {
				set_global_str('SEARCH_HISTORY0', copy(get_line,block_col1, (block_col2 - block_col1) + 1));
			} else if(  (block_stat == 3)  ) {
				set_global_str('SEARCH_HISTORY0', copy(get_line,block_col1, (block_col2 - block_col1) + 1));
			}
*/
		} else {
			right;
			word_left;
			set_global_str('SEARCH_HISTORY0', get_word(word_delimits) );
		}
		goto_mark;

			/* Call the search/replace user interface macro */
		RM(Interface_Mac + '/M=' + str( search_mode ) + '/H=' + help_str +
					'/Y=' + str(start_Row) + '/SRG=SEARCH_STR/RPG=REPLACE_STR/SWG='
				+ sparestring);

		if (return_Int == 12) {
			RM("SEARCH_LIST");
			Goto S_AND_R_EXIT;
		}
		set_global_str('SEARCH_HISTORY0', '' );
    search_str    = Global_Str('SEARCH_STR');
    replace_str   = Global_Str('REPLACE_STR');
    switches_str  = Global_Str( sparestring );
		if(  NOT( Return_Int )  ) {
			Goto S_AND_R_EXIT;
		}
	}

	Return_Int = True;

	refresh = true;

Start_Search:
  Switches_Str  = CAPS( Switches_Str );
  Ignore_Case   = (XPos('I',Switches_Str,1) != 0);
  GlobalSearch  = (XPos('G',Switches_Str,1) != 0);

	if(  Global_Int('REPSEARCH') != 0  ) {
    GlobalSearch = False;
	}
	if (search_all_windows && all_windows_global) {
    GlobalSearch = True;
	}
  NoPrompt      = (XPos('N',Switches_Str,1) != 0);
  Making_List   = (XPos('L',Switches_Str,1) != 0);
  S_Prompt      = (XPos('P',Switches_Str,1) != 0);
  Back_Search   = (XPos('B',Switches_Str,1) != 0);
  Across_Lines  = (XPos('W',Switches_Str,1) != 0);

//search_all_windows is not compatible with file_replace
	Search_All_Windows = ((XPos('A',Switches_Str,1) != 0) && (file_replace == 0));
	No_Cursor_Movement = False;

	if (Search_Mode == True) {
		Making_List = False;
		SpareString = Search_Str;
		Return_Str = Replace_Str;
		if(  (Ignore_Case)  ) {
			SpareString = Caps(SpareString);
			Return_Str = Caps(Return_Str);
		}
		if(  (SpareString != Return_Str)  ) {
/* Don't allow 'C' switch if search_str = replace_str.  This would cause a
continuous loop */
			No_Cursor_Movement = (XPos('C',Switches_Str,1) != 0);
		}
	} else {
    if (noprompt) {
			making_list = true;
		}
		if (making_list) {
			noprompt = true;
		}
	}
	Reg_Exp_Stat = (XPos('X',Switches_Str,1) == 0);
	restrict_count = 0;
	orig_line = c_line;


	// 06-15-93 12:57pm
	// TMJ - Mods for UNIX style regular expressions
	if(reg_exp_stat)
	{
		if(reg_exp_style)
			s_flags |= _RegExp;
		else
			s_flags |= _OldExp;
	}
	if(!ignore_case)
		s_flags |= _CaseSensitive;
	if(back_search)
		s_flags |= _Backward;

	Mark_Pos;
	Restrict = XPos('R',Switches_Str,1) != 0;
	if(  (Restrict)  ) {
		block_end;
		if(  block_stat == 0  ) {
			if (search_all_windows) {
				goto SEARCH_OUT;
			}
			RM('USERIN^VERIFY /H=SR/BL=NO BLOCK MARKED/T=Perform search on file?');
			if(  return_int == 0  ) {
				make_message('No block marked.');
				refresh = true;
				redraw;
				Error_level = 0;
				goto s_and_r_exit;
			}
			restrict = 0;
		}
		else if( ((c_line == block_line1) && (c_col < block_col1)) ||
					((c_line == block_line2) && (c_col >= block_col2)) ||
					(c_line < block_line1) || (c_line > block_line2) ||
					(!tpb)) {
			Goto Restrict1;
		}
	}

	if(  GlobalSearch == TRUE  ) {
	Restrict1:
		if(  Back_Search  ) {
			if(  Restrict  ) {
				Goto_Line( Block_Line2 );
				EOL;
			} else {
				EOF;
			}
		} else {
			if(  Restrict  ) {
				Goto_Line( Block_Line1 );
				Goto_Col( 1 );
				goto_col( block_col1 );
			} else {
				GOTO_Line(1);
				Goto_Col(1);
			}
		}
	}

	make_message('');
	Temp_Ins = Insert_Mode;
	Insert_Mode = TRUE;
	searching = TRUE;

	if(  NoPrompt && Search_Mode  )
	{
		Refresh = FALSE;
	}

	Error_level = 0;

	while(  Searching  ) {
		refresh = false;
		if(  NoPRompt  ) {
			if(  Search_Mode  ) {
				make_message( 'Searching... Replaces:' + str(count) + ' <CtrlBREAK> to abort.');
			} else {
				make_message( 'Searching... Occurrences:' + str(foundnum) + ' <CtrlBREAK> to abort.');
			}
		} else {
			make_message('Searching...   <CtrlBREAK> to abort.');
		}
		WORKING;
		orig_line = c_line;
		if(  Back_Search  ) {
			if(  Restrict  ) {
sagain2:
				Restrict_Count = C_Line - Block_Line1 + 1;
				if(  restrict_count < 1  ) {
					goto search_out;
				}
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
					S_Res = Return_Int;
				} else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}

/* check to see if the last time we went through this loop we set the at_top
	 flag.  If so, consider this find to have failed to avoid a continuous loop */
				if (at_top)
					s_res = 0;
/* set special flag if we are already at the top of the file so we don't get
	 into a continuous loop */
				at_top = ((c_line == 1) && (c_col == 1));

				if(  s_res  ) {
					if(  block_stat == 2  ) {
						if(  (c_col < block_col1) | ((c_col + length(found_str) - 1) > block_Col2)  ) {
							call searchmove;
							goto sagain2;
						}
					} else if(  block_stat == 3  ) {
						if(  ((c_line == block_line1) & (c_col < block_col1))  ) {
							call searchmove;
							goto sagain2;
						} else if(  ((c_line == block_line2) & ((c_col + length(found_str) - 1) > block_col2))  ) {
							call searchmove;
							goto sagain2;
						}
					}
				}
			} else {
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
					S_Res = Return_Int;
				} else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}

/* check to see if the last time we went through this loop we set the at_top
	 flag.  If so, consider this find to have failed to avoid a continuous loop */
				if (at_top)
					s_res = 0;
/* set special flag if we are already at the top of the file so we don't get
	 into a continuous loop */
				at_top = ((c_line == 1) && (c_col == 1));

			}
		} else {
			if(  Restrict  ) {
sagain:
				Restrict_Count = Block_Line2 - C_Line + 1;
				if(  restrict_count < 1  ) {
					goto search_out;
				}
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
					S_Res = Return_Int;
				} else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}
				if(  s_res  ) {
					if(  block_stat == 2  ) {
						if(  (c_col < block_col1) | ((c_col + length(found_str) - 1) > block_Col2)  ) {
							call searchmove;
							goto sagain;
						}
					} else if(  block_stat == 3  ) {
						if(  ((c_line == block_line1) & (c_col < block_col1))  ) {
							call searchmove;
							goto sagain;
						} else if(  ((c_line == block_line2) & ((c_col + length(found_str) - 1) > block_col2))  ) {
							call searchmove;
							goto sagain;
						}
					}
				}
			} else {

				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
					S_Res = Return_Int;
				} else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}
			}
		}
/* This only occurs if user pressed <CTRL-BREAK> */
		if(  Error_Level == 1015  ) {
			Make_message('Search aborted by user.');
			refresh = true;
			redraw;
			Error_level = 0;
			GOTO S_And_R_Exit;
		}
		if(  S_Res  ) {
			if(  FoundNum == 0  ) {
/* Only after the first successful find will we create a window to put our list */
				++all_windows_count;
				if (making_list) {

// Mod to handle correct placement of .TMP files
					RM("TMP_FILE_NAME /FN=SRLST.TMP");
/*
					return_str = "SRLST.TMP";
					rm("MakeUserPath");
*/
					list_file_name = return_str;
					if (switch_file(list_file_name)) {
						if (all_windows_count == 1) {
							erase_window;
						}
					} else {
						switch_window(window_count);
						Create_Window;
					}
					file_name = list_file_name;
					window_Attr = $81;
// WinFinish jkp changed screen_width to 80
          pad_str (sparestring, 80," ");
					sparestring = str_ins("",sparestring,7) + "";
					format_line = sparestring;
					List_Window_Num = Cur_Window;
					Switch_Win_Id(Active_Window);
					tab_expand = true;
/*
beep;
make_message("LINE 431 " + str(list_window_num));
read_key;
*/
          put_line_to_win("@=" + file_name + "#=OCC=WIN_ID=" +
            str(window_id),
						all_windows_count + all_windows_foundnum,list_window_num,false);
					tab_expand = t_tab_expand;
				} else {
					Pop_Mark;
				}
			}
			++FoundNum;
			if (making_list) {
				mark_pos;
// Windows JKP changed screen_width to 80
        goto_col(c_col - (80 / 2) + 7);
        sparestring = Copy(Get_Line,c_col, 80 - 15);
				tabs_to_spaces(sparestring);
				tab_expand = true;
/*
beep;
make_message("LINE 450 " + str(list_window_num));
read_key;
*/
        put_line_to_win("L=" + str(c_line) + "T=" + sparestring,FoundNum +
					all_windows_count + all_windows_foundnum,list_window_num,false);
				tab_expand = t_tab_expand;
				goto_Mark;
			}
			if(  NOPROMPT == FALSE  ) {
				make_message('');
			}
			if(  Search_Mode  ) {
				CALL Do_Replace_Prompt;
			} else {
				CALL Do_Search_Prompt;
			}
		} else {
			Searching = FALSE;
			if(  FoundNum == 0  ) {
				Goto_Mark;
			}
		}
	}
search_out:
	if (making_list && foundnum) {
		Switch_Window(list_Window_num);
		tab_expand = true;
		goto_line(all_windows_foundnum + all_windows_count);
		goto_col(1);
    if (search_fwd("#=",1)) {
			RM("DELEOL");
			text("#=" + str(all_windows_count) + "OCC=" + str(foundnum) +
        "WIN_ID=" + str(active_window));
		}
		tab_expand = t_tab_expand;
		switch_win_id(active_window);
	}
	if (search_all_windows) {
		all_windows_foundnum += foundnum;
		if (!s_prompt && foundnum && !making_list && !noprompt) {
// we should only get here if we have stop on first occurrence selected
			search_all_windows = false;
			goto ALL_WINDOWS_FOUND;
		}
    if ( !skip_all )
    {
      pop_undo;
      SWITCH_WINDOW(CUR_WINDOW + 1);
      RM( 'FINDWIN /HIDDEN=1');
      rm('SELECT_WINDOW');
      push_undo;
      active_window = window_id;
      if (window_id != first_window) {
        all_windows_global = true;
        foundnum = 0;
        goto start_search;
      }
    }
	}

ALL_WINDOWS_FOUND:
	Set_Global_Int('MENU_RESULT',TRUE);

	if(  Search_Mode  ) {                                                 /*  ldh  */
   /*  call
    Center_Line;     */                                             /*  ldh  */
	}                                                                /*  ldh  */
	if (making_list && (foundnum || all_windows_foundnum)) {
		Switch_Window(list_Window_num);

		Set_Global_Str("!SR_LST_WN","/SS=" + Global_Str("SEARCH_STR"));

		tof;
		Switch_Win_Id(Active_Window);
		make_message("");
		RM("SEARCH_LIST");

		if (Return_Int || search_all_windows) {
			Pop_Mark;
		} else {
			Goto_Mark;
		}
	}
	if (search_all_windows) {
		sparestring = 'String Found ' + STR(all_windows_foundnum) + ' Times in ' +
			str(all_windows_count) + " files.";
	} else
		sparestring = 'String Found ' + STR(FoundNum) + ' Times.';
	Make_Message(sparestring);
	Refresh = TRUE;
	Insert_Mode = Temp_Ins;
	GOTO S_And_R_Exit;


Do_Replace_Prompt:

Replace_Loop:
	if(  noprompt == FALSE  ) {
		call highlight_find;
		if(  NOT(S_Prompt)  ) {
			Searching = False;
		}
		Make_Message('');

Replace_loop1:
    int menu   = Create_SR_Dialog (Search_Mode, File_Replace, S_Prompt, Search_all_Windows);
    return_int = SR_Dialog_Loop (menu);
    Destroy_Mew_Dlg (menu);
    UpdateWindow (frame_handle);

		make_message('');
    if       (  return_int == 3  ) {
			call searchmove;
		} else if(  return_int == 4  ) {
			noprompt = true;
		} else if(  return_int == 5  ) {
			noprompt = true;
			all_files = 1;
		} else if(  return_int == 6  ) {
			Searching = FALSE;
		} else if(  return_int == 2  ) {
			all_files = -1;
			Searching = FALSE;
    } else if(  return_int == 1  ) {
			T_Col = C_Col;
			if(  (Across_Lines)  ) {
				Return_Str = Replace_Str;
				RM('REPL_ACROSS_LINE ');
			} else {
				Replace( Replace_Str );
			}

			if(  (No_Cursor_Movement)  ) {
				Goto_Col(T_Col);
			} else {
				if(  Back_Search  ) {
					Goto_Col(T_Col);
					Left;
				} else {
					while(  NOT(at_eol) & (cur_char == '|255')  ) {
						right;
					}
					if(  At_Eol  ) {
						right;
					}
				}
			}
			++count;
			//Redraw;
		}
    else
      goto Replace_loop1;

    if ( noprompt == TRUE)  goto nonstop;
    Ret;
  }
  else
  {
NonStop:
		T_Col = C_Col;
		if(  (Across_Lines)  ) {
			Return_Str = Replace_Str;
			RM('REPL_ACROSS_LINE ');
		} else {
			Replace( Replace_Str );
		}
		if(  (No_Cursor_Movement)  ) {
			Goto_Col(T_Col);
		} else {
			if (Back_Search) {
				Goto_Col(T_Col);
				Left;
			} else {
				while(  NOT(at_eol) & (cur_char == '|255')  ) {
					right;
				}
				if(  At_Eol  ) {
					right;
				}
			}
		}
		++count;
	}
	RET;

highlight_find:
	refresh = false;
	if (across_lines) {
// This will scroll the screen to make as much of the phrase as possible visable
		jx = Parse_Int('/L=',Global_Str('@LINE_SEARCH_POS')) - c_line;
		if (jx > (win_y2 - win_y1))
			jx = (win_y2 - win_y1);
		goto_line(c_line + jx);
	}

	if(  c_line > orig_line  ) {
		if(  (c_line - orig_line) <= ((win_y2 - win_y1) - c_row)  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				down;
			}
		} else {                                                              /*  ldh  */
			call Center_Line;                                               /*  ldh  */
		}
	} else {
    if(  (orig_line - c_line) <= ((win_y2 - win_y1) - ((win_y2 - (win_y1 + c_row))))  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				up;
			}
    } else {                                                              /*  ldh  */
			call Center_Line;                                               /*  ldh  */
    }
	}

/*
	sparestring = found_str;
	expand_tabs( sparestring, hl );
	hl = svl( sparestring );
	tp = c_col;
	goto_col(c_col + hl);
	goto_col(tp);
	if(  (win_x2 - wherex) < hl  ) {
		hl = win_x2 - wherex;
	}
 */

	if (Across_Lines) {
// This brings the cursor back to the right place after the scrolling above
		refresh = true;
		redraw;
    for (jx; jx > 0; jx--)
			up;

// Highlight the entire phrase
		Jx = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS'));
		Set_Highlight(c_line,c_col,
			Parse_Int('/L=',Global_Str('@LINE_SEARCH_STR' + Str(Jx))),
			Parse_Int('/C=',Global_Str('@LINE_SEARCH_STR' + Str(Jx))) +
			length(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR' + Str(Jx)))));

	} else {
		refresh = true;
		hl = c_line;
		tp = c_col;
		goto_line( search_end_line );
		goto_col( search_end_col );
		goto_line(hl);
		goto_col(tp);

		search_highlight = buffer_id;
		//redraw;
		if(event_macro != "")
		{
			key1 = 0;
			key2 = 0;
			rm(event_macro);
		}
	}
	ret;

Do_Search_Prompt:
  if (Noprompt) {
    Call searchmove;
    Ret;
  }

	if (NOT(S_Prompt)) {
		call highlight_find;
		Make_Message('String Found ' + STR(FoundNum) + ' Times.');
		Searching = False;
	//	if (search_all_windows)
	//		RET;
    Ret;
	}

	call highlight_find;

  int menu = Create_SR_Dialog (Search_Mode, File_Replace, S_prompt, Search_All_Windows);
  return_int = SR_Dialog_Loop (menu);
  Destroy_Mew_Dlg (menu);
  UpdateWindow (frame_handle);

search_promptx:
	make_message('');
	if(  return_int == 2  ) {
		Searching = FALSE;
    skip_all = 1;
  } else if( return_int == 3 ) {
    Searching = False;
	} else {
		call searchmove;
	}
  Ret;

searchmove:
  if(  Back_Search  ) {
    LEFT;
  } else {
    RIGHT;
    while(  not(at_eol) & (cur_char == '|255')  ) {
      right;
    }
    if(  At_Eol  ) {
      right;
    }
  }
  ret;

/* <<<Added 12-Apr-90 ldh ******************************************************/
Center_Line:
	New_Line_Num = C_Line;
	tp = c_col;
/* These 6 lines will center the selected line on the screen if possible */
	while(  (C_Row > ((Win_Y2 - Win_Y1) / 2))  ) {
		Up;
	}
	while(  (C_Row < ((Win_Y2 - Win_Y1) / 2))  ) {
		Down;
	}
	Goto_Line(New_Line_Num);
	goto_col(tp);
	ret;
/******************************************************************** Added>>> */

s_and_r_exit:
	tab_expand = t_tab_expand;
	status_row = t_status_row;
	persistent_blocks = tpb;


	Set_Global_Int('FOUND_COUNT', foundnum);
	Pop_Undo;
  Set_Global_Int('REPSEARCH',0);
	Reg_Exp_Stat = True;
	redraw;
	if(  (Across_Lines)  ) {
		Jx = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS'));
		while(  (Jx)  ) {
			Set_Global_Str('@LINE_SEARCH_STR' + Str(Jx),'');
			--Jx;
		}
		Set_Global_Str('@LINE_SEARCH_POS','');
	}
	return_int = all_files;
}

macro SEARCH_LIST trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SEARCH_LIST

Description: Brings up the list of search occurrences created by S_AND_R

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Active_Window = Window_Id,
			t_reg_exp_stat = reg_exp_stat,
			Line_Number,
			t_tab_expand = tab_expand,
			win_id;
	str f_name[128] = "";

/*
beep;
make_message(str(reg_exp_stat));
read_key;
*/
	tab_expand = true;
	reg_exp_stat = true;

// Mod to handle correct placement of .TMP files
	RM("TMP_FILE_NAME /FN=SRLST.TMP");

	error_level = 0;
	if (Switch_File(return_str)) {
      mark_pos;
      eof;
      make_message('String Found ' + str(c_line - 1) + ' Times.');
      goto_mark;
      int dlg;
      DlgCreate( dlg );
      DlgAddCtrl( dlg, DLG_ListBox, "L=/W=7T=/W=60", 1,1,70,15,1000,0,"/WIN=" + str(cur_window));
      DlgAddCtrl( dlg, DLG_PushButton, "OK", 1,17,DLG_StanBtnWidth,0,101,DLGF_DefButton,"/R=1" );
      DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_StanBtnWidth + 2,DLG_PosOffset,DLG_StanBtnWidth,0,102,0,"/R=0" );
      DlgAddCtrl( dlg, DLG_PushButton, "&Help", 62,DLG_PosOffset,DLG_StanBtnWidth,0,103,0,"/R=2" );
      return_int = DlgExecute( dlg, 1000, "Found List", SEARCH_HELPLINK, "", 0 );
      DlgKill( dlg );

			window_Attr = $81;
			if (return_Int) {
				Goto_Col(1);
        line_number = parse_int("L=", get_line);
        if (line_number) {
					mark_pos;
          if (search_bwd("%@@=",0)) {
            f_name = parse_str("%@=", get_line);
						win_id = parse_int("WIN_ID=",get_line);
						goto_mark;
// look for window by window_id first
						if (switch_win_id(win_id)) {
							Goto_Line(Line_Number);
							Goto FOUND;
						} else if (switch_file(f_name)) {
// if not there, look for it by name
							Goto_Line(Line_Number);
							Goto FOUND;
						}
					} else
						goto_mark;
				Make_Message("Window for search list not found.");
				}
			}
	} else {
		Make_Message("No search list found.");
	}
	Switch_Win_Id(Active_Window);
FOUND:
	RM("Select_Window");
  redraw;      // jkp to fix redraw when calling directly.
	reg_exp_stat = t_reg_exp_stat;
	tab_expand = t_tab_expand;
}

macro SRCH_ACROSS_LINE TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SRCH_ACROSS_LINE

Description: Performs Word/Phrase search

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str
					Current_Word[80],
					T_Delimits[40] = Word_Delimits,
					Punctuation[5] = ',.?;:'
					;
	int
					Restrict_Count = Parse_Int('/R=',MParm_Str),
					Back_Search = Parse_Int('/B=',MParm_Str),
					Word_Index,
					Word_Count = 0,
					Check_Col,
					ret_val = 0
					;

	Reg_Exp_Stat = False;
	Word_Delimits = ' |9|255';
	if (Global_Str('@PHRASE_SRCH_DELIM') != '') {
		Word_Delimits = Global_Str('@PHRASE_SRCH_DELIM');
	}

	if (Ignore_Case) {
		Return_Str = Caps(Return_Str);
	}
	Ret_Val = 0;

	RM("PARSE_PHRASE /M=0");
	Word_Count = Return_Int;

	if (Word_Count < 1) {
		Goto EXIT;
	}


SEARCH_AGAIN:
	Word_Index = 1;

	if (Back_Search) {
		if ((c_line == 1) && (c_col == 1)) {
// if we are at the top of the file already, get out!
			goto exit;
		}
		if (Search_Bwd(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')),Restrict_Count) == 0) {
			Goto EXIT;
		}
	} else {
		if (at_eof) {
// if we are at the end of the file already, get out!
			goto exit;
		}
		if (Search_Fwd(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')),Restrict_Count) == 0) {
			Goto EXIT;
		}
	}
	Set_Global_Str('@LINE_SEARCH_STR1','/S=' + Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')) + '/L=' + Str(C_Line) + '/C=' + Str(C_Col));

/* Check to make sure that we found a whole word */
	Mark_Pos;
	if ((C_Col > 1) && (XPos(Cur_Char,Punctuation,1) == 0)){
		Left;
// For the first word, we'll acccept default word delimiters as leading chars
		if (Xpos(Cur_Char,T_Delimits,1) == 0) {
			Pop_Mark;
			if ( !back_search ) // MNB added
				Word_Right;
			Goto SEARCH_AGAIN;
		}
		Right;
	}
	if (word_count > 1) {
		Goto_Col(C_Col + Length(Found_Str));
		if ((At_Eol == 0) & (Xpos(Cur_Char,Word_Delimits,1) == 0)) {
			Pop_Mark;
			Goto SEARCH_AGAIN;
		}
		Goto_Mark;
		Mark_Pos;
		Word_Right;
		if (At_Eol == 0) {
			Word_Left;
		}
	}
CHECK_NEXT_WORD:
	if (Word_Index == Word_Count) {
/* If we found all the words, then...  */
		if (Word_Count == 1) {
			Goto_Col(C_Col + Length(Found_Str));
			if ((At_Eol == 0) & (Xpos(Cur_Char,T_Delimits,1) == 0)) {
				if (back_search) {
					goto_mark;
					left;
				} else {
					Pop_Mark;
				}
				Goto SEARCH_AGAIN;
			}
		}
		Set_Global_Str('@LINE_SEARCH_POS','/L=' + Str(C_Line) + '/C=' + Str(C_Col) + '/#=' + Str(Word_Count));
		Goto_Mark;
		Ret_Val = 1;
		Goto EXIT;
	}
	++Word_Index;
EOL_DELIMITS:
	Word_Right;
	if (((Xpos(Cur_Char,Word_Delimits,1) | (At_Eol == True)) > 0) & (At_Eof == False)) {
/* We would only get here if there are word delimiters at the end of a line */
		Goto EOL_DELIMITS;
	}
	Check_Col = C_Col;
	if (Word_Index == Word_Count) {
/* On the last word, allow trailing chars according to users word delimits */
		Current_Word = Get_Word(T_Delimits);
	} else {
		Current_Word = Get_Word(Word_Delimits);
	}
	if (Ignore_Case) {
		Current_Word = Caps(Current_Word);
	}
	if (Current_Word != Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR' + Str(Word_Index)))) {
		Goto_Mark;
		if (Back_Search) {
			Left;
		} else {
			Right;
		}
		Goto SEARCH_AGAIN;
	}
	Set_Global_Str('@LINE_SEARCH_STR' + Str(Word_Index),'/S=' + Current_Word + '/L=' + Str(C_Line) + '/C=' + Str(Check_Col));

	Goto CHECK_NEXT_WORD;

EXIT:
	Return_Int = Ret_Val;
	Word_Delimits = T_Delimits;
}

macro PARSE_PHRASE TRANS2 {
	str
					Search_Str = Return_Str,
					Current_Word[80],
					g_str[18]
					;
	int
					Copy_Index = 1,
					Word_Count = 0
					;
	char  Ch
					;
	if (parse_int("/M=",mparm_str)) {
		g_str = '@LINE_REPLACE_STR';
	} else {
		g_str = '@LINE_SEARCH_STR';
	}

GET_SEARCH_WORD:
	Current_Word = '';
MORE_SEARCH_WORD:
	if (Copy_Index <= Svl(Search_Str)) {
		Ch = Str_Char(Search_Str,Copy_Index);
		++Copy_Index;
		if (Xpos(Ch,Word_Delimits,1) == 0) {
			Current_Word = Current_Word + Ch;
			Goto MORE_SEARCH_WORD;
		}
	}
	if (Current_Word != '') {
		++Word_Count;
		Set_Global_Str(g_str + Str(Word_Count),'/S=' + Current_Word);
	}

NEXT_SEARCH_WORD:
/* Find the beginning next word in Search_Str for next time */
	while ((Copy_Index < Svl(Search_Str)) &
					(Xpos(Str_Char(Search_Str,Copy_Index),Word_Delimits,1) > 0)) {
		++Copy_Index;
	}

	if (Copy_Index <= Svl(Search_Str)) {
		Goto GET_SEARCH_WORD;
	}

	return_int = Word_Count;
}

macro REPL_ACROSS_LINE TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: REPL_ACROSS_LINE

Description: Performs Word/Phrase replace

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str T_Delimits[40] = Word_Delimits;

	int Search_Count = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS')),
			Done_Count,
			Replace_Count,
			T_line = C_Line,
			T_Row = C_Row
			;

	refresh = false;
	Word_Delimits = ' |9|255';
	if (Global_Str('@PHRASE_SRCH_DELIM') != '') {
		Word_Delimits = Global_Str('@PHRASE_SRCH_DELIM');
	}
	RM("PARSE_PHRASE /M=1");
	Replace_Count = Return_Int;

	Mark_Pos;
/* Place markers at the beginning of every found word, then at the end of the
found phrase */
	Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_POS')));
	Goto_Col(Parse_Int('/C=',Global_Str('@LINE_SEARCH_POS')));
	Insert_Mode = True;
	Text('|0');

	for (Done_count = 1;done_count <= search_count;done_count++) {
		Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Goto_Col( Parse_Int('/C=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Insert_Mode = False;
		Text('|0');
	}
	Goto_Mark;
	Insert_Mode = True;

	for (Done_count = 1;done_count <= search_count;done_count++) {
		Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Goto_Col(1);
		search_Fwd('|0',1);
		Del_Chars(Length(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count)))));
		if (Done_Count <= Replace_Count) {
			Text(Parse_Str('/S=',Global_Str('@LINE_REPLACE_STR' + Str(Done_Count))));
		}
	}

	while (search_count < Replace_Count) {
		++search_Count;
		Text(" " + Parse_Str('/S=',Global_Str('@LINE_REPLACE_STR' + Str(Search_Count))));
	}

/* Get rid of end of found phrase mark */
	if (Search_Fwd('|0',1)) {
		Del_Char;
	}

/* Fix it so the display does not scroll unless neccessary */
	t_row = t_row + (c_line - t_line);
	t_line = c_line;
	while (c_row < t_row) {
		down;
	}
	goto_line(t_line);
	refresh = true;

	for (replace_count;replace_count > 0;replace_count--)
		Set_Global_Str('@LINE_REPLACE_STR' + Str(Replace_Count),"");

	Word_Delimits = T_Delimits;
}

macro SrchIntr NO_BREAK trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SrchIntr

Description:  Search (and Replace) User Interface.  This macro is called
							by S_AND_R.

Parameters:		/M=n	Mode, 0 = Search, 1 = Search and Replace
							/H=str Help String
							/SRG=str  Name of the global_str to put the search str in
							/RPG=str  Name of the global_str to put the replace str in
							/SWG=str  Name of the global_str to put the switches str in
							/SWONLY=1	Edit switches only

Returns:
						Return_Int > 0 IF START_SEARCH WAS SELECTED

							 (C) Copyright 1991 by American Cybernetics, Inc.
SEARCHķ
Search For:                                                         ݺ
                                                                       
Type:                               Direction:                         
  ( ) Literal                         () Forward  ( ) Backward        
  ( ) Regular expressions           Mode:                              
  ( ) Word/Phrase search              () Stop on first occurrence     
Options:                              ( ) Prompt for next search       
  [ ] Case sensitive                  ( ) Find all occurrences         
  [ ] Global search                                                    
  [ ] Restrict to marked block                                         
                                                                       
                   OK<ENTER> Cancel<ESC> Help<F1> Short form<F5>   
                             
ͼ
SEARCH AND REPLACEķ
Search For:                                                         ݺ
Replace With: ݺ
                                                                       
Type:                               Direction:                         
  ( ) Literal                         () Forward  ( ) Backward        
  ( ) Regular expressions           Mode:                              
  ( ) Word/Phrase search              ( ) Replace first occurrence only
Options:                              () Prompt for each replace      
  [ ] Case sensitive                  ( ) Replace all occurrences      
  [ ] Global search                 Leave cursor at:                   
  [ ] Restrict to marked block        () End of replace string        
                                      ( ) Start of replace string      
                                                                       
                   OK<ENTER> Cancel<ESC> Help<F1> Long form<F5>    
                              
ͼ
*******************************************************************************/
    int search_mode, sw_pos, tsw_pos, jx,
        ic, gs, ps, regs, rb, bs, np, cs, ls, ml, aw, opt, count,
        smode,
        swonly = parse_int('/SWONLY=', mparm_str),
        menu = menu_create
						 ;
    str  help_str[40], title_str[30] = 'Search' ;

		help_str = Global_Str(parse_str('/SWG=', mparm_str));
		search_mode = parse_int( '/M=', mparm_str );
		if (search_mode) {
      title_str = 'Search And Replace';
		}
again:
    sw_pos = 3;
		ic = (xpos( 'I', help_str, 1 ) == 0);
		gs = (xpos( 'G', help_str, 1 ) != 0);
		ps = (xpos( 'P', help_str, 1 ) != 0);
		bs = (xpos( 'B', help_str, 1 ) != 0);
		regs = (xpos( 'X', help_str, 1 ) == 0);
		rb = (xpos( 'R', help_str, 1 ) != 0);
		np = (xpos( 'N', help_str, 1 ) != 0);
		cs = (xpos( 'C', help_str, 1 ) != 0);
		ls = (xpos( 'W', help_str, 1 ) != 0);
		ml = (xpos( 'L', help_str, 1 ) != 0);
		aw = (xpos( 'A', help_str, 1 ) != 0);
		if (!search_mode && np) {
			ml = 1;
		}


    if(  (ls)  ) {
      opt = 3;
    } else if(  (regs)  ) {
      opt = 2;
    } else {
      opt = 1;
    }

    smode = 1;
    if (ml) {
      smode = 3;
    } else if (np) {
      smode = 3;
    } else if (ps) {
      smode = 2;
    }

    jx = 1;
    if (swonly) {
    //  sw_pos = 1;
   } else {
        menu_set_item( menu, jx, 'Search for:  ',Global_Str(parse_str('/SRG=', mparm_str)),
      '/L=1/QK=1/C=6/W=38/ML=254/HISTORY=SEARCH_HISTORY/GO=' + str( search_mode == 0),0,0, 0);
      ++jx;
      if(  Search_Mode  ) {
        menu_set_item( menu, jx, 'Replace with:',Global_Str(parse_str('/RPG=', mparm_str)),
        '/L=2/HISTORY=REPLACE_HISTORY/QK=1/C=6/W=38/ML=254/GO=1',0,0, 0);
        ++jx;
      }
    }

    menu_set_item( menu, jx, 'Type','',
      '/C=1/W=28/HT=4/L=' + str( sw_pos + 0),10,0, 0);
    tsw_pos = jx;
    ++jx;
    menu_set_item( menu, jx, 'Literal','',
      '/QK=1/C=2/L=' + str(sw_pos + 1),12, opt == 1, 0);
    ++jx;
    menu_set_item( menu, jx, 'Regular expressions','',
      '/QK=9/C=2/L=' + str(sw_pos + 2),12, opt == 2, 0);
    ++jx;
    menu_set_item( menu, jx, 'Word/Phrase search','',
      '/QK=4/C=2/L=' + str(sw_pos + 3),12, opt == 3, 0);
    ++jx;

    menu_set_item( menu, jx, 'Direction','',
      '/C=31/W=28/HT=2/L=' + str(sw_pos + 0),10,0, 0);
    ++jx;
    menu_set_item( menu, jx, 'Forward  ','',
      '/QK=1/C=32/L=' + str(sw_pos + 1),12, Not(bs), 0);
    ++jx;
    Help_Str = '';
    if(  (Search_Mode)  ) {
      Help_Str = '     ';
    }
    menu_set_item( menu, jx, 'Backward ' ,'',
      '/QK=1/C=44/L=' + str(sw_pos + 1),12, bs, 0);
    ++jx;

    menu_set_item( menu, jx, 'Options','',
      '/W=28/HT=5/C=1/L=' + str( sw_pos + 4),10,0, 0);
    ++jx;
    menu_set_item( menu, jx, 'Case sensitive','',
      '/QK=1/C=2/L=' + str(sw_pos + 5),13, ic, 0);
    ++jx;
    menu_set_item( menu, jx, 'Global search','',
      '/QK=1/C=2/L=' + str(sw_pos + 6),13, gs, 0);
    ++jx;
    menu_set_item( menu, jx, 'Restrict to marked block','',
      '/QK=13/C=2/L=' + str(sw_pos + 7),13, rb, 0);
    ++jx;
    menu_set_item( menu, jx, 'Search all windows','',
      '/QK=12/C=2/L=' + str(sw_pos +8),13, aw, 0);
    ++jx;

    if(  search_mode  ) {
      menu_set_item( menu, jx, 'Mode','',
      '/C=31/W=28/HT=4/L=' + str( sw_pos + 2),10,0, 0);
      ++jx;
      menu_set_item( menu, jx, 'Replace first occurrence','',
      '/C=32/QK=15/L=' + str(sw_pos + 3),12, (smode == 1), 0);
      ++jx;
      menu_set_item( menu, jx, 'Prompt for each replace','',
      '/C=32/QK=1/L=' + str(sw_pos + 4),12,(smode == 2), 0);
      ++jx;
      menu_set_item( menu, jx, 'Replace all','',
      '/C=32/QK=9/L=' + str(sw_pos + 5),12,(smode == 3), 0);
      ++jx;
      menu_set_item( menu, jx, 'Leave cursor at','',
      '/C=31/W=28/HT=3/L=' + str(sw_pos + 6),10,0, 0);
      ++jx;
      menu_set_item( menu, jx, 'End of replace string','',
      '/QK=2/C=32/L=' + str(sw_pos + 7),12, (cs == 0), 0);
      ++jx;
      menu_set_item( menu, jx, 'Start of replace string','',
      '/QK=2/C=32/L=' + str(sw_pos + 8),12, (cs), 0);
      ++jx;
      menu_set_item( menu, jx, '','BT_SR_101','/L=1/C=1/MD=1',30,0, 0);
      ++jx;
    } else {
      menu_set_item( menu, jx, 'Mode','',
      '/C=31/W=28/HT=4/L=' + str( sw_pos + 2),10,0, 0);
      ++jx;
      menu_set_item( menu, jx, 'Stop on first occurrence','',
      '/C=32/QK=3/L=' + str(sw_pos + 3),12,(smode == 1), 0);
      ++jx;
      menu_set_item( menu, jx, 'Prompt for next search','',
      '/C=32/QK=1/L=' + str(sw_pos + 4),12,(smode == 2), 0);
      ++jx;
      menu_set_item( menu, jx, 'List all occurrences','',
      '/C=32/QK=6/L=' + str(sw_pos + 5),12,(smode == 3), 0);
      ++jx;

      menu_set_item( menu, jx, 'List previous occurrences','',
        '/QK=2/C=31/K2=64/R=12/NHT=1/L=' + str(sw_pos + 8) + "/OFF=" +
        str((Global_Str("!SR_LST_WN") == "")),11,0, 0);
      ++jx;
      menu_set_item( menu, jx, '','BT_SR_100','/L=1/C=1/MD=1',30,0, 0);
      ++jx;
    }
    // Changes below by AJH 21DEC94 to add reg exp help button
    menu_set_item( menu, jx, 'Reg Exp Help','MEWHELP^REGEXPHELP',
      '/C=31/M=1/QK=9/L=' + str(sw_pos + 10),11,0, 0);
    ++jx;
    menu_set_item( menu, jx, 'OK','',
      '/C=1/W=10/R=1/L=' + str(sw_pos +10),11,1, 0);
    ++jx;
    menu_set_item( menu, jx, 'Cancel','',
      '/W=10/C=13/R=0/L=' + str(sw_pos +10),11,0, 0);
    ++jx;
    menu_set_item( menu, jx, 'Help','',
      '/W=10/C=48/R=2/L=' + str(sw_pos +10),11,0, 0);
    // End changes AJH 21DEC94

    return_int = menu;
    RM('USERIN^Data_In /HN=1/POSG=@SRPOS@/PRE=SR/S=1/#=' + str( jx ) +
          '/T=' + title_str + '/H=' + parse_str('/H=', mparm_str));
    if(  NOT(swonly) | RETURN_INT  ) {

      help_str = '';
      if(  menu_item_int( menu, tsw_pos + 8, 2 ) == 0  ) {
        help_str = help_str + 'I';
      }
      if(  menu_item_int( menu, tsw_pos + 2, 2 ) == 0  ) {
        help_str = help_str + 'X';
      }
      if(  menu_item_int( menu, tsw_pos + 6, 2 ) != 0  ) {
        help_str = help_str + 'B';
      }
      if(  menu_item_int( menu, tsw_pos + 9, 2 ) != 0  ) {
        help_str = help_str + 'G';
      }
      if(  menu_item_int( menu, tsw_pos + 10, 2 ) != 0  ) {
        help_str = help_str + 'R';
      }
      if(  menu_item_int( menu, tsw_pos + 11, 2 ) != 0  ) {
        help_str = help_str + 'A';
      }
      if(  menu_item_int( menu, tsw_pos + 3, 2 ) != 0  ) {
        help_str = help_str + 'W';
      }
      if(  menu_item_int( menu,  tsw_pos + 14 , 2 ) != 0  ) {
        help_str = help_str + 'P';
      }
      if(  menu_item_int( menu,  tsw_pos + 15 , 2 ) != 0  ) {
        if (search_mode) {
          help_str = help_str + 'N';
        } else {
          help_str = help_str + 'L';
        }
      }
      if(  search_mode  ) {
        if(  menu_item_int( menu, tsw_pos + 18, 2 ) != 0   ) {
          help_str = help_str + 'C';
        }
        if(  NOT(swonly)  ) {
          Set_Global_Str(parse_str('/RPG=', mparm_str), menu_item_str( menu, 2, 2 ));
        }
      }
      Set_Global_Str(parse_str('/SWG=', mparm_str), help_str);
      if(  NOT(swonly)  ) {
        Set_Global_Str(parse_str('/SRG=', mparm_str), menu_item_str( menu, 1, 2 ));
      }

//      if(  return_int == 11  ) {
//        set_global_int('SEARCH_INTR_STYLE', 1 );
//        goto again;
//      }
    }
		menu_delete( menu );
}

macro SEARCH trans2  {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	SEARCH

Description:	Calls S_and_R in search only mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	SET_GLOBAL_INT('SEARCH_MODE',0);
	SET_GLOBAL_INT('REPSEARCH',0);
	RM( 'S_AND_R '+mparm_str);
}

macro S_REPL trans2  {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	S_REPL

Description:	Calls S_and_R in search and replace mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	SET_GLOBAL_INT('SEARCH_MODE',1);
	SET_GLOBAL_INT('REPSEARCH',0);
	RM( 'S_AND_R '+mparm_str );
}

macro REPSRCH trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	S_REPL

Description:	Calls S_and_R in repeat mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Tint, tpb = persistent_blocks;
	persistent_blocks = TRUE;
	push_undo;
	Mark_Pos;
	if(  (Global_Int('SEARCH_MODE'))  ) {
		TInt = XPOS('B',Caps(Global_Str('REPL_SWITCHES')),1);
	} else {
		TInt = XPOS('B',Caps(Global_Str('SWITCHES')),1);
  }

	if(  (TInt)  ) {
		Left;
	} else {
		Right;
		while(  NOT(at_eol) & (cur_char == '|255')  ) {
			right;
		}
	}
	if(  (Global_Str('SEARCH_STR') != '')  ) {
		SET_GLOBAL_INT('REPSEARCH',1);
	}
	RM( 'S_AND_R /NG=1' + mparm_str );

	if(  (return_int > 0) & (global_int('FOUND_COUNT') == 0)  ) {
		Goto_Mark;
		Make_Message('No more occurrences.');
	} else {
		Pop_Mark;
	}
	persistent_blocks = tpb;
	pop_undo;
}


#define DIR_ID    3001
#define FILE_ID   3002
#define ABORT_ID  3003
#define SRCH_ID  3004

int FileSrch ( str ppath[128], mask[13], &root,
               int search_dirs, sm, flags, sub ) Trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:  FILESRCH

Description:  Called by FS to perform the actual multi-file search.

Parameters:		Return_Str = Search_Str
							path    Path(s) to search
							search_dirs        1 = search subdirectories.
							root         Root path to search if no dir is specified in the
													 paths
							sm           Search files in Memory.  If a file is already loaded,
													 then search there instead.
							flags     Search flags

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str  t_search_rec[80] = file_search_rec,
			 path[128]
			 ;

	int  t_attr = file_search_attr,
					 doserror,
					 t_undo_stat,
           found_win = window_id,
           found_win_num = cur_window,
					 jx,
					 pp
					 ;
  int hDlg, h_list;
  struct tmsg msg;


  hDlg = GetActiveWindow ();
	h_list = GetDlgItem(hDlg, 3100);

	if(  sub == 0  ) {
		t_undo_stat = undo_stat;
		refresh = false;
		undo_stat = false;
    SetDlgItemText (hDlg, SRCH_ID,copy(return_str,1, 51) );
    call check_abort;
    return_int = 0;
    pp = 1;
parse_loop:
//		WORKING;
		path = ppath;
		if(  pp < svl(path)  ) {
			jx = xpos( ' ', path, pp );
			if(  jx == 0  ) {
				jx = svl( path ) + 1;
			}
			path = remove_space( copy( path, pp, jx - pp ) );
			pp = jx + 1;
			mask = truncate_path(path);
			path = get_path(path);
			if(  path == ''  ) {
				path = root;
			}
			path = fexpand( path );
      if(  (copy( path, svl(path), 1) != "\\")  ) {
        path = path + "\\";
			}
			call do_search;
			goto parse_loop;
		}
	} else {
		path = ppath;
		call do_search;
	}

	goto exit;


do_search:
	WORKING;
	File_Search_Attr = $37;

	if(  search_dirs  ) {
    doserror = first_file( path + "*.*" );
		while(  doserror == 0  ) {
			call check_abort;
			if(  return_int == -1  ) {
				goto search_exit;
			}
      if(  ((last_file_attr & $10) != 0 & (last_file_name != '.'))
          & (last_file_name != "..")  ) {

          if( filesrch( path + last_file_name + "\\", mask, root, 1, sm, flags, 1 ) == - 1) {
            goto search_exit;
          }
			}
			doserror = next_file;
		}
	}
  SetDlgItemText (hDlg, DIR_ID, path);

	File_Search_Attr = $27;
	doserror = first_file( path + mask );
	if(  doserror == 0  ) {
			search_loop:
				call check_abort;
				if(  return_int == -1  ) {
					goto search_exit;
				}
				error_level = 0;
        SetDlgItemText (hDlg, FILE_ID, last_file_name);
					// Now we are going to do the Search in Memory mode
				if( sm ) {
					if( switch_file( path + last_file_name )) {
						jx = 0;
						mark_pos;
						tof;
						if(find_text( return_str, 0, flags ) ) {
							jx = c_line;
						}
						goto_mark;
            switch_win_id(found_win);
						if( jx > 0 )
								call put_success;
						if( error_level == 1010 )
								goto search_exit;
						goto next_file;
					}
				}
				jx = search_file( path + last_file_name, return_str, flags );
				if(  jx > 0  ) {
					call put_success;
				} else {
					if(  error_level == 1010  ) {
            goto search_exit;
					}
				}
		 next_file:
				doserror = next_file;
				if(  doserror == 0  ) {
					goto search_loop;
				}
		}
Search_exit:
  Ret;


put_success:
  {
    switch_win_id(found_win);
    eof;
    if(c_col > 1)
      down;
    put_line( "FN=" + last_file_name + "LN="  + 'L:' + str(jx) +
     "FP=" + path );
    SendMessage( h_list, WM_SETREDRAW, 0, 0);
    SendMessage( h_list, LB_ADDSTRING, 0, 0 );
    sendmessage( h_list, LB_SETCARETINDEX, c_line - 1, 1);
    SendMessage( h_list, WM_SETREDRAW, 1, 0);
    sendmessage( h_list, WM_ML2_REDRAW,0,0 );
		WORKING;
		ret;
	}

Check_abort:
  while ( PeekMessage( &msg, 0, 0, 0, PM_REMOVE))
  {
    if ( msg.message == WM_KEYDOWN ) {
			if (msg.wparam == VK_ESCAPE) {
        return_int = -1;
        break;
			}
		}

    if ( msg.message == WM_USER )
    {
      if ( msg.wparam == ABORT_ID )
      {
        return_int = -1;
        break;
      }
    }

    if( !IsDialogMessage( hDlg, &msg) )
    {
        Translatemessage( &msg );
        Dispatchmessage ( &msg );
    }
  }
  ret;


Exit:

	if(  sub == 0  ) {
		undo_stat = t_undo_stat;
	}

	file_search_attr = t_attr;
	file_search_rec = t_search_rec;
	return(return_int);
} /* FILESRCH */


macro FS TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: fs

Description:  Multi-File search.  Will prompt for a filespec (wild cards are
							allowed), a search string	and search switches, and (using
							MEFIND.EXE) perform a search through all the files matching the
							filespec, and then put up a list of all the matching files.  The
							user may then select one of the files, and the cursor will
							automatically go the the line where the match was found.

Parameters:		/N=		Skips directly to the filename list, using the last
										set of files found by MEFIND.
							/M=  If > 0 will do search and replace


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
		str  search_str[80], switches_str[10], filespec[80], sstr[80],
					mode_str[15] = '',replace_str[80],
					help_str[30] = MFSRCH_HELPLINK, root[90];
    int  t_win, file_count, str_count, nl, nc, jx, x1, y1, iMenu,
					search_mode = (parse_int('/M=',mparm_str) > 0), menu = menu_create,
					list_window , already_loaded, leave_files_open, flags = 0,
					all_files = 0;
		int  search_dirs, use_reg_exp,
					filespec_item,
					path_item,
					searchdir_item,
					case_item,
					regexp_item,
					memory_item,
					open_item,
					case_sensitive, search_in_mem, result,
				replace_window = 0,
				dialog_start = global_int("!FS_DIALOG_START_" + str(search_mode));
		str  tc[1] , Find_Name[80], bitmap_name[20];

  int line_height = 0,
			font_height = 0,
			font_width = 0,
			dfont = 0,
			hdlg = 0,
			h_list,
			h_dir,
			h_file,
			habort,
			htemp,
			found_win_num,
			dlg_unit_X,
			dlg_unit_Y,
			button_height,
			y,
			h,
      list_only,
      tempx;        //AJH 21DEC94

  struct tmsg msg;


		if (dialog_start < 1) {
			dialog_start = 1;
		}
		t_win = window_id;
		refresh = false;
		mark_pos;
		if(  (c_line == block_line1) &
				(block_stat > 0) & (block_line1 == block_line2)  ) {
			if(  (block_stat == 1)  ) {
				first_word;
				set_global_str('SEARCH_HISTORY0', get_word('') );
			} else {
				set_global_str('SEARCH_HISTORY0', copy(get_line,block_col1, (block_col2 - block_col1) + 1));
			}
		} else {
			right;
			word_left;
			set_global_str('SEARCH_HISTORY0', get_word(word_delimits) );
		}
		goto_mark;

		result = 0;
		set_global_int('MENU_LEVEL', global_int('MENU_LEVEL') + 1 );

		if (search_mode) {
			help_str = MFSRCHREP_HELPLINK;
			switches_str = caps(Global_Str('FRSWITCHES'));
			bitmap_name = "BT_SR_104";
		} else {
			bitmap_name = "BT_SR_103";
			switches_str = caps(Global_Str('FSWITCHES'));
		}

//		use_reg_exp = xpos('R',switches_str, 1) != 0;
//		case_sensitive = xpos('C',switches_str, 1) != 0;

		use_reg_exp = xpos('X',switches_str, 1) == 0;
		case_sensitive = xpos('I',switches_str, 1) == 0;

		search_dirs = xpos('S',switches_str, 1) != 0;
		search_in_mem = xpos('F',switches_str, 1) != 0;
		leave_files_open = xpos('O',switches_str, 1) != 0;
		if (search_mode) {
			switch_window( window_count );
			create_window;
			replace_window = window_id;
			switch_win_id(t_win);
		}


// Mod to handle correct placement of .TMP files
		RM("TMP_FILE_NAME /FN=MEFIND.TMP");
		find_name = Return_Str;

		if(  xpos('/N', caps(mparm_str), 1 )  ) {
			if(  NOT(switch_file(Find_Name))  ) {
				switch_window( window_count );
				create_window;
				window_attr = $80;
				load_file(find_name);
				if(  error_level == 0  ) {
					goto load_find_file;
				}
				file_name = find_name;
				rm('MEERROR^MessageBox /M=No matched file available.');
        goto exit;
			} else {
				goto load_find_file;
			}
		}

		search_str = Global_Str('SEARCH_STR');
		replace_str = Global_Str('REPLACE_STR');

		menu_set_item(menu,1,'Search For:   ',search_str,
			'/QK=1/C=6/W=40/ML=254/HISTORY=SEARCH_HISTORY/L=1',0,0,0);
    iMenu = 3;
		if (search_mode) {
      mode_str = ' and Replace';
			menu_set_item(menu,2,'Replace with: ',replace_str,
				'/QK=1/C=6/W=40/ML=254/HISTORY=REPLACE_HISTORY/L=2',0,0,0);
      ++iMenu;
			filespec = Global_Str('FRFILESPEC');
		} else {
			filespec = Global_Str('FFILESPEC');
		}

		filespec_item = imenu - 1;
		menu_set_item(menu,filespec_item,'Filespec:     ',filespec,
			'/QK=1/C=6/W=40/ML=80/HISTORY=FILESPEC_HISTORY/L=' + str(filespec_item),0,0,0);

    nl = 5;
		path_item = imenu;
		if (search_mode) {
    	menu_set_item(menu,path_item,'Starting path:',global_str('FSEARCH_REPL_PATH'),
      	'/HISTORY=FSPATH_HISTORY/QK=10/C=6/W=40/ML=80/L=' + str(++iMenu - 1),0,0,0);
		} else {
    	menu_set_item(menu,path_item,'Starting path:',global_str('FSEARCH_PATH'),
      	'/HISTORY=FSPATH_HISTORY/QK=10/C=6/W=40/ML=80/L=' + str(++iMenu - 1),0,0,0);
		}
    if ( search_mode )
      ++nl;
    menu_set_item(menu,iMenu,'Options','',
      '/C=1/W=27/HT=' + str(nl) + '/L=' + str(++iMenu),10,0,0);
		searchdir_item = imenu;
    menu_set_item(menu,searchdir_item,'Search sub-directories','',
      '/QK=12/C=2/L=' + str(++iMenu),13,search_dirs,0);
		case_item = imenu;
    menu_set_item(menu,case_item,'Case Sensitive','',
      '/QK=1/C=2/L=' + str(++iMenu),13,case_sensitive,0);
		regexp_item = imenu;
    menu_set_item(menu,regexp_item,'Regular Expressions','',
      '/QK=9/C=2/L=' + str(++iMenu),13,use_reg_exp,0);
		memory_item = imenu;
    menu_set_item(menu,memory_item,'Search files in memory','',
      '/QK=17/C=2/L=' + str(++iMenu),13,search_in_mem,0);
		if (search_mode) {
			open_item = imenu;
      menu_set_item(menu,open_item,'Leave all files open','',
        '/QK=1/C=2/L=' + str(++iMenu),13,leave_files_open,0);
    }
    else
    {
    }

    // Changes below by AJH 21DEC94 to add reg exp help button
    tempx = iMenu + 2;
    menu_set_item( menu, iMenu++, 'OK','',
      '/C=1/W=10/R=1/L=' + str(tempx),11,1, 0);
    menu_set_item( menu, iMenu++, 'Cancel','',
      '/W=10/C=13/R=0/L=' + str(tempx),11,0, 0);
    menu_set_item( menu, iMenu++, 'Reg Exp Help','MEWHELP^REGEXPHELP',
      '/C=34/QK=9/M=1/L=' + str(tempx),11,0, 0);
    menu_set_item( menu, iMenu++, 'Help','',
      '/W=10/C=51/R=2/L=' + str(tempx),11,0, 0);
    // End of changes by AJH 21DEC94

    menu_set_item( menu, iMenu, '',bitmap_name,'/L=1/C=1/MD=1',30,0, 0);

		return_int = menu;
		RM('UserIn^Data_In /HN=1/POSG=@FSPOS@/H=' + help_str +
      '/S=' + str(dialog_start) + '/#=' + str(iMenu) +
      '/T=Multiple File Search' + mode_str);
		set_global_str('SEARCH_HISTORY0', '' );
		filespec = menu_item_str(menu,filespec_item,2);
		search_str = menu_item_str(menu,1,2);
		if (search_mode) {
			replace_str = menu_item_str(menu,2,2);
			set_Global_Str('REPLACE_STR', replace_str);
			set_Global_Str('FRFILESPEC', filespec);
		} else {
			set_Global_Str('FFILESPEC', filespec);
		}
		SET_GLOBAL_STR('FLAST_CHOICE', '');
		set_Global_Str('SEARCH_STR', search_str);
		set_Global_Str('FSEARCH_STR', search_str);

		search_dirs = menu_item_int(menu,searchdir_item,2);
		case_sensitive = menu_item_int(menu,case_item,2);
		use_reg_exp = menu_item_int(menu,regexp_item,2);
		search_in_mem = menu_item_int(menu,memory_item,2);
		if (search_mode) {
			leave_files_open = menu_item_int(menu,open_item,2);
			set_global_str('FSEARCH_REPL_PATH',menu_item_str(menu,path_Item,2));
		} else
			set_global_str('FSEARCH_PATH',menu_item_str(menu,path_item,2));

		switches_str = '';
		reg_exp_stat = use_reg_exp;
		ignore_case = ( case_sensitive == 0 );

		if (!reg_exp_stat) {
			switches_str = 'X';
		}
		if (ignore_case) {
			switches_str = switches_str + 'I';
		}

		if(reg_exp_stat)
		{
			if( reg_exp_style )
				flags |= _RegExp;
			else
				flags |= _OldExp;
		}
		if(!ignore_case)
			flags |= _CaseSensitive;

		if(  search_dirs  ) {
			switches_str = switches_str + 'S';
		}
		if(  search_in_mem  ) {
			switches_str = switches_str + 'F';
		}
		if(  leave_files_open  ) {
			switches_str = switches_str + 'O';
		}
		if(  return_int  ) {
			working;
			y1 = 5;
			if(  switch_file(Find_Name)  ) {
				erase_window;
			} else {
				switch_window( window_count );
				create_window;
				window_attr = $80;
			}
			file_name = find_name;
			return_str = search_str;
			if (search_mode)
			{
				root = global_str('FSEARCH_REPL_PATH');
			}
			else
			{
				root = global_str('FSEARCH_PATH');
			}
			SET_GLOBAL_INT("@FSEARCH_ABORTED",0);

	list_only = false;
	Call CREATE_FS_DLG;

			filesrch( filespec, "",root, search_dirs, search_in_mem, flags, 0 );

		DestroyWindow(habort); // get rid of abort button
		SetWindowText(h_dir,"");
		SetWindowText(h_file,"");

			set_Global_Str('SEARCH_STR', search_str);
			if (search_mode) {
				set_global_str("FRSWITCHES","P" + switches_str);
				SET_GLOBAL_INT('SEARCH_MODE',1);
			} else {
				if(  (xpos( 'P', global_str('SWITCHES'), 1 ))  ) {
					sstr = sstr + 'P';
				} else if(  (xpos( 'N', global_str('SWITCHES'), 1 ))  ) {
					sstr = sstr + 'N';
				}
				set_global_str("FSWITCHES",switches_str);
				SET_GLOBAL_INT('SEARCH_MODE',0);
			}


			if(  (error_level != 0)  ) {
		    Destroy_Mew_Dlg (hDlg);
				goto exitx;
			}
			if(  (return_int == -1)  ) {
				SET_GLOBAL_INT("@FSEARCH_ABORTED",1);
			}
			tof;
	 load_find_file:
	 no_create:
      refresh = false;
			window_attr = window_attr | $81;  /* make it hidden and invisible */
			if(  at_eof  ) {
				eof;
				goto_col(1);
				if(  at_eof  ) {
					RM('MEERROR^MESSAGEBOX /B=2/T=Multiple File Search/M=No matched files found');
			    Destroy_Mew_Dlg (hDlg);
					goto exitx;
				}
			}
			if(  file_changed  ) {
				save_file;
			}
			goto_col(1);
			list_window = window_id;
			if (Search_Mode) {
				if (hdlg) {
			  	Destroy_Mew_Dlg (hDlg);
				}
			} else {
/*
        int dlg;
				str dlg_title[50];
        DlgCreate( dlg );
        DlgAddCtrl( dlg, DLG_PushButton, "Ok", 1,1,8,0,100,DLGF_DefButton,"/R=1");
        DlgAddCtrl( dlg, DLG_PushButton, "Cancel", 1,3,8,0,101,0,"/R=0");
        DlgAddCtrl( dlg, DLG_PushButton, "&Help", 1,6,8,0,103,0,"/R=2");
        //
				Dlg_Title = "Matched Files";
				if (GLOBAL_INT("@FSEARCH_ABORTED")) {
					Dlg_Title = "Matched Files (incomplete search)";
				}
        DlgAddCtrl( dlg, DLG_ListBox, "CM=/W=15/H=15/T=4FN=/IS=1/W=17LN=/W=12FP=/W=30", 12,1,50,0,1000,0,"/INCO=1/WIN=" + str(cur_window));
        return_int = DlgExecute( dlg, 1000, dlg_title, "","",0);
        DlgKill(  dlg );
*/
	if (hdlg == 0) {
// if we are doing a list previous, we need to create the dialog
		list_only = true;
		Call CREATE_FS_DLG;
  	SetDlgItemText (hDlg, SRCH_ID,Global_Str('FSEARCH_STR'));

	}
// change search status dialog box into a user input dialog box
  //  SendMessage(h_list, LB_SETCARETINDEX, global_int('@FLAST_CHOICE') - 1, 1);
  //  sendmessage( h_list, LB_SETSEL, true, global_int('@FLAST_CHOICE') - 1);
  //  sendmessage( h_list, WM_ML2_REDRAW,0,0 );
  	EnableWindow (h_list, TRUE);

		Str Dlg_Title[50] = "Multiple File Search";
		if (GLOBAL_INT("@FSEARCH_ABORTED")) {
			Dlg_Title = Dlg_title + " (incomplete search)";
		}
		SetWindowText(hDlg,Dlg_Title);

  	Create_MEW_Ctrl( "BUTTON", "&Select",
									BS_PUSHBUTTON | BS_DEFPUSHBUTTON | WS_TABSTOP,
                  5, y, 10 * font_width, button_height,
                  hDlg, 1001, app_handle, 0);

		y = y + button_height + (dlg_unit_y * 3);
  	Create_MEW_Ctrl( "BUTTON", "Cancel",
									BS_PUSHBUTTON | WS_TABSTOP,
                  5, Y, 10 * font_width, button_height,
                  hDlg, 1002, app_handle, 0);

		y = y + button_height + (dlg_unit_y * 8);
  	Create_MEW_Ctrl( "BUTTON", "&Help",
									BS_PUSHBUTTON | WS_TABSTOP,
                  5, Y, 10 * font_width, button_height,
                  hDlg, 1003, app_handle, 0);

    int maxlength = 0, j,listcount = SendDlgItemMessage( hdlg, 3100, LB_GETCOUNT, 0, 0 );

    mark_pos;
    tof;
    while ( !at_eof ) {
      if ( length(parse_str("FP=", get_line) ) > maxlength) {
        maxlength = length(parse_str("FP=", get_line));
      }
      down;
    }
    goto_mark;
    maxlength = maxlength + 42;
    SendDlgItemMessage (hDlg, 3100, LB_SetHorizontalExt, maxlength * font_width, 0);

    SetFocus (h_list);

   // goto_line( global_int('@FLAST_CHOICE'));
    int tfl = global_int('@FLAST_CHOICE') - 1;
    if ( tfl < 0 )
    {
      tfl = 0;
    }
    SendDlgItemMessage(hdlg, 3100, WM_ML2_SETCARET, 0, tfl);
//    SendDlgItemMessage(hdlg, 3100, LB_SETCARETINDEX, global_int('@FLAST_CHOICE') - 1, 1);
 //   SendDlgItemMessage(hdlg, 3100, LB_SETSEL, 2, 1);
  //  sendmessage( h_list, LB_SETSEL, true, global_int('@FLAST_CHOICE') - 1);
   // sendmessage( h_list, WM_ML2_REDRAW,0,0 );
	Return_int = 0;
	kloop:
        if (getmessage( &msg,0,0,0)) {
          if (msg.message == wm_user) {
            switch( msg.wparam ) {
              case 998 :
              case 1 :
              case 1001 :
                int firsttime = 1;
                for ( j=0; j<listcount; ++j ) {
                  if ( SendMessage (GetDlgItem(hdlg, 3100), LB_GETSEL, j, 0)) {
                    goto_line (j+1);
                    return_int = 1;
                    call replace_load;
                    if ( firsttime ) {
                      t_win = window_id;
                      firsttime = 0;
                    }
                    switch_window(found_win_num);
                  }
                }
                return_int = 0;
                goto kdone;

              case 2 :
              case 1002 :

                goto kdone;
							case 1003 :
                MewHelp_Context (); // (str(hLIST_FILES_FROM_LAS));
								return_int = 0;
								break;
            }
          } else if (msg.message == WM_SYSCOMMAND) {
            if (msg.wparam == SC_CLOSE) {
              goto KDONE;
            }
          }
          if (!IsDialogMessage(hdlg, &msg)) {
              translatemessage( &msg );
              dispatchmessage( &msg );
	 				}
				}
        goto kloop;
kdone:
        Set_Global_Int( '@FLAST_CHOICE',SendDlgItemMessage(hdlg, 3100, LB_GETCARETINDEX,0, 0 ) + 1 );

			  Destroy_Mew_Dlg (hDlg);
        switch_window(found_win_num);

				window_attr = window_attr | $81;  /* make it hidden and invisible */
				if(  return_int != 1  ) {
					switch_win_id(t_win);
					goto exit;
				}
			}

REPLACE_LOAD:
			already_loaded = 0;
			result = 1;
			Goto_Col(1);
      if(!parse_int("CM=", get_line) )
      {
         put_line( "CM=1" + get_line );
      }
			file_changed = false;

      return_str = fexpand(  parse_str("FP=", get_line) +parse_str("FN=", get_line));
      nl = parse_int("LN=", get_line);
   //   set_global_int('@FLAST_CHOICE', c_line);
			if(  switch_file( return_str )  ) {
				already_loaded = 1;
				rm("Select_Window");
				make_message( return_str + ' already loaded.');
				tof;
				goto no_load;
			}
			if (search_mode) {
				switch_win_id( replace_window );
        make_window_visible (1);
				RM('LdFiles /CW=' + str(leave_files_open));
			} else {
				switch_win_id( t_win );
				RM('LdFiles /CW=2');
			}

			if(  error_level == 0  ) {
        Make_Message('"' + File_Name + '" loaded.');
no_load:
				if (leave_files_open)
					t_win = window_id;

				down; down; down; down;
				goto_line( nl );
				if(  format_stat  ) {
					up;
				}
				goto_col( 1 );
				left;
				reg_exp_stat = (XPos('X',switches_str,1) == 0);
				ignore_case = XPos('I',switches_str,1);
				if(!XPos('X',switches_str,1))
				{
					if( reg_exp_style )
						flags |= _RegExp;
					else
						flags |= _OldExp;
				}
				if(!XPos('I',switches_str,1))
					flags |= _CaseSensitive;

				if (search_mode) {
					SET_GLOBAL_INT('REPSEARCH',1);

          RM( 'S_AND_R /FR=1/NG=1');
/* Return_Int can have 3 values:
		0 = Normal s/r occurred
		1 = Non-Stop all files
	 -1 = Abort remaining files
*/
					if ((return_int == 1) && (!all_files)) {
						all_files = 1;
						set_global_str('FRSWITCHES',global_str('FRSWITCHES') + "N");
					}
					if (!already_loaded) {
						if (file_changed) {
							save_file;
						}
					}
          refresh = false;
					switch_win_id(list_window);
					down;
					goto_col(1);
					if ((!at_eof) && (return_int != -1)) {
						goto REPLACE_LOAD;
					}
					make_message('');
					switch_win_id(t_win);
				} else
				{
					find_text(global_str('FSearch_Str'),0, flags);
				}
				reg_exp_stat = true;
			} else {
				switch_win_id(t_win);
			}
      if ( !SEARCH_MODE )
        ret;
		}
exit:
	if(  error_level != 0  ) {
exitx:
		switch_win_id(t_win);
	}
	t_win = window_id;
	if (switch_win_id(replace_window)) {
		delete_window;
		switch_win_id(t_win);
	}
	menu_delete(menu);
	set_global_int('MENU_LEVEL', global_int('MENU_LEVEL') - 1 );
	return_int = result;
	update_status_line;

	GOTO FINAL_EXIT;

// ******************SUBROUTINES
CREATE_FS_DLG:
	int list_count = 0,
			bitmap_offset,
			dc, true_font_height,
			blackframe_offset = 3;

	struct TTEXTMETRIC tm;

 	found_win_num = cur_window;
  hDlg = Create_Mew_Dlg ('Searching Files', "", frame_handle, 0);
  Get_MEW_Dlg_Metrics( hDlg, line_height, font_height, font_width, dfont );

  dc = GetDc( hdlg );
  Selectobject( dc, dfont );

	GetTextMetrics(dc, &tm);
	true_font_height =
			tm.tmHeight +
			tm.tmExternalLeading
			;

	ReleaseDC(hdlg,dc);
//	DeleteObject(dfont);  for some reason, deleteobject screws up the dialog font.


	bitmap_offset = 13 * font_width;
// This is the formula used in DIALOG.S for default button height
  button_height = ((DLG_DefBtnHeight * font_height) /8) + 1;
  y  = 5 + blackframe_offset;
  h  = font_height + 4;

	htemp = GetDialogBaseUnits();
	dlg_unit_X = (htemp & 0xffff) / 4;
	dlg_unit_y = (htemp >> 16) / 8;

  BuildMEWButton(hdlg, 0, bitmap_name, 0,
						MBCS_TRANSPARENT | MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
						0, font_width * 4, y + h, 0, 0);

  hTemp = Create_MEW_Ctrl( "STATIC", "Search expression:", 0,
                  bitmap_offset + 5, y, 25 * font_width, h,
                  hDlg, 0, app_handle, 0);


  hTemp = Create_MEW_Ctrl( "STATIC", "", ss_blackframe | ss_left,
                  bitmap_offset + 4 + (20 * font_width), y - blackframe_offset, 30 * font_width + (blackframe_offset * 2), h + (blackframe_offset * 2),
                  hDlg, 0, app_handle, 0);

/*
  hTemp = Create_MEW_Ctrl( "STATIC", "", 0,
                  bitmap_offset + 5 + (20 * font_width), y, 30 * font_width, h,
                  hDlg, SRCH_ID, app_handle, 0);
*/
  hTemp = Create_MEW_Ctrl( "STATIC", "", 0,
                  bitmap_offset + 4 + (blackframe_offset) + (20 * font_width), (y - blackframe_offset) + ((h + 2) / 2) - (true_font_height / 2), 30 * font_width, h,
                  hDlg, SRCH_ID, app_handle, 0);
  //EnableWindow (hTemp, FALSE);

	if (!list_only) {
	  y = Y + line_height + (blackframe_offset * 2);

	  hTemp= Create_MEW_Ctrl( "STATIC", "In Directory:", 0,
	                  bitmap_offset + 5, y, 20 * font_width, h,
	                  hDlg, 0, app_handle, 0);

	  hTemp= Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
	                  bitmap_offset + 4 + (20 * font_width), y - blackframe_offset, 30 * font_width + (blackframe_offset * 2), h + (blackframe_offset * 2),
	                  hDlg, 0, app_handle, 0);
	  h_dir = Create_MEW_Ctrl( "STATIC", "", 0,
	                  bitmap_offset + 4 + (blackframe_offset) + (20 * font_width), (y - blackframe_offset) + ((h + 2) / 2) - (true_font_height / 2), 30 * font_width, h,
	                  hDlg, DIR_ID, app_handle, 0);
	  y = Y + line_height + (blackframe_offset * 2);


	  hTemp = Create_MEW_Ctrl( "STATIC", "In File:", 0,
	                  bitmap_offset + 5, y, 10 * font_width, h,
	                  hDlg, 0, app_handle, 0);

	  hTemp = Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
	                  bitmap_offset + 4 + (20 * font_width), y - blackframe_offset, 30 * font_width + (blackframe_offset * 2), h + (blackframe_offset * 2),
	                  hDlg, 0, app_handle, 0);

	  h_file = Create_MEW_Ctrl( "STATIC", "", 0,
	                  bitmap_offset + 4 + (blackframe_offset) + (20 * font_width), (y - blackframe_offset) + ((h + 2) / 2) - (true_font_height / 2), 30 * font_width, h,
	                  hDlg, FILE_ID, app_handle, 0);
	}
  y += line_height;
  y += line_height;

	if (!list_only) {
	  habort = Create_MEW_Ctrl( "BUTTON", "&Abort",
										BS_PUSHBUTTON | BS_DEFPUSHBUTTON | WS_TABSTOP,
	                  5, y + line_height, 10 * font_width, button_height,
	                  hDlg, ABORT_ID, app_handle, 0);
	  SetFocus (habort);
	}

  hTemp= Create_MEW_Ctrl( "BUTTON", "Matched files", BS_GROUPBOX,
                  (13 * font_width),
									y,
									(60 * font_width) + 10,
									(h * 15) + 5 + line_height,
                  hDlg, 0, app_handle, 0);
  y += line_height;
	if (list_only) {
		eof;
		if (c_col == 1) {
			up;
		}
		list_count = c_line;
	}

  h_list =
    ListBoxCreate( found_win_num,          // The edit buffer/window number
                   1,                    // The starting line in the buffer
                   list_count,          // The number of lines
                   5 + (13 * font_width),
                   y,
                   60 * font_width,
                   h * 15,
                   3100,                   // Ctrl id
                   _LB_FLAG_HSCROLL | _LB_FLAG_AUTOWIDTH |
                   _LB_FLAG_EXTENDEDSEL
                    | _LB_FLAG_INCSEARCH ,    // Flag bits. See _LB_FLAG_xxxx
                   2,                     // Field number to use for  inc search
                   hDlg,              // Parent window
                   "CM=/W=15/H=15/T=4FN=/IS=1/W=17LN=/W=12FP=/W=30"// display string
                   );
  EnableWindow (h_list, FALSE);



  EnableWindow      ( hDlg, TRUE );
  BringWindowToTop  ( hDlg );
  ShowWindow        ( hDlg, TRUE );

	RET;
// ****************** END SUBROUTINES

FINAL_EXIT:
}

/************************************************************************

Module Name:  INC_SRCH.S

Description:  Incremental Search such as in Emacs and such.

Creation Date:  02-19-93 04:07pm
 MNB modified to make this usable for MEW 09-09-94

Key Assignments:		<Esc> - cancels search and returns cursor to
														original position prior to the search.
									 <AltP> - searches backwards (previous)
									 <AltN> - searches for next occurrence
  						<Backspace> - removes the last char in the search
							  						string and searches for the new string
									<AltW> - performs a word search
									<AltC> - performs case sensitive searhing

************************************************************************/
macro incsrch {

	int
	t_reg_exp_Stat = reg_exp_Stat, // Save system vars so we can restore
	t_ignore_case = ignore_case,  // them to their original state on exit
	t_refresh = refresh,
	orig_line, tp, New_line_Num, newline,
	backward = parse_int('/BWD=', mparm_str),
	valid_key, passed_vk, case_sensitive = 0;

	str search_str = "",
	mstr, word_srch, bwd, cs;

	struct TMsg msg;

	if ( backward != 0 )
		backward = _backward;
	reg_exp_stat = false;
	ignore_case = true;
	mark_pos;

	while ( GetMessage(&msg, 0, 0, 0)) {
		redraw;
		orig_line = C_line;
		make_message(Bwd+cs+'Inc-Srch '+word_srch+'"'+search_str+'" '+mstr);
		newline = 0;
		refresh = false;
		if ( ((msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& (valid_key == 0) ) {
      PostMessage( frame_handle, WM_KEYDOWN, passed_vk, 0 );
			break;
		}
		if ( (msg.message == WM_SYSKEYDOWN) || (msg.message == WM_KEYDOWN) )
		{
      if ( msg.wparam == VK_Capital )
      {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        goto again;
      }
			if (msg.wparam == VK_Back) {
				valid_key = 1;
				search_str = str_del(search_str, svl(search_str), 1);
				goto search_only;
			} else
				valid_key = 0;
			if ( msg.wparam == 27 ) {
				break;
			}
			if ( (msg.wparam == VK_SHIFT) || (msg.wparam == VK_CONTROL) ||
					 (msg.wparam == VK_MENU) )	{
				valid_key = 1;
				goto again;
			} else
				valid_key = 0;

			if ( (msg.wparam == 87) && (msg.message == WM_SYSKEYDOWN) ) {  //Alt W key
				valid_key = 1;
				if ( global_int('Inc_Word_Srch') ) {
					set_global_int('Inc_Word_Srch', 0);
					word_srch = "";
				} else {
					set_global_int('Inc_Word_Srch', 1);
					word_srch = "Word ";
					if ( search_str != '' )
						goto search_only;
				}
			} else if ( (msg.wparam == 67) && (msg.message == WM_SYSKEYDOWN) ) {
				valid_key = 1;
				if ( case_sensitive ) {
					case_sensitive = 0;
					ignore_case = true;
					cs = '';
				} else {
					case_sensitive = _CaseSensitive;
					ignore_case = false;
					cs = "Case ";
					if ( search_str  != '' )
						goto search_only;
				}
			} else if ( (msg.wparam == 78) && (msg.message == WM_SYSKEYDOWN)) { //Next occ.
				valid_key = 1;
				right;
				backward = 0;
				Bwd = "";
				mark_pos;
				if ( global_int('Inc_Word_Srch' ) ){
					return_str = search_str;
					rm('srch_across_line');
					if ( return_int ) {
						pop_mark;
						call highlight_find;
						mstr = '';
					} else {
						goto_mark;
						left;
						find_text(search_str, 0, case_sensitive);
						call highlight_find;
						mstr = ' String not found';
						rm('MEERROR^BEEPS /C=2');
					}
				} else {
					if ( find_text(search_str,0,case_sensitive) ) {
						pop_mark;
						call highlight_find;
						mstr = '';
					} else {
						goto_mark;
						left;
						rm('MEERROR^BEEPS /C=2');
						mstr = ' String not found';
						find_text(search_str,0,case_sensitive);
						call highlight_find;
					}
				}
			} else if ( (msg.wparam == 80) && (msg.message == WM_SYSKEYDOWN) ){      // PageUp key?
				valid_key = 1;
				left;
				backward = _backward;
				Bwd = "Bwd ";
				mark_pos;
				if ( global_int('Inc_Word_Srch') ) {
					return_str = search_str;
					rm('srch_across_line /B=1');
					if ( return_int ) {
						pop_mark;
						call highlight_find;
						mstr = '';
					} else {
						goto_mark;
						right;
						find_text(search_str, 0, case_sensitive);
						rm('MEERROR^BEEPS /C=2');
						call highlight_find;
						mstr = ' String not found';
					}
				} else {
					if (find_text(search_str,0, _backward | case_sensitive)) {
						pop_mark;
						call highlight_find;
						mstr = '';
					} else {
						goto_mark;
						right;
						rm('MEERROR^BEEPS /C=2');
						find_text(search_str,0,case_sensitive);
						call highlight_find;
						mstr = ' String not found';
					}
	/*
	 * otherwise seacrh for previous search string
	 */
		  	}
			} else
				valid_key = 0;
		}
		TranslateMessage(&msg);
		passed_vk = msg.wparam;
		if ( msg.message == WM_CHAR ) {
			valid_key = 1;
/*
* All alphanumeric keys are added to the search string,
* but only if the new search string finds something.
*/
			str jx = char(msg.wparam);
			search_str = search_str + jx;
search_only:
			if ( global_int('Inc_Word_Srch') ) {
				return_str = search_str;
				mark_pos;
				rm('srch_across_line /B=' + str(backward));
				if ( return_int ) {
					pop_mark;
					call highlight_find;
					jx = '';
					mstr = "";
				} else {
					goto_mark;
					refresh = true;
					rm('meerror^beeps /C=2');
					mstr = ' String not found';
				}
			} else {
				mark_pos;
				if (find_text(search_str,0, backward | case_sensitive)) {
					pop_mark;
					call highlight_find;
					jx = '';
					mstr = "";
				} else {
					goto_mark;
					refresh = true;
					rm("MEERROR^BEEPS /C=2");
					mstr = ' String not found';
				}
			}
		}
again:
	}
	if (msg.wparam == 27) {	      // Cancel and return cursor to original
		goto_mark;									// position if ESC is pressed
		redraw;
	} else
		pop_mark;

	reg_exp_stat = t_reg_exp_stat; // Restore system variables
	ignore_case = t_ignore_case;
	refresh = t_refresh;

	make_message(""); // Erase prompt
	goto done;


/*
 * These subroutines were swiped from MEUTIL2 and modified a bit.
 */
highlight_find:
	if(  c_line > orig_line  ) {
		if(  (c_line - orig_line) <= (win_CHeight - c_row)  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				down;
			}
		} else {
			call Center_line;
		}
	} else if (newline == 0) {
		if(  (orig_line - c_line) <= (win_CHeight - (win_CHeight - c_row))  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				up;
			}
		} else {
			call Center_line;
		}
	}
	refresh = true;
	tp = c_col;
	goto_col(search_end_col);
	goto_col(tp);
	search_highlight = buffer_id;
	ret;

/* will center the selected line on the screen if possible */
Center_line:
	New_line_Num = C_line;
	tp = c_col;

	while ((C_Row > (win_CHeight / 2))) {
	Up;
	}
	while ((C_Row < (win_CHeight / 2))) {
	Down;
	}
	Goto_line(New_line_Num);
	goto_col(tp);
	ret;

done:
/* Comment out the line below if you want the status of Word search
 	 to be restored */
	set_global_int('Inc_Word_Srch',0);
}
