macro_file mewsetup;
// $Header: /MEWIN/SRC/MEWSETUP.S 94    2/06/95 12:47p Manny $


#include winsmall.sh
#include metools.sh
#include fonts.sh
#include winexec.sh
#include dialog.sh
#include tbwin.sh
#include exit.sh
#include db.sh
#include mew.sh

#define SRCHDEF_HELPLINK      "SEARCH DEFAULTS"
#define SRCHREPDEF_HELPLINK   "SEARCH AND REPLACE DEFAULTS"
#define FNAMEEXT_HELPLINK     "FILENAME EXTENSIONS SETUP"
#define MAINSRCHDEF_HELPLINK  "SEARCH DEFAULTS, CONFIGURING"
#define MFSRCHDEF_HELPLINK    "MULTI-FILE SEARCH DEFAULTS"
#define MSRCHREPDEF_HELPLINK  "MULTI-FILE SEARCH AND REPLACE DEFAULTS"
#define BACKTMPAUTO_HELPLINK  "BACKUPS/TEMP FILES/AUTOSAVE"
#define MEMUSE_HELPLINK       "MEMORY USAGE"
#define USERINTR_HELPLINK     "USER INTERFACE, CONFIGURING"
#define CUSTOMIZE_HELPLINK    "CUSTOMIZE DIALOG BOX"
#define EDITSETT_HELPLINK     "EDIT SETTINGS"


global
{
	int _reset_screen;
}




void CUSTOMIZE()
{
  // int cpux = cpu;
	int start_num = 17, tw = window_id, tr = refresh;
  int tundo = undo_stat, bw = 30, bh = DLG_Units | DLG_Units_Line_Half;

  int dlg;

	undo_stat = false;
	refresh = false;

  DlgCreate(dlg);

  rm("CmdSetMgr /M=1");


 // DlgAddCtrl( dlg, DLG_GreyFrame, "", 38,DLG_Units | DLG_Units_Per_Line,34,
 //       DLG_Units | (DLG_Units_Per_Line + DLG_Units_Per_Line + DLG_Units_QLine),911,0,"" );

  DlgAddCtrl( dlg, DLG_BlackFrame, "", 1,DLG_Units | 5,34,DLG_Units | ((Dlg_Units_Per_Line * 8) + DLG_Units_HLine),901,0,"" );
  DlgAddctrl( dlg, DLG_Static, "&Command set:", DLG_PosOffset + 1, DLG_PosOffset, 0,
      0, 910, 0, "" );
  DlgAddCtrl( dlg, DLG_MacroBtnStr, return_str, DLG_PosOffset, DLG_PosOffset | 1, 31, 0, 2400, 0, "/M=CmdSetMgr" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_106 &Keys / Commands...", DLG_PosOffset,DLG_PosOffset | DLG_Units | DLG_Units_Line_Half,bw,bh, 1401, 0, "/M=CommandMapEdit" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_107 &Menus...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1409, 0, "/M=Menus^MenuEditor" );

  //DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_114 &Right button menu...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1411, 0, "/M=SetupContextMenu" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_GN_111 &Toolbars/boxes...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1410, 0, "/M=TBMGR" );





  bw = 24;
/*
  DlgAddCtrl( dlg, DLG_BlackFrame, "",1,DLG_Units | 5,59,DLG_Units | (DLG_Units_Line_Half + 3),900,0,"" );
  DlgAddCtrl( dlg, DLG_Static, "Serial #: "+Global_Str('@ME_SERIAL#'),DLG_PosOffset + 1,DLG_PosOffset, 0, 0, 1300, 0,  "");
  if(user_id  != "" )
  {
    return_str = "  User ID: " + user_id;
  }
  else
  {
    return_str = "";
  }
  DlgAddCtrl( dlg, DLG_Static, "Licensed users: "+str(max_user_count) + return_str, DLG_PosOffset + 36, DLG_PosOffset,0,0, 1301, 0, "" );
  DlgAddCtrl( dlg, DLG_Static, "ME Path: " + me_path , 2,DLG_PosOffset + 1,0,0, 1302,0, "" );
 */
  DlgAddCtrl( dlg, DLG_BlackFrame, "", 38,DLG_Units | 5,53,DLG_Units | ((Dlg_Units_Per_Line * 14)),941,0,"" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_101 &Edit settings...", DLG_PosOffset + 1,DLG_PosOffset,bw,bh, 1001, 0, "/M=SETEDIT" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_103 Memor&y, program execution...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1002, 0, "/M=SETMEMORY" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SR_100 &Search defaults...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1006, 0, "/M=SrchSet" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_FL_102 &Backups, temp files, autosave...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1005, 0, "/M=SetMEPaths" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_104 Filename e&xtensions...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1011, 0, "/M=Extens" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_ED_115 S&pellcheck...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1031, 0, "/M=Spell^SpellSetup" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_TAGS_100 Ta&gs...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1033, 0, "/M=METAGS^TAG_CONFIGURE" );



  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_100 &User interface...", DLG_PosOffset + bw + 2,DLG_Units | 5,bw,bh, 1003, 0, "/M=INTERFACESETUP" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_102 &Fonts...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1004, 0, "/M=SetupDefFonts" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_105 C&olors...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1007, 0, "/M=SetupDefColors" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_FL_114 File comp&are...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1008, 0, "/M=FC^FC_CONFIG" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_108 &Languages...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1012, 0, "/M=Lang_Menu /LM=0" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_VCS_100 &VCS interface...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1030, 0, "/M=VCS^VCSCONFIGURE" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_GN_121 Sess&ion manager...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1032, 0, "/M=SESSMGR^SM_CONFIGURE" );


  DlgAddCtrl( dlg, DLG_PushButton, "Close",
        1, DLG_PosOffset | 1
            , DLG_StanBtnWidth, 0, 2101, 0, "/R=0");

  DlgAddCtrl( dlg, DLG_PushButton, "&Help",
        20, DLG_PosOffset, DLG_StanBtnWidth, 0, 2102, 0, "/R=2");

  DlgExecute( dlg, 2101, "Customize",	CUSTOMIZE_HELPLINK, "" , 0 );

  DlgKill(dlg);

  if(global_int("SETUP_CHANGED"))
  {
    rm("SETSAVE");
  }

	switch_win_id(tw);
	undo_stat = tundo;
	refresh = tr;
	return();

}




global
{
  str CmdSetMgrTmp "~CMDSETMGR_TMP";
  str Csm_Copied "@CSM_CopiedRec";
}

void CmdSetMgr( int m = parse_int("/M=", mparm_str ))
{
  int tw = window_id;
  if( !LocateDbPage( "MECONFIG", "CMDMAPLIST.DB", false ) )
  {
    if( LocateDbPage( "MECONFIG", "CMDMAPLIST.DB", true ) )
    {
      eol;
      cr;
      put_line( "NAME=Default MEW command mapFN=WCMDMAP" );
    }
  }
  switch_win_id(tw);
  switch ( m )
  {
    case 0 :
        str fstr = return_str;
        if(db( "MECONFIG", "CMDMAPLIST.DB", "MEWHDRS.DB", "CMDMAPLIST.HDR", "Command Set Manager",
                "Command Set Manager","~CMDSETMGR_TMP", 1, "/PRE=@CSM_/NCP=1/NDH=1/MOVE=1/H=" + str(0) +
                "/FV=" + fstr + "/EMAC=CMDSETMGR_EDIT"  ))
        {

          if( LocateDbPage( wcmdmapname, "WCMDMAP.DB", false ) )
          {
            if(file_changed)
              save_file;
            delete_window;
          }

          wcmdmapname = parse_str( "FN=", CmdSetMgrTmp );

          RebuildWcmds();

          Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
          return_str = parse_str("NAME=", CmdSetMgrTmp );
        }
        else
        {
          call get_cmdset;
          return_int = 1;
        }
        CmdSetMgrTmp = "";
        break;

    case 1 :
          call get_cmdset;
          return_int = 1;
          break;

  }
  switch_win_id(tw);
  return();

get_cmdset:
  if(GetDbRecord("MECONFIG", "CMDMAPLIST.DB", "FN", wcmdmapname,
        0,0, "~CMDSETMGR_TMP", false, "" ) )
  {
    return_str = parse_str("NAME=", CmdSetMgrTmp );
  }
  else
  {
    return_str = wcmdmapname;
  }
  ret;
}

void CmdSetMgr_Edit(  )
{

  int tw = window_id;
  int copying = parse_int("/COPY=", mparm_str);
  int creating = parse_int("/CREATE=",mparm_str);
  int dlg, result;

  str orig_name[128] = parse_str("NAME=", CmdSetMgrTmp);
  str orig_fn[128] = parse_str("FN=", CmdSetMgrTmp);
  str tstr;
  int j = 1;

  orig_fn = Caps(Truncate_Path(Truncate_Extension( orig_fn ) ) );

  str name[128] = orig_name;
  str fn[128] = orig_fn;
  str hook_str = "";
  str dlg_name = "Edit Command Set";

  DlgCreate(dlg);

  if( copying )
  {
    dlg_name = "Copy Command Set";
    hook_str = "/HOOK=CmdSetMgrHook";
    name = "<new command map description>";
    fn = "<net command map filename>";
    DlgAddCtrl( dlg, Dlg_GroupBox, "Copy:", 1,1,56, 3,2200, 0,"" );
    DlgAddCtrl( dlg, DLG_Static, "Description:", 2, DLG_PosOffset + 1, 0, 0, 2100, 0, "");
    DlgAddCtrl( dlg, DLG_Static, orig_name, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 2150, 0, "");
    DlgAddCtrl( dlg, DLG_Static, "Filename:", 2, Dlg_PosOffset + 1, 0, 0, 2101, 0, "");
    DlgAddCtrl( dlg, DLG_Static, orig_fn, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 2151, 0, "");
    tstr = "To:";
    j = 2;
    DlgAddCtrl( dlg, Dlg_GroupBox, tstr, 1, Dlg_PosOffset + j,56,
        DLG_Units | ((Dlg_Units_Per_Line * 3) + Dlg_Units_QLine),2201, 0,"" );
  }
  else
  {
    if(creating)
    {
      dlg_name = "Import(Insert) Command Set";
    }
    j = 1;
    tstr = "Edit:";
  }

  DlgAddCtrl( dlg, DLG_Static, "&Description:", j, DLG_PosOffset + 1, 0, 0, 2000, 0, "");
  DlgAddCtrl( dlg, DLG_Text, name, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 1000, 0, "");

  DlgAddCtrl( dlg, DLG_Static, "&Filename:", j, Dlg_PosOffset + 1, 0, 0, 2001, 0, "");
  DlgAddCtrl( dlg, DLG_Text, fn, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 1001, 0, "/ML=128");

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + j + 1, DLG_StanBtnWidth, 0, 100, DLGF_DefButton, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 101, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 46, DLG_PosOffset, DLG_StanBtnWidth, 0, 102, 0, "/R=2");

  result = DlgExecute(dlg, 1000, dlg_name, "", hook_str, 0 );

  if(result == 1)
  {
     name = DlgGetStr( dlg, 1000 );
     fn = Caps(Truncate_Path(Truncate_Extension(DlgGetStr( dlg, 1001 ))));
     CmdSetMgrTmp = "NAME=" + name + "FN=" + fn;

     if(copying)
     {
       fn = CreateUserPath( fn + ".DB", false );
       if( LocateDbPage( orig_fn, "WCMDMAP.DB", false ) )
       {
        if(file_changed)
          save_file;
        file_name = fn;
        save_file;
       }
     }
  }

  DlgKill(Dlg);

  return_int = result;
  switch_win_id(tw);
}

int CmdSetMgrHook( int &retval, int window, message, wparam, lparam, str parms ) no_break
{
  switch ( message )
  {
    case WM_COMMAND :
        if( wparam == 100 )
        {
          str fn[128], orig_fn[128] = "", estr[80];
          SendDlgItemMessageStr( window, 1001, WM_GETTEXT, 127, fn );

          int for_copy = ( GetDlgItem(window,2151) != 0 );
          if(for_copy)
          {
            SendDlgItemMessageStr( window, 2151, WM_GETTEXT, 127, orig_fn );
          }

          if(xpos("<", fn,1))
          {
            estr = "Valid filename required";
            goto ok_error;
          }
          else
          {
            fn = Caps(Truncate_Path(Truncate_Extension( fn ) ) );
            SendDlgItemMessageStr( window, 1001, WM_SETTEXT, svl(fn), fn );
            if( orig_fn == fn )
            {
              estr = "Unique filename required!";
              goto ok_error;
            }
          }
          if(file_exists(createuserpath(fn + ".DB", false)))
          {
            estr = fn + ".DB already exists.  Please choose new filename.";
            goto ok_error;
          }
          break;

        ok_error:
          beep;
          MessageBox( window, estr, "Data Entry Error", MB_OK | MB_ICONSTOP );
          SetFocus( GetDlgItem( window, 1001 ) );
          SendDlgItemMessage( window, 1001, EM_SETSEL, 0, Make_Long( 0, -1 ) );
          return(1);
        }
        break;

  }
  return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));

}


void SetMemory()
{
  int dlg;

  DlgCreate( dlg );

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_103", 1, 1, 0,0, 1000, 0, "" );
  DlgAddCtrl( dlg, DLG_Static, '&Max % of Windows memory to use(1-90):',
          2, 3, 0,0, 1001, 0, "" );
  DlgAddCtrl( dlg, DLG_Integer, "", DLG_PosOffset + 39, DLG_PosOffset, 5, 0, 1002, 0, "/MIN=1/MAX=99");
  DlgSetInt( dlg, 1002, memory_percentage );


  DlgAddCtrl( dlg, DLG_GroupBox, "Execute DOSEXEC.EXE", 2, DLG_PosOffset | 2, 30, 3, 2001, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Directly", DLG_PosOffset | 1, DLG_PosOffset | 1, 0, 0, 1101,0,"" );
  DlgSetInt( dlg, 1101, DosExecMethod == _DosExec_Direct );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Via DOSEXEC.PIF", DLG_PosOffset, DLG_PosOffset | 1, 0, 0, 1102,0,"" );
  DlgSetInt( dlg, 1102, DosExecMethod == _DosExec_PIF );

  // Not implemented yet
 // DlgAddCtrl( dlg, DLG_RadioButton, "&Through SHELL VM", DLG_PosOffset, DLG_PosOffset | 1, 0, 0, 1103,0,"" );
 // DlgSetInt( dlg, 1103, DosExecMethod == _DosExec_ExecVM );



  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + 2, DLG_StanBtnWidth, 0, 100, DLGF_DefButton, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 101, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 38, DLG_PosOffset, DLG_StanBtnWidth, 0, 102, 0, "/R=2");


  if(DlgExecute( dlg, 1002, "Memory Usage, DOS Program Execution", MEMUSE_HELPLINK, "", 0 ))
	{
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
    memory_percentage = DlgGetInt( dlg, 1002 );
    if(DlgGetInt( dlg,1101 ))
    {
      DosExecMethod = _DosExec_Direct;
    }
    else if(DlgGetInt( dlg,1102 ))
    {
      DosExecMethod = _DosExec_PIF;
    }
  //  else if(DlgGetInt( dlg,1103 ))
  //  {
  //    DosExecMethod = _DosExec_ExecVM;
  //  }
	}
  DlgKill( dlg );
	return_int = 0;
	return();
}


macro InterfaceSetup TRANS2 NO_BREAK{
/*******************************************************************************
																MULTI-EDIT MACRO

Name: INTERFACESETUP

Description: A dialog box to configure user interface preferences.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int dlg;

  DlgCreate( dlg );

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_100",1,1,8,0,150,0,"");
  DlgAddCtrl( dlg, DLG_GroupBox, 'Options',7, 1, 48, 14, 2001, 0, "" );

  DlgAddCtrl( dlg, DLG_CheckBox, '&Overlap split window borders',DLG_PosOffset + 1,DLG_PosOffset + 1,0,0,1001,0,"");
  DlgSetInt( dlg, 1001,Global_Int('SPLIT_EDGE_MODE') == 0);

  DlgAddCtrl( dlg, DLG_CheckBox, '&Auto-arrange compiler error window',DLG_PosOffset,DLG_PosOffset + 1,0,0,1002,0,"");
  DlgSetInt( dlg, 1002,Global_Int('!AutoArrangErrSrc'));

  DlgAddCtrl( dlg, DLG_CheckBox, '&Confirm file overwrites',DLG_PosOffset,DLG_PosOffset + 1,0,0,1005,0,"");
  DlgSetInt( dlg, 1005,!Global_Int("NO_CONFIRM_OVERWRITE"));

  DlgAddCtrl( dlg, DLG_CheckBox, '&Bypass compiler menus with only 1 entry',DLG_PosOffset,DLG_PosOffset + 1,0,0,1006,0,"");
  DlgSetInt( dlg, 1006,Global_Int('@PGM_MENU_BYPASS'));

  DlgAddCtrl( dlg, DLG_CheckBox, 'Uni&x-style regular expressions',DLG_PosOffset,DLG_PosOffset + 1,0,0,1007,0,"");
  DlgSetInt( dlg, 1007, global_int("REG_EXP_STYLE"));

  DlgAddCtrl( dlg, DLG_CheckBox, '&Saving file clears line-changed highlighting',DLG_PosOffset,DLG_PosOffset + 1,0,0,1025,0,"");
  DlgSetInt( dlg, 1025, save_resets_changed );

  DlgAddCtrl( dlg, DLG_CheckBox, '&Persistent blocks',DLG_PosOffset,DLG_PosOffset + 1,0,0,1003,0,"");
  DlgSetInt( dlg, 1003,Persistent_blocks);

  DlgAddCtrl( dlg, DLG_CheckBox, 'I&nclusive stream blocks',DLG_PosOffset,DLG_PosOffset + 1,0,0,1004,0,"");
  DlgSetInt( dlg, 1004,stream_block_mode);

  DlgAddCtrl( dlg, DLG_CheckBox, '&Typing overwrites non-persistent blocks',DLG_PosOffset,DLG_PosOffset + 1,0,0,1024,0,"");
  DlgSetInt( dlg, 1024,typing_overwrites_block);

  DlgAddCtrl( dlg, DLG_CheckBox, 'T&urn block highlight off after paste',DLG_PosOffset,DLG_PosOffset + 1,0,0,1027,0,"");
  DlgSetInt( dlg, 1027,Global_Int("BlockOffAfterPaste"));

  DlgAddCtrl( dlg, DLG_CheckBox, 'Outline Current &Line',DLG_PosOffset,DLG_PosOffset + 1,0,0,1030,0,"");
  DlgSetInt( dlg, 1030, cl_focus_rect);

  DlgAddCtrl( dlg, DLG_CheckBox, 'Open Windows Maximi&zed',DLG_PosOffset,DLG_PosOffset + 1,0,0,1031,0,"");
  DlgSetInt( dlg, 1031, Global_Int ("@MAXIMIZE_WINDOWS"));

  DlgAddCtrl( dlg, DLG_CheckBox, 'Al&ways have at least one window open',DLG_PosOffset,DLG_PosOffset + 1,0,0,1040,0,"");
  DlgSetInt( dlg, 1040, !nofile_hidden );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Caret', DLG_PosOffset + 48, 1, 26, 8, 2001, 0, "" );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Insert', DLG_PosOffset + 2, DLG_PosOffset + 1, 10, 5, 1300, 0, "");

  DlgAddCtrl( dlg, DLG_RadioButton, 'Thin', DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0, 1400, 0, "");
  DlgSetInt(dlg, 1400, (Ins_Cursor & 0x7F) == 0);

  DlgAddCtrl( dlg, DLG_RadioButton, '1/3', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1401, 0, "");
  DlgSetInt(dlg, 1401, (Ins_Cursor & 0x7F) == 2);

  DlgAddCtrl( dlg, DLG_RadioButton, '1/2', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1402, 0, "");
  DlgSetInt(dlg, 1402, (Ins_Cursor & 0x7F) == 1);

  DlgAddCtrl( dlg, DLG_RadioButton, 'Full', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1403, 0, "");
  DlgSetInt(dlg, 1403, (Ins_Cursor & 0x7F) == 3);

  DlgAddCtrl( dlg, DLG_CheckBox, 'Horiz', DLG_PosOffset, DLG_PosOffset + 2, 0, 0, 1032, 0, "");
  DlgSetInt( dlg, 1032, (Ins_Cursor & 0x80) != 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Overwrite', DLG_PosOffset + (Dlg_Units | 43), Dlg_NegOffset - 6, 10, 5, 1301, 0, "");

  DlgAddCtrl( dlg, DLG_RadioButton, 'Thin', DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0, 1404, 0, "");
  DlgSetInt(dlg, 1404, (Ovr_Cursor & 0x7F) == 0);

  DlgAddCtrl( dlg, DLG_RadioButton, '1/3', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1405, 0, "");
  DlgSetInt(dlg, 1405, (Ovr_Cursor & 0x7F) == 2);

  DlgAddCtrl( dlg, DLG_RadioButton, '1/2', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1406, 0, "");
  DlgSetInt(dlg, 1406, (Ovr_Cursor & 0x7F) == 1);

  DlgAddCtrl( dlg, DLG_RadioButton, 'Full', DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1407, 0, "");
  DlgSetInt(dlg, 1407, (Ovr_Cursor & 0x7F) == 3);

  DlgAddCtrl( dlg, DLG_CheckBox, 'Horiz', DLG_PosOffset, DLG_PosOffset + 2, 0, 0, 1033, 0, "");
  DlgSetInt( dlg, 1033, (Ovr_Cursor & 0x80) != 0);

  DlgAddCtrl( dlg, DLG_Static, 'Toolbar pop-up help delay (in 10ths of a second):', 5, 16, 0, 0, 2004,0,"");
  DlgAddCtrl( dlg, DLG_Integer, "" ,DLG_PosOffset + 48 ,DLG_PosOffset,5,0,1200,0,"/MIN=1/MAX=100");
  DlgSetInt( dlg, 1200, Global_Int("TOOLHELPDELAY"));


  DlgAddCtrl( dlg, DLG_PushButton, "OK",  1,DLG_PosOffset + 2,Dlg_StanBtnWidth,0,100,DLGF_DefButton,"/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel",DLG_PosOffset  + Dlg_StanBtnWidth + 2,DLG_PosOffset,Dlg_StanBtnWidth,0,101,0,"/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 70,DLG_PosOffset,Dlg_StanBtnWidth,0,102,0,"/R=2");

  if(DlgExecute( dlg, 1001, "User Interface setup", USERINTR_HELPLINK , "", 0 ))
  {
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

    Set_Global_Int('SPLIT_EDGE_MODE', DlgGetInt(dlg,1001) == 0 );
    Set_Global_Int('!AutoArrangErrSrc', DlgGetInt(dlg,1002) );
    save_resets_changed     = DlgGetInt( dlg, 1025);
    persistent_blocks       = DlgGetInt( dlg, 1003);
    stream_block_mode       = DlgGetInt( dlg, 1004);
    typing_overwrites_block = DlgGetInt( dlg, 1024 );
    Set_Global_Int("BlockOffAfterPaste", DlgGetInt( dlg, 1027 ));
    int tcl = cl_focus_rect;
    cl_focus_rect           = DlgGetInt( dlg, 1030);
    Set_Global_Int("@MAXIMIZE_WINDOWS", DlgGetInt (dlg, 1031));
    nofile_hidden = !DlgGetInt( dlg, 1040);
    Set_Global_Int("NO_CONFIRM_OVERWRITE", !DlgGetInt(dlg,1005));
    Set_Global_Int('@PGM_MENU_BYPASS',DlgGetInt(dlg,1006));
    Set_Global_Int('REG_EXP_STYLE',DlgGetInt(dlg,1007));
    Set_Global_Int("TOOLHELPDELAY",DlgGetInt( dlg, 1200));
    ToolboxSetPopupDelay( Global_Int("TOOLHELPDELAY") * 100 );

    if ( DlgGetInt(dlg, 1400) )
      Ins_Cursor = 0;
    else if ( DlgGetInt(dlg, 1401) )
      Ins_Cursor = 2;
    else if ( DlgGetInt(dlg, 1402) )
      Ins_Cursor = 1;
    else if ( DlgGetInt(dlg, 1403) )
      Ins_Cursor = 3;
    if ( DlgGetInt(dlg, 1032) ) {
      Ins_Cursor = Ins_Cursor | 0x80;
    } else {
      Ins_Cursor = Ins_Cursor & 0x7F;
    }

    if ( DlgGetInt(dlg, 1404) )
      Ovr_Cursor = 0;
    else if ( DlgGetInt(dlg, 1405) )
      Ovr_Cursor = 2;
    else if ( DlgGetInt(dlg, 1406) )
      Ovr_Cursor = 1;
    else if ( DlgGetInt(dlg, 1407) )
      Ovr_Cursor = 3;
    if ( DlgGetInt(dlg, 1033) ) {
      Ovr_Cursor = Ovr_Cursor | 0x80;
    } else {
      Ovr_Cursor = Ovr_Cursor & 0x7F;
    }

    if(tcl != cl_focus_rect)
    {
      RedrawWindow( frame_handle, 0, 0, rdw_Invalidate | rdw_AllChildren );
      int tr = refresh;
      refresh = true;
      new_screen;
      refresh = tr;
    }
	}
  DlgKill( dlg );
	return_int = 0;
}


macro CHECK_SETUP TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  CHECK_SETUP

Description:  Checks for configuration changed and prompts the user to save.

Parameters:
							/X=   X coordinate for menu box
							/Y=   Y coordinate for menu box

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

#ifdef DEMO
  Set_Global_Int('SETUP_CHANGED',0);
#else
  if(global_int("SETUP_CHANGED"))
  {
    rm("SETSAVE");
  }
#endif // DEMO
  return_int = 1;
}


#ifndef DEMO
#endif



macro SRCHSET TRANS2 {
/********************************MULTI-EDIT MACRO******************************

Name: SRCHSET

Description:  Setup routine for default search/search and replace/multi-file
							search settings.

Global Strings Modified:
							'DEF_SWITCHES'
							'DEF_REPL_SWITCHES'
							'DEF_FS_SWITCHES'
							'DEF_FS_PATH'
							'DEF_FSR_SWITCHES'
							'DEF_FSR_PATH'

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

		int  /*use_reg_exp, case_sensitive, search_dirs,*/jx,
        menu, menu_cnt/*, search_in_mem*/ ;
		str  switches_str[40], temp_return, title[40], multi_search_help[40];


		temp_return = return_str;
		jx = 1;
loop:
    menu_cnt = 5;
    title = "Multi-File Search Setup";
    int dlg, bw = 46, bh = DLG_Units | DLG_Units_Line_Half;

    DlgCreate(dlg);

    DlgAddCtrl( dlg, DLG_BlackFrame, "",1, DLG_Units | DLG_Units_HLine,49,DLG_Units | ((Dlg_Units_Per_Line * 8)),900,0,"" );
    DlgAddCtrl( dlg, DLG_BitmapBtn, "BT_SR_100 &Search Defaults", 2, DLG_PosOffset, bw,bh,100,0, "/R=101" );
   // DlgAddCtrl( dlg, DLG_PushButton, "&Search Defaults", DLG_PosOffset + 6, DLG_PosOffset, 40,0,110,0, "/R=101" );
    DlgAddCtrl( dlg, DLG_BitmapBtn, "BT_SR_101 Search and &Replace Defaults", 2, DLG_PosOffset + 2, bw,bh,101,0, "/R=102" );
   // DlgAddCtrl( dlg, DLG_PushButton, "Search and &Replace Defaults", DLG_PosOffset + 6, DLG_PosOffset, 40,0,111,0, "/R=102" );
    DlgAddCtrl( dlg, DLG_BitmapBtn, "BT_SR_103 &Multi-File Search Defaults", 2, DLG_PosOffset + 2, bw,bh,102,0, "/R=103" );
  //  DlgAddCtrl( dlg, DLG_PushButton, "&Multi-File Search Defaults", DLG_PosOffset + 6, DLG_PosOffset, 40,0,112,0, "/R=103" );
    DlgAddCtrl( dlg, DLG_BitmapBtn, "BT_SR_104 Multi-&File Search and Replace Defaults", 2, DLG_PosOffset + 2, bw,bh,103,0, "/R=104" );
   // DlgAddCtrl( dlg, DLG_PushButton, "Multi-&File Search and Replace Defaults", DLG_PosOffset + 6, DLG_PosOffset, 40,0,113,0, "/R=104" );
    DlgAddCtrl( dlg, DLG_PushButton, "Close", 2, 10, DLG_StanBtnWidth,0,114,0, "/R=0" );
    DlgAddCtrl( dlg, DLG_PushButton, "&Help", 38, 10, DLG_StanBtnWidth,0,115,0, "/R=2" );

    return_int = DlgExecute( dlg, 114,'Search Defaults Setup', MAINSRCHDEF_HELPLINK,"", 0 );
    DlgKill(dlg);

		if ( return_int > 100 )
			return_int -= 100;
		jx = return_int;
		if(  return_int < 1  ) {
			goto exit;
		} else if(  return_int == 1  ) {
			RM('MEUTIL2^SrchIntr /M=0/SWONLY=1/SWG=DEF_SWITCHES/H=' +
					SRCHDEF_HELPLINK);
			if(  return_int  ) {
				Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
			}
		} else if(  return_int == 2  ) {
			RM('MEUTIL2^SrchIntr /M=1/SWONLY=1/SWG=DEF_REPL_SWITCHES/H=' +
					SRCHREPDEF_HELPLINK);
			if(  return_int  ) {
				Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
			}
		} else if(  return_int > 2  ) {
			int dlg;
			if (return_int == 3)
				switches_str = global_str('DEF_FS_SWITCHES');
			else
				switches_str = global_str('DEF_FSR_SWITCHES');

			DlgCreate(dlg);
      DlgAddCtrl( dlg, DLG_CheckBox, "&Search sub-directories", 10, 1, 24, 0, 1001, 0, "");
  		DlgSetInt( dlg, 1001,xpos('S',switches_str, 1) != 0);
      DlgAddCtrl( dlg, DLG_CheckBox, "&Case Sensitivity", 10, 2, 24, 0, 1002, 0, "");
  		DlgSetInt( dlg, 1002,xpos('I',switches_str, 1) == 0);
      DlgAddCtrl( dlg, DLG_CheckBox, "&Regular Expressions", 10, 3, 24, 0, 1003, 0, "");
  		DlgSetInt( dlg, 1003,xpos('X',switches_str, 1) != 0);
      DlgAddCtrl( dlg, DLG_CheckBox, "Search file in &memory", 10, 4, 24, 0, 1004, 0, "");
  		DlgSetInt( dlg, 1004,xpos('F',switches_str, 1) != 0);
			if (return_int == 3) {
        DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SR_103", 1, 1, 0,0,100,0, "" );
        DlgAddCtrl( dlg, DLG_BlackFrame, "", 9, DLG_UNITS | 5, 30,DLG_Units | ((Dlg_Units_Per_Line * 3) + 6 ),900,0,"" );
	      DlgAddCtrl( dlg, DLG_Static, "Starting &Path:", 1, 6, 0,0,101,0, "" );
  			DlgAddCtrl( dlg, DLG_Text, global_str('DEF_FS_PATH'),16, 6,30, 0,1100,0,"/ML=60" );
				multi_search_help = MFSRCHDEF_HELPLINK;
			} else {
        DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SR_104", 1, 1, 0,0,100,0, "" );
        DlgAddCtrl( dlg, DLG_CheckBox, "&Leave all files open", 10, 5, 24, 0, 1005, 0, "");
  			DlgSetInt( dlg, 1005,xpos('O', switches_str, 1) != 0);
        DlgAddCtrl( dlg, DLG_BlackFrame, "", 9, DLG_Units | 4, 30,DLG_Units | ((Dlg_Units_Per_Line * 4) + 6 ),900,0,"" );
	      DlgAddCtrl( dlg, DLG_Static, "Starting &Path:", 1, 7, 0,0,101,0, "" );
  			DlgAddCtrl( dlg, DLG_Text, global_str('DEF_FSR_PATH'),16, 7,30, 0,1100,0,"/ML=60" );
        menu_cnt = 6;
        title = "Multi-File Search And Replace Setup";
				multi_search_help = MSRCHREPDEF_HELPLINK;
			}
      DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + 2, DLG_StanBtnWidth, 0, 1006, DLGF_DefButton, "/R=1");
      DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 1007, 0, "/R=0");
      DlgAddCtrl( dlg, DLG_PushButton, "&Help", 36, DLG_PosOffset, DLG_StanBtnWidth, 0, 1008, 0, "/R=2");
/*
			use_reg_exp = xpos('R',switches_str, 1) != 0;
			case_sensitive = xpos('C',switches_str, 1) != 0;
			search_dirs = xpos('S',switches_str, 1) != 0;
			search_in_mem = xpos('F',switches_str, 1) != 0;
			menu_set_item( menu, 1, 'Search sub-directories   ','',
						'/QK=12/C=2/W=1',13,search_dirs, 0);
			menu_set_item( menu, 2, 'Case Sensitivity         ','',
						'/QK=1/C=2/W=1',13,case_sensitive, 0);
			menu_set_item( menu, 3, 'Regular Expressions      ','',
						'/QK=9/C=2/W=1',13,use_reg_exp, 0);
			menu_set_item( menu, 4, 'search files in Memory   ','',
						'/QK=17/C=2/W=1',13,search_in_mem, 0);
			menu_set_item( menu, 5, 'Starting path: ',global_str('DEF_FS_PATH'),
						'/QK=10/C=1/L=6/ML=60/W=30',0,0, 0);
*/
    return_int = DlgExecute( dlg, 1100, title, multi_search_help,"", 0 );
			if(  return_int  ) {
				switches_str = '';
	      if(DlgGetInt( dlg, 1003)) {
					switches_str = 'X';
				}
	      if(!DlgGetInt( dlg, 1002)) {
					switches_str = switches_str + 'I';
				}
	      if(DlgGetInt( dlg, 1001)) {
					switches_str = switches_str + 'S';
				}
	      if(DlgGetInt( dlg, 1004)) {
					switches_str = switches_str + 'F';
				}
        if (menu_cnt == 6) {
	      	if(DlgGetInt( dlg, 1005)) {
						switches_str = switches_str + 'O';
					}
					set_Global_Str('DEF_FSR_SWITCHES', switches_str);
					set_global_str('DEF_FSR_PATH', DlgGetStr( dlg, 1100));
				} else {
					set_Global_Str('DEF_FS_SWITCHES', switches_str);
					set_global_str('DEF_FS_PATH', DlgGetStr( dlg, 1100));
				}
/*
				search_dirs = menu_item_int( menu, 1, 2 );
				set_global_str('DEF_FS_PATH', menu_item_str(menu, 5, 2));
				case_sensitive = menu_item_int( menu, 2, 2 );
				use_reg_exp = menu_item_int( menu, 3, 2 );
				search_in_mem = menu_item_int( menu, 4, 2 );
				switches_str = '';
				if(  use_reg_exp  ) {
					switches_str = 'R';
				}
				if(  case_sensitive  ) {
					switches_str = switches_str + 'C';
				}
				if(  search_dirs  ) {
					switches_str = switches_str + 'S';
				}
				if(  search_in_mem  ) {
					switches_str = switches_str + 'F';
				}
				set_Global_Str('DEF_FS_SWITCHES', switches_str);
*/

				Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
			}
		  DlgKill(dlg);
			//menu_delete( menu );
		}
		goto loop;
exit:
		return_str = temp_return;
	return_int = 0;
}

macro SETEDIT TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  SETEDIT

Description:  This is the edit settings menu.

Parameters:
							/X=   X coordinate for menu box
							/Y=   Y coordinate for menu box

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
/* Global variables used:
Global_Int('Default_Insert_Mode') The insert mode upon startup of editor
Global_Str('Def_Switches') The search switches upon startup of editor
Global_Str('Format_Code_Delimit') The print formatter code delimiter
 */
	int  x1, dlg;

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_101", 1, 2, 0,0, 1000, 0, "" );
  DlgAddCtrl( dlg, Dlg_Static, "&Page Break String",9, 1, 0, 0, 2001, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Page_Str, 35, Dlg_PosOffset, 15, 0, 1101, 0, "");

/* Specchar and dlbparen properly represent unprintable ASCII codes in the menu */
	RM( 'userin^SPECCHAR ' + Word_Delimits );
  DlgAddCtrl( dlg, Dlg_Static, "&Word Delimits", 9, Dlg_PosOffset + 1, 0, 0, 2002, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, return_str, 35, Dlg_PosOffset, 40, 0, 1102, 0, "/ML=40");

  DlgAddCtrl( dlg, Dlg_Static, "Max &Undo Count", 9, Dlg_PosOffset + 1, 0, 0, 2003, 0, "");

  DlgAddCtrl( dlg, Dlg_Integer, "", 35, Dlg_PosOffset, 8, 0, 1103, 0, "/MIN=0/MAX=65535");
	DlgSetInt( dlg, 1103, max_undo);

  DlgAddCtrl( dlg, Dlg_Static, "Default &File Extension(s)", 9, Dlg_PosOffset + 1, 0, 0, 2004, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Global_Str('@DEFAULT_EXT_LIST'), 35, Dlg_PosOffset, 40, 0, 1104, 0, "/ML=80");

  DlgAddCtrl( dlg, DLG_GroupBox, 'Options:',1, 6, 28, 5, 2001, 0, "" );

  DlgAddCtrl( dlg, DLG_CheckBox, "Tru&ncate Spaces",  Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1001, 0, "");
	DlgSetInt( dlg, 1001, Truncate_Spaces);

  DlgAddCtrl( dlg, DLG_CheckBox, "Control-&Z at EOF",  Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1002, 0, "");
	DlgSetInt( dlg, 1002, Ctrl_Z);


  DlgAddCtrl( dlg, DLG_CheckBox, "&CR/LF at EOF", Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1003, 0, "");
	DlgSetInt( dlg, 1003, EOF_Cr);

  DlgAddCtrl( dlg, DLG_CheckBox, "Edit Binary Files In He&x", Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1004, DLGF_Disable, "");
  DlgSetInt( dlg, 1004, 0);   //global_int("BINARY_MODE"));

  DlgAddCtrl( dlg, DLG_GroupBox, 'Tab expand',31, 6, 15, 3, 2002, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Tabs", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, Tab_Expand);

  DlgAddCtrl( dlg, DLG_RadioButton, "&Spaces", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, Tab_Expand == 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Column block move',48, 6, 30, 3, 2003, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Deletes Space", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1303, 0, "");
	DlgSetInt( dlg, 1303, Column_Move_Style);

  DlgAddCtrl( dlg, DLG_RadioButton, "&Leaves Space", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1304, 0, "");
	DlgSetInt( dlg, 1304, Column_Move_Style == 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Default mode', 31, 10, 15, 3, 2004, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Insert", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1305, 0, "");
	DlgSetInt( dlg, 1305, Global_Int("DEFAULT_INSERT_MODE"));

  DlgAddCtrl( dlg, DLG_RadioButton, "&Overwrite", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1306, 0, "");
	DlgSetInt( dlg, 1306, Global_Int("DEFAULT_INSERT_MODE") == 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Leave cursor at', 48, 10, 30, 3, 2005, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Beginning of Pasted Text",
            DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0, 1307, 0, "");
	DlgSetInt( dlg, 1307, Global_Int("CURSOR_EOB") == 0);

  DlgAddCtrl( dlg, DLG_RadioButton, "&End of Pasted Text",
            DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1308, 0, "");
	DlgSetInt( dlg, 1308, Global_Int("CURSOR_EOB") != 0);

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 2, 14, DLG_StanBtnWidth, 0, 201, DLGF_DefButton, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + Dlg_StanBtnWidth + 2,
                    DLG_PosOffset, DLG_StanBtnWidth, 0, 202, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 68, Dlg_PosOffset, DLG_StanBtnWidth, 0, 203, 0, "/R=2");

	return_int = DlgExecute( dlg, 1101, "Edit Settings", EDITSETT_HELPLINK, "", 0);


	if(  return_int  ) {

//		Page_Str = menu_item_str( menu, 1, 2 );
		Page_Str = DlgGetStr(dlg,1101);
//		RM('USERIN^VALCHAR ' + menu_item_str( menu, 2, 2 ) );
		RM('USERIN^VALCHAR ' + DlgGetstr(dlg, 1102));
		word_delimits = return_str;
//		max_undo = menu_item_int( menu, 4, 2 );
		max_undo = DlgGetInt(dlg, 1103);
//		Set_Global_Str('@DEFAULT_EXT_LIST', menu_item_str( menu, 5, 2 ));
		Set_Global_Str('@DEFAULT_EXT_LIST', DlgGetStr(dlg, 1104));
	 /*	if(  menu_item_int( menu, 8, 2 )  ) {
			ins_cursor = 0;
		} else if(  menu_item_int( menu, 9, 2 )  ) {
			ins_cursor = 1;
		} else if(  menu_item_int( menu, 10, 2 )  ) {
			ins_cursor = 2;
		} else if(  menu_item_int( menu, 11, 2 )  ) {
			ins_cursor = 3;
		}

		if(  menu_item_int( menu, 13, 2 )  ) {
			ovr_cursor = 0;
		} else if(  menu_item_int( menu, 14, 2 )  ) {
			ovr_cursor = 1;
		} else if(  menu_item_int( menu, 15, 2 )  ) {
			ovr_cursor = 2;
		} else if(  menu_item_int( menu, 16, 2 )  ) {
			ovr_cursor = 3;
		}
		*/
//		Truncate_Spaces = menu_item_int( menu, 18, 2 );
		Truncate_Spaces = DlgGetInt(dlg, 1001);
//		ctrl_z = menu_item_int( menu, 19, 2 );
		ctrl_z = DlgGetInt(dlg, 1002);
//		eof_cr = menu_item_int( menu, 20, 2 );
		eof_cr = DlgGetInt(dlg, 1003);
//		set_global_int("BINARY_MODE", menu_item_int(menu,21,2));
		set_global_int("BINARY_MODE", DlgGetInt(dlg, 1004));
		//tab_expand = menu_item_int( menu, 23, 2 );
		tab_expand = DlgGetInt(dlg, 1301);
//		column_move_style = menu_item_int( menu, 26, 2 );
		column_move_style = DlgGetInt(dlg, 1303);
//		Set_Global_Int('Default_Insert_Mode', menu_item_int( menu, 29, 2 ));
		Set_Global_Int('Default_Insert_Mode', DlgGetInt(dlg, 1305));
//		set_global_int('CURSOR_EOB', menu_item_int(menu,33,2));
		set_global_int('CURSOR_EOB', DlgGetInt(dlg, 1308));

		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
	}
//	menu_delete( menu );
	return_int = 0;

  DlgKill(dlg);
}

macro SETMEPATHS TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  SETMEPATHS

Description:  This menu sets up the backup methods, and backup and
	temp file paths

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  dlg/*x1, menu = menu_create */;
/* Build a menu with current settings */
	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_FL_102", 2, 2 , 0,0, 1000, 0, "" );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Autosave Setup', 9, 1, 52, 5, 2005, 0, "" );

  DlgAddCtrl( dlg, Dlg_Static, "&Seconds of keyboard inactivity (0 = OFF)",
							Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 2006, 0, "");
  DlgAddCtrl( dlg, Dlg_Integer, "",
							DLg_PosOffset + 40, Dlg_PosOffset, 8, 0, 1102, 0, "/MIN=0/MAX=254");
	DlgSetInt( dlg, 1102, parse_int('/T1=', global_str('!AUTOSAVEPARMS')));

  DlgAddCtrl( dlg, DLG_CheckBox, "Sa&ve complete editor status",
			Dlg_NegOffset - 38, Dlg_PosOffset + 1, 0, 0, 1001, 0, "");
	DlgSetInt( dlg, 1001, parse_int('/S1=', global_str('!AUTOSAVEPARMS')));
  DlgAddCtrl( dlg, Dlg_Static, "&Absolute interval in seconds (0 = OFF) ",
							Dlg_NegOffset + 2, Dlg_PosOffset + 1, 0, 0, 2007, 0, "");
  DlgAddCtrl( dlg, Dlg_Integer, "",
							DLg_PosOffset + 40, Dlg_PosOffset, 8, 0, 1103, 0, "/MIN=0/MAX=254");
	DlgSetInt( dlg, 1103, parse_int('/T2=', global_str('!AUTOSAVEPARMS')));
  DlgAddCtrl( dlg, DLG_CheckBox, "Sav&e complete editor status",
			Dlg_NegOffset - 38, Dlg_PosOffset + 1, 0, 0, 1002, 0, "");
	DlgSetInt( dlg, 1002, parse_int('/S2=', global_str('!AUTOSAVEPARMS')));

  DlgAddCtrl( dlg, DLG_GroupBox, 'Backups', 1, Dlg_Units + 65, 60, 7, 2001, 0, "" );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Backup method', DLG_PosOffset + 2,
							Dlg_PosOffset + 1, 33, 4, 2002, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Off", Dlg_PosOffset + 1,
							Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, (backups & 0xF == 0));
  DlgAddCtrl( dlg, DLG_RadioButton, "Create .&BAK file", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, (backups & 0xF == 1));
  DlgAddCtrl( dlg, DLG_RadioButton, "&Copy file to backup directory", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1303, 0, "");
	DlgSetInt( dlg, 1303, (backups & 0xF == 2));

  DlgAddCtrl( dlg, DLG_GroupBox, 'Backup Frequency', 39, Dlg_NegOffset - 3, 20, 3, 2003, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&First save only", Dlg_PosOffset + 1,
							Dlg_PosOffset + 1, 0, 0, 1304, 0, "");
	DlgSetInt( dlg, 1304, (backups & 0x80 == 0));
  DlgAddCtrl( dlg, DLG_RadioButton, "Ever&y save", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1305, 0, "");
	DlgSetInt( dlg, 1305, (backups & 0x80 != 0));
  DlgAddCtrl( dlg, Dlg_Static, "Backup &directory:", 3, 12, 0, 0, 2004, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Global_Str('!BACKUP_PATH'),
							dlg_PosOffset + 20, Dlg_PosOffset, 35, 0, 1101, 0, "");

	DlgAddCtrl( dlg, DLG_CheckBox, "&Network file locking",
      1, Dlg_PosOffset + 2, 0, 0, 1003, 0, "");
	DlgSetInt( dlg, 1003, file_locking);
  DlgAddCtrl( dlg, Dlg_Static, "S&wap file directory:",
              1, Dlg_PosOffset | Dlg_Units | 14, 0, 0, 2008, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Global_Str('!TEMP_PATH'),
              dlg_PosOffset + 22, Dlg_PosOffset, 35, 0, 1104, 0, "");
  DlgAddCtrl( dlg, Dlg_Static, ".&TMP file directory:",
              1, Dlg_PosOffset | Dlg_Units | 14, 0, 0, 2009, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Global_Str('@TMP_FILE_PATH'),
              dlg_PosOffset + 22, Dlg_PosOffset, 35, 0, 1105, 0, "");

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + 2, Dlg_StanBtnWidth, 0, 201, DLGF_DefButton, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset +Dlg_StanBtnWidth + 2, DLG_PosOffset, Dlg_StanBtnWidth, 0, 202, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 51, DLG_PosOffset, Dlg_StanBtnWidth, 0, 203, 0, "/R=2");

    return_int = DlgExecute(dlg, 1101,
									"Backups, Temp Files and Autosave",
									BACKTMPAUTO_HELPLINK, "", 0);



//	return_int = menu;
//	RM('USERIN^DATA_IN /HN=1/T=Backups // Temp files // Autosave/#=17/H=INEDAU');

	if(  return_int  ) {
		file_locking = DlgGetInt( dlg, 1003);
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

		RM('SetAutoSave /M2=1/T1=' + Str(DlgGetInt(dlg, 1102)) +
				'/S1=' + str(DlgGetint( dlg, 1001)) +
				'/T2=' + str(DlgGetInt(dlg, 1103)) +
				'/S2=' + str(DlgGetInt(dlg, 1002)) +
				'/H1=' + parse_Str('/H1=', global_str('!AUTOSAVEPARMS')) +
				'/H2=' + parse_Str('/H2=', global_str('!AUTOSAVEPARMS')));
		backups = 0;
		if (DlgGetInt( dlg, 1302)) {
			backups = 1;
		}
		if (DlgGetInt( dlg, 1303)) {
			backups = 2;
		}
		if (DlgGetInt( dlg, 1305)) {
			backups = backups | $80;
		}
		return_str = DlgGetstr( dlg, 1101);
    Set_Global_Str('!BACKUP_PATH', return_str );
		rm('XLATECMDLINE');
		backup_path = return_str;
		if(  ((Length(Backup_Path) > 0) &
				(Copy(Backup_Path,Length(Backup_Path),1) != '\'))  ) {
			Backup_Path = Backup_Path + '\';
		}
    return_str = DlgGetstr(dlg, 1104);
    Set_Global_Str('!TEMP_PATH', return_str );
		rm('XLATECMDLINE');
		temp_path = return_str;
		if(  ((Length(Temp_Path) > 0) &
				(Copy(Temp_Path,Length(Temp_Path),1) != '\'))  ) {
			Temp_Path = Temp_Path + '\';
		}

    Set_Global_Str('@TMP_FILE_PATH', DlgGetstr(dlg, 1105));

	}
/*
	menu_delete( menu );
*/
	DlgKill(dlg);

	return_int = 0;
}


macro EXTENS TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  EXTENS

DESCRIPTION:  This is the filename extension specific setup menu.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	Set_Global_Str('T_Format','');
  /*
  RM('DB /H=' + str(hFILENAME_EXTENSIONS) +
      '/NDF=1/F=MECONFIG/CBT=Done/HF=MEWHDRS.DB/HPT=EXT.HDR/DPT=EXT.DB'
      + '/PROTECT1=DEFAULT/PRE=EXT/LT=EXTENSION SETUP/NOALPHA=1/GLO=EXT'+
      '/CP=Input new extension: /DELMAC=1/CANMAC=1/MACRO=CHECK_EXT');
  */
  db( "MECONFIG", "EXT.DB", "MEWHDRS.DB", "EXT.HDR", "Filename Extension Setup",
          "Edit Filename Extension Setup","EXT", 0, '/H=' + FNAMEEXT_HELPLINK +
      '/NDF=1/PROTECT1=DEFAULT/PRE=EXT/BMP=BT_SETUP_104'+
      '/CP=Input new extension: /DELMAC=1/CANMAC=1/MACRO=CHECK_EXT'  );

	Set_Global_Str('T_Format','');
	Set_Global_Str("@T_EXT","");
}

macro CHECK_EXT TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  CHECK_EXT

DESCRIPTION:  Checks to see if a extension create is aborted or an extension
is deleted, and if so, finds and deletes any associated compiler records.
Also, resets the extension global string of an edited extension record.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str
			g_str[20] = Parse_Str('/GLO=',Mparm_Str),
			tstr[80] = Parse_Str('EXT=',Global_Str(g_str)),
			tstr2[8],
			language[40] = Parse_Str('LS=',Global_Str(g_str));
	int
		t_int,
		t_int2,
		t_int3,
		reinit = false,
		reinit_count,
		active_window = window_id;
		mark_pos;

	if (Parse_Int('/P=',MParm_Str)) {
/* prompt user if he wants to reinitialize extension parameters for all
	 existing windows */
//    language_not_changed = (language == parse_str("/LANG=",global_str("@T_EXT")));

			// If there are no files loaded with the designated extensions
			// then do not prompt the user
		t_int2 = 1;
		do
		{
			t_int = xpos(' ', tstr, t_int2 );
			if(t_int == 0)
			{
				tstr2 = copy( tstr,t_int2,3);
			}
			else
			{
				tstr2 = copy( tstr, t_int2, t_int - t_int2 );
			}
			if(global_str("." + caps(tstr2)) != "")
			{
				reinit = TRUE;
				t_int = 0;
			}
			t_int2 = t_int + 1;
		} while( t_int != 0);

		if(reinit)
      RM("VERIFY /T=Reset extension configuration in currently loaded files?/H=" +
        FNAMEEXT_HELPLINK);
  reinit = return_int;
		if ((tstr != parse_str("/EXT=",global_str("@T_EXT"))) &&
				(!parse_int("/CREATE=",global_str("@T_EXT")))) {
			Mark_Pos;
			Tof;
			Reg_Exp_Stat = True;
			if (Search_Fwd('%|12' + parse_str("/EXT=",global_str("@T_EXT")) + '.PGM$',0)) {
				right;
				del_chars(length(parse_str("/EXT=",global_str("@T_EXT"))));
				insert_mode = true;
				text(tstr);
			}
			goto_mark;
		}

/* This will reassign the extension specific global on the fly */
		t_int2 = 1;
		call SKIP_DELIMITS;

PARSE_EXT:
		tstr2 = '';
		while ((t_int2 <= svl(tstr)) && (!xpos(str_char(tstr,t_int2)," ;,",1))) {
			tstr2 = tstr2 + str_char(tstr,t_int2);
			++t_int2;
		}
		call SKIP_DELIMITS;
		TStr2 = '.' + Tstr2;
		if (tstr2 == ".DEFAULT") {
/* The default get special treatment.  We need to find all extension specific
globals that use default and reassign them */
			t_int = 1;
FIND_EXT:
			if (t_int3 = XPos("",global_str("EXTENSIONS"),t_int + 1)) {
				tstr2 = copy(global_str("EXTENSIONS"),t_int,t_int3 - t_int);
				if (xpos("DEFAULT",parse_str("EXT=",Global_Str(tstr2)),1)) {
					call SET_EXT_PARMS;
				}
				t_int = t_int3 + 1;
				Goto FIND_EXT;
			}
		} else if (Global_Str(TStr2) != '') {
			call SET_EXT_PARMS;
		}
		if (t_int2 <= svl(tstr))
			goto PARSE_EXT;
	} else {
		Set_Global_Str("@T_EXT","/EXT=" + tstr + "/LANG=" + language + mparm_str);
	}
	goto EXIT;

SKIP_DELIMITS:
	while ((t_int2 <= svl(tstr)) && (xpos(str_char(tstr,t_int2)," ;,",1)))
		++t_int2;
	RET;

SET_EXT_PARMS:
	Set_Global_Str(tstr2,Global_Str(g_str));
	if (reinit) {
/* go around the window list to see if there are any currently loaded files
	 with this extension */
			for (reinit_count = 0;reinit_count < window_count;++reinit_count) {
				switch_window(cur_window + 1);
				if ("." + get_extension(file_name) == tstr2) {
// if the language has not changed, EXTSETUP need not run SET_SYNTAX_PARMS
          RM("EXTSETUP /NOSYNTAX=" + str((language ==
            parse_str("/LANG=",global_str("." +
            get_extension(file_name))))));
				}
			}
	}
	RET;

EXIT:
	switch_win_id(active_window);
	goto_mark;
}

macro LANG_MENU TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  LANG_MENU

Description:  Menu of language types for extension setup

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
// GET_DB_RECORD stores the initial amount of records in global_int("@LANG")
	int active_window = window_id;
  int list_mode = parse_int("/LM=", mparm_str);

  if(!xpos("/LM=",mparm_str, 1))
    list_mode = 2;

	mark_pos;
	RM("GET_DB_RECORD /NDF=1/F=MECONFIG/DPT=LANGUAGE.DB/DBF=LANG/AGLO=@LANG/#=1");
	switch_win_id(active_window);
	goto_mark;
  db( "MECONFIG", "LANGUAGE.DB", "MEWHDRS.DB", "LANGUAGE.HDR", "Languages",
          "Language Setup","@LANG", list_mode, "/NDH=1/PRE=LANG/U=1/H=" + FNAMEEXT_HELPLINK +
          "/BMP=BT_SETUP_108/FV=" + parse_str("/STR=", mparm_str) + "/MACRO=LANG_WARNING"  );
//  RM('USERIN^DB /HF=MEWHDRS.DB/NDH=1/HPT=LANGUAGE.HDR/PRE=LANG/NDF=1/F=MECONFIG/DPT=LANGUAGE.DB/LO=2/U=1/LT=Language/DT=Language Setup/H=FE_LANGUAGE/GLO=@LANG/MACRO=LANG_WARNING/FV=' + parse_str("/STR=", mparm_str));
	set_global_int("@LANG",0);
}

macro PGM_MENU TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_MENU

Description:  Menu of compiler/program types for extension setup

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
    RM('DB /H=' + FNAMEEXT_HELPLINK +
			'/HF=MEWHDRS.DB/HPT=PGM.HDR/NDH=1/NDF=1/F=MECONFIG/DPT=PGM.DB/FV=' +
			parse_str("/STR=",mparm_str) +
      '/PRE=PT/GLO=!PGM/NE=1/NC=1/LO=1/U=1/LT=Compiler//Program/MACRO=SETUP^PGM_WARNING');
}

macro PGM_DB TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_DB

Description:  Menu of program/compiler interfaces for the selected extension
							This macro is run by DATA_IN

Parameters:
							/PRE=   Prefix of the ISTR global.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

//  str  glob_name[20];
//  glob_name = parse_str('/PRE=', mparm_str ) + 'ISTR_1';
  RM('USERIN^DB /HF=MEWHDRS.DB/PRE=PGM/HPT=PROGRAMS.HDR/NDF=1/F=MECONFIG/CBT=Done/DPT=' +
		parse_str("/EXT=",global_str("@T_EXT")) +
//      global_str( glob_name ) +
  '.PGM/LT=Compiler////Program Setup/NOALPHA=1/H=' +
	FNAMEEXT_HELPLINK);
}

macro PGM_WARNING TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_WARNING

Description:  Warns user that he cannot just arbitrarily add program types
							without having support for them.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	if(  (Parse_Int('/P=',MParm_Str))  ) {
		RM('MEERROR^MessageBox /T=WARNING/B=1/M=If you added any new program types, be sure that the macro CMPERROR in the macro file LANGUAGE.S has code to support it.');
	}
}

macro LANG_WARNING TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  LANG_WARNING

Description:  Warns user that he cannot just arbitrarily add language types
							without having support for them.  Also handles the
							reinitializing of syntax highlighting parameters on the fly.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str language[40];
	int active_window = window_id;
	mark_pos;

	if(  (Parse_Int('/P=',MParm_Str))  ) {
		language = parse_str("LANG=",global_str("@LANG"));
		if (length(global_str("@LANG")) >
			(svl(language) + 6)) {
			set_global_str("@" + copy(language,1,3) + "_SYNTAX_PARMS",global_str("@LANG"));
// this will reinit the syntax highliting for this language
			RM("SET_SYNTAX_PARMS /LANG=" + language);
		}
		if (parse_int("/NOCHECK=",mparm_str) == 0) {
//check record count against orignal amount
			RM("GET_DB_RECORD /NDF=1/F=MECONFIG/DPT=LANGUAGE.DB/DBF=LANG/AGLO=@TLANG/FV=" + language);
			if (global_int("@TLANG") > global_int("@LANG") )
				RM('MEERROR^MessageBox /T=WARNING/B=1/M=If you added any new language types, be sure that you have the appropriate support macros.');
			set_global_int("@LANG",0);
		}
	}
	switch_win_id(active_window);
	goto_mark;
}


macro SETSAVE TRANS2 {
/*******************************************************************************
                               MULTI-EDIT MACRO

NAME:  SETSAVE

DESCRIPTION:  This macro creates and compiles INIT.S to save all setup
              parameters

PARAMETERS:
              /NKKW=1   Don't get rid of keymap window when done.  This
                        rarely used parameter was created specifically
                        for conversion macros so that the keymap window
                        can be retained and reused.

               (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

#ifdef DEMO
	RM("MESSAGEBOX /B=2/T=OPERATION NOT AVAILABLE IN DEMO/M=The Multi-Edit Demo does not support permanent saving of configuration settings.");
#else
  str gn[32], gv[2048];

  int T_Insert_Mode;
  int Active_Window;

  Refresh = False;

  T_Insert_Mode = Insert_Mode;
  Return_Str = '';
  Undo_Stat = False;
  Insert_Mode = True;
  Active_Window = Window_Id;
  Working;

  if( LocateDBPage( "MECONFIG", "INIT.CFG", true ) )
  {
    if( read_only )
    {
      rm("MESSAGEBOX /B=2/T=Error Saving Configuration/M=MECONFIG.DB is locked!");
      goto end_of_mac;
    }

    int tl = c_line;
    goto_col(1);
    down;
    block_begin;
    while(!at_eof && (cur_char != "\f"))
    {
      down;
    }
    up;
    block_end;
    if(c_line > tl)
      delete_block;
    goto_line(tl);

    eol;
    cr;

    put_line("/MEMORY_PERCENTAGE=" + str(memory_percentage ) );
    eol; cr;;

    Put_Line('/PAGE_STR=' + Convert_String(page_str));
    eol; cr;;

    Put_Line('/TRUNCATE_SPACES=' + Str(Truncate_Spaces));
    eol; cr;;

    Put_Line('/PERSISTENT_BLOCKS=' + Str(persistent_Blocks));
    eol; cr;;

    Put_Line('/SAVE_RESETS_CHANGED=' + Str(save_resets_changed));
    eol; cr;;

    Put_Line('/TYPING_OVERWRITES_BLOCK=' + Str(typing_overwrites_block));
    eol; cr;;

    Put_Line('/STREAM_BLOCK_MODE=' + Str(stream_block_mode));
    eol; cr;;

    Put_Line('/CTRL_Z=' + Str(Ctrl_Z));
    eol; cr;;

    Put_Line('/EOF_CR=' + Str(Eof_Cr));
    eol; cr;;

    Put_Line('/FILE_LOCKING=' + Str(File_Locking));
    eol; cr;;

    Put_Line('/DISPLAY_TABS=' + Str(Display_Tabs));
    eol; cr;;

    Put_Line('/TAB_EXPAND=' + Str(Tab_Expand));
    eol; cr;;

    Put_Line('/WORD_DELIMITS=' + Convert_String(Word_Delimits));
    eol; cr;;

    Put_Line('/MAX_UNDO=' + Str(Max_Undo));
    eol; cr;;

    Put_Line('/COLUMN_MOVE_STYLE=' + Str(Column_Move_Style));
    eol; cr;;

    Put_Line('/KEYWORD_HIGHLIGHTING=' + Str(Keyword_Highlighting));
    eol; cr;;

    Put_Line('/KEYWORD_CLINE_OVERRIDE=' + Str(Keyword_Cline_Override));
    eol; cr;;

    Put_Line('/CL_FOCUS_RECT=' + Str(CL_Focus_Rect));
    eol; cr;;

    Put_Line('/INSERT_MODE=' + str(Global_Int('Default_Insert_Mode')));
    eol; cr;;

    Put_Line('/BACKUPS=' + Str(Backups));
    eol; cr;;

    Put_Line('/INS_CURSOR=' + Str(INS_CURSOR));
    eol; cr;;

    Put_Line('/OVR_CURSOR=' + Str(OVR_CURSOR));
    eol; cr;;


    put_line('/GLOBAL_VARIABLES=');
    eol; cr;;

    gn = "@ME_SERIAL#";
    call do_global_str;

    gn = "@MEWPROCSTART";
    call do_global_str;

    gn = "&WCMDMAPNAME";
    call do_global_str;

    gn = "&DEFAULTFONT";
    call do_global_str;

    gn = "&DEFAULTMENU";
    call do_global_str;

    gn = "&DEFAULTCOLOR";
    call do_global_str;

    gn = "!BACKUP_PATH";
    call do_global_str;

    gn = "!TEMP_PATH";
    call do_global_str;

    gn = "@TMP_FILE_PATH";
    call do_global_str;


    gv = Global_Str('!AUTOSAVEPARMS');
    var_remove_str('/H1=', gv );
    var_remove_str('/H2=', gv );

    gn = "!AUTOSAVEPARMS";
    call do_global_str2;

    gn = "@PGM_MENU_BYPASS";
    call do_global_int;

    gn = "@RESTORE_PATH";
    call do_global_str;

    gn = "@RESTORE_FLAGS";
    call do_global_int;

    gn = "~SESSION_NEW_EMPTY";
    call do_global_int;

    gn = "!AUTOARRANGERRSRC";
    call do_global_int;

    gn = "&VCSENABLE";
    call do_global_int;

    gn = "@DEFAULT_EXT_LIST";
    call do_global_str;

    gn = "DEFAULT_INSERT_MODE";
    call do_global_int;

    gn = "REG_EXP_STYLE";
    call do_global_int;

    gn = "SWITCHES";
    gv = GLobal_Str("DEF_SWITCHES");
    call do_global_str2;

    gn = "DEF_SWITCHES";
    call do_global_str;

    gn = "REPL_SWITCHES";
    gv = GLobal_Str("DEF_REPL_SWITCHES");
    call do_global_str2;

    gn = "DEF_REPL_SWITCHES";
    call do_global_str;

    gn = "FSWITCHES";
    gv = GLobal_Str("DEF_FS_SWITCHES");
    call do_global_str2;

    gn = "DEF_FS_SWITCHES";
    call do_global_str;

    gn = "FSEARCH_PATH";
    gv = GLobal_Str("DEF_FS_PATH");
    call do_global_str2;

    gn = "DEF_FS_PATH";
    call do_global_str;

    gn = "FRSWITCHES";
    gv = GLobal_Str("DEF_FSR_SWITCHES");
    call do_global_str2;

    gn = "DEF_FSR_SWITCHES";
    call do_global_str;

    gn = "FSEARCH_REPL_PATH";
    gv = GLobal_Str("DEF_FSR_PATH");
    call do_global_str2;

    gn = "DEF_FSR_PATH";
    call do_global_str;

    gn = "FC_CONFIG_STR";
    call do_global_str;

    gn = "BINARY_MODE";
    call do_global_int;

    gn = "TOOLHELPDELAY";
    call do_global_int;


    gn = "SPLIT_EDGE_MODE";
    call do_global_int;

    gn = "NO_CONFIRM_OVERWRITE";
    call do_global_int;

    gn = "CURSOR_EOB";
    call do_global_int;

    gn = "@RESTORE";
    call do_global_int;

    gn = "@MAXIMIZE_WINDOWS";
    call do_global_int;

    gn = "NOFILE_HIDDEN";
    call do_global_int;

    gn = "!DOSEXECMETHOD";
    call do_global_int;

    gn = "BlockOffAfterPaste";
    call do_global_int;

    Set_Global_Int('SETUP_CHANGED', 0);

    save_file;
    error_level = 0;

    // TMJ - 01-15-93 08:52am
    // This is to  allow for other macros to be executed after the configuration
    // is changed
    str temp_stuff = global_str('@CONFIG_MACRO@');
    int jx;

    while(  temp_stuff != ''  ) {
      jx = xpos( ';', temp_stuff, 1 );
      if(  jx == 0  ) {
        jx = svl(temp_stuff) + 1;
      }
      Return_Int = 1;
      if(  jx > 1  ) {
        RM( copy( temp_stuff, 1, jx -1)  );
      }
      temp_stuff = str_del( temp_stuff, 1, jx );
   //   if(  return_int == 0  ) {
   //     goto end_of_mac;
   //   }
    }
  }
  else
  {
    rm("MESSAGEBOX /B=2/T=Error Saving Configuration/M=Could not build INIT.CFG in MECONFIG.DB");
  }

  Goto END_OF_MAC;
/*********************************** SUBROUTINES *******************************/

do_global_str:
  put_line("/GS=" + gn + "=" + Convert_String( global_str(gn)));
  eol; cr;
  ret;

do_global_str2:
  put_line("/GS=" + gn + "=" + Convert_String( gv ));
  eol; cr;;
  ret;

do_global_int:
  put_line("/GI=" + gn + "=" + str( Global_Int(gn)));
  eol; cr;;
  ret;



END_OF_MAC:

/* clean up altered system variables */
  Undo_Stat = True;
  Insert_Mode = T_Insert_Mode;
  switch_win_id( active_window );
#endif // DEMO

}