// $Header: /MEWIN/SRC/MEWLOGO.S 37    2/06/95 5:17p Todd $

#include windows.sh
#include mew_dlgs.sh
#include mew_btn.sh
#include mewlib.sh
#include mewlogo.sh
#include MEW.SH

#DEFINE mewlogo_title "Version " + version + ""

global
{
  int mewlogo_window "&mewlogo_window";
  int mewlogo_bmp "&mewlogo_bmp";
  int mewlogo_offset "&mewlogo_offset";
}

void mewlogo( int m = parse_int("/M=", mparm_str) )
{

  struct tmsg msg;


  switch( m )
  {
    case 0 :
    case 2 :
      str title;
      int x = 0, y = 0, kwin = 0;
      int main_dlg;

      Mew_Set_3d;

      if( m != 2)
      {
        main_dlg = Create_Mew_DlgEx ("", WS_POPUP, x, y, frame_handle, DLG_NOSIZE | DLG_NOCENTER | DLG_NOPARDISABLE);
        mewlogo_offset = 0;
      }
      else
      {
        main_dlg = Create_Mew_Dlg("About Multi-Edit for Windows", "", frame_handle, DLG_NOSIZE | DLG_NOCENTER);
        mewlogo_offset = 1;
      }


      // Get the size of the bitmap
      int tbh, dc;
      struct tbitmap tb;

      dc = GetDc(  frame_handle );
      mewlogo_bmp = LoadBitmap( app_handle, "LOGO2");
      SelectObject( dc, mewlogo_bmp );
      GetObject( mewlogo_bmp, 14, &tb );

      ReleaseDc(frame_handle, dc);

      // Create a dummy static frame for sizing
      int th = Create_MEW_Ctrl( "STATIC", "",
                    ws_visible | SS_GRAYFRAME,
                    mewlogo_offset,
                    mewlogo_offset * 4,
                    tb.bmwidth - 1 + mewlogo_offset,
                    tb.bmheight - 1 + mewlogo_offset,
                    main_dlg,111,
                    app_handle,  0
                  );



      int line_height, font_height, font_width, dfont;
      Get_MEW_Dlg_Metrics( main_dlg, line_height, font_height, font_width, dfont );

  /*
      int mf_x = 230;
      int mf_y = 13;
      int mf_w = 158;
      int mf_h = 80;

      int swin = Create_MEW_Ctrl( "STATIC", "",
                    ws_visible | SS_BLACKFRAME,
                    mf_x,
                    mf_y,
                    mf_w,
                    mf_h,
                    main_dlg,105,
                    app_handle,  0
                  );

      title = "Version " + version + "\r\n\r\nALPHA release 4c";

      int swin = Create_MEW_Ctrl( "STATIC", title,
                    ws_visible | SS_CENTER,
                    mf_x + 2,
                    mf_y + 2,
                    mf_w - 4,
                    mf_h - 4,
                    main_dlg,101,
                    app_handle,  0
                  );
    */
      if(  m== 2 )
      {
       kwin = Create_MEW_Ctrl( "BUTTON", "OK",
                    ws_child | bs_defpushbutton  | ws_visible | ws_tabstop,
                    295,
                    125,
                    75,
                    25,
                    main_dlg,1001,
                    app_handle,  0
                  );
      }

      // Size the dialog using the dummy static frame
      Auto_Size_Mew_Dlg( main_dlg, 0, 0 );
      Center_Mew_Dlg( main_dlg, TRUE );

      // Kill the dummy static frame
      DestroyWindow( th );

      // Initiate the window proc
      SubClass_With_Macro( main_dlg, "MewLogoProc", "" );


      mewlogo_window = main_dlg;

      // Display the window
      ShowWindow( main_dlg, sw_shownormal );


      if( m == 2 )
      {
        call mloop;
        BringWindowToTop( kwin );
        SetFocus( kwin );

       kloop:
        if ( getmessage( &msg,0,0,0) )
				{
          if( msg.message == wm_user)
					{
            switch( msg.wparam )
            {
              case 999 :
              case 1 :
              case 2 :
              case 100 :
              case 1001 :
                goto kdone;
            }
					}
          if( !IsDialogMessage( main_dlg, &msg) )
	 				{
              translatemessage( &msg );
              dispatchmessage( &msg );
	 				}
				}
        goto kloop;
      kdone:
        destroy_mew_dlg( mewlogo_window );
        mewlogo_window = 0;
      }
      else
      {
        call mloop;
      }

      break;

    case 3 :
      if(mewlogo_window != 0)
      {
//        ProcessMsgQueue(10);
        SendMessage( mewlogo_window, WM_MEWLOGO_TEXT, 0, 0 );
      }
      break;

    case 1 :
      if(mewlogo_window != 0)
      {
        destroy_mew_dlg( mewlogo_window );
        mewlogo_window = 0;
      }
      break;
  }
  return();

mloop:
  int jx = 10;
  while (jx)
  {
    --jx;
    if ( peekmessage( &msg,0,0,0, PM_REMOVE) )
    {
      translatemessage( &msg );
      dispatchmessage( &msg );
    }
    else
      jx = 0;
  }
  ret;

}


int MewLogoProc( int &retval, int window, message, wparam, lparam, str parms ) no_break
{
  int result = 0;
  struct trect tr;
  struct TPaintStruct pi;

  switch ( message )
  {
    case WM_DESTROY :
      if(mewlogo_bmp)
      {
        DeleteObject( mewlogo_bmp );
        mewlogo_bmp = 0;
        mewlogo_offset = 0;
        mewlogo_window = 0;
      }
      break;

    case WM_MEWLOGO_TEXT :
      call set_tr;
      invalidaterect( window, &tr, false );
      UpdateWindow(window);
      break;

    case WM_PAINT :
      BeginPaint (window, &pi);
      if (   !((pi.top    == 0)
        & (pi.bottom == 0)
        & (pi.left   == 0)
        & (pi.right  == 0)))
      {
        if(mewlogo_bmp)
        {
          //DrawBitmap256(pi.hdc, mewlogo_bmp, mewlogo_offset, mewlogo_offset * 4, 0 );
          DrawBitmap(pi.hdc, mewlogo_bmp, mewlogo_offset, mewlogo_offset * 4, 0 );
        }
        call draw_logo_text;



      }
      EndPaint( window, &pi);
      result = 1;
      break;
  }
  return( result );

 set_tr:
  tr.left = 250;
  tr.top = 12;
  tr.right = 410;
  tr.bottom = 13 + 80;
  ret;

 draw_logo_text:
  call set_tr;
  SetBkMode( pi.hdc, TRANSPARENT );
  SetTextColor( pi.hdc, GetSysColor( COLOR_BTNHIGHLIGHT ) );
  drawtext(pi.hdc, mewlogo_title, -1, &tr, DT_CENTER | DT_WORDBREAK);
  tr.left = 253;
  tr.top = 14;
  SetTextColor( pi.hdc,  GetSysColor( COLOR_BTNSHADOW ));
  drawtext(pi.hdc, mewlogo_title, -1, &tr, DT_CENTER | DT_WORDBREAK);
  tr.left = 251;
  tr.top = 13;
  SetTextColor( pi.hdc, GetSysColor( COLOR_BTNTEXT ) );

  str tstr[128] = mewlogo_title + "\n\r\n\r";

  if(max_user_count == 255)
  {
    tstr += "Unlimited License";
  }
  else
  {
    tstr += "Licensed users: " + str(max_user_count);
  }
  if(Global_Str('@ME_SERIAL#') != "")
  {
      tstr += "\n\rsn: " + Global_Str('@ME_SERIAL#');
  }

  drawtext(pi.hdc, tstr, -1, &tr, DT_CENTER | DT_WORDBREAK);

  //drawtext(pi.hdc, mewlogo_title, -1, &tr, DT_CENTER | DT_WORDBREAK);
  ret;

}