/*
 *  m a p i . s h
 *
 *  Messaging Applications Programming Interface.
 *
 *  Purpose:
 *    This file defines the structures and constants used by
 *    that subset of the messaging applications programming
 *    interface which will be supported under Windows by
 *    Microsoft Mail for PC Networks vesion 3.0.
 */


#DEFINE	ULong	  	LongInt
#DEFINE	LPDWORD		*DWORD
#DEFINE	Flags	  	LongInt
#DEFINE	LHandle	  LongInt
#DEFINE	LPLHandle	*LHandle
#DEFINE LongInt INT
#DEFINE ASCIIZP INT
#DEFINE POINTINT INT


#DEFINE	  lhSessionNull	0


// #DEFINE	PMapiFileDesc	  *TMapiFileDesc
#DEFINE	PMapiFileDesc	  INT
structure TMapiFileDesc
{
    LongInt ulReserved;       // Reserved for future use (must be 0)
    LongInt flFlags;		// Flags
    LongInt nPosition;        // character in text to be replaced by attachment
    ASCIIZP lpszPathName;       // Full path name of attachment file
    ASCIIZP lpszFileName;       // Original file name (optional)
    POINTINT lpFileType;       // Attachment file type (optional)
}



#DEFINE	  MAPI_OLE 				0x00000001
#DEFINE	  MAPI_OLE_STATIC 0x00000002


// #DEFINE	PMapiRecipDesc	  *TMapiRecipDesc
#DEFINE	PMapiRecipDesc	  INT
structure TMapiRecipDesc
{
    LongInt ulReserved;           // Reserved for future use
    LongInt ulRecipClass;         // Recipient class
                                    // MAPI_TO, MAPI_CC, MAPI_BCC, MAPI_ORIG
    ASCIIZP lpszName;               // Recipient name
    ASCIIZP lpszAddress;            // Recipient address (optional)
    LongInt ulEIDSize;            // Count in bytes of size of pEntryID
    POINTINT lpEntryID;            // System-specific recipient reference
}


#DEFINE	  MAPI_ORIG 0           // Recipient is message originator
#DEFINE	  MAPI_TO   1           // Recipient is a primary recipient
#DEFINE	  MAPI_CC   2           // Recipient is a copy recipient
#DEFINE	  MAPI_BCC  3           // Recipient is blind copy recipient


// #DEFINE	PMapiMessage	  *TMapiMessage
#DEFINE	PMapiMessage	  INT
structure TMapiMessage
{
    LongInt ulReserved;                   // Reserved for future use (M.B. 0)
    ASCIIZP lpszSubject;                  // Message Subject
    ASCIIZP lpszNoteText;                 // Message Text
    ASCIIZP lpszMessageType;              // Message Class
    ASCIIZP lpszDateReceived;             // in YYYY/MM/DD HH:MM format
    ASCIIZP lpszConversationID;		// conversation thread ID
    Flags flFlags;                      // unread,return receipt
    pMapiRecipDesc lpOriginator;       // Originator descriptor
    ULong nRecipCount;                  // Number of recipients
    pMapiRecipDesc lpRecips;           // Recipient descriptors
    ULong nFileCount;                   // # of file attachments
    pMapiFileDesc lpFiles;             // Attachment descriptors
}



#DEFINE	  MAPI_UNREAD            0x00000001
#DEFINE	  MAPI_RECEIPT_REQUESTED 0x00000002
#DEFINE	  MAPI_SENT              0x00000004

/*
 *  Entry points.
 */

#DEFINE	  MAPI_LOGON_UI         0x00000001  // Display logon UI
#DEFINE	  MAPI_NEW_SESSION      0x00000002  // Do not use default.
#DEFINE	  MAPI_DIALOG           0x00000008  // Display a send note UI
#DEFINE	  MAPI_UNREAD_ONLY      0x00000020  // Only unread messages
#DEFINE	  MAPI_ENVELOPE_ONLY    0x00000040  // Only header information
#DEFINE	  MAPI_PEEK             0x00000080  // Do not mark as read.
#DEFINE	  MAPI_GUARANTEE_FIFO		0x00000100	// use date order
#DEFINE	  MAPI_BODY_AS_FILE			0x00000200
#DEFINE	  MAPI_AB_NOMODIFY			0x00000400	// Don't allow mods of AB entries
#DEFINE	  MAPI_SUPPRESS_ATTACH	0x00000800	// header + body, no files
#DEFINE	  MAPI_FORCE_DOWNLOAD		0x00001000	// force download of new mail during MAPILogon

import DWORD MAPILogon(DWORD ulUIParam , ASCIIZ lpszName, ASCIIZ lpszPassword ,
                   Flags flFlags , DWORD ulReserved ,
                   LPLHandle lplhSession )   MAPI 11;

import DWORD MAPILogoff(LHandle lhSession , DWORD ulUIParam , Flags flFlags ,
                    DWORD ulReserved )   MAPI 12;

import DWORD MAPISendMail(LHandle lhSession , DWORD ulUIParam ,
                      pMapiMessage lpMessage , Flags flFlags ,
                      DWORD ulReserved )   MAPI 13;

import DWORD MAPISendDocuments(DWORD ulUIParam , ASCIIZ lpszDelimChar ,
                           ASCIIZ lpszFilePaths , ASCIIZ lpszFileNames ,
                           DWORD ulReserved )   MAPI 10;

import DWORD MAPIFindNext(LHandle lhSession , DWORD ulUIParam ,
                      ASCIIZ lpszMessageType, ASCIIZ lpszSeedMessageID ,
                      Flags flFlags , DWORD ulReserved ,
                      *ASCIIZ lpszMessageID )   MAPI 16;

import DWORD MAPIReadMail(LHandle lhSession , DWORD ulUIParam ,
                      ASCIIZ lpszMessageID , Flags flFlags ,
                      DWORD ulReserved , pMapiMessage lppMessageOut )   MAPI 15;

import DWORD MAPISaveMail(LHANDLE lhSession , DWORD ulUIParam ,
                      pMapiMessage pMessage , FLAGS flFlags ,
                      DWORD ulReserved , ASCIIZ lpszMessageID )   MAPI 14;

import DWORD MAPIDeleteMail(LHANDLE lhSession , DWORD ulUIParam ,
                        ASCIIZ lpszMessageID , Flags flFlags ,
                        DWORD ulReserved )   MAPI 17;

import DWORD MAPIFreeBuffer( POINTER pv )   MAPI 18;

import DWORD MAPIAddress(LHandle lhSession , DWORD ulUIParam ,
	             ASCIIZ plszCaption , DWORD nEditFields ,
		     ASCIIZ lpszLabels , DWORD nRecips ,
		     pMapiRecipDesc lpRecips , FLAGS flFlags , DWORD ulReserved ,
		     LPDWORD lpnNewRecips , pMapiRecipDesc lppNewRecips )   MAPI 19;

import DWORD MAPIDetails(LHANDLE lhSession , LHANDLE ulUIParam ,
		     pMapiRecipDesc lpRecip , FLAGS flFlags , DWORD ulReserved )   MAPI 20;

import DWORD MAPIResolveName(LHANDLE lhSession , DWORD ulUIParam ,
			 *ASCIIZ lpszName , FLAGS flFlags ,
			 DWORD ulReserved , pMapiRecipDesc lppRecip )   MAPI 21;


#DEFINE	  SUCCESS_SUCCESS                   0
#DEFINE	  MAPI_USER_ABORT                   1
#DEFINE	  MAPI_E_FAILURE                    2
#DEFINE	  MAPI_E_LOGIN_FAILURE              3
#DEFINE	  MAPI_E_DISK_FULL                  4
#DEFINE	  MAPI_E_INSUFFICIENT_MEMORY        5
#DEFINE	  MAPI_E_ACCESS_DENIED		    			6
#DEFINE	  MAPI_E_TOO_MANY_SESSIONS          8
#DEFINE	  MAPI_E_TOO_MANY_FILES             9
#DEFINE	  MAPI_E_TOO_MANY_RECIPIENTS        10
#DEFINE	  MAPI_E_ATTACHMENT_NOT_FOUND       11
#DEFINE	  MAPI_E_ATTACHMENT_OPEN_FAILURE    12
#DEFINE	  MAPI_E_ATTACHMENT_WRITE_FAILURE   13
#DEFINE	  MAPI_E_UNKNOWN_RECIPIENT          14
#DEFINE	  MAPI_E_BAD_RECIPTYPE              15
#DEFINE	  MAPI_E_NO_MESSAGES                16
#DEFINE	  MAPI_E_INVALID_MESSAGE            17
#DEFINE	  MAPI_E_TEXT_TOO_LARGE             18
#DEFINE	  MAPI_E_INVALID_SESSION	    			19
#DEFINE	  MAPI_E_TYPE_NOT_SUPPORTED	    		20
#DEFINE	  MAPI_E_AMBIGUOUS_RECIPIENT	    	21
#DEFINE	  MAPI_E_MESSAGE_IN_USE		    			22
#DEFINE	  MAPI_E_NETWORK_FAILURE	    			23
#DEFINE	  MAPI_E_INVALID_EDITFIELDS	    		24
#DEFINE	  MAPI_E_INVALID_RECIPS		    			25
#DEFINE	  MAPI_E_NOT_SUPPORTED		    			26