// $Header: /MeWin/Build/Src/LINEDRAW.S 6     2/06/95 5:44p Manny $
Macro_File LineDraw;

#include windows.sh

macro LINEDRAW TRANS {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: LINEDRAW

Description: This macro allows the user to draw the single and double line
characters using the arrow keys to create lines and boxes etc.

							(C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

/*
Here is a list of all of the linedrawing characters:

 */
/*  Define variables  */

  Struct Tmsg msg;
  char U_Char,D_Char,L_Char,R_Char;
	int Temp_Integer,Present_Direction,A_Left,A_Right,A_Up,A_Down,
          Draw_Mode, shifted, action = 0,
					Temp_Insert = Insert_mode,
					D_Mode,U_Mode,L_Mode,R_Mode,
					Temp_Tab_Expand = Tab_Expand,
					K1,K2,Same_Direction,
          t_undo_stat = undo_stat, or = refresh;

/*  Store current status of certain stuff so we can restore it upon exit.  */
	Insert_Mode = False;
	Tab_Expand = False;
	Push_Labels;
	refresh = TRUE;
	Redraw;
/*  Initialize variables  */

	Present_Direction = 0;
	A_Left = 1;
	A_Right = 2;
	A_Up = 3;
	A_Down = 4;

	Draw_Mode = 1;
  MAKE_MESSAGE('SINGLE: Arrows=move, Shift Arrows=draw, TAB=Dbl Line, Esc=quit.');
  //FLABEL('Double',2,$FF);

  while ( GetMessage(&msg, 0, 0, 0) ) {
    if ( msg.message == WM_KEYDOWN ) {
      if ( msg.wparam == VK_ESCAPE )
      {
        make_message('');
        goto end_of_mac;
      }
      if ( (msg.wparam == VK_F1)     || (msg.wparam == VK_TAB)
        || (msg.wparam == VK_PRIOR)  || (msg.wparam == VK_NEXT)
        || (msg.wparam == VK_END)    || (msg.wparam == VK_HOME)
        || (msg.wparam == VK_LEFT)   || (msg.wparam == VK_UP)
        || (msg.wparam == VK_RIGHT)  || (msg.wparam == VK_DOWN) ) {
          action = msg.wparam;
          if ( getkeystate(VK_SHIFT) & 0x8000 ) {
            shifted = true;
          } else
            shifted = false;
          push_undo;
          call take_action;
          pop_undo;
      }
      continue;
    }
    if ( msg.message == WM_SYSKEYDOWN ) {
      if ( (msg.wparam > 0x2F) && (msg.wparam < 0x60) ) {
        continue;
      }
    }
    //if ((msg.message <= WM_NCMButtonDblClk) && (msg.message > WM_NCMouseMove))
    //if ( (msg.message == WM_LBUTTONDBLCLK) || (msg.message == WM_LBUTTONDOWN)
    //  || (msg.message == WM_RBUTTONDBLCLK) || (msg.message == WM_RBUTTONDOWN)
    //  || (msg.message == WM_MBUTTONDBLCLK) || (msg.message == WM_MBUTTONDOWN))
    //{
    //  goto WAIT_FOR_KEYPRESS;
    //}
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  PostQuitMessage(0);

  goto end_of_mac;

TAKE_ACTION:
  if (action == VK_F1) {
    rm ('MEWHELP^MEWHELP /H=LD');
  }
  if (action == VK_TAB) {
		if(  (Draw_Mode < 3)  ) {
			++Draw_Mode;
		} else {
			Draw_Mode = 1;
		}
		MAKE_MESSAGE(Copy(
'SINGLE: Arrows=move, Shift Arrows=draw, TAB=Dbl Line, Esc=quit.        ' +
'DOUBLE: Arrows=move, Shift Arrows=draw, TAB=erase, Esc=quit.           ' +
'ERASE: Arrows=move, Shift Arrows=erase, TAB=Sngl Line, Esc=quit.    '
                                        ,((Draw_Mode - 1) * 71) + 1,71));
    ret;
  }
  if ( action == VK_PRIOR ) {
		Page_Up;
	}
  if ( action == VK_NEXT ) {
		Page_Down;
	}
  if ( action == VK_HOME ) {
		Home;
	}
  if ( action == VK_END ) {
		Eol;
	}

  if ( action == VK_RIGHT ) {
    if(  c_col > right_margin  ) { /* Don't allow cursor to wrap down */
      ret;
		}
    if ( !shifted ) {
			Right;
			Present_Direction = 0;
      ret;
		}
    if ( shifted ) {
			if(  (Draw_Mode == 3)  ) {
				Text(' ');
				Present_Direction = 0;
        ret;
			}
			Same_Direction = (Present_Direction == A_Right);
			if (Same_Direction) {	/* If we were previously going a
different direction, then insert char at current cusror position. Otherwise,
insert char in the next right position */
				Right;
			}
			Present_Direction = A_Right;
			Call LOOK_AROUND;

			Temp_Integer = XPos(L_Char,'پ',1);
			if ((Temp_Integer) && (Same_Direction)) {
				Left;
				Text(Copy('',((Draw_Mode - 1) * 12) + Temp_Integer,1));
        LEFT;
        ret;
			}

			if ((L_Mode > 0) & ((D_Mode + U_Mode + R_Mode) == 0)) {
				Text(Copy('',Draw_Mode,1));
        LEFT;
        ret;
			}

			if(  ((D_Mode == 1) & (U_Mode == 1))  ) {
				Text(Copy('ƴδƵ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        LEFT;
        ret;
			}

			if(  ((D_Mode == 2) & (U_Mode == 2))  ) {
				Text(Copy('̶ζ̴',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        LEFT;
        ret;
			}

			if(  (D_Mode == 1)  ) {
				Text(Copy('տտ˿տڸ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        LEFT;
        ret;
			}

			if(  (D_Mode == 2)  ) {
				Text(Copy('ɷ˷ɷֻ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        LEFT;
        ret;
			}

			if(  (U_Mode == 2)  ) {
				Text(Copy('ȽʽȽӼ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (U_Mode == 1)  ) {
				Text(Copy('پټټپ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

/* If no other condition exists... */
			Text(Copy('',Draw_Mode,1));
      left;
        ret;
		}
	}
  if ( action == VK_LEFT ) {
		if(  c_col == 1  ) { /* Don't allow cursor to wrap up */
      ret;
		}
    if ( !shifted ) {
			Left;
			Present_Direction = 0;
      ret;
		}
    if ( shifted ) {
			if(  (Draw_Mode == 3)  ) {
				Text(' ');
				Left;
				Left;
				Present_Direction = 0;
        ret;
			}
			Same_Direction = (Present_Direction == A_Left);
			if (Same_Direction) {	/* If we were previously going a
different direction, then insert char at current cusror position. Otherwise,
insert char in the next left position */
				Left;
			}
			Present_Direction = A_Left;
			Call LOOK_AROUND;

			Temp_Integer = XPos(R_Char,'',1);
			if ((Temp_Integer) && (Same_Direction)) {
				Right;
				Text(Copy('',((Draw_Mode - 1) * 12) + Temp_Integer,1));
        left;
        ret;
			}

			if(  ((R_Mode > 0) & ((D_Mode + U_Mode + L_Mode) == 0))  ) {
				Text(Copy('',Draw_Mode,1));
        left;
        ret;
			}

			if(  ((D_Mode == 1) & (U_Mode == 1))  ) {
				Text(Copy('ƴδƴ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}


			if(  ((D_Mode == 2) & (U_Mode == 2))  ) {
				Text(Copy('̶̶ǹ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (D_Mode == 1)  ) {
				Text(Copy('տ˿տ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (D_Mode == 2)  ) {
				Text(Copy('ɷ˷ɷ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (U_Mode == 2)  ) {
				Text(Copy('ȽʽȽ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (U_Mode == 1)  ) {
				Text(Copy('پپپپپ',((L_Mode * 8) + (R_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

/* If no other condition exists... */
			Text(Copy('',Draw_Mode,1));
      left;
        ret;
		}
	}
  if ( action == VK_UP ) {
		if(  C_Line == 1  ) {
      ret;
		}
    if ( !shifted ) {
			Up;
			Present_Direction = 0;
      ret;
		}
    if ( shifted ) {
			if(  (Draw_Mode == 3)  ) {
				Text(' ');
				Left;
				Up;
				Present_Direction = 0;
        ret;
			}
			Same_Direction = (Present_Direction == A_Up);
			if (Same_Direction) {	/* If we were previously going a
different direction, then insert char at current cusror position. Otherwise,
insert char in the next up position */
				Up;
			}
			Present_Direction = A_Up;
			Call LOOK_AROUND;


			Temp_Integer = XPos(D_Char,'',1);
			if ((Temp_Integer) && (Same_Direction)) {
				Down;
				Text(Copy('Ź',((Draw_Mode - 1) * 12) + Temp_Integer,1));
        left;
        ret;
			}

			if(  ((D_Mode > 0) & ((R_Mode + U_Mode + L_Mode) == 0))  ) {
				Text(Copy('',Draw_Mode,1));
        left;
        ret;
			}

			if(  ((L_Mode == 1) & (R_Mode == 1))  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  ((L_Mode == 2) & (R_Mode == 2))  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (L_Mode == 1)  ) {
				Text(Copy('ٽٽٽٷٽٽ',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (L_Mode == 2)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (R_Mode == 2)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (R_Mode == 1)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

/* If no other condition exists... */
			Text(Copy('',Draw_Mode,1));
      left;
        ret;
		}
	}
  if ( action == VK_DOWN ) {
    if ( !shifted ) {
			Down;
			Present_Direction = 0;
      ret;
		}
    if ( shifted ) {
			if(  (Draw_Mode == 3)  ) {
				Text(' ');
				Left;
				Down;
				Present_Direction = 0;
        ret;
			}
			Same_Direction = (Present_Direction == A_Down);
			if (Same_Direction) {	/* If we were previously going a
different direction, then insert char at current cusror position. Otherwise,
insert char in the next down position */
				Down;
			}
			Present_Direction = A_Down;
			Call LOOK_AROUND;

			Temp_Integer = XPos(U_Char,'پ',1);
			if ((Temp_Integer) && (Same_Direction)) {
				Up;
				Text(Copy('Ź',((Draw_Mode - 1) * 12) + Temp_Integer,1));
        left;
        ret;
			}

			if(  ((U_Mode > 0) & ((R_Mode + D_Mode + L_Mode) == 0))  ) {
				Text(Copy('',Draw_Mode,1));
        left;
        ret;
			}

			if(  ((L_Mode == 1) & (R_Mode == 1))  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}


			if(  ((L_Mode == 2) & (R_Mode == 2))  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (L_Mode == 1)  ) {
				Text(Copy('ټټٽ',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (L_Mode == 2)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (R_Mode == 2)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

			if(  (R_Mode == 1)  ) {
				Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + Draw_Mode,1));
        left;
        ret;
			}

/* If no other condition exists... */
			Text(Copy('',Draw_Mode,1));
      left;
      ret;
		}
	}

  ret;
/*******************************************************************************/
//  Goto WAIT_FOR_KEYPRESS;


LOOK_AROUND:
/*  This subroutine looks at all chars surrounding CUR_CHAR and stores special
values into variables based on what it finds  */

	Undo_stat = False;
  //if(  (((C_Row + 2) > Win_Y1) & ((C_Row + 4) < Win_Y2))  ) {
		Refresh = False;
  //}

	if(  C_Line > 1  ) {
		UP;
		U_Char = Cur_Char;
		RIGHT;
		DOWN;
	} else {
		U_Char = '|0';
		Right;
	}
	R_Char = Cur_Char;
	DOWN;
	LEFT;
	D_Char = Cur_Char;
	if(  c_col > 1  ) {
		LEFT;
		UP;
		L_Char = Cur_Char;
		RIGHT;
	} else {
		L_Char = '|0';
		Up;
	}
	Refresh = True;

	D_mode = XPos(D_Char,'϶',1);
	D_mode = (D_Mode > 0) + (D_Mode > 13);
	U_mode = XPos(U_Char,'ڶ',1);
	U_mode = (U_Mode > 0) + (U_Mode > 13);
	L_mode = XPos(L_Char,'',1);
	L_mode = (L_Mode > 0) + (L_Mode > 13);
	R_mode = XPos(R_Char,'ٵ',1);
	R_mode = (R_Mode > 0) + (R_Mode > 13);
	Undo_stat = t_undo_stat;
	RET;

END_OF_MAC:

	INSERT_MODE = Temp_Insert; /*  Switch previous insert/overwrite mode  */
	Tab_Expand = Temp_Tab_Expand;
	Pop_Labels;
	Undo_Stat = T_undo_stat;
  Refresh = or;
}
