// $Header: /MeWin/Src/FONTS.S 15    1/23/95 4:24p Johnp $
Macro_File fonts;

#include windows.sh
#include commdlg.sh
#include fonts.sh
#include mewhelp.sh
#include mewlib.sh

#define FONT_HELPLINK "FONTS, CHANGING"

#define _FO_ID_HELP   1038

structure ts
{
  ASCIIZ style[100];
}
int ChooseFontProc ( int dlg, int message, int wparam, int lparam, struct TChooseFont frec ) No_Break
{

  int result = 0;
  switch ( message )
  {
    case WM_ACTIVATE :
    {
      if ( wparam )
      {
        HelpLink_String = FONT_HELPLINK;
      }
      else
      {
        HelpLink_String = "";
      }
      break;
    }

    case WM_COMMAND :
    {
      switch ( wparam )
      {
        case _FO_ID_HELP :
          MewHelp_Context();
					result = 1;
					break;
      }
    }
  }
  return (result);
}


int SelectFont( int parent, str &fontname, int &fontsize, int &charset, str helplink ) trans2
{
  struct TLogFont cur_font;
	struct TChooseFont ChooseRec;

  //str old_h_c = help_context

	struct ts t;
  if( !parent)
  {
    parent = frame_handle;
  }

	if ( fontsize == 0 )
	{
		fontsize = -14;
	}

	if ( fontname == "" )
	{
		fontname = "Courier New";
	}

  cur_font.lfHeight         = fontsize;
  cur_font.lfWidth          = 0;
  cur_font.lfEscapement     = 0;
  cur_font.lfWeight         = fw_normal;
  cur_font.lfItalic         = 0;
  cur_font.lfUnderline      = 0;
  cur_font.lfStrikeOut      = 0;
  cur_font.lfOrientation    = 0;
  cur_font.lfCharSet        = ANSI_CharSet;
  cur_font.lfCLipPrecision  = Clip_Default_Precis;
  cur_font.lfQuality        = Default_Quality;
  cur_font.lfPitchAndFamily = Fixed_Pitch | ff_DontCare;
  cur_font.lfFaceName       = fontname;

  ChooseRec.lStructSize     = 46;             //
  ChooseRec.hWndOwner       = parent;         // caller's window handle
  ChooseRec.hDC             = 0;              // printer DC/IC or nil
  ChooseRec.lpLogFont       = &cur_font;      // ptr. to a LOGFONT struct
  ChooseRec.iPointSize      = 0;              // 10 * size in points of selected font
  ChooseRec.Flags           = cf_ScreenFonts | cf_InitToLogFontStr |
                                cf_FixedPitchOnly | CF_SHOWHELP;   // enum. type flags
  ChooseRec.rgbColors       = 0x00ffffff;     // returned text color
  ChooseRec.lCustData       = 0;              // data passed to hook fn.
  ChooseRec.lpfnHook        = 0;              // ptr. to hook function
  ChooseRec.lpTemplateName  = 0;              // custom template name
  ChooseRec.hInstance       = app_handle;    /* instance handle of.EXE that
                                                contains cust. dlg. template */
  ChooseRec.lpszStyle       = &t.style;     /* return the style field here
                                              must be lf_FaceSize or bigger */
  ChooseRec.nFontType       = 0;            /* same value reported to the EnumFonts
                                              call back with the extra fonttype_
                                              bits added */
  ChooseRec.nSizeMin        = 0;            // minimum pt size allowed &
  ChooseRec.nSizeMax        = 0;            /* max pt size allowed if
                                              cf_LimitSize is used      */

  helplink_string = helplink;
  if( HookFontPromptWithMacro( &ChooseRec, "ChooseFontProc" ) )
	{
		fontname = cur_font.lfFaceName;
		fontsize = cur_font.lfHeight;
    charset = cur_font.lfCharset;

		return(TRUE);
	}
	return(FALSE);
}


void SetWindowFonts( int win, str fontname, int fontsize, int charset )
{
	struct TLogFont cur_font;
  int nfont, bfont, ifont, checkl;
  str checks[20] =  'AaBbWw012cdli';

	Fonts_Get(win, nfont, bfont, ifont );
	if(nfont)
	  DeleteObject( nfont );
	if(bfont)
	  DeleteObject( bfont );
	if(ifont)
	  DeleteObject( ifont );

  cur_font.lfHeight     = fontsize;
  cur_font.lfWidth      = 0;
 	cur_font.lfEscapement = 0;
  cur_font.lfWeight     = fw_normal;
  cur_font.lfItalic     = 0;
  cur_font.lfUnderline  = 0;
  cur_font.lfStrikeOut  = 0;
  cur_font.lfOrientation = 0;
  cur_font.lfCharSet    = charset;
  cur_font.lfOutPrecision   = OUT_DEFAULT_PRECIS;
  cur_font.lfCLipPrecision  = Clip_Default_Precis;
  cur_font.lfQuality        = Draft_Quality;
  cur_font.lfPitchAndFamily = Fixed_Pitch | ff_DontCare;
  cur_font.lfFaceName       = fontname;

  nfont = CreateFontIndirect (&cur_Font);

  int dc = GetDc( client_handle );
  int tx = 0;
  if(dc >= 32)
  {
    SelectObject( dc, nfont );
    tx = GetTextExtent( dc, 'A', 1 );
    checkl = GetTextExtent( dc, checks, svl(checks) ) & 0xffff;

    ReleaseDc( client_handle,dc );
  }

//  cur_font.lfWidth = tx & 0xffff;
//  cur_font.lfHeight = tx >> 16;
  cur_font.lfOutPrecision = OUT_DEFAULT_PRECIS;

  cur_font.lfWeight = fw_Bold;
  bfont = CreateFontIndirect(&cur_Font);

  dc = GetDc( client_handle );
  int tx2 = tx;
  if(dc >= 32)
  {
    SelectObject( dc, bfont );

    tx2 = GetTextExtent( dc, checks, svl(checks) ) & 0xffff;
    ReleaseDc( client_handle,dc );
    if(checkl != tx2)
    {
  //    rm("MEERROR^MESSAGEBOX /T=Warning/M=This font will not display bold text");
      DeleteObject( bfont );
/*      cur_font.lfWidth = tx & 0xffff;
      cur_font.lfHeight = tx >> 16;
      cur_font.lfWeight = fw_Normal;
      bfont = CreateFontIndirect(&cur_Font); */
      bfont = 0;
    }
  }

  cur_font.lfWeight = fw_Normal;
  cur_font.lfItalic = 1;

 // cur_font.lfWidth = tx & 0xffff;
 // cur_font.lfHeight = tx >> 16;
  cur_font.lfOutPrecision = OUT_DEFAULT_PRECIS;

  ifont = CreateFontIndirect(&cur_Font);





	Fonts_Set( win, nfont, bfont, ifont );
}


void SetupDefFonts( int parent = parse_int("/DLGHANDLE=", mparm_str) ) trans2
{
	str fontname;
  int fontsize, charset;

	fontname = parse_str("/NAME=", DefaultFont);
	fontsize = parse_int("/SIZE=", DefaultFont);
  charset = parse_int("/SET=", DefaultFont);

  if( SelectFont( parent, fontname, fontsize, charset, FONT_HELPLINK ))
	{
    SetWindowFonts( 0, fontname, fontsize, charset );
    RedrawWindow( frame_handle, 0, 0, rdw_Invalidate | rdw_AllChildren );
    int tr = refresh;
    refresh = true;
		new_screen;
    refresh = tr;
    DefaultFont =  "/NAME=" + fontname  + "/SIZE=" + str(fontsize) + "/SET=" + str(charset);
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
	}
}