extproc s -sk -sf 15 -sm 1 -xslick.sta -p
const
   DOS_INSTALLATION=1
   OS2_INSTALLATION=2
   SHARE_PCODE=' argument.ex emulate.ex '
   BRIEF_PCODE=' briefsch.ex briefutl.ex editflst.ex '||
               'poperror.ex briefdef.ex '

   EMACS_PCODE=' prefix.ex emacs.ex emacsdef.ex '

include 'slick.sh'
defmain
   'set SLICKEXT='  /* Remove SLICKEXT environment variable. */
#if 0
   /* code for testing configure_user_files() */
#if 1
   dll_dir='c:\slick\dll\'
   os2exec_dir='c:\slick\os2\'
   dosexec_dir='c:\slick\dos\'
   macro_dir='c:\slick\macro\'
   misc_dir='c:\slick\misc\'
#else
   dll_dir='c:\slick\dll\'
   os2exec_dir='c:\slick\'
   dosexec_dir='c:\binr\'
   macro_dir='c:\slick\'
   misc_dir='c:\slick\'
#endif
   /* install_for=DOS_INSTALLATION;dosexec_dir=os2exec_dir */
   install_for=OS2_INSTALLATION
   configure_user_files(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   pause
   exit(1)
#endif
   if file_match('-p install.ex',1)='' then
      say nls('The SlickEdit installation program must be run from the current directory')
      return(1)
   endif
   msg1=nls('This program installs SlickEdit onto a hard disk.')
   msg2=nls('If this is NOT your first time installing SlickEdit, you may want to backup your macros or specify a new directory.')
   msg3=nls('This installation will overwrite all previously installed files, except USERMODS.E.')
   msg4=nls('If this is NOT your first time installing SlickEdit for OS/2 and you have used SlickEdit''s concurrent process, REBOOT your machine so that the SLICK.DLL may be replaced.')
   say  ''
   nls_say(1,70,msg1,msg2,msg3,msg4)
   say ''
   say nls('Press the ESC key at any prompt to abort the installation.')
   if machine()='PCDOSP' then  /* protect mode? */
      install_for=OS2_INSTALLATION
      say ''
      say '       'nls('A complete installation will require about 2.5 megabytes')
      say ''
   else
      say ''
      say ''
      say '   1.  'nls('Install for DOS only.  Requires about 2.3 megabytes.')
      say '   2.  'nls('Install for DOS and OS/2 operation.  Requires about 2.5 megabytes.')
      say ''
      nls_say(8,70,nls('The sizes shown above indicate the amount of disk space required for a complete installation.'))
   endif
      msg1=nls('Approximately 710k of disk space may be saved by selecting not to install macro source code.')
      msg2=nls('Approximately 760k of disk space may be saved by selecting the summary of keys help files.')
      nls_say(8,70,msg1,msg2)
      say ''
   if machine()<>'PCDOSP' then  /* protect mode? */
      loop
         says '   'nls('Enter selection(1-2):')' '
         status=read_line(install_for)
         if status then
           say nls('Installation stopped')
           return(1)
         endif
         if install_for='1' or install_for='2' then
            leave
         endif
      endloop
   endif
   status=query_install_macros(copy_macros)
   if status then
      say nls('Installation aborted')
      return(1)
   endif
   status=query_install_help(complete_help)
   if status then
      say nls('Installation aborted')
      return(1)
   endif
   status=query_install_emulation(complete_help,copy_macros,brief_emulation,emacs_emulation)
   if status then
      say nls('Installation aborted')
      return(1)
   endif
   status=query_directories(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   if status then
     say nls('Installation stopped')
     return(1)
   endif
   status=edit('+l disk?')
   if not status then
      rc=install_disks(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for,copy_macros,complete_help,brief_emulation,emacs_emulation)
   endif
   if rc then
      say nls('Installation not successful')
   else
      configure_user_files(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
      nls_say(1,70,nls('The UPDATE.DOC file documents most enhancements to SlickEdit from version 2.2 to 2.3.'),
      'If you are using a German or other language keyboard driver which provides special support for the right ALT key, YOU MUST use the -sk invocation option.'
      )
   endif

defproc global configure_user_files(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   if install_for<>DOS_INSTALLATION then
      files='AUTOEXEC.BAT CONFIG.SYS'
      msg=nls('On what drive does AUTOEXEC.BAT and CONFIG.SYS reside?')
   else
      files='AUTOEXEC.BAT'
      msg=nls('On what drive does AUTOEXEC.BAT reside?')
   endif
   say ''
   loop
      says msg' '
      status=read_line(boot_drive,'C:')
      if status then
         say nls('Installation aborted')
         exit(1)
      endif
      boot_drive=substr(upcase(boot_drive),1,1)
      if isalpha(boot_drive) then
         leave
      endif
   endloop
   status=update_files(files,boot_drive,dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   if status then
      say nls('Installation aborted')
      return(1)
   endif
   loop
      say ''
      if files='' then
         say nls('Installation completed')
         say ''
         return ''
      endif
      say nls('INSTALL appends new paths to the end of environment variables.')
      parse value files with a b
      if b<>'' then  /* More than one file changed? */
         msg=nls('~Update files, ~Show instructions, ~Write alternate files, ~Discard')
         say nls('What should INSTALL do with changes to %s and %s',a,b)
      else
         msg=nls('~Update file, ~Show instructions, ~Write alternate file, ~Discard')
         say nls('What should INSTALL do with changes to %s',strip(files))
      endif
      msg=nls_strip_chars(selection_chars,msg)
      msg=msg||' ['selection_chars']: '
      loop
         says msg
         status=read_line(response)
         if status then
            say nls('Installation aborted')
            exit(1)
         endif
         response=substr(upcase(response),1,1)
         if pos(response,selection_chars) then
            leave
         endif
      endloop
      selection_i=pos(response,selection_chars)
      if selection_i=4 then
         say ''
         say nls('You must update %s yourself',files)
         say ''
         return ''
      endif
      if selection_i=1 or selection_i=3 then /* Update or write */
         in_files=files
         loop
            parse value in_files with name in_files
            if name='' then
               leave
            endif
            load_name=name
            load_files '+lw +u 'load_name
            if rc and rc<>NEW_FILE_RC then
               say nls('Unable to read %s',load_name)'.  'get_message(rc)
               return(rc)
            endif
            if selection_i=3 then  /* Write alternate file */
               new_name=strip_filename(load_name,'E')'.new'
               prompt_for_alternate(nls('Write %s to alternate file:',name)' ',new_name)
               .buf_name=new_name
            else
               new_name=strip_filename(load_name,'E')'.bak'
               prompt_for_alternate(nls('Backup %s to file:',name)' ',new_name)
               status=copy_file(load_name,new_name)
               if status then
                  say nls('Unable to backup %s',new_name)'. 'get_message(status)
                  say nls('%s not changed',load_name)
                  delete_buffer
                  return(1)
               endif
            endif
            status=save('+o')
            if status then
               say nls('Unable to write to %s',.buf_name)'. 'get_message(status)
               say nls('%s not changed',name)
               delete_buffer
               return(1)
            endif
            delete_buffer
         endloop
         if selection_i=3 then /* Write alternate. */
            parse value files with a b
            if b<>'' then
               say nls('You must update AUTOEXEC.BAT and CONFIG.SYS yourself')
            else
               say nls('You must update %s yourself',files)
            endif
         else
            say nls('Installation completed')
         endif
         say ''
         return ''
      endif
      show_instructions(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
  endloop
  return(0)

defproc global show_instructions(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   say ''
   if install_for<>DOS_INSTALLATION then
      msg1=nls('Add the directories "%s" to your search PATH in AUTOEXEC.BAT.',dosexec_dir';'os2exec_dir)
      nls_say(1,78,msg1)
      say ''
      msg1=nls('Add the directory "%s" to your search PATH in CONFIG.SYS.',os2exec_dir)
      msg2=nls('DO NOT include the directory "%s" in your search PATH in CONFIG.SYS.',dosexec_dir)
      nls_say(1,78,msg1)
      say ''
      nls_say(1,78,nls('Add the directory "%s" to your search LIBPATH in CONFIG.SYS.',dll_dir))
   else
      nls_say(1,78,nls('Add the directory "%s" to your search PATH in AUTOEXEC.BAT.',dosexec_dir))
   endif
   say ''
   if not file_eq(os2exec_dir,misc_dir) or not file_eq(os2exec_dir,macro_dir) then
      if file_eq(macro_dir,misc_dir) then
         dirs=macro_dir
      else
         dirs=macro_dir';'misc_dir
      endif
      if install_for<>DOS_INSTALLATION then
         msg=nls("Add the statement SET SLICKPATH='%s' to your CONFIG.SYS and AUTOEXEC.BAT",dirs)
      else
         msg=nls("Add the statement SET SLICKPATH='%s' to your AUTOEXEC.BAT",dirs)
      endif
      nls_say(1,78,msg)
      say ""
      msg=nls("SLICKPATH is an environment variable SlickEdit uses to find help files, macros files, and other non-executable files.")
      nls_say(1,78,msg)
      say ''
   endif
defproc global prompt_for_alternate(msg,var new_name)
   loop
      says msg
      status=read_line(new_name,lowcase(new_name))
      if status then
         message nls('Installation aborted')
         exit(1)
      endif
      if new_name='' then
         iterate
      endif
      if file_match('-p 'new_name,1)<>'' then  /* File already exist? */
         prompt_yesno(nls("File already exits.  Overwrite"),overwrite)
         if overwrite=nls('N') then
            iterate
         endif
      endif
      return ''
   endloop

defproc global update_files(var in_files,boot_drive,dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   files=in_files
   in_files=''
   loop
      parse value files with name files
      if name='' then
         leave
      endif
      load_name=lowcase(boot_drive)':\'name
      load_files '+lw +u 'load_name
      if rc and rc<>NEW_FILE_RC then
         say nls('Unable to read %s',load_name)'.  'get_message(rc)
         return(rc)
      endif
      if install_for<>DOS_INSTALLATION then
         if name='AUTOEXEC.BAT' then
            /* First search for values */
#if 0
               /* Code to place new paths on front of env vars. */
               seek_pos1=config_envvar('PATH',os2exec_dir,'S')
               seek_pos2=config_envvar('PATH',dosexec_dir,'S')
               /* say 'seek_pos1='seek_pos1;say 'seek_pos2='seek_pos2 */
               if seek_pos1<seek_pos2 and seek_pos2>0 then
                  /* say 'special case' */
                  /* Must remove and add this variable again. */
                  seek_pos2=config_envvar('PATH',dosexec_dir,1)
               endif
               config_envvar('PATH',os2exec_dir)
               config_envvar('PATH',dosexec_dir)
#else
               config_envvar('PATH',dosexec_dir)
               config_envvar('PATH',os2exec_dir)
#endif
         endif
         if name='CONFIG.SYS' then
            config_envvar('PATH',os2exec_dir)
            config_envvar('LIBPATH',dll_dir)
         endif
      else
         if name='AUTOEXEC.BAT' then
            config_envvar('PATH',dosexec_dir)
         endif
      endif
      if not file_eq(os2exec_dir,misc_dir) or not file_eq(os2exec_dir,macro_dir) then
         config_envvar('SLICKPATH',macro_dir)
         if file_eq(macro_dir,misc_dir) then
         else
            config_envvar('SLICKPATH',misc_dir)
         endif
      endif
      if .modify then
         in_files=in_files load_name
      endif
   endloop
   return(0)

const
   MAX_STRING=255

defproc global config_envvar(envvar,text)
   /* Find last occurrence of the envvar */
   top
   if upcase(envvar)='PATH' then
      re='^ *(set|) *'envvar'( #| *=)'
   else
      re='^ *(set|) *'envvar' *='
   endif
   search re,'>ri'
   line_num=0
   loop
      if rc then
         leave
      endif
      if is_beginning_of_line() then
         line_num=.line
      endif
      repeat_search
   endloop
   if not line_num then
      if arg(3)='S' then  /* Just searching for position? */
         return(-1)  /* Did not find one */
      endif
      /* say 'Envvar 'envvar' not found' */
      bottom;get_line line;if line=chr(26) then up endif
      insert_line 'set 'envvar'='text||chr(13)||chr(10)
      return(point()+5+length(envvar))
   endif
   /* Envvar found.  Check if text already in string. */
   p=point()  /* Seek position to beginning line. */
   get_line line
   p=p+text_col(line,.col,'p')-1
   text=strip(text)
   if last_char(text)=FILESEP then
      text=substr(text,1,length(text)-1)
   endif
   re=text
   re=stranslate(re,'\\','\')
   re=stranslate(re,'\:',':')
   orig_p=p
   orig_add_semi=0
   /* say 'looking for 're' arg(3)='arg(3) */
   loop
      goto_point p
      line=get_text(MAX_STRING)
      i=pos('{(^|;) *'re'(\\|) *}(;|\13|\10)',line,'','ri')
      if i then
         on_semi=i<>1
         if arg(3)=1 then  /* Delete it? */
            goto_point p+i-1
            unmark
            mark_char '','N'
            if on_semi then
               goto_point p+i+pos('0')-1
            else
               goto_point p+i+pos('0')
            endif
            mark_char '','N'
            delete_mark
         endif
         /* say 'Found it' */
         return(p+i-1+on_semi)
      endif
      i=pos('\13|\10',line,'','ri')
      if i then
         line=substr(line,1,i-1)
#if 1
         orig_add_semi=last_char(strip(line))<>';'
         orig_p=p+i-1
#endif
         leave
      endif
      i=pos(';',line)
      if not i then
         leave
      endif
      p=p+i-1
   endloop
   if arg(3)='S' then  /* Just searching for position? */
      return(-1)  /* Did not find text */
   endif
   goto_point orig_p
   if command_state() then
      command_toggle
   endif
   if not insert_state() then
      insert_toggle
   endif
   if orig_add_semi then
      keyin ';'text';'
   else
      keyin text';'
   endif
   return(orig_p)

defproc global is_beginning_of_line()
   up
   get_line line
   down
   return(last_char(line)=chr(10) or last_char(line)=chr(13))
defproc install_disks(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for,copy_macros,complete_help,brief_emulation,emacs_emulation)
     disk_number=1
     if install_for=DOS_INSTALLATION then
        sunpak_dir=dosexec_dir
     else
        sunpak_dir=os2exec_dir
     endif
     call spill_file_path(sunpak_dir)
     loop
       status=edit('disk'disk_number)    /* activate the buffer */
       if status then
          leave
       endif
       top
       /* make sure the first file is found */
       call find_first_file(disk_number)
       loop
          get_line line
          parse value line with filename comment
          filename=lowcase(strip_filename(filename,'P'))
          extension=get_extension(filename)
          skip=pos('install',filename) or pos('readme',filename) or
               (substr(filename,1,3)='all' and extension='spk')
          if not skip then
             if extension='spk' then
                if not (
                     (filename='slick.spk' and not complete_help) or
                     (filename='macro.spk' and not copy_macros)
                   ) then
                   if filename='macro.spk' then
                      destpath=macro_dir
                      old_spill_file_path=spill_file_path()
                      spill_file_path(destpath)
                      load_status=load_files('+c +l 'destpath'usermods.e')
                      if load_status=NEW_FILE_RC then
                         delete_buffer;quit_view
                      endif
                   elseif filename='macrop.spk' then
                      destpath=macro_dir
                   elseif filename='slick.spk' then
                      destpath=misc_dir
                   elseif filename='slickmnu.spk' then
                      destpath=misc_dir
                   endif
                   say 'Unpacking 'filename
                   '0 'sunpak_dir'sunpak 'filename destpath
                   if filename='macro.spk' then
                      if not load_status then
                          write_file '+o'
                          delete_buffer;quit_view
                      endif
                      spill_file_path(old_spill_file_path)
                   elseif filename='slickmnu.spk' then
                      copy_file misc_dir||'slick.mnu',misc_dir||'slickd.mnu'
                   endif
                endif
                skip=1
             elseif install_for=DOS_INSTALLATION and (
                  extension='cmd' or extension='dll' or is_os2exe(filename)) then
                skip=1
             elseif install_for<>DOS_INSTALLATION and is_dos_only_exe(filename) then
                skip=1
             elseif extension='exe' then
                /* say 'filename=<'filename'> is_dos='is_dosexe(filename)' is_dos_only_exe='is_dos_only_exe(filename)' dosdir='dosexec_dir;getkey('r') */
                  if is_dosexe(filename) then
                     parse value filename with name '_dos' rest_of_name
                     if filename='ft_dos.exe' then
                        destname=dosexec_dir||'fasttype.exe'
                     else
                        destname=dosexec_dir||name||rest_of_name
                     endif
                  else
                     destname=os2exec_dir||filename
                  endif
                  if not copy_macros and (filename='st.exe' or filename='st_dos.exe') then
                     skip=1
                  endif
             elseif extension='cmd' and not copy_macros and filename<>'startit.cmd' then
                skip=1
             elseif (extension='e' or extension='sh') and not copy_macros then
                skip=1
             elseif extension='dll' then
                destname=dll_dir||filename
             else
                destname=misc_dir||filename
             endif
          endif
          if not skip then
            say 'Copying 'filename' to 'destname
            if filename='slick.sta' then
               write_state destname
               if rc then
                  rc=PATH_NOT_FOUND_RC
               endif
            else
               copy_file  filename,destname
            endif
            if rc= PATH_NOT_FOUND_RC then
               path=substr(destname,1,pathlen(destname)-1)
               /* try to create the directory */
               rc= make_path(absolute(path))
               if not rc then
                  if filename='slick.sta' then
                     write_state destname
                  else
                     copy_file  filename,destname
                  endif
               endif
            endif
            if rc then
               if not ((rc=ACCESS_DENIED_RC or rc=GENERAL_FAILURE_RC) and filename="slick.dll") then
                  message 'Failed to copy file "'filename'". 'get_message(rc)
                  if rc=ACCESS_DENIED_RC or rc=GENERAL_FAILURE_RC then
                     message 'Make sure all SlickEdit files are not being used by other processes'
                  endif
                  return(rc)
               endif
            endif
          endif
          down
          if rc then leave endif  /* Hit bottom file? */
          get_line line
          if line='*' then
             disk_number=disk_number+1
             down
             call find_first_file(disk_number)
          endif
       endloop
       .modify=0;call quit()
       disk_number=disk_number+1
     endloop
     erase_unused_files(sunpak_dir,dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,complete_help,copy_macros,brief_emulation,emacs_emulation)
     status=finish_help(complete_help,misc_dir,brief_emulation)
     return(status)

defproc global erase_unused_files(sunpak_dir,dll_dir,os2exec_dir,dosexec_dir,macro_dir,
    misc_dir,complete_help,copy_macros,brief_emulation,emacs_emulation)

   delete_file sunpak_dir||'sunpak.exe'
   if not brief_emulation and not emacs_emulation then
      delete_file misc_dir||'slickd.mnu'
   endif
   if not brief_emulation then
      delete_file misc_dir||'brief.doc'
      delete_file misc_dir||'brief.mnu'
   endif
   if not emacs_emulation then
      delete_file misc_dir||'emacs.doc'
      delete_file misc_dir||'emacs.mnu'
   endif
   if copy_macros then
      delete_files('listproc.ex bookmark.ex',macro_dir)
      if not brief_emulation then
         delete_files(stranslate(BRIEF_PCODE,'.e','.ex'),macro_dir)
      endif
      if not emacs_emulation then
         delete_files(stranslate(EMACS_PCODE,'.e','.ex'),macro_dir)
      endif
   else
      if not brief_emulation then
         delete_files(BRIEF_PCODE,macro_dir)
      endif
      if not emacs_emulation then
         delete_files(EMACS_PCODE,macro_dir)
      endif
      if not emacs_emulation and not brief_emulation then
         delete_files(SHARE_PCODE,macro_dir)
      endif
   endif

defproc global delete_files(pcode_files,destpath)
   loop
      parse value pcode_files with filename pcode_files
      if filename='' then
         leave
      endif
      delete_file destpath||filename
   endloop

defproc global find_first_file(disk_number)
   get_line line
   parse value line with filename comment
   filename=strip_filename(filename,'P')
   loop
     if file_match(filename,1)='' then
        say nls('Please insert disk labelled %s','DISK'disk_number)
        says nls('Press ENTER when ready')
        loop
           key=getkey('R')
           if key==ENTER or key==ESC then leave endif
        endloop
        say ''
        if key==ESC then
           say nls('Installation aborted')
           exit(1)
        endif
     else
        leave
     endif
   endloop

defproc global query_install_macros(var copy_macros)
   msg1=nls('The macro source code requires about 710k of disk space and allows you to change any macro procedure or command.')
   msg2=nls('The macro source code also provides you with examples and documentation for some extensive macro procedures.')
   msg3=nls('If you have plenty of disk space, we recommend installing the macro source code.')
   say ''
   nls_say(1,72,msg1,msg2,msg3)
   say  ''
   prompt_yesno(nls('Install macro source code'),copy_macros)
   say ''
   return(0)

defproc global query_install_help(var complete_help)
   msg1=nls('The standard help files require about 780k of disk space and provides help on all macro commands, macro built-in functions, and SlickEdit macro language primitives.')
   msg2=nls('If you do not install complete help, the F1 (HELP) key will load a file containing a summary of the key definitions which requires about 20k of disk space.')
   say ''
   nls_say(1,72,msg1,msg2)
   say  ''
   prompt_yesno(nls('Install complete help'),complete_help)
   say ''
   return(0)

defproc global query_install_emulation(complete_help,copy_macros,var brief_emulation,var emacs_emulation)
   space=25;    /* pcode */
   espace=28
#if 0
   if complete_help then
      space=space+28   /* Brief.doc */
   else
      space=space+5
   endif
   if complete_help then
      espace=espace+35   /* emacs.doc */
   else
      espace=espace+7
   endif
#endif
   if copy_macros then
      space=space+30
      espace=espace+42
   endif
   msg1=nls('SlickEdit has emulation for BRIEF and EMACS.  The BRIEF emulation files will require 'space'k of disk space.')
   msg2=nls('The EMACS emulation files will require 'espace'k of disk space.')
   msg3=nls('After this installation is completed, you may use SlickEdit''s on-line configuration menu (F5) to select BRIEF or EMACS emulation.')
   say ''
   nls_say(1,72,msg1,msg2,msg3)
   say ''
   if query_emulate(nls('Install emulation for BRIEF'),brief_emulation) then
      return(1)
   endif
   if query_emulate(nls('Install emulation for EMACS'),emacs_emulation) then
      return(1)
   endif
   say ''
   return(0)

defproc global query_emulate(msg,var brief_emulation)
   prompt_yesno(msg,brief_emulation)
   return(0)

defproc global finish_help(complete_help,destpath,brief_emulation)
   if complete_help then
      return(0)
   endif
   /* Remove all help name table entries of built-ins and langauge class */
   language_class=eq_name2value('language',HELP_CLASSES)
   help_class=eq_name2value('help',HELP_CLASSES)
   menu_class=eq_name2value('menu',HELP_CLASSES)
   index=name_match('',1,MISC_TYPE|BUILT_IN_TYPE)
   loop
      if not index then
         leave
      endif
      if name_class(index)=language_class or name_class(index)=help_class or
         name_class(index)=menu_class or name_type(index)=BUILT_IN_TYPE then
         delete_name index
      endif
      index=name_match('',0,MISC_TYPE|BUILT_IN_TYPE)
   endloop
   index=name_match('',1,COMMAND_TYPE)
   loop
      if not index then
         leave
      endif
      set_name_help index,0
      index=name_match('',0,COMMAND_TYPE)
   endloop
   call bind_to_key('-r edit-help 'key2index(F1))
   help_file_spec=destpath||'slick.doc'
   maybe_build_help(junk)
   filename=destpath||'slick.sta'
   say nls('Writing configuration to %s',filename)
   call spill_file_path('.\')
   call cache_size('-1 12 -1 55')
   write_state filename
   return(rc)



defproc global query_directories(var dll_dir,var os2exec_dir,var dosexec_dir,var macro_dir,var misc_dir,install_for)
   dll_dir='c:\slick\dll\'
   os2exec_dir='c:\slick\'
   if install_for=DOS_INSTALLATION then
      dosexec_dir=os2exec_dir
   else
      dosexec_dir='c:\binr\'
   endif
   macro_dir=os2exec_dir
   misc_dir=os2exec_dir
   first_time=1
   say ''
   say ''
   if install_for=DOS_INSTALLATION THEN
      msg1=nls("You will be prompted for directories where you want executables, macro files, and miscellaneous data files placed.")
      msg2=nls("The miscellaneous data files include menu and help files.")
      msg3=nls("Don't worry if you make a mistake.")
      msg4=nls("You will prompted whether you wish to make any changes after you have entered all directory names.")
      nls_say(1,72,msg1,msg2,msg3,msg4)
   else
      msg1=nls("You will be prompted for directories where you want OS/2 executables, DOS executables, .DLL files, macro files, and miscellaneous data files placed.")
      msg2=nls("The miscellaneous data files include menu and help files.  Don't worry if you make a mistake.")
      msg3=nls("You will prompted whether you wish to make any changes after you have entered all directory names.")
      nls_say(1,72,msg1,msg2,msg3)
   endif
   say ""
   say ""
   loop
      if install_for=DOS_INSTALLATION THEN
         prompt_for_dir(nls("Directory for DOS executables:")" ",dosexec_dir);
         if first_time then
            first_time=0
            change_drives(dosexec_dir,dll_dir,os2exec_dir,macro_dir,misc_dir)
         endif
      else
         prompt_for_dir(nls("Directory for OS/2 executables:")" ",os2exec_dir);
         if first_time then
            first_time=0
            change_drives(os2exec_dir,dll_dir,dosexec_dir,macro_dir,misc_dir)
         endif
         prompt_for_dir(nls("Directory for DOS executables:")" ",dosexec_dir);
         if file_eq(dosexec_dir,os2exec_dir) then
            say nls('DOS and OS/2 executables must be in different directories')
            iterate
         endif
         prompt_for_dir(nls("Directory for .DLL files:")" ",dll_dir);
      endif
      prompt_for_dir(nls("Directory for macros:")" ",macro_dir);
      prompt_for_dir(nls("Directory for help,menus, and miscellaneous files:")" ",misc_dir);
      say ""
      prompt_yesno(nls("Do you want to make changes"),make_change);
      if not make_change then
        if not make_directories(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for) then
           leave
        endif
      endif
   endloop
   if install_for=DOS_INSTALLATION then
      os2exec_dir=dosexec_dir
   endif
   return(0)

defproc global make_directories(dll_dir,os2exec_dir,dosexec_dir,macro_dir,misc_dir,install_for)
   if install_for<>DOS_INSTALLATION and maybe_makedir(os2exec_dir) then return(1); endif
   if maybe_makedir(dosexec_dir) then return(1); endif
   if install_for<>DOS_INSTALLATION and maybe_makedir(dll_dir) then return(1); endif
   if maybe_makedir(macro_dir) then return(1); endif
   if maybe_makedir(misc_dir) then  return(1); endif
   return(0);

defproc global maybe_makedir(dir)
   if dir='' then
      return(1)
   endif
   dir=substr(dir,1,length(dir)-1)
   if file_match('-p 'dir,1)='' then
      say 'Directory 'dir
      prompt_yesno(nls("does not exist")".  "nls("Create"),create_it);
      if not create_it then
         return(1);
      endif
      return(make_path(dir))
   endif
   return(0);

defproc global prompt_for_dir(msg,var dir)
   says msg
   status=read_line(dir,dir)
   if status then
      say nls('Installation aborted')
      exit(1)
   endif
   if last_char(dir)<>FILESEP then
      dir=dir||FILESEP
   endif
   dir=absolute(dir)

defproc global is_os2exe(filename)
   return(filename='st.exe' or filename='s.exe' or
               filename='grep.exe' or filename='fasttype.exe' or
               filename='slk-init.exe')

defproc global is_dosexe(filename)
   return(filename='slksort.exe' or filename='st_dos.exe' or filename='s_dos.exe' or
               filename='grep_dos.exe' or filename='ft_dos.exe')

defproc global is_dos_only_exe(filename)
   return(filename='grep_dos.exe' or filename='ft_dos.exe')

defproc global prompt_yesno(msg,var yesno)
   loop
      says msg' ['nls('Y')']: '
      status=read_line(yesno)
      if status then
         say nls('Installation aborted')
         exit(1)
      endif
      if yesno='' then
         yesno=nls('Y')
      endif
      yesno=substr(upcase(yesno),1,1)
      if yesno=nls('Y') or yesno=nls('N') then
         leave
      endif
   endloop
   setyesno(yesno,yesno)

defproc global change_drives(dosexec_dir,var dll_dir,var os2exec_dir,var macro_dir,var misc_dir)
   change_drive(dosexec_dir,dll_dir)
   change_drive(dosexec_dir,os2exec_dir)
   change_drive(dosexec_dir,macro_dir)
   change_drive(dosexec_dir,misc_dir)

defproc global change_drive(dosexec_dir,var dir)
   dir=stranslate(dir,dosexec_dir,'c:\slick\')
#if 0
   if substr(dir,2,1)=':' and substr(dosexec_dir,2,1)=':' then
      dir=substr(dosexec_dir,1,1)||substr(dir,2)
   endif
#endif

defproc global nls_say(left_ma,right_ma,msg1)
   line=substr('',1,left_ma-1)
   for j= 3 to arg() by 1
      text=arg(j)
      loop
         diff=(length(line)+length(text))-right_ma
         if diff>=0 then
            i=lastpos(' ',text,length(text)-diff)
            if not i then
               i=right_ma-left_ma
            endif
            line=line||substr(text,1,i)
            text=substr(text,i+1)
            say line
            line=substr('',1,left_ma-1)
         else
            line=line||text'  '
            diff=length(line)-right_ma
            if diff>=0 then
               say line
               line=substr('',1,left_ma-1)
            endif
            leave
         endif
      endloop
   endfor
   if length(line)>=left_ma then
      say line
   endif

