//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)5 LCM.S, 04-Feb-95,01:32:02, LDH"

macro_file LCM;
/******************************************************************************
                             Multi-Edit Macro File
                               19-Dec-94  13:22

  This macro is the specific interface code for the VCS package PAN/LCM by
  Computer Associates.

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

#include DIALOG.SH
#include WINEXEC.SH
#include IDEXE.SH
#include METOOLS.SH
#include DBTOOLS.SH
#include DB.SH
#include VCS.SH

#ifdef   _DEBUG_
  #include DBUG.SH                      // Dbug macros
  #include SPRINTF.SH
#endif

#ifdef  _BETA_
  #define _LCM_VER    "7.00p(0.09b)"
#else
  #define _LCM_VER    "7.00p(0.09b)"
#endif

prototype Lcm {
  int  LcmExec( str CmdLine, int Show_Win, int Chg_Dir );
  str  LcmXlate( str Path, str Fname, str Lfile );
  str  LcmExt( str FName );
  int  LcmChkLib( str Path, str FName, int Pm );
  int  LcmLogin( int Chg_Usr );
  str  LcmGetFName( str LibFile );
  int  LcmChkLock( );
  str  LcmLookup( str FName, str Field1, str Field2 );
  str  LcmCfgFile( str FName, str Param );
  int  LcmCmds( str Cmd, str FName );
  void LcmParseErr( );
  str  LcmGetUser( );
}

global {
  str lcmUser         "&lcmUser";       // Contains the current user name
  str lcmPwd          "!lcmPwd";        // Contains the temporary user password
  str lcmCfg          "!lcmCfg";        // Contains the command/setup options
  str lcmLUT          "!lcmLUT";        // Contains the LOOKUP data record
}

macro Lcm Trans {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : Lcm

  Function: Checks that the GET executable is found and initilizes LCM
            support.

  Syntax  : Rm( "Lcm /I" );

  Entry   : /I              - Initialize the system if checks pass.

  Exit    : Return_Int
              False         - LCM support not installed and checks failed.
              True          - LCM support installed and checks passed.

            gstr !vcsVerStr   - "LCM " + macro version number.
            gstr !vcsRevStr   - macro revision number.
            gstr !vcsDoLogin  - False.

  Globals : str !vcsVerStr  - Returns the string "LCM " + macro version no.
            str !vcsRevStr  - Returns the macro revision number.
            str !vcsDoLogin - Set True to enable changing username and passwd.

  Macros  : int VcsChkVer
            mac PathSearch

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
  str Rev_Id = "@(#)5 LCM.S, 04-Feb-95,01:32:02, LDH";
  str Cmd = Copy( _GET_CMDL, 1, XPos( " ", _GET_CMDL, 1 ) - 1 );

  // Check for get command EXE file
  Return_Str = ExecSearchPath( Cmd, "<%PATH>" );
  Return_Int = ( Return_Str != "" );
  if ( Return_Int ) {
    if ( VcsChkVer( _LCM_VER ) ) {
      if ( XPos( "/I", MParm_Str, 1 ) ) {  // Initialize?
        vcsDoLogin = True;              // Enable change user ID menu item
        if ( lcmUser == "" ) {
          if ( !( Return_Int = LcmLogin( False ) ) ) {
            Error_Level = 9012;         // Set login error
          }
        }
      }
    }
    else {
      Error_Level = 9011;               // Set version error
    }
  }
  else {
    Error_Level = 9010;                 // Set no EXE found error
  }
  vcsVerStr = "LCM " + _LCM_VER;
  vcsRevStr = Rev_Id;

}  // Lcm

macro LcmView Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmView

  Function: The LCM specific view macro to view the changes to the current
            work file compared to the latest revision in the archive.

  Syntax  : Rm( "LcmView" );

  Entry   : gstr !vcsFName  - Filename of file to compare
            gint !vcsLibFnd - Set True if archive found.

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals : str !vcsFName   - The work file name.
            int !vcsLibFnd  - The archive found status (True = found).
            str !vcsDlgMsg  - The dialog message when calling VcsGetLib.
            str !vcsMsg     - The status line message when exec is run.
            str !lcmCfg     - The LCM specific command/setup options.
            str !vcsName    - The vcs temp file name.


  Macros  : int  VcsGetLib
            int  LcmExec
            mac  CDiff
            void VcsViewWinDlg

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );
  str TFName = LcmCfgFile( vcsFName, "BASEDIR" ) + FName;

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(LCM) VIEW Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "LCM archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Working;
    if ( Switch_File( vcsFName ) ) {
      if ( File_Changed ) {
        Rm( "SaveFile /NP=1" );
      }
    }
    if ( _RVC ) {
      if ( File_Exists( TFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( TFName, _VCS3_TMP );
        Frn = True;
      }
    }
    vcsMsg = "Viewing changes made to \"" + FName + "\"...";
    vcsDlgMsg = "(LCM) VIEW Command Line.";
    if ( Return_Int = LcmExec( _VIEW_CMDL, _DISP_WIN, _DO_CD ) ) {
      if ( _RVC ) {
        Rm( "CDiff /F=" + TFName + "/D=" + str( !_CDIF ));
        if ( Return_Int == 1 ) {
          vcsMsg = "Files the same.";
        }
        else {
          vcsMsg = "CDIFF complete.";
        }
        Set_File_Attr( TFName, 0 );
        Del_File( TFName );
        Return_Int = True;
      }
      else if ( Switch_File( vcsName ) ) {
        Return_Int = False;
        Error_Level = 0;
        Load_File( vcsName );
        if ( !Error_Level ) {
          VcsViewWinDlg( "(LCM) Differences of " + Truncate_Path( vcsFName ),
              100, 18, "", hc_vcs_View );
          vcsMsg = "LCM VIEW command complete.";
          Return_Int = True;
        }
      }
    }
    if ( Frn ) {
      Rename_File( _VCS3_TMP, TFName );
    }
  }
}  // LcmView

macro LcmList Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmList

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(LCM) LIST Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "LCM archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    vcsMsg = "Listing versions of \"" + Truncate_Path( vcsFName ) + "\"...";
    vcsDlgMsg = "(LCM) LIST Command Line.";
    if ( Return_Int = LcmExec( _LIST_CMDL, _DISP_WIN, False ) ) {  // No vcs errors
      if ( Switch_File( vcsName ) ) {
        Return_Int = False;
        Error_Level = 0;
        Load_File( vcsName );
        if ( !Error_Level ) {
          VcsViewWinDlg( "(LCM) Versions of " + Truncate_Path( vcsFName ),
              100, 18, "BT_VCS_109", hc_vcs_List );
          vcsMsg = "LCM LIST command complete.";
          Return_Int = True;
        }
      }
    }
  }
}  // LcmList

macro LcmLock Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmLock

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(LCM) LOCK Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "LCM archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    if ( Return_Int = !LcmChkLock( ) ) {
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Locking \"" + vcsFName + "\"...";
      vcsDlgMsg = "(LCM) LOCK Command Line.";
      Return_Int = LcmExec( _LOCK_CMDL, _DISP_WIN, _DO_CD );
      if ( Frn ) {
        if ( Return_Int ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        else {
          int Sel = Error_Level;

          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
    }
  }
}  // LcmLock

macro LcmGet Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmGet

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str FName = Truncate_Path( vcsFName );
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );

  int Fw = 0;
  int Frn = False;
  int Sel;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(LCM) " + Cmd + " Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "LCM archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Return_Int = True;
    if ( Cmd == "GET" ) {
      Return_Int = !LcmChkLock( );
      Vcs_Cmd = _GET_CMDL;
    }
    else {
      Vcs_Cmd = _BROWSE_CMDL;
    }
    if ( Return_Int ) {
      if ( File_Name == vcsFName ) {
        Frn = True;
      }
      else if ( Switch_File( vcsFName ) ) {
        Frn = True;
      }
      if ( Frn ) {
        if ( !Read_Only || vcsDF || ( Truncate_Path( File_Name ) != FName ) ) {
          Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
              " Already loaded, OVERWRITE? /BL= ARE YOU SURE? " );
        }
        if ( Return_Int ) {
          Fw = Window_Id;
          VcsPushPos( );
          Erase_Window;
        }
      }
      else if ( File_Exists( vcsFName ) ) {
        Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
            " Already exists, OVERWRITE? /BL= ARE YOU SURE? " );
      }
    }
    if ( Return_Int ) {
      Frn = False;
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Retrieving \"" + vcsFName + "\"...";
      vcsDlgMsg = "(LCM) " + Cmd + " Command Line.";
      if ( Return_Int = LcmExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
        if ( Frn ) {
          Sel = Error_Level;
          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
      else {                            // error, restore file
        if ( Frn ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        if ( Switch_Win_Id( Fw ) ) {
          Sel = Error_Level;
          Error_Level = 0;
          Load_File( vcsFName );
          if ( !Error_Level ) {
            Rm( "ExtSetup" );
          }
          VcsPopPos( True );
          Error_Level = Sel;
          Return_Int = False;
        }
      }
    }
  }
}  // LcmGet

macro LcmPut Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmPut

  Function: The LCM specific CREATE/PUT/UNLOCK commands.

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error
  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );
  str FName[ 12 ] = Truncate_Path( vcsFName );

  int Sel;
  int Fw = 0;
  int Ow = 0;
  int Get_Cmt = False;

  Return_Int = True;
  if ( vcsChkMod != "V" ) {
    Return_Int = !LcmChkLock( );
  }
  if ( Return_Int ) {
    if ( File_Name == vcsFName ) {
      Fw = Window_Id;
    }
    else if ( Switch_File( vcsFName ) ) {
      Fw = Window_Id;
    }
    if ( Fw ) {
      VcsPushPos( );
    }
    if ( vcsChkMod == "V" ) {
      if ( Window_Id == Fw ) {
        Erase_Window;
      }
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( vcsFName, 0 );
        Del_File( vcsFName );
      }
    }
    else {
      if ( !vcsLibFnd ) {
        vcsDlgMsg = "(LCM) " + Cmd + " Archive File Path.";
        vcsLibFnd = VcsGetLib( vcsFName );
        Return_Int = !Error_Level;
        Error_Level = 0;
      }
      if ( Return_Int ) {
        if ( Cmd == "PUT" ) {
          Get_Cmt = True;
          if ( !vcsLibFnd ) {
            Cmd = "CREATE";
          }
          if ( !Fw ) {
            Ow = Window_Id;
            Switch_Window( Window_Count );
            Create_Window;
            Load_File( vcsFName );
            Fw = Window_Id;
          }
        }
        switch ( Cmd ) {
          case "CREATE":
            Vcs_Cmd = _CREATE_CMDL;
            vcsMsg = "Creating \"" + Get_Path( vcsAFile ) + FName + "\" ...";
            vcsDlgMsg = "(LCM) Describe \"" + FName + "\".";
            break;

          case "PUT":
            Vcs_Cmd = _PUT_CMDL;
            vcsMsg = "Storing \"" + FName + "\" in \"" + Get_Path( vcsAFile ) +
                FName + "\"...";
            vcsDlgMsg = "(LCM) Describe changes to \"" + FName + "\".";
            break;

          case "UNLOCK":
            Vcs_Cmd = _UNLOCK_CMDL;
            vcsMsg = "Unlocking \"" + Get_Path( vcsAFile ) + FName + "\"...";
            break;
        }
        Return_Int = True;
        if ( Get_Cmt ) {
          Return_Int = VcsGetCmt( True, False );
        }
        if ( Return_Int ) {
          if ( Fw ) {
            Erase_Window;
          }
          vcsDlgMsg = "(LCM) " + Cmd + " Command Line.";
          if ( Return_Int = LcmExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
            if ( File_Exists( vcsFName ) ) {
              if ( _DEL_SRC ) {
                Sel = Error_Level;
                Set_File_Attr( vcsFName, 0 );
                Del_File( vcsFName );
                Error_Level = Sel;
              }
              else if ( Cmd == "UNLOCK" ) {
                Set_File_Attr( vcsFName, 0x01 );  // force file readonly
              }
            }
            if ( Ow ) {
              Delete_Window;
              Switch_Win_Id( Ow );
            }
          }
          else {                        // error, reload file
            if ( Switch_Win_Id( Fw ) ) {
              Sel = Error_Level;
              Error_Level = 0;
              Load_File( vcsFName );
              if ( Error_Level == 0 ) {
                if ( Get_Cmt && vcsChgFlg ) {
                  VcsPutCmt( False );
                }
                Rm( "ExtSetup" );
              }
              Get_Cmt = True;
              if ( Ow ) {
                Delete_Window;
                Switch_Win_Id( Ow );
                Get_Cmt = False;
              }
              VcsPopPos( Get_Cmt );
              Error_Level = Sel;
              Return_Int = False;
            }
          }
        }
      }
    }
  }
}  // LcmPut

int LcmExec( str CmdLine, int Show_Win, int Chg_Dir ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmExec

  Function: Execute the LCM command in cmdline.

  Syntax  : Pass = LcmExec( CmdLine, Show_Win, Chg_Dir );

  Entry   : str CmdLine
            int Show_Win
            int Chg_Dir
            gstr !vcsFName
            gstr !vcsAFile
            gint !vcsSNCL

  Exit    : int
              True            - No Error.
              False           - ( Error_Level == 0 ) Cancelled
                                ( Error_Level = Error number ) Error
                gstr !vcsMsg  - Error message  ( Only when Error_Level != 0 )

            gstr !vcsDlgMsg   - Cleared.

  Globals : str !vcsFName   - Contains the work file name.
            str !vcsAFile   - Contains the archive file name.
            int !vcsSNCL    - Flag to not show cmdline dialog ( True ).
            str !vcsCfg     - Contains the main vcs config options.
            str !vcsMsg     - Contains the status line message.
            str !vcsName    - Contains the vcs temp file name.
            str !vcsDlgMsg  - Contains the show cmdline dialog message.

  Macros  : str LcmXlate
            int VcsEditStrDlg
            int ExecProg

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Result = True;

  CmdLine = LcmXlate( CmdLine, vcsFName, vcsAFile );
  Error_Level = 0;
  if ( vcsSNCL ) {
    if ( Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ) {
      Result = False;
    }
  }
  else if ( _SHOW_CMD ) {
    Result = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Result ) {
    Set_File_Attr( vcsName, 0 );
    Del_File( vcsName );                // Erase tmp capture file
    Result = False;
    Working;
    Make_Message( vcsMsg );
    Error_Level = ExecProg( CmdLine, vcsPrjDir, vcsName, vcsName,
        _EP_FLAGS_NOBYPASS );
    switch ( Error_Level ) {

      case _Exec_Abort :
        Error_Level = 0;
        break;

      case _Exec_Error :
        Error_Level = ExecErrorCode;
        break;

      case _Exec_Success :
        Error_Level = 0;
        switch ( ExecId ) {

          case _Exe_Id_Windows :
            LcmParseErr( );

          case _Exe_Id_Dos :
          case _Exe_Id_Os2 :
            Error_Level = ExecReturnCode;
            if ( Error_Level == 0 ) {
              Result = True;
              break;
            }

          default :
            Error_Level += 9000;
        }
    }
  }
  vcsDlgMsg = "";
  return ( Result );

}  // LcmExec

str LcmXlate(
        str Path = Return_Str,
        str FName = Parse_Str( "/F=", MParm_Str ),
        str LPath = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmXlate

  Function: Place holder for adding code to implement any LCM specific
            tranlation metacommands. Calls VcsXlate to finish the translations.

  Syntax  : Path = LcmXlate( Path, FName, LPath );

  Entry   : str Path            - The string to be translated.
            str FName           - The work file name.
            str LPath           - The LCM archive path.

  Exit    : str ( Return_Str )  - The expanded command line.

  Globals : none

  Macros  : str VcsXlate

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  return ( VcsXlate( Path, FName, LPath ) );

}  // LcmXlate

str LcmExt( str FName = Parse_Str( "/F=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:22

  Name    : LcmExt

  Function: Takes a filename extension and converts it to the equivalent LCM
            extension.

  Syntax  : LcmExt( str FName );

  Entry   : str FName     - Filename for which the extension is translated.

  Exit    : str           - The vcs file extension based upon LIBEXT.

  Globals : none.

  Macros  : none.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  return ( Get_Extension( FName ) );

}  // LcmExt

int LcmChkLib(
        str Path = Parse_Str( "/P=", MParm_Str ),
        str FName = Parse_Str( "/F=", MParm_Str ),
        int Pm = Parse_Int( "/M=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmChkLib

  Function: Search "Path" for the LCM archive for "FName" based upon "Pm".

  Syntax  : LibFnd = LcmChkLib( Path, FName, Pm );

  Entry   : gstr !vcsID - The name of the currently selected vcs package.
            str  Path   - Contains the search path.
            str  FName  - The filename for which to find archive.
            int  Pm     - Path Mode.
              -2        - Check for and return archive file only.
              -1        - Check for and return archive file,
                          iff no file return 1st lib path.
               0        - Return full archive path.
              +#        - Return # directory from archive path.

  Exit    : int ( gint !vcsRInt )
              #                 - File was found in # path.
                gstr !vcsAFile  - The found archive filename or path.
              0                 - File NOT found.
                gstr !vcsAFile  - The archive path based upon pm.
                                  ( Not set if Pm == -2 ).

  Globals : str !vcsID    - The name of the currently selected vcs package.
            int !vcsRInt  - The return integer.
            str !vcsAFile - The found archive filename or path.

  Macros  : int VcsGetPath

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  vcsRInt = False;
  if ( ( Path == _LIB_PATH ) && ( _DO_CD == 2 ) ) {
    Path = "<LOOKUP>";
  }
  return ( vcsRInt = VcsGetPath( Path, FName, LcmExt( FName ), Pm ) );

}  // LcmChkLib

str LcmGetFName( str LibFile = Parse_Str( "/P=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmGetFName

  Function: Returns the work file name extracted from the archive "LibFile" or
            "" when archive doesn't exist.

  Syntax  : FName = LcmGetFName( LibFile );

  Entry   : str LibFile           - archive file name

  Exit    : str ( gstr !vcsRStr ) - The workfile_name or "".

  Globals : str !vcsRStr          - The return string.

  Macros  : none

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  vcsRStr = LibFile;
  return ( vcsRStr );

}  // LcmGetFName

int LcmChkLock( ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmChkLock

  Function: Check to see if a archive file is locked.

            Note: The LCM support doesn't support this at this time, thus it
                  always returns False (not locked).

  Syntax  : Locked = LcmChkLock( );

  Entry   : none.

  Exit    : int
              True      - Archive file locked.
              False     - Archive file not locked.

  Globals : none.

  Macros  : none.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  return ( False );

}  // LcmChkLock

macro LcmDir Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmDir

  Function: Displays directory listing of LCM archive files.  Allows user to
            select a file to be retrieved for modification, viewing only, or
            listing the version history.

  Syntax  : Rm( "LcmDir /C=Cmd/RC" );

  Entry   : /C=str        - Command to execute ( ie GET, BROWSE or LIST ).
            /RC           - Repeat command until <ESC>.

  Exit    : none.

  Globals : none.

  Macros  : mac VcsFile

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str User = lcmUser;
  VcsGetPath( _LIB_PATH, FExpand( "*.*" ), "", 1 );
  VcsFileDlg( "(LCM) Archive Files", vcsAFile + "*.*", User );

}  // LcmDir

macro LcmIActive Trans {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmIActive

  Function: Runs the "menu command line" that is contained in "!lcmCfg" global
            variable.

  Syntax  : Rm( "LcmIActive" );

  Entry   : none.

  Exit    : none.

  Globals : str !lcmCfg - Contains the commands/setup options for LCM.

  Macros  : int WinExecAndWait

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str CmdLine = _MENU_CMDL;

  if ( _SHOW_CMD ) {
    vcsDlgMsg = "(LCM) Run Interactive Command Line";
    Return_Int = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Return_Int ) {
    WinExecAndWait( CmdLine, "", _EP_Flags_DontWait, "", "" );
  }
}  // LcmIActive

int LcmLogin( int Chg_Usr = XPos( "/CU", MParm_Str, 1 ) ) Trans {
/******************************************************************************
                               Multi-Edit Macro
                               20-Dec-94  14:36

  Name    : LcmLogin

  Function: Check if a user is logged in.

  Syntax  : Rm( "LcmLogin" );

  Entry   : none.

  Exit    : none.

  Globals : none.

  Macros  : none.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  int Ow = Window_Id;
  int Srf = Refresh;
  int Jx;
  int Result;
  int Pass2 = False;

  str User;
  str Pwd;

  Result = !Chg_Usr;                // Change User
  Refresh = False;
  if ( Result ) {
    Make_Message( "Checking PAN/LCM Login Status..." );
    lcmUser = "";
    Result = LcmCmds( "LOGIN", "" );
  }
  if ( Result == False ) {
    while ( True ) {
      if ( ( User = lcmUser ) == "" ) {
        User = LcmGetUser( );
      }
      Result = VcsLoginDlg( "LCM Login", User, Pwd );
      if ( Result ) {
        lcmUser = User;
        lcmPwd =  Pwd;
        Make_Message( "Logging into PAN/LCM..." );
        Result = LcmCmds( "LOGIN", "" );
        lcmPwd = "";
        if ( Result ) {
          vcsDoLogin = True;          // Enable change user ID menu item
          break;
        }
        Rm( "Verify /T=Invalid User or Password./BL=Try Again? /H=" +
            hc_vcs_Verify );
        Result = Return_Int;
        if ( Result == 0 ) {
          Rm( "MessageBox /T=PAN/LCM Login Error/M=LCM Support not enabled" );
          vcsId = "";
          vcsDoLogin = False;             // Disable change user ID menu item
          break;
        }
      }
      else {
        break;
      }
    }
  }

Exit:
  Error_Level = 0;
  Switch_Win_Id( Ow );
  Refresh = Srf;

  return ( Result );

}  // LcmLogin

macro LcmAdminPrj Trans {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmAdminPrj

  Function: Create, edit and delete entries in the user's administer project
            database for LCM.

  Syntax  : Rm( "LcmAdminPrj" );

  Entry   : none.

  Exit    : none.

  Globals : str !lcmLUT - The contents of the current db record.

  Macros  : mac LcmChkAdmin

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  lcmLUT = "";                          // clear global lookup variable
  DB( _VCS_DB, "LCM.VAD", "MEWHDRS.DB", "LCMVAD.HDR",
      "(LCM) Associate Directories",
      "(LCM) Associate Directories Setup",
      "!VAD", 0,
      "/BMP=BT_VCS_102/NDF=1/PRE=!VAD/H=" + hc_vcs_Admin +
          "/CP=New File Directory:/MOVE=1/MACRO=LcmChkAdmin" );

}  // LcmAdminPrj

str LcmLookup(
        str FName = Parse_str( "/F=", MParm_Str ),
        str Field1 = Parse_Str( "/F1=", MParm_Str ),
        str Field2 = Parse_Str( "/F2=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmLookup

  Function: Returns the string in "Field2" of the LCM administer project
            database when the directory of "FName" matches a string in
            "Field1".

  Syntax  : Str_Val = LcmLookup( FName, Field1, Field2 );

  Entry   : str FName  - The filename to extract the directory name from.
            str Field1 - The field name of the field to match the directory to.
            str Field2 - The field name fo the field to return the string from.

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match or Field2 empty.
              [Field2]    - Contents of Field2 when match found.

            gstr !lcmLUT  - Contains the found record.

  Globals : str !vcsRStr  - The return string.
            str !lcmLUT   - The contents of the matched db record.

  Macros  : int DbGetRecord

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  int Result = True;

  vcsRStr = "";
  FName = Caps( Get_Path( FName ) );
  if ( FName != Parse_Str( "\x7F" + Field1 + "=", lcmLUT ) ) {

    int Cnt = 0;
    int OrgWin = Window_Id;
    int TRefresh = Refresh;
    int Flags = _dbf_NoDelWin | _dbf_NoSwitchWin;

    str ADField = "\x7F" + "AD=";
    str DbName = _VCS_DB;
    str TStr;
    str SFName = FName;

    Result = False;
    Refresh = False;
    lcmLUT = "";
    while ( DbGetRecord( DbName, "LCM.VAD", Field1, FName, Cnt, Flags, "" ) ==
        _NoError ) {
      if ( lcmLUT != "" ) {
        TStr =  Parse_Str( ADField, lcmLUT ) + ";" +
            Parse_Str( ADField, FName );
        Return_Str = ADField;
        Rm( "ChngParm /G=!lcmLUT/P=" + TStr );
      }
      else {
        lcmLUT = FName;
        if ( Field1 == "AD" ) {
          break;
        }
      }
      Flags =  _dbf_NoDelWin | _dbf_NoSwitchWin | _sf_Position;
      FName = SFName;
      DbName = "";
      Result = True;
    }
    Switch_Win_Id( OrgWin );
    Refresh = TRefresh;
  }
  if ( Result ) {
    vcsRStr = Parse_Str( "\x7F" + Field2 + "=", lcmLUT );
    if ( Field1 == "AD" ) {
      lcmLUT = "";
    }
  }
  return ( vcsRStr );

}  // LcmLookup

str LcmCfgFile(
        str FName = Parse_Str( "/F=", MParm_Str ),
        str Param = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               20-Dec-94  00:50

  Name    : LcmCfgFile

  Function: Parse and return the value for Param from the LCMPROJ.CFG file.
            (Note: this function currently uses the <LOOKUP> function until the
            code is actually written and tested to parse the LCMPROJ.CFG file)

  Syntax  : Str_Val = LcmCfgFile( FName, Param );

  Entry   : str FName   - The filename to extract the directory name from
            str Param   - The parameter to parse for the return string

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match
              [Param]     - Contents of Param from config file when match found

  Globals : str !vcsRStr  - The return string
            str !lcmCfg
            str &lcmUser

  Macros  : str LcmLookUp

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  vcsRStr = "";
  switch ( Param ) {
    case "ARCDIR" :
      vcsRStr = LcmLookup( FName, "FD", "AD" );
      break;

    case "ARCEXT" :
      vcsRStr = _LIB_EXT;
      break;

    case "USER" :
      vcsRStr = lcmUser;
      break;

    case "WORKDIR" :
      vcsRStr = LcmLookup( FName, "FD", "WD" );
      break;

    case "BASEDIR" :
      vcsRStr = LcmLookup( FName, "FD", "BD" );
      break;
  }
  return ( vcsRStr );

}  // LcmCfgFile

macro LcmChkAdmin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmChkAdmin

  Function: Called by the AdminPrj dialog to capitialize, check and update all
            directories to end with a \ when saving the data in the dialog.

  Syntax  : Called only by the DB macro when in the AdminPrj dialog.

  Entry   : Values passed by the DB macro.

  Exit    : updated data.

  Globals : none.

  Macros  : none.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  if ( Parse_Int( "/P=", MParm_Str ) != 0 ) {

    str GStr = Parse_Str( "/GLO=", MParm_Str );
    str TStr = Caps( Global_Str( GStr ) );

    int Len = Svl( TStr );
    int Jx = 1;

    while ( Jx < Len ) {
      if ( ( Jx = XPos( "\x7F", TStr, ++Jx ) ) == 0 ) {
        Jx = Len + 1;
      }
      if ( Pos( Copy( TStr, Jx - 2, 1 ), "=" ) == 0 ) {
        if ( Pos( Copy( TStr, Jx - 1, 1 ), ";>\\" ) == 0 ) {
          TStr = Str_Ins( "\\", TStr, Jx );
          Len = Svl( TStr );
        }
      }
    }
    Jx = 1;
    while ( Jx = XPos( ";", TStr, Jx ) ) {
      if ( Copy( TStr, Jx - 1, 1 ) != "\\" ) {
        TStr = Str_Ins( "\\", TStr, Jx );
      }
      ++Jx;
    }
    Set_Global_Str( GStr, TStr );
  }
}  // LcmChkAdmin

int LcmCmds( str Cmd, str FName ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               04-Jan-95  12:15

  Name    : LcmCmds
  Function:
  Syntax  : Result = LcmCmds( Cmd, FName );

  Entry   : str Cmd
            str FName

  Exit    :
  Globals :
  Macros  :

               Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  int Result;
  int SavSNCL = vcsSNCL;
  int TRefresh = Refresh;
  int OrgWin = Window_Id;

  vcsSNCL = True;
//   vcsSNCL = False;
  switch ( Cmd ) {

    case "LOGIN" :
      Result = LcmExec( "LCMLOG.EXE " + lcmUser + " " + lcmPwd, 0, False );
      lcmUser = "";
      if ( Result == True ) {
        Result = False;
        Refresh = False;
        if ( !Switch_File( vcsName ) ) {
          Switch_Window( Window_Count );
          Create_Window;
        }
        Error_Level = 0;
        Load_File( vcsName );
        if ( Error_Level == 0 ) {
          if ( Find_Text( "Logged in: ", 0, 0 ) ) {
            Result = True;
            lcmUser = Remove_Space( Parse_Str( "Logged in: ", Get_Line( ) ) );
            lcmUser = Copy( lcmUser, 1, XPos( "(", lcmUser, 1 ) - 1 );
          }
        }
        Delete_Window;
        Switch_Win_Id( OrgWin );
        Refresh = TRefresh;
      }
      break;
  }
  vcsSNCL = SavSNCL;
  return ( Result );

}  // LcmCmds

void LcmParseErr( ) Trans {
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  13:23

  Name    : LcmParseErr

  Function: Used to parse the captured file from a Windows executable.
            Note: Currently no Windows programs for LCM to support.

  Syntax  : LcmParseErr( );

  Entry   : None.

  Exit    : gint ExecReturnCode - The error code for the executed windows program

  Globals : int ExecReturnCode

  Macros  : None.

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

  ExecReturnCode = 100;                 // Return error not supported yet

}  // LcmParseErr

str LcmGetUser( ) {
/******************************************************************************
                               Multi-Edit Macro
                               04-Jan-95  12:32

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

               Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  return ( _VCS_USERID );

}  // LcmGetUser
