//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)10 CDIFF.S, 22-Jan-95,20:49:00, LDH"

macro_file CDIFF;
/******************************************************************************
                             Multi-Edit Macro File
                               14-Mar-92  17:53

  Colorized Difference Macro

                Copyright (C) 1992-94 by Small Systems Support
********************************************************************( ldh )***/

#include WINEXEC.SH
#include COLORS.SH
#include METOOLS.SH
#include VCS.SH

#ifdef _DEBUG_
  #include DBUG.SH
#endif


macro CDiff Trans {
/******************************************************************************
                               Multi-Edit Macro
                               10-Oct-94  20:32

  Name    : CDiff (Color Difference)

  Function: Compares the file in the current window to a specified file and
            display a colorized difference file.

  Syntax  : Rm( "CDiff /F=str/DF=str/D=int" );

  Entry   : /F=str  Filename of file to compare with current file.
            /DF=str Filename of the Differences
            /D=int  0 - show color display, 1 - show diff file

  Exit    :

  Globals : None

  Macros  :

                Copyright (C) 1992-94 by Small Systems Support
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
  str RevId = "@(#)10 CDIFF.S, 22-Jan-95,20:49:00, LDH";

  int OldWin = Window_Id;
  int CpyWin;
  int DifWin;
  int LstWin;
  int LCnt;
  int Ln;
  int Cnt;
  int TLine;
  int Diff = Parse_Int( "/D=", MParm_Str );
  int UseDif = True;
  int Sudo = Undo_Stat;
  int Srf = Refresh;
  int Si = Insert_Mode;
  int Result = False;

  str OrgFile[ 128 ] = File_Name;
  str LstName[ 128 ] = TempFileName( Truncate_Path( File_Name ) );
  str FName[ 128 ] = Parse_Str( "/F=", MParm_Str );
  str CDifName[ 128 ] = Parse_Str( "/DF=", MParm_Str );
  str Cmd[ 2 ];
  str Tmp[ 20 ];

  Working;
  Insert_Mode = True;
  Refresh = False;
  Undo_Stat = False;

  vcsSaveWin = Window_Id;               // Save window_id for VcsShowWin macro
  if ( CDifName == "" ) {
    CDifName = TempFileName( "CDIF.TMP" );
    UseDif = False;
  }
  if ( Switch_File( CDifName ) ) {
    Erase_Window;
  }
  else {
    Switch_Window( Window_Count );
    Create_Window;
  }
  Window_Attr = 0x81;
  DifWin = Window_Id;
  CpyWin = Cur_Window;

  if ( Switch_File( LstName ) ) {
    Erase_Window;
  }
  else {
    Switch_Window( Window_Count );
    Create_Window;
  }
  LstWin = Window_Id;

  if ( FName == "" ) {
    Return_Str = OrgFile;
    Rm( "MEUTIL1^File_Prompt /T=Filename to Compare" );
    if ( Return_Int == 0 ) {
      Delete_Window;
      goto Err_Exit;
    }
    FName = Return_Str;
  }
  Load_File( FName );
  if ( Error_Level ) {
    goto Err_Exit;
  }
  Read_Only = False;
  File_Name = LstName;

  if ( !UseDif ) {
    Make_Message( "Comparing \"" + OrgFile + "\" to \"" + FName + "\"..." );
    Return_Str = Me_Path + "VCMPR.EXE " + FName + " " + OrgFile +
        " " + CDifName + " INSDEL";
    ExecProg( Return_Str, "", "", "", _EP_Flags_NoBypass );
    Return_Int = ExecReturnCode;
    if ( Return_Int ) {
      if ( Return_Int == 1 ) {
        Make_Message( "Files the same." );
      }
      goto Exit;
    }
  }
  Switch_Win_Id( DifWin );
  Load_File( CDifName );
  if ( Error_Level ) {
    goto Err_Exit;
  }
  if ( !Diff ) {
    Make_Message( "Colorizing Difference File..." );
    Goto_Col( 1 );
    LCnt = 0;
    while ( !At_Eof ) {
      Cmd = Get_Word( " " );
      Right;
      Forward_Till_Not( " " );
      Val( Ln, Get_Word( " " ) );
      Forward_Till_Not( " " );
      Val( Cnt, Get_Word( " " ) );

      if ( Cmd == ".D" ) {
//         Make_Message( "D Command " + Str( Ln ) + " " + Str( Cnt ) );
        Switch_Win_Id( LstWin );
        TLine = Ln + LCnt;
        Goto_Line( TLine );
        Block_Begin;
        Goto_Line( TLine + Cnt - 1 );
        Rm( "Colorize /C=1/CN=" + Str( fc_Different_Attr ) ); // Mark lines DEL
      }
      else if ( Cmd == ".I" ) {
        Down;
//         Make_Message( "I Command " + Str( Ln ) + " " + Str( Cnt ) );
        Block_Begin;
        Goto_Line( C_Line + Cnt - 1 );
        Switch_Win_Id( LstWin );
        TLine = Ln + LCnt;
        Goto_Line( TLine + 1 );
        Window_Copy( CpyWin );
        Goto_Line( Block_Line2 );
        Rm( "Colorize /C=1/CN=" + Str( fc_Inserted_Attr ) );  // Mark lines ADD
        LCnt += Cnt;
      }
      else {
        Make_Message( "Invalid Command" );
      }
      Down;
      Switch_Win_Id( DifWin );
      Down;
      Block_Off;
      Goto_Col( 1 );
    }

    Switch_Win_Id( LstWin );
    File_Changed = False;
    Read_Only = True;
    Rm( "ExtSetup" );
    Eof;
    Tof;
    while ( Line_Attr == 0 ) {
      Down;
    }
    Rm( "Select_Window" );
    Rm( "SetWindowNames" );
    Window_Name += "-CDif";
    if ( C_Line != 1 ) {
      int Jx = C_Line;
      int Value = ( Win_Y2 - Win_Y1 ) / 2;
      while ( C_Row > Value ) {
        Up;
      }
      while ( C_Row < Value ) {
        Down;
      }
      Goto_Line( Jx );
    }
//     Redraw;
//     Key_To_Window( <F1>, 'MEHelp /F=VCS/LK=OPTS_CDIF" );
    Key_To_Window( 0xB00 + Ascii( "A" ), "CDifSrch /C=0" );
    Key_To_Window( 0xB00 + Ascii( "S" ), "CDifSrch /C=1" );
    Key_To_Window( 0xB00 + Ascii( "D" ), "CDifSrch /C=2" );
    Key_To_Window( 0xB00 + Ascii( "F" ), "CDifSrch /C=3" );
    Key_To_Window( 0xB00 + Ascii( "X" ), "CDifSrch /C=4" );
    Key_To_Window( 0xB00 + Ascii( "E" ), "CDifSrch /C=5" );
    Key_To_Window( 0xB00 + Ascii( "L" ), "CDifKill /C=0" );
    Key_To_Window( 0xB00 + Ascii( "K" ), "CDifKill /C=1" );
    Key_To_Window( 0xB00 + Ascii( "N" ), "CDifKill /C=2" );
    Key_To_Window( 0xB00 + Ascii( "O" ), "CDifKill /C=3" );

    Result = True;
  }
  else {
    if ( Switch_Win_Id( DifWin ) ) {
      Tof;
      VcsViewWinDlg( "Differences", 100, 18, "", hc_vcs_View );
      Delete_Window;
    }
  }
  Make_Message( "" );
//   Read_Only = FALSE;
  goto Exit;

Err_Exit:
  Return_Int = 2;

Exit:
  if ( Switch_Win_Id( DifWin ) ) {
    Delete_Window;
  }
  Set_File_Attr( CDifName, 0 );
  Del_File( CDifName );

  if ( Result == False ) {
    if ( Switch_Win_Id( LstWin ) ) {
      Delete_Window;
    }
    Switch_Win_Id( OldWin );
  }
  else {
    Switch_Win_Id( LstWin );
  }

  Undo_Stat = Sudo;
  Refresh = Srf;
  Insert_Mode = Si;

}  // CDiff

macro Colorize Trans {
/****************************************************************************
  Sets the line color for every line in a block to a user specified color.
   If no block is marked then only the current line is colored.

  Parameters:  /F= - If non-zero every line in the file will be changed.
               /C= - 1 To colorize changed lines without confirmation.
                   - 2 To not colorize changed lines without confirmation.
               /CN=  Color Number

            (C) Copyright 1992-94 by American Cybernetics, Inc.
****************************************************************************/

  int I = Block_Line1;
  int End = Block_Line2;
  int Unchange = Parse_Int( "/C=", MParm_Str );
  int Color = Parse_Int( "/CN=", MParm_Str );
  int OldRefresh = Refresh;

  str Type = "BLOCK";

  Mark_Pos;
  if ( Parse_Int( "/F=", MParm_Str ) ) {
    Tof;
    Type = "FILE";
    End = 0x7FFFFFFF;
  }
  else if ( !Block_Stat ) {
    Type = "LINE";
    End = I;
  }
  else {
    Goto_Line( I );
  }
#ifndef Windows
  if ( !Color ) {
    if ( ( Return_Int = Global_Int( "@CColorLast" ) ) == 0 ) {
      Return_Int = T_Color;
    }
    Rm( "SETUP^ColorChart /T=COLORIZE CURRENT " + Type );
    if ( ( Color = Return_Int ) == -1 ) {
      goto Exit;
    }
  }
  Set_Global_Int( "@CColorLast", Color );
#endif
  Block_Off;
  Refresh = False;
  while ( !At_EOF && ( I++ <= End ) ) {
    if ( !Unchange && Line_Changed ) {
      Rm( "Verify /T=Changed lines detected.  Do you want to colorize them also." );
      if ( Return_Int ) {
        Unchange = 1;
        Line_Changed = 0;
      }
      else {
        Unchange = 2;
      }
    }
    else if ( Unchange != 2 ) {
      Line_Changed = 0;
    }
    Line_Attr = Color;
    Down;
  }
  Refresh = OldRefresh;

Exit:
  Goto_Mark;
}  // Colorize

macro CDifSrch Trans {
/******************************************************************************
                               Multi-Edit Macro
                               10-Feb-93  21:58

  Macro   : CDifSrch

  Function: Search for added or deleted lines

  Syntax  : Rm( "CDifSrch /C=Cmd" );

  Entry   : /C=Cmd  0 - Search fwd for Added lines.
                    1 - Search bwd for Added lines.
                    2 - Search fwd for Deleted lines.
                    3 - Search bwd for Deleted lines.
                    4 - Search fwd for any changed lines.
                    5 - Search bwd for any changed lines.

  Exit    : Line positioned.

  Globals : None

  Macros  : None

                Copyright (C) 1992-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Cmd = Parse_Int( "/C=", MParm_Str );
  int Srf = Refresh;
  int Color;
  int Found = False;
  int Cur_LA = Line_Attr;

  Refresh = False;
  if ( !XPos( "-CDif", Window_Name, 1 ) ) {
    Window_Name += "-CDif";
  }
  Working;
  Mark_Pos;
  switch ( Cmd ) {

    case 0:
      while ( ( Line_Attr == Cur_LA ) && !At_Eof ) {
        Down;
      }
      while ( ( Line_Attr != fc_Inserted_Attr ) && !At_Eof ) {
        Down;
      }
      if ( Line_Attr == fc_Inserted_Attr) {
        Found = True;
      }
      break;

    case 1:
      while ( ( Line_Attr == Cur_LA ) && ( C_Line != 1 ) ) {
        Up;
      }
      while ( ( Line_Attr != fc_Inserted_Attr ) && ( C_Line != 1 ) ) {
        Up;
      }
      while ( ( Line_Attr == fc_Inserted_Attr ) && ( C_Line != 1 ) ) {
        Up;
      }
      if ( Line_Attr != fc_Inserted_Attr ) {
        Down;
      }
      if ( Line_Attr == fc_Inserted_Attr ) {
        Found = True;
      }
      break;

    case 2:
      while ( ( Line_Attr == Cur_LA ) && !At_Eof ) {
        Down;
      }
      while ( ( Line_Attr != fc_Different_Attr ) && !At_Eof ) {
        Down;
      }
      if ( Line_Attr == fc_Different_Attr ) {
        Found = True;
      }
      break;

    case 3:
      while ( ( Line_Attr == Cur_LA ) && ( C_Line != 1 ) ) {
        Up;
      }
      while ( ( Line_Attr != fc_Different_Attr ) && ( C_Line != 1 ) ) {
        Up;
      }
      while ( ( Line_Attr == fc_Different_Attr ) && ( C_Line != 1 ) ) {
        Up;
      }
      if ( Line_Attr != fc_Different_Attr ) {
        Down;
      }
      if ( Line_Attr == fc_Different_Attr ) {
        Found = True;
      }
      break;

    case 4:
      while ( ( Line_Attr == Cur_LA ) && !At_Eof ) {
        Down;
      }
      while ( ( Line_Attr == 0 ) && !At_Eof ) {
        Down;
      }
      if ( ( Line_Attr == fc_Inserted_Attr ) ||
          ( Line_Attr == fc_Different_Attr ) ) {
        Found = True;
      }
      break;

    case 5:
      while ( ( Line_Attr == Cur_LA ) && ( C_Line != 1 ) ) {
        Up;
      }
      while ( ( Line_Attr == 0 ) && ( C_Line != 1 ) ) {
        Up;
      }

      Cur_LA = Line_Attr;
      while ( ( Line_Attr == Cur_La) && ( C_Line != 1 ) ) {
        Up;
      }
      if ( Line_Attr != Cur_LA ) {
        Down;
      }
      if ( ( Line_Attr == fc_Inserted_Attr ) ||
          ( Line_Attr == fc_Different_Attr ) ) {
        Found = True;
      }
      break;
  }
  if ( !Found ) {
    Goto_Mark;
  }
  else {
    Pop_Mark;
    if ( C_Line != 1 ) {

      int Tmp;
      int Value;

      Tmp = C_Line;
      Value = ( ( Win_Y2 - Win_Y1 ) / 2 );
      while ( C_Row > Value ) {
        Up;
      }
      while ( C_Row < Value ) {
        Down;
      }
      Goto_Line( Tmp );
    }
  }

  Redraw;
  Refresh = Srf;

} // CDifSrch

macro CDifKill Trans {
/******************************************************************************
                               Multi-Edit Macro
                               09-Mar-93  22:29

  Macro   : CDifKill

  Function: Kills the added or deleted lines the cursor is currently on.

  Syntax  : Rm( "CDifKill /C=cmd" );

  Entry   : /C=cmd  0 - Delete one line.
                    1 - Delete to end of block (add, delete) or one line.
                    2 - Delete all add lines (New).
                    3 - Delete all delete line (Old).

  Exit    : Lines deleted.

  Globals : None

  Macros  : None

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Srf = Refresh;
  int Cmd = Parse_Int( "/C=", MParm_Str );
  int Cur_LA = Line_Attr;

  Read_Only = False;
  Refresh = False;
  if ( !XPos( "-CDif", Window_Name, 1 ) ) {
    Window_Name += "-CDif";
  }
  Working;
  Push_Undo;
  switch ( Cmd ) {

    case 1:
      if ( ( Cur_LA == fc_Inserted_Attr ) || ( Cur_LA == fc_Different_Attr ) ) {
        while ( ( Line_Attr == Cur_LA ) && !At_Eof ) {
          Del_Line;
        }
        break;
      }                                 // Fall through on False

    case 0:
      Del_Line;
      break;

    case 2:
      Mark_Pos;
      Tof;
      while ( !At_Eof ) {
        while ( ( Line_Attr != fc_Inserted_Attr ) && !At_Eof ) {
          Down;
        }
        while ( ( Line_Attr == fc_Inserted_Attr ) && !At_Eof ) {
          Del_Line;
        }
      }
      Goto_Mark;
      break;

    case 3:
      Mark_Pos;
      Tof;
      while ( !At_Eof ) {
        while ( ( Line_Attr != fc_Different_Attr ) && !At_Eof ) {
          Down;
        }
        while ( ( Line_Attr == fc_Different_Attr ) && !At_Eof ) {
          Del_Line;
        }
      }
      Goto_Mark;
      break;
  }
  Pop_Undo;
  Redraw;
  Refresh = Srf;

} // CDifKill
