ns_register_proc GET /NS/TclInit TclInit
ns_register_proc GET /NS/GetTcl GetTcl
ns_register_proc POST /NS/UpdateTcl PostTcl

proc TclInit {conn ignored} {
	source [ns_info tcllib]/init.tcl
	ns_returnnotice $conn 200 "Tcl Initialized"
}

proc GetTcl {conn {ignored {}}} {
        set script [lindex [ns_conn urlv $conn] 2]
        set file [ns_info tcllib]/$script
	if [file exists $file] {
        	set fp [open $file]
        	set tcl [ns_quotehtml [read $fp]]
        	close $fp
	} else {
		set tcl ""
	}
        set page "<html><body>
        <form action=/NS/UpdateTcl/$script method=post>
        <textarea name=tcl rows=20 cols=80>$tcl</textarea><br>
        <input type=submit>
        </form></body></html>"
        ns_return $conn 200 text/html $page
}


proc PostTcl {conn ignored} {
        set script [lindex [ns_conn urlv $conn] 2]
	set file [ns_info tcllib]/$script
        set form [ns_conn form $conn]
        set tcl [ns_set get $form tcl]
	# Eliminate carriage-return.
	regsub -all "\r\n" $tcl "\n" tcl
        set fp [open $file w]
        puts $fp $tcl
        close $fp
	source $file
        GetTcl $conn
}
