ns_register_proc GET  /NS/ArchiveVersions ArchiveVersions
ns_register_proc GET  /NS/Archive Archive


proc Archive {conn ignore} {

    set db [ns_conn db $conn]
    set url /[join [lrange [ns_conn urlv $conn] 3 end] /]
    set check [ns_checkurl GET $url [ns_conn authuser $conn] [ns_conn authpassword $conn]]

    if {$check == "FORBIDDEN"} {
	ns_returnnotice $conn 403 "Forbidden"
    } elseif {$check == "UNAUTHORIZED"} {
	ns_returnnotice $conn 401 "Unauthorized"
    } else {
	if [ns_info winnt] {
		set tmp "\\nsarchive"
	} else {
		set tmp "/tmp/nsarchive"
	}
	set ts [ArchiveDecodeTS [lindex [ns_conn urlv $conn] 2]]
	set row [ns_db 0or1row $db \
		"select LOToFile(archive_lo,'$tmp') from ns_archives@\[timestamp '$ts'\] where archive_url='$url';"]
	if {$row == ""} {
	    ns_returnnotice $conn 404 "URL not found" "URL $url not found as it existed at $ts"
	} else {
	    set type [ns_guesstype $url]
	    set file [ns_set value $row 0]
	    ns_returnfile $conn 200 $type $file
	    ns_unlink $file
	}
    }
}


proc ArchiveVersions {conn ignore} {

    set db [ns_conn db $conn]
    set url /[join [lrange [ns_conn urlv $conn] 2 end] /]
    set page \
"<HTML><HEAD><TITLE>Version Picker</TITLE></HEAD>
<BODY><H1>Versions for $url</H1>"

    set row [ns_db select $db "select tmin::timestamp + interval '1' second
	from ns_archives@\[,\] where archive_url = '$url' order by 1 desc;"]

    while {[ns_db getrow $db $row]} {
	set tmin [lindex [split [ns_set value $row 0] .] 0]
	set when [ArchiveEncodeTS $tmin]
	append links \
"<LI><A HREF=[ns_info location]/NS/Archive/$when$url>$tmin</A>"
    }
    if [info exists links] {
	append page "Please choose a version:  <UL>$links</UL>"
    } else {
	append page "No versions found."
    }
    append page "</BODY></HTML>"
    ns_return $conn 200 text/html $page
}


proc ArchiveEncodeTS {ts} {
        regsub -all -- {[-: ]} $ts "" time
        return $time
}


proc ArchiveDecodeTS {ts} {
        set date "[string range $ts 0 3]-[string range $ts 4 5]-[string range $ts 6 7]"
        set time "[string range $ts 8 9]:[string range $ts 10 11]:[string range $ts 12 13]"
        return "$date $time"
}
