#ifndef NSFUNCS_H
#define NSFUNCS_H

/* $Id: nsfuncs.h,v 1.8 1995/06/06 23:18:31 jimbo Exp $ */


#ifdef WIN32
#define DllExport __declspec(dllexport)
#define DllImport __declspec(dllimport)
#else
#define DllExport
#define DllImport
#endif


/*
 * Ns_Info:
 */
extern DllExport NsdInfo *Ns_Info(Ns_Conn *conn);
#define Ns_InfoPageRoot(conn)	((Ns_Info(conn))->pageroot)
#define Ns_InfoLocation(conn)	((Ns_Info(conn))->location)
#define Ns_InfoName(conn)	((Ns_Info(conn))->name)
#define Ns_InfoPort(conn)	((Ns_Info(conn))->port)
#define Ns_InfoVersion(conn)	((Ns_Info(conn))->version)
#define Ns_InfoHome(conn)	((Ns_Info(conn))->home)

/*
 * Ns_Sets:
 */
extern DllExport Ns_Set  *Ns_SetCreate(char *name);
extern DllExport void     Ns_SetFree(Ns_Set *set);
extern DllExport void     Ns_SetTrunc(Ns_Set *set, int size);
extern DllExport int      Ns_SetFind(Ns_Set *set, char *key);
extern DllExport int      Ns_SetPut(Ns_Set *set, char *key, char *value);
extern DllExport char    *Ns_SetGet(Ns_Set *set, char *key);
extern DllExport void     Ns_SetDelete(Ns_Set *set, int index);
extern DllExport void     Ns_SetDeleteKey(Ns_Set *set, char *key);
extern DllExport void     Ns_SetMerge(Ns_Set *high, Ns_Set *low);
extern DllExport void     Ns_SetMove(Ns_Set *to, Ns_Set *from);
extern DllExport void     Ns_SetPutValue(Ns_Set *set, int index, char *value);
extern DllExport void     Ns_SetPrint(Ns_Set *set);
extern DllExport Ns_Set  *Ns_SetCopy(Ns_Set *old);
extern DllExport Ns_Set **Ns_SetSplit(Ns_Set *set, char sep);
extern DllExport Ns_Set  *Ns_SetListFind(Ns_Set **sets, char *name);
extern DllExport void     Ns_SetListFree(Ns_Set **sets);
#define Ns_SetSize(s) 		((s)->size)
#define Ns_SetKey(s,i)		((s)->fields[(i)].name)
#define Ns_SetValue(s,i)	((s)->fields[(i)].value)
#define Ns_SetLast(s)		(((s)->size)-1)


/*
 * Ns_DStrings:
 */
extern DllExport void     Ns_DStringInit(Ns_DString * dsPtr);
extern DllExport char    *Ns_DStringNAppend(Ns_DString * dsPtr, char *string, int length);
extern DllExport char    *Ns_DStringVarAppend(Ns_DString * dsPtr,...);
extern DllExport char    *Ns_DStringPrintf(Ns_DString * dsPtr, char *fmt,...);
extern DllExport void     Ns_DStringFree(Ns_DString * dsPtr);
extern DllExport void     Ns_DStringTrunc(Ns_DString * dsPtr, int length);
extern DllExport char    *Ns_DStringExport(Ns_DString * src);
#define Ns_DStringLength(dsPtr) ((dsPtr)->length)
#define Ns_DStringValue(dsPtr) ((dsPtr)->string)
#define Ns_DStringAppend(dsPtr, string) Ns_DStringNAppend(dsPtr, string, -1)


/*
 * NaviServer client connection interface.
 */
extern DllExport char    *Ns_SkipUrl(Ns_Request * request, int nurl);

/*
 * Routines for registering operation procedures.
 */
extern DllExport void Ns_RegisterOp(char *method, char *url, Ns_OpProc *proc,
    Ns_OpDeleteProc *deleteProc, Ns_OpContext context, int flags);
extern DllExport void Ns_GetOp(char *method, char *url, Ns_OpProc **pproc,
    Ns_OpDeleteProc **pdeleteProc, Ns_OpContext *pcontext, int *pflags);
extern DllExport void     Ns_UnRegisterOp(char *method, char *url);


/*
 * Routines for registering chores, shutdown procedures, and connection
 * traces.
 */
extern DllExport Ns_ProcHandle Ns_RegisterChore(Ns_Callback * proc, void *context);
extern DllExport Ns_ProcHandle Ns_RegisterShutdown(Ns_Callback * proc, void *context);
extern DllExport Ns_ProcHandle Ns_RegisterTrace(Ns_TraceProc * proc, void *context);


/*
 * Routines for URL and file paths.
 */
extern DllExport int      Ns_UrlIsFile(char *url);
extern DllExport int      Ns_UrlIsDir(char *url);
extern DllExport int      Ns_UrlIsMiniWeb(char *url);
extern DllExport void     Ns_UrlToFile(Ns_DString * dest, char *url);
extern DllExport void     Ns_UrlToNvd(Ns_DString * dest, char *url);
extern DllExport char    *Ns_RelativeUrl(char *url);
extern DllExport char    *Ns_AbsoluteUrl(Ns_DString * pds, char *url, char *baseurl);
extern DllExport int      Ns_PathIsAbsolute(char *path);
extern DllExport char    *Ns_NormalizePath(Ns_DString * dest, char *path);
extern DllExport char    *Ns_MakePath(Ns_DString * dest,...);
extern DllExport char    *Ns_LibPath(Ns_DString * dest, char *relpath);
extern DllExport char    *Ns_HomePath(Ns_DString * dest, char *relpath);


/*
 * Routines to send data to a client.
 */
extern DllExport int      Ns_ResetReturn(Ns_Conn *conn);
extern DllExport void     Ns_WriteConn(Ns_Conn *conn, char *buf, int len);
extern DllExport void     Ns_PutsConn(Ns_Conn *conn, char *string);
extern DllExport void     Ns_PrintfHeader(Ns_Conn *conn, char *fmt,...);
extern DllExport void     Ns_ContentHeaders(Ns_Conn *conn, int status, char *type, int len);
extern DllExport void     Ns_ExpiresHeader(Ns_Conn *conn, char *httptime);
extern DllExport void     Ns_ReturnHtml(Ns_Conn *conn, int status, char *html, int len);
extern DllExport void     Ns_ReturnOk(Ns_Conn *conn);
extern DllExport void     Ns_ReturnNoResponse(Ns_Conn *conn);
extern DllExport void     Ns_ReturnRedirect(Ns_Conn *conn, char *location);
extern DllExport void     Ns_ReturnNotModified(Ns_Conn *conn);
extern DllExport void     Ns_ReturnBadRequest(Ns_Conn *conn);
extern DllExport void     Ns_ReturnUnauthorized(Ns_Conn *conn);
extern DllExport void     Ns_ReturnForbidden(Ns_Conn *conn);
extern DllExport void     Ns_ReturnNotFound(Ns_Conn *conn);
extern DllExport void     Ns_ReturnError(Ns_Conn *conn, int status, char *fmt,...);
extern DllExport void     Ns_ReturnNotImplemented(Ns_Conn *conn);
extern DllExport void     Ns_ReturnStatus(Ns_Conn *conn, int status, char *msg);
extern DllExport void     Ns_HtmlHeaders(Ns_Conn *conn, int status, int len);
extern DllExport void     Ns_TypeHeader(Ns_Conn *conn, char *type);
extern DllExport void     Ns_LengthHeader(Ns_Conn *conn, int len);
extern DllExport void     Ns_LastModifiedHeader(Ns_Conn *conn, time_t * when);
extern DllExport void     Ns_RequiredHeaders(Ns_Conn *conn, int status, char *msg);
extern DllExport void     Ns_EndOfHeaders(Ns_Conn *conn);
extern DllExport void     Ns_ReturnFile(Ns_Conn *conn, int status, char *type, char *file);
extern DllExport void     Ns_ReturnNotice(Ns_Conn *conn, int status, char *notice, char *text);


/*
 * Config files:
 */
extern DllExport Ns_Set  *Ns_ConfigSection(char *sectionName);
extern DllExport char    *Ns_ConfigGet(char *sectionName, char *key);
extern DllExport void     Ns_ConfigPut(char *sectionName, char *key, char *value);
extern DllExport void     Ns_ConfigDelete(char *sectionName, char *key);
extern DllExport int      Ns_ConfigGetInt(char *sectionName, char *key, int *valuePtr);
extern DllExport void     Ns_ConfigPutInt(char *sectionName, char *key, int value);


/*
 * Misc utility functions.
 */
extern DllExport void    *ns_malloc(size_t size);
extern DllExport void    *ns_calloc(size_t num, size_t size);
extern DllExport void     ns_free(void *buf);
extern DllExport void    *ns_realloc(void *buf, size_t size);
extern DllExport char    *ns_strdup(char *string);
extern DllExport char    *ns_strcopy(char *string);

extern DllExport void     Ns_ConnError(Ns_Conn *conn,...);
extern DllExport char    *Ns_GuessMimeType(char *file);
extern DllExport char    *Ns_UrlEncode(Ns_DString * pds, char *url);
extern DllExport char    *Ns_UrlDecode(Ns_DString * pds, char *url);
extern DllExport char    *Ns_HttpTime(time_t * when);
extern DllExport int      Ns_FetchURL(char *url, Ns_DString * pds, Ns_Set *headers);
extern DllExport void     Ns_Log(Ns_LogSeverity severity, char *fmt,...);
extern DllExport void     Ns_LogRaw(char *data, int len);
extern DllExport void     Ns_Fatal(char *fmt,...);
extern DllExport void     Ns_QuoteHtml(Ns_DString * pds, char *string);


/*
 * The NaviServer database interface.
 */
extern DllExport Ns_DbHandle *Ns_ServerDbHandle(void);
extern DllExport void Ns_DbQuoteValue(Ns_DString *pds, char *string);
extern DllExport Ns_Set  *Ns_DbSelect(Ns_DbHandle *handle, char *sql);
extern DllExport int      Ns_DbGetRow(Ns_DbHandle *handle, Ns_Set *row);
extern DllExport Ns_Set  *Ns_Db0or1Row(Ns_DbHandle *handle, char *sql, int *nrows);
extern DllExport Ns_Set  *Ns_Db1Row(Ns_DbHandle *handle, char *sql);
extern DllExport int      Ns_DbFlush(Ns_DbHandle *handle);
extern DllExport int      Ns_DbCancel(Ns_DbHandle *handle);
extern DllExport int      Ns_DbDML(Ns_DbHandle *handle, char *sql);
extern DllExport void     Ns_DbError(Ns_DbHandle *handle,...);
extern DllExport void     Ns_DbReturnError(Ns_Conn *conn, int status, char *fmt,...);
extern DllExport Ns_DbTableInfo *Ns_DbGetTableInfo(char *table);
extern DllExport int      Ns_DbColumnIndex(Ns_DbTableInfo * tinfo, char *name);
extern DllExport int      Ns_DbPrintTable(Ns_DString *pds, Ns_Conn *conn, char *sql, int maxrows);
extern DllExport char    *Ns_DbUrlOwner(char *method, char *url);
extern DllExport int      Ns_DbCheckPasswd(char *user, char *passwd);
#define Ns_DbTableValue(t,k)  (Ns_SetGet((t)->info,k))
#define Ns_DbTableDescription(t)  (Ns_DbTableValue(t,"table_description"))
#define Ns_DbTableName(t)  ((t)->info->name)
#define Ns_DbColumnCount(t)  ((t)->ncolumns)
#define Ns_DbColumnName(t,i)  ((i) < 0 ? NULL : (t)->columns[(i)]->name)
#define Ns_DbColumnValue(t,i,k)  ((i) < 0 ? NULL : Ns_SetGet((t)->columns[(i)],k))
#define Ns_DbColumnType(t,i)  (Ns_DbColumnValue((t),(i),"column_type"))

extern DllExport void     Ns_SetCheckUrlProc(Ns_CheckUrlProc * proc);
extern DllExport int      Ns_CheckUrl(char *method, char *url, char *authuser, char *authpasswd);
extern DllExport Ns_Request *Ns_ParseRequest(char *requestString);
extern DllExport void     Ns_RequestFree(Ns_Request * request);

#endif					/* NSFUNCS_H */
 
